/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.internal.xml;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.xml.BuildStatus;
import com.metamatrix.metamodels.xml.ValueType;
import com.metamatrix.metamodels.xml.XmlAll;
import com.metamatrix.metamodels.xml.XmlAttribute;
import com.metamatrix.metamodels.xml.XmlBaseElement;
import com.metamatrix.metamodels.xml.XmlBuildable;
import com.metamatrix.metamodels.xml.XmlChoice;
import com.metamatrix.metamodels.xml.XmlContainerHolder;
import com.metamatrix.metamodels.xml.XmlContainerNode;
import com.metamatrix.metamodels.xml.XmlDocumentBuilder;
import com.metamatrix.metamodels.xml.XmlDocumentEntity;
import com.metamatrix.metamodels.xml.XmlDocumentFactory;
import com.metamatrix.metamodels.xml.XmlDocumentNode;
import com.metamatrix.metamodels.xml.XmlDocumentPlugin;
import com.metamatrix.metamodels.xml.XmlElement;
import com.metamatrix.metamodels.xml.XmlElementHolder;
import com.metamatrix.metamodels.xml.XmlFragment;
import com.metamatrix.metamodels.xml.XmlFragmentUse;
import com.metamatrix.metamodels.xml.XmlNamespace;
import com.metamatrix.metamodels.xml.XmlRoot;
import com.metamatrix.metamodels.xml.XmlSequence;
import com.metamatrix.metamodels.xml.util.XmlDocumentUtil;
import com.metamatrix.modeler.core.ModelEditor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.validation.rules.StringNameValidator;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDAttributeUseCategory;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConstraint;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDForm;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;

public class XmlDocumentBuilderImpl
implements XmlDocumentBuilder {
    private static final String TASK_NAME = XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.buildingXmlDocForRoot");
    private static final String CALCULATING_MSG = XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.Calculating_effort_to_build__1");
    private static final String CALCULATING_MSG2 = XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.Calculating_effort_to_update__2");
    private static final String BUILDING_MSG = XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.Building_Document_node__3");
    private static final String UPDATING_MSG = XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.Updating_Document_node__4");
    private final Collection schemaUris = new ArrayList();
    private final Collection referencedSchemas = new ArrayList();
    private final HashMap updateDeleteMap = new HashMap();
    private final HashMap updateCurrentChildMap = new HashMap();
    private final HashMap fragmentMap = new HashMap();
    private final HashMap uriToNamespaceMap = new HashMap();
    private final StringNameValidator validator = new StringNameValidator();
    private final HashSet unhandledModelImports = new HashSet();
    private Collection recursiveElementUUIDs = new HashSet();
    private int nodeCount;
    private int newCount;
    private int moveCount;
    private int factor;
    private int tempFactor;
    private Stack recursionStack;
    private int numberOfLevelsToBuild = -1;
    private XmlElement root;
    private IProgressMonitor monitor;
    private XmlDocumentFactory docFactory = XmlDocumentFactory.eINSTANCE;
    private ModelEditor me = ModelerCore.getModelEditor();
    private boolean useFragments;
    static /* synthetic */ Class class$org$eclipse$xsd$XSDAttributeDeclaration;

    public XmlDocumentBuilderImpl() {
        this(-1);
    }

    public XmlDocumentBuilderImpl(int levels) {
        this.setNumberOfLevelsToBuild(levels);
    }

    public void setFragments(Collection xmlFragments) throws ModelerCoreException {
        ArgCheck.isNotNull((Object)xmlFragments);
        Iterator iter = xmlFragments.iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            if (!(next instanceof XmlFragment)) {
                throw new ModelerCoreException(XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.All_xml_fragments_must_be_an_instance_of_XmlFragment_1"));
            }
            XmlFragment fragment = (XmlFragment)next;
            XSDComponent xsdComponent = fragment.getRoot() == null ? null : fragment.getRoot().getXsdComponent();
            if (xsdComponent == null) continue;
            XSDComponent ref = this.resolveSchemaRef(xsdComponent);
            if (ref != null) {
                xsdComponent = ref;
            }
            this.fragmentMap.put(xsdComponent, fragment);
        }
        this.useFragments = !this.fragmentMap.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int buildDocument(XmlElement rootElement, IProgressMonitor progressMonitor) throws ModelerCoreException {
        int n;
        block22: {
            block23: {
                ArgCheck.isNotNull((Object)rootElement);
                this.root = rootElement;
                this.monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
                this.referencedSchemas.clear();
                this.initializeSchemaUris(rootElement);
                boolean startedTxn = ModelerCore.startTxn((boolean)true, (boolean)true, (String)XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.Build_XML_Document_5"), (Object)this);
                boolean succeeded = false;
                try {
                    try {
                        XSDTypeDefinition typeDefn;
                        XSDComponent schemaComponent;
                        this.setBuildStatusProperty(rootElement, BuildStatus.COMPLETE_LITERAL);
                        if (rootElement.isRecursive()) {
                            this.setRecursiveProperty(rootElement, false);
                        }
                        if ((schemaComponent = this.root.getXsdComponent()) == null) {
                            throw new ModelerCoreException(XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.Schema_reference_not_set_on_root_element_1"));
                        }
                        Resource rsrc = rootElement.eResource();
                        if (rsrc instanceof EmfResource) {
                            EmfResource elementResource = (EmfResource)rsrc;
                            try {
                                ModelerCore.getModelEditor().addModelImport(elementResource, schemaComponent.eResource());
                            }
                            catch (ModelerCoreException e) {
                                String msg = XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.Error_adding_model_import_to__1") + elementResource.getURI();
                                XmlDocumentPlugin.Util.log(4, msg);
                            }
                        } else if (rsrc == null) {
                            this.unhandledModelImports.add(schemaComponent.eResource());
                        }
                        if ((typeDefn = XmlDocumentUtil.findXSDType(schemaComponent)) == null) throw new ModelerCoreException(XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.No_type_element_found_for_root_document_element_2"));
                        if (schemaComponent instanceof XSDNamedComponent) {
                            String newName;
                            XSDComponent ref;
                            String name = ((XSDNamedComponent)schemaComponent).getName();
                            if ((name == null || name.length() == 0) && (ref = this.resolveSchemaRef(schemaComponent)) != null && ref instanceof XSDNamedComponent) {
                                name = ((XSDNamedComponent)ref).getName();
                            }
                            if ((newName = this.validator.createValidName(name)) != null) {
                                name = newName;
                            }
                            this.root.setName(name);
                        }
                        this.monitor.beginTask(TASK_NAME, 5000);
                        this.monitor.subTask(CALCULATING_MSG + this.root.getName());
                        this.initializeRecursionStack(this.root);
                        this.monitor.subTask(BUILDING_MSG + this.root.getName());
                        this.initializeRecursionStack(this.root);
                        this.nodeCount = 0;
                        this.addChildren(this.root, (XSDComponent)typeDefn, BUILDING_MSG + this.root.getName());
                        succeeded = true;
                        n = this.nodeCount;
                        Object var11_14 = null;
                        this.cleanup();
                        if (!startedTxn) break block22;
                        if (!succeeded) break block23;
                    }
                    catch (ModelerCoreException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        ModelerCore.Util.log(4, e, e.getMessage());
                        Object var11_15 = null;
                        this.cleanup();
                        if (startedTxn) {
                            if (succeeded) {
                                ModelerCore.commitTxn();
                            } else {
                                ModelerCore.rollbackTxn();
                            }
                        }
                        System.gc();
                        Thread.yield();
                        this.monitor.worked(10);
                        return this.nodeCount;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_16 = null;
                    this.cleanup();
                    if (startedTxn) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                    System.gc();
                    Thread.yield();
                    this.monitor.worked(10);
                    throw throwable;
                }
                ModelerCore.commitTxn();
                break block22;
            }
            ModelerCore.rollbackTxn();
        }
        System.gc();
        Thread.yield();
        this.monitor.worked(10);
        return n;
    }

    public Collection getUnhandledModelImports() {
        return this.unhandledModelImports;
    }

    private void cleanup() {
        this.useFragments = false;
        this.numberOfLevelsToBuild = -1;
        this.numberOfLevelsToBuild = -1;
        this.root = null;
        this.recursionStack.clear();
        this.recursiveElementUUIDs.clear();
        this.updateDeleteMap.clear();
        this.updateCurrentChildMap.clear();
        this.uriToNamespaceMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int updateFromSchema(XmlElement rootElement, IProgressMonitor progressMonitor) throws ModelerCoreException {
        int count;
        block3: {
            ArgCheck.isNotNull((Object)rootElement);
            this.root = rootElement;
            count = 0;
            this.monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
            boolean startedTxn = ModelerCore.startTxn((boolean)true, (boolean)true, (String)XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.Update_XML_Document_from_Schema_6"), (Object)this);
            boolean succeeded = false;
            try {
                this.updateFromSchema(this.root, false);
                count = this.performTreeUpdates();
                this.referencedSchemas.clear();
                this.initializeSchemaUris(rootElement);
                this.updateFromSchema(this.root, true);
                count = count + this.newCount + this.moveCount;
                Object var7_6 = null;
                this.cleanup();
                if (!startedTxn) return count;
                if (!succeeded) break block3;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.cleanup();
                if (!startedTxn) throw throwable;
                if (succeeded) {
                    ModelerCore.commitTxn();
                    throw throwable;
                }
                ModelerCore.rollbackTxn();
                throw throwable;
            }
            ModelerCore.commitTxn();
            return count;
        }
        ModelerCore.rollbackTxn();
        return count;
    }

    public void setNumberOfLevelsToBuild(int numberOfLevelsToBuild) {
        this.numberOfLevelsToBuild = numberOfLevelsToBuild;
    }

    public Collection getRecursiveElementObjectIDs() {
        return this.recursiveElementUUIDs;
    }

    public void setAddNamespaces(boolean addNamespaces) {
    }

    public Collection buildXmlFragments(XSDSchema schema) throws ModelerCoreException {
        ArgCheck.isNotNull((Object)schema);
        ArrayList<XmlFragment> fragments = new ArrayList<XmlFragment>();
        Iterator iter = schema.getContents().iterator();
        while (iter.hasNext() && (this.monitor == null || !this.monitor.isCanceled())) {
            Object next = iter.next();
            if (!(next instanceof XSDElementDeclaration)) continue;
            XSDElementDeclaration child = (XSDElementDeclaration)next;
            XmlRoot root = this.docFactory.createXmlRoot();
            XmlDocumentBuilderImpl builder = new XmlDocumentBuilderImpl();
            root.setXsdComponent((XSDComponent)child);
            builder.buildDocument(root, null);
            XmlFragment fragment = this.docFactory.createXmlFragment();
            String name = root.getName();
            String newName = this.validator.createValidName(name);
            if (newName != null) {
                name = newName;
            }
            fragment.setName(name);
            fragment.setRoot(root);
            fragments.add(fragment);
        }
        return fragments;
    }

    private void initializeSchemaUris(XmlElement element) {
        XSDComponent xsdComp = element.getXsdComponent();
        if (xsdComp == null) {
            return;
        }
        EObject root = null;
        EObject node = element;
        while (root == null && node != null) {
            if (node instanceof XmlRoot) {
                root = node;
                continue;
            }
            node = node.eContainer();
        }
        if (root == null) {
            return;
        }
        Iterator children = root.eContents().iterator();
        while (children.hasNext()) {
            EObject next = (EObject)children.next();
            if (!(next instanceof XmlNamespace)) continue;
            this.schemaUris.add(((XmlNamespace)next).getUri());
        }
        this.updateSchemaUris(element, xsdComp);
    }

    private void updateSchemaUris(EObject docNode, XSDComponent xsdComp) {
        if (xsdComp == null || docNode == null) {
            return;
        }
        XSDSchema schema = xsdComp.getSchema();
        if (schema == null) {
            String msg = null;
            if (xsdComp instanceof XSDNamedComponent) {
                XSDNamedComponent namedComp = (XSDNamedComponent)xsdComp;
                Object[] params = new Object[]{namedComp.getName()};
                msg = XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.Unable_to_resolve_XSD_reference_to", params);
            } else {
                IPath path = ModelerCore.getModelEditor().getModelRelativePath(docNode);
                Object[] params = new Object[]{path};
                msg = XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.Unable_to_resolve_XSD_reference_for", params);
            }
            XmlDocumentPlugin.Util.log(4, msg);
            return;
        }
        if (this.referencedSchemas.contains(schema)) {
            return;
        }
        this.referencedSchemas.add(schema);
        XmlElement root = null;
        EObject node = docNode;
        while (root == null && node != null) {
            if (node instanceof XmlRoot) {
                root = (XmlElement)node;
                continue;
            }
            node = node.eContainer();
        }
        Map qNameMap = schema.getQNamePrefixToNamespaceMap();
        if (qNameMap != null) {
            Iterator entries = qNameMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry next = entries.next();
                String prefix = (String)next.getKey();
                String uri = (String)next.getValue();
                if (this.schemaUris.contains(uri)) continue;
                XmlNamespace ns = this.docFactory.createXmlNamespace();
                if ("this".equals(prefix) || prefix == null || prefix.trim().length() == 0) {
                    ns.setPrefix(XmlDocumentUtil.createXmlPrefixFromUri(uri));
                } else {
                    ns.setPrefix(prefix);
                }
                ns.setUri(uri);
                ns.setElement(root);
                this.schemaUris.add(uri);
                this.uriToNamespaceMap.put(uri, ns);
            }
        }
    }

    private int performTreeUpdates() throws ModelerCoreException {
        int count = 0;
        Iterator keys = this.updateDeleteMap.keySet().iterator();
        while (keys.hasNext()) {
            EObject parent = (EObject)keys.next();
            ArrayList children = (ArrayList)this.updateDeleteMap.get(parent);
            if (children == null) continue;
            Iterator childrenIT = children.iterator();
            while (childrenIT.hasNext()) {
                EObject child = (EObject)childrenIT.next();
                this.me.delete(child);
                ++count;
            }
        }
        return count;
    }

    private void updateFromSchema(XmlElement rootElement, boolean doAdds) throws ModelerCoreException {
        this.root = rootElement;
        this.newCount = 0;
        XSDComponent schemaComponent = this.root.getXsdComponent();
        XSDTypeDefinition typeDefn = XmlDocumentUtil.findXSDType(schemaComponent);
        if (typeDefn != null) {
            this.nodeCount = 1;
            this.monitor.beginTask(CALCULATING_MSG2 + this.root, 5000);
            this.initializeRecursionStack(this.root);
            this.monitor.worked(500);
            this.monitor.subTask(UPDATING_MSG + this.root);
            double temp = 4500.0 / (double)this.nodeCount;
            this.factor = temp > 0.0 ? 4500 / this.nodeCount : new Double(-2.0444444444444443).intValue();
            this.initializeRecursionStack(this.root);
            this.nodeCount = 0;
            if (doAdds) {
                this.updateAdd(this.root, (XSDComponent)typeDefn, UPDATING_MSG + this.root);
            } else {
                this.updateDelete(this.root, (XSDComponent)typeDefn, UPDATING_MSG + this.root);
            }
        }
    }

    private void updateDelete(XmlDocumentEntity documentElement, XSDComponent xsdComponent, String taskName) {
        Object sibling;
        Iterator childrenIT;
        ArrayList oldChildren;
        Object sibling2;
        Iterator iter;
        ArrayList currentChildren;
        XmlContainerNode temp;
        if (this.monitor.isCanceled()) {
            return;
        }
        this.monitor.subTask(XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.{0}_{1}_of_{2}", (Object)taskName, (Object)new Integer(this.nodeCount), (Object)new Integer(4500)));
        XSDComponent ref = this.resolveSchemaRef(xsdComponent);
        boolean checkRecursion = false;
        boolean isRecursive = false;
        boolean checkExisting = false;
        if (ref != null) {
            if (this.recursionStack.contains(ref)) {
                isRecursive = true;
            }
            this.recursionStack.push(ref);
        } else {
            if (this.recursionStack.contains(xsdComponent)) {
                isRecursive = true;
            }
            this.recursionStack.push(xsdComponent);
        }
        XmlDocumentEntity documentChild = documentElement;
        this.updateDeleteMap(documentElement, null);
        XmlDocumentEntity existingChild = this.findExistingDocumentChild((ArrayList)this.updateDeleteMap.get(documentElement), xsdComponent);
        if (this.isAllCompositor(xsdComponent)) {
            temp = null;
            currentChildren = (ArrayList)this.updateCurrentChildMap.get(documentElement);
            if (currentChildren != null) {
                iter = currentChildren.iterator();
                while (iter.hasNext()) {
                    sibling2 = iter.next();
                    if (!(sibling2 instanceof XmlAll)) continue;
                    temp = (XmlAll)sibling2;
                    documentChild = temp;
                    break;
                }
            }
            if (temp == null && (oldChildren = (ArrayList)this.updateDeleteMap.get(documentElement)) != null) {
                childrenIT = oldChildren.iterator();
                while (childrenIT.hasNext()) {
                    sibling = childrenIT.next();
                    if (!(sibling instanceof XmlAll)) continue;
                    temp = (XmlAll)sibling;
                    documentChild = temp;
                    break;
                }
            }
            if (temp != null) {
                this.updateDeleteMap(documentElement, documentChild);
            }
            if (ref != null) {
                xsdComponent = ref;
            }
            this.updateMonitor();
            checkRecursion = true;
        } else if (this.isSequenceCompositor(xsdComponent)) {
            temp = null;
            currentChildren = (ArrayList)this.updateCurrentChildMap.get(documentElement);
            if (currentChildren != null) {
                iter = currentChildren.iterator();
                while (iter.hasNext()) {
                    sibling2 = (EObject)iter.next();
                    if (!(sibling2 instanceof XmlSequence) || !this.isValidSequenceForReuse((EObject)this.findSchemaReference((EObject)sibling2), (EObject)xsdComponent)) continue;
                    temp = (XmlSequence)sibling2;
                    documentChild = temp;
                    break;
                }
            }
            if (temp == null && (oldChildren = (ArrayList)this.updateDeleteMap.get(documentElement)) != null) {
                childrenIT = oldChildren.iterator();
                while (childrenIT.hasNext()) {
                    sibling = (EObject)childrenIT.next();
                    if (!(sibling instanceof XmlSequence) || !this.isValidSequenceForReuse((EObject)this.findSchemaReference((EObject)sibling), (EObject)xsdComponent)) continue;
                    temp = (XmlSequence)sibling;
                    documentChild = temp;
                    break;
                }
            }
            if (temp != null) {
                this.updateDeleteMap(documentElement, documentChild);
            }
            this.updateMonitor();
        } else if (existingChild != null) {
            documentChild = existingChild;
            this.updateDeleteMap(documentElement, documentChild);
            ++this.nodeCount;
            this.updateMonitor();
            checkExisting = true;
            checkRecursion = xsdComponent instanceof XSDElementDeclaration && !((XSDElementDeclaration)xsdComponent).isAbstract();
        } else {
            boolean bl = checkRecursion = xsdComponent instanceof XSDElementDeclaration && !((XSDElementDeclaration)xsdComponent).isAbstract();
        }
        if (isRecursive && checkRecursion) {
            if (this.recursiveElementUUIDs.contains(documentChild.getObjectId())) {
                if (!this.recursionStack.isEmpty()) {
                    this.recursionStack.pop();
                }
                return;
            }
            this.recursiveElementUUIDs.add(documentChild.getObjectId());
            if (!this.recursionStack.isEmpty()) {
                this.recursionStack.pop();
            }
            return;
        }
        XSDTypeDefinition typeEntity = XmlDocumentUtil.findXSDType(xsdComponent);
        if (typeEntity != null && typeEntity.eContainer() != null && !typeEntity.eContainer().equals(xsdComponent) && (!checkExisting || checkExisting && existingChild != null)) {
            this.updateDelete(documentChild, (XSDComponent)typeEntity, taskName);
        }
        Iterator children = xsdComponent.eContents().iterator();
        while (children.hasNext()) {
            EObject schemaChild = (EObject)children.next();
            if (checkExisting && (!checkExisting || existingChild == null) || !(schemaChild instanceof XSDComponent)) continue;
            this.updateDelete(documentChild, (XSDComponent)schemaChild, taskName);
        }
        if (!this.recursionStack.isEmpty()) {
            this.recursionStack.pop();
        }
    }

    private void updateDeleteMap(XmlDocumentEntity documentEntity, XmlDocumentEntity child) {
        if (child == null) {
            if (this.updateDeleteMap.get(documentEntity) == null) {
                ArrayList children = new ArrayList(documentEntity.eContents());
                this.updateDeleteMap.put(documentEntity, children);
            }
            return;
        }
        ArrayList<XmlDocumentEntity> children = (ArrayList<XmlDocumentEntity>)this.updateDeleteMap.get(documentEntity);
        if (children != null) {
            children.remove(child);
            this.updateDeleteMap.put(documentEntity, children);
        }
        if ((children = (ArrayList)this.updateCurrentChildMap.get(documentEntity)) == null) {
            children = new ArrayList<XmlDocumentEntity>();
        }
        children.add(child);
        this.updateCurrentChildMap.put(documentEntity, children);
    }

    private void updateAdd(XmlDocumentEntity documentElement, XSDComponent xsdComponent, String taskName) throws ModelerCoreException {
        XSDTypeDefinition typeEntity;
        EObject sibling;
        Iterator iter;
        XmlContainerNode temp;
        String newName;
        String name;
        if (this.monitor.isCanceled()) {
            return;
        }
        this.monitor.subTask(XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.{0}_{1}_of_{2}", (Object)taskName, (Object)new Integer(this.nodeCount), (Object)new Integer(4500)));
        XSDComponent ref = this.resolveSchemaRef(xsdComponent);
        if (this.useFragments) {
            XmlFragment fragment;
            XmlFragment xmlFragment = fragment = ref == null ? (XmlFragment)this.fragmentMap.get(xsdComponent) : (XmlFragment)this.fragmentMap.get(ref);
            if (fragment != null) {
                if (documentElement instanceof XmlElementHolder) {
                    XmlFragmentUse use = this.docFactory.createXmlFragmentUse();
                    use.setFragment(fragment);
                    use.setName(fragment.getName());
                    use.setXsdComponent(ref == null ? xsdComponent : ref);
                    use.setNamespace(fragment.getRoot() == null ? null : fragment.getRoot().getNamespace());
                    use.setParent((XmlElementHolder)((Object)documentElement));
                    return;
                }
                if (ModelerCore.DEBUG_XML) {
                    System.out.println("Can't add docFragment to " + documentElement.getClass().getName());
                }
            }
        }
        boolean checkRecursion = false;
        boolean isRecursive = false;
        boolean checkExisting = false;
        if (ref != null) {
            if (this.recursionStack.contains(ref)) {
                isRecursive = true;
            }
            this.recursionStack.push(ref);
        } else {
            if (this.recursionStack.contains(xsdComponent)) {
                isRecursive = true;
            }
            this.recursionStack.push(xsdComponent);
        }
        XmlDocumentEntity documentChild = documentElement;
        ArrayList docChildren = new ArrayList(documentChild.eContents());
        XmlDocumentEntity existingChild = this.findExistingDocumentChild(docChildren, xsdComponent);
        if (xsdComponent instanceof XSDElementDeclaration && !((XSDElementDeclaration)xsdComponent).isAbstract()) {
            name = ((XSDElementDeclaration)xsdComponent).getName();
            if (ref != null) {
                name = ((XSDElementDeclaration)ref).getName();
            }
            if (existingChild == null) {
                XmlElement temp2 = this.docFactory.createXmlElement();
                temp2.setXsdComponent(xsdComponent);
                if (documentElement instanceof XmlContainerNode) {
                    this.addValueToList(documentElement, temp2, ((XmlContainerNode)documentElement).getElements());
                } else if (ModelerCore.DEBUG_XML) {
                    System.out.println("Can't add element to " + documentElement.getClass().getName());
                }
                XSDElementDeclaration xsdElement = (XSDElementDeclaration)xsdComponent;
                if (xsdElement.getLexicalValue() != null) {
                    temp2.setValue(xsdElement.getLexicalValue());
                    XSDConstraint constraint = xsdElement.getConstraint();
                    if (XSDConstraint.DEFAULT_LITERAL.equals(constraint)) {
                        temp2.setValueType(ValueType.DEFAULT_LITERAL);
                    } else if (XSDConstraint.FIXED_LITERAL.equals(constraint)) {
                        temp2.setValueType(ValueType.FIXED_LITERAL);
                    }
                }
                documentChild = temp2;
                ++this.newCount;
            } else {
                boolean moved = this.moveIfNotAtSameIndex(existingChild, xsdComponent);
                if (moved) {
                    ++this.moveCount;
                }
                if ((newName = this.validator.createValidName(name)) != null) {
                    name = newName;
                }
                if (!name.equals(((XmlElement)existingChild).getName())) {
                    ((XmlElement)existingChild).setName(name);
                }
                documentChild = existingChild;
            }
            if (ref != null) {
                xsdComponent = ref;
            }
            checkRecursion = true;
            checkExisting = true;
            ++this.nodeCount;
            this.updateMonitor();
        } else if (xsdComponent instanceof XSDModelGroupDefinition) {
            if (ref != null) {
                xsdComponent = ref;
            }
            this.updateMonitor();
        } else if (xsdComponent instanceof XSDAttributeDeclaration) {
            name = ((XSDAttributeDeclaration)xsdComponent).getName();
            if (ref != null) {
                name = ((XSDAttributeDeclaration)ref).getName();
            }
            if (existingChild == null) {
                boolean prohibited = this.isProhibited((XSDAttributeDeclaration)xsdComponent);
                if (prohibited) {
                    this.removeChildrenOfSameName(documentElement, class$org$eclipse$xsd$XSDAttributeDeclaration == null ? (class$org$eclipse$xsd$XSDAttributeDeclaration = XmlDocumentBuilderImpl.class$("org.eclipse.xsd.XSDAttributeDeclaration")) : class$org$eclipse$xsd$XSDAttributeDeclaration, ((XSDAttributeDeclaration)xsdComponent).getName());
                } else {
                    XmlAttribute attribute = this.docFactory.createXmlAttribute();
                    attribute.setXsdComponent(xsdComponent);
                    if (documentElement instanceof XmlElement) {
                        this.addValueToList(documentElement, attribute, ((XmlElement)documentElement).getAttributes());
                    } else if (ModelerCore.DEBUG_XML) {
                        System.out.println("Can't add attribute to " + documentElement.getClass().getName());
                    }
                    documentChild = attribute;
                    ++this.newCount;
                }
            } else {
                boolean moved = this.moveIfNotAtSameIndex(existingChild, xsdComponent);
                if (moved) {
                    ++this.moveCount;
                }
                if ((newName = this.validator.createValidName(name)) != null) {
                    name = newName;
                }
                if (!name.equals(((XmlAttribute)existingChild).getName())) {
                    ((XmlAttribute)existingChild).setName(name);
                }
                documentChild = existingChild;
            }
            if (ref != null) {
                xsdComponent = ref;
            }
            checkExisting = true;
            ++this.nodeCount;
            this.updateMonitor();
        } else if (this.isAllCompositor(xsdComponent)) {
            temp = null;
            iter = documentElement.eContents().iterator();
            if (iter.hasNext()) {
                sibling = (XmlAll)iter.next();
                temp = sibling;
                temp.setXsdComponent(xsdComponent);
                documentChild = sibling;
            }
            if (temp == null) {
                temp = this.docFactory.createXmlAll();
                temp.setXsdComponent(xsdComponent);
                this.addValueToList(documentElement, temp, ((XmlContainerHolder)((Object)documentElement)).getContainers());
                documentChild = temp;
                ++this.newCount;
            }
            if (ref != null) {
                xsdComponent = ref;
            }
            checkRecursion = true;
            ++this.nodeCount;
            this.updateMonitor();
        } else if (this.isChoiceCompositor(xsdComponent)) {
            if (existingChild == null) {
                temp = this.docFactory.createXmlChoice();
                temp.setXsdComponent(xsdComponent);
                this.addValueToList(documentElement, temp, ((XmlContainerHolder)((Object)documentElement)).getContainers());
                documentChild = temp;
                ++this.newCount;
            } else {
                documentChild = existingChild;
            }
            checkExisting = true;
            ++this.nodeCount;
            this.updateMonitor();
        } else if (this.isSequenceCompositor(xsdComponent)) {
            temp = null;
            iter = documentElement.eContents().iterator();
            while (iter.hasNext()) {
                sibling = (EObject)iter.next();
                if (!(sibling instanceof XmlSequence) || !this.isValidSequenceForReuse((EObject)this.findSchemaReference(sibling), (EObject)xsdComponent)) continue;
                temp = (XmlSequence)sibling;
                documentChild = temp;
                break;
            }
            if (temp == null) {
                temp = this.docFactory.createXmlSequence();
                this.addValueToList(documentElement, temp, ((XmlContainerHolder)((Object)documentElement)).getContainers());
                documentChild = temp;
                ++this.newCount;
            }
            temp.setXsdComponent(xsdComponent);
            ++this.nodeCount;
            this.updateMonitor();
        }
        if (isRecursive && checkRecursion) {
            if (documentChild instanceof XmlElement) {
                ((XmlElement)documentChild).setRecursive(true);
            }
            if (this.recursiveElementUUIDs.contains(documentChild.getObjectId())) {
                if (!this.recursionStack.isEmpty()) {
                    this.recursionStack.pop();
                }
                return;
            }
            this.recursiveElementUUIDs.add(documentChild.getObjectId());
            if (!this.recursionStack.isEmpty()) {
                this.recursionStack.pop();
            }
            return;
        }
        if (documentChild != documentElement) {
            this.updateSchemaUris(documentChild, xsdComponent);
        }
        if ((typeEntity = XmlDocumentUtil.findXSDType(xsdComponent)) != null && typeEntity.eContainer() != null && !typeEntity.eContainer().equals(xsdComponent)) {
            if (checkExisting && existingChild == null) {
                this.addChildren(documentChild, (XSDComponent)typeEntity, taskName);
            } else {
                this.updateAdd(documentChild, (XSDComponent)typeEntity, taskName);
            }
        }
        Iterator children = xsdComponent.eContents().iterator();
        while (children.hasNext()) {
            EObject schemaChild = (EObject)children.next();
            if (!(schemaChild instanceof XSDComponent)) continue;
            if (checkExisting && existingChild == null) {
                this.addChildren(documentChild, (XSDComponent)schemaChild, taskName);
                continue;
            }
            this.updateAdd(documentChild, (XSDComponent)schemaChild, taskName);
        }
        if (!this.recursionStack.isEmpty()) {
            this.recursionStack.pop();
        }
    }

    private boolean moveIfNotAtSameIndex(XmlDocumentEntity documentElement, XSDComponent xsdComponent) throws ModelerCoreException {
        boolean moved = false;
        XmlDocumentEntity docParent = (XmlDocumentEntity)documentElement.eContainer();
        XSDComponent schemaParent = (XSDComponent)xsdComponent.eContainer();
        int docIndex = this.getIndexOfChild(docParent, documentElement);
        int schemaIndex = this.getIndexOfChild((EObject)schemaParent, (EObject)xsdComponent);
        if (docIndex == -1) {
            throw new ModelerCoreException(XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.Unable_to_find_document_index_for_{0}_5") + xsdComponent.toString());
        }
        if (schemaIndex == -1) {
            throw new ModelerCoreException(XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.Unable_to_find_schema_index_for_{0}_6") + documentElement.toString());
        }
        if (docIndex == 0 && schemaIndex == 0) {
            return moved;
        }
        EList docList = (EList)docParent.eGet(documentElement.eContainmentFeature());
        EList schemaList = null;
        schemaList = schemaParent instanceof XSDParticle || schemaParent instanceof XSDAttributeUse ? (EList)schemaParent.eContainer().eGet(schemaParent.eContainmentFeature()) : (EList)schemaParent.eGet((EStructuralFeature)xsdComponent.eContainmentFeature());
        if (schemaIndex > 0 && docList.size() > 1) {
            EObject tempSchemaElement = (EObject)schemaList.get(schemaIndex - 1);
            Iterator docChildren = docList.iterator();
            boolean found = false;
            while (docChildren.hasNext() && !found) {
                EObject docChild = (EObject)docChildren.next();
                XSDComponent schemaRef = this.findSchemaReference(docChild);
                if (schemaRef == null || schemaRef != tempSchemaElement) continue;
                found = true;
                int temp = this.getIndexOfChild(docParent, docChild) + 1;
                if (temp == docIndex) continue;
                this.me.move((Object)docParent, (EObject)documentElement, temp);
                moved = true;
            }
        } else if (schemaIndex == 0 && docList.size() > 1) {
            int foundIndex = Integer.MAX_VALUE;
            Iterator docChildren = docList.iterator();
            while (docChildren.hasNext()) {
                int temp;
                EObject docChild = (EObject)docChildren.next();
                XSDComponent schemaRef = this.findSchemaReference(docChild);
                if (schemaRef == null || schemaRef == xsdComponent || !schemaList.contains((Object)schemaRef) || (temp = this.getIndexOfChild(docParent, docChild)) >= foundIndex) continue;
                foundIndex = temp;
            }
            if (foundIndex < Integer.MAX_VALUE && foundIndex != docIndex) {
                this.me.move((Object)docParent, (EObject)documentElement, foundIndex);
                moved = true;
            }
        }
        return moved;
    }

    private int getIndexOfChild(EObject parent, EObject child) {
        if (child.eContainer() == null || !child.eContainer().equals(parent)) {
            return -1;
        }
        if (parent instanceof XSDParticle || parent instanceof XSDAttributeUse) {
            return this.getIndexOfChild(parent.eContainer(), parent);
        }
        EReference sf = child.eContainmentFeature();
        if (sf == null) {
            return -1;
        }
        Object result = parent.eGet(sf);
        if (result == null || !(result instanceof EList)) {
            return -1;
        }
        return ((EList)result).indexOf((Object)child);
    }

    private XmlDocumentEntity findExistingDocumentChild(ArrayList documentChildren, XSDComponent xsdComponent) {
        if (documentChildren == null || documentChildren.isEmpty()) {
            return null;
        }
        Iterator children = documentChildren.iterator();
        while (children.hasNext()) {
            XmlDocumentEntity next = (XmlDocumentEntity)children.next();
            if (!xsdComponent.equals(this.findSchemaReference(next))) continue;
            return next;
        }
        if (this.isAllCompositor(xsdComponent) || this.isSequenceCompositor(xsdComponent)) {
            children = documentChildren.iterator();
            while (children.hasNext()) {
                XmlDocumentEntity child = (XmlDocumentEntity)children.next();
                XSDComponent schemaRef = this.findSchemaReference(child);
                if (schemaRef == null || !xsdComponent.eClass().equals(schemaRef.eClass())) continue;
                Iterator grandchildren = child.eContents().iterator();
                while (grandchildren.hasNext()) {
                    XmlDocumentEntity grandchild = (XmlDocumentEntity)grandchildren.next();
                    XSDComponent gcSchemaRef = this.findSchemaReference(grandchild);
                    if (!xsdComponent.eContents().contains((Object)gcSchemaRef)) continue;
                    return child;
                }
            }
        }
        return null;
    }

    private XSDComponent findSchemaReference(EObject child) {
        if (child instanceof XmlDocumentNode) {
            return ((XmlDocumentNode)child).getXsdComponent();
        }
        if (child instanceof XmlContainerNode) {
            return ((XmlContainerNode)child).getXsdComponent();
        }
        return null;
    }

    private void updateMonitor() {
        if (this.factor > 0) {
            this.monitor.worked(this.factor);
            return;
        }
        --this.tempFactor;
        if (this.tempFactor == this.factor) {
            this.monitor.worked(1);
            this.tempFactor = 0;
        }
    }

    private XSDComponent resolveSchemaRef(XSDComponent schemaComponent) {
        XSDElementDeclaration ref = null;
        if (schemaComponent instanceof XSDElementDeclaration) {
            ref = ((XSDElementDeclaration)schemaComponent).getResolvedElementDeclaration();
        } else if (schemaComponent instanceof XSDModelGroupDefinition) {
            ref = ((XSDModelGroupDefinition)schemaComponent).getResolvedModelGroupDefinition();
        } else if (schemaComponent instanceof XSDAttributeDeclaration) {
            ref = ((XSDAttributeDeclaration)schemaComponent).getResolvedAttributeDeclaration();
        } else if (schemaComponent instanceof XSDAttributeGroupDefinition) {
            ref = ((XSDAttributeGroupDefinition)schemaComponent).getResolvedAttributeGroupDefinition();
        }
        if (ref == null || ref == schemaComponent) {
            return null;
        }
        return ref;
    }

    private void initializeRecursionStack(XmlElement root) {
        this.recursionStack = new Stack();
        this.addRecursionParentTypes(root);
    }

    private void addRecursionParentTypes(XmlBaseElement node) {
        XmlElementHolder parent = node.getParent();
        if (parent instanceof XmlBaseElement) {
            this.addRecursionParentTypes((XmlBaseElement)((Object)parent));
        } else if (parent instanceof XmlContainerNode) {
            XmlContainerHolder nextParent = ((XmlContainerNode)parent).getParent();
            while (nextParent != null) {
                if (nextParent instanceof XmlElement) {
                    this.addRecursionParentTypes((XmlElement)nextParent);
                    break;
                }
                nextParent = ((XmlContainerNode)parent).getParent();
            }
        }
        XSDComponent schemaComponent = node.getXsdComponent();
        XSDComponent ref = this.resolveSchemaRef(schemaComponent);
        if (ref != null) {
            this.recursionStack.push(ref);
        } else {
            this.recursionStack.push(schemaComponent);
        }
    }

    private boolean isValidSequenceForReuse(EObject sequence1, EObject sequence2) {
        if (sequence1 == null || sequence2 == null) {
            return false;
        }
        if (sequence1 instanceof XSDModelGroup && sequence2 instanceof XSDModelGroup) {
            EObject obj1 = sequence1.eContainer();
            EObject obj2 = sequence2.eContainer();
            boolean sameMult = false;
            if (obj1 instanceof XSDParticle && obj2 instanceof XSDParticle) {
                XSDParticle p1 = (XSDParticle)sequence1.eContainer();
                XSDParticle p2 = (XSDParticle)sequence2.eContainer();
                if (p1 != null && p2 != null) {
                    int max2;
                    int max1 = p1.getMaxOccurs();
                    boolean maxMatch = max1 == (max2 = p2.getMaxOccurs());
                    int min1 = p1.getMinOccurs();
                    int min2 = p2.getMinOccurs();
                    boolean minMatch = min1 == min2;
                    sameMult = minMatch && maxMatch;
                }
                boolean isChoice = false;
                if (sameMult) {
                    EObject parent2;
                    EObject parent1 = p1.eContainer();
                    if (parent1 == (parent2 = p2.eContainer()) && parent1 != null && parent1 instanceof XSDModelGroup) {
                        isChoice = ((XSDModelGroup)parent1).getCompositor().equals(XSDCompositor.CHOICE_LITERAL);
                    }
                    if (isChoice) {
                        return false;
                    }
                }
                return sameMult;
            }
        }
        return false;
    }

    private void addChildren(XmlDocumentEntity docParent, XSDComponent xsdComponent, String taskName) {
        XSDTypeDefinition typeEntity;
        Object sibling;
        Iterator iter;
        XmlContainerNode temp;
        String newName;
        String name;
        boolean proceed;
        XmlNamespace ns;
        String uri;
        XSDFeature feature;
        XmlElement elem;
        XSDComponent parentXsdComp;
        if (docParent instanceof XmlElement && (parentXsdComp = (elem = (XmlElement)docParent).getXsdComponent()) instanceof XSDFeature && ((feature = (XSDFeature)parentXsdComp).isGlobal() || XSDForm.QUALIFIED_LITERAL.equals(feature.getForm())) && (uri = feature.getTargetNamespace()) != null && (ns = (XmlNamespace)this.uriToNamespaceMap.get(uri)) != null) {
            elem.setNamespace(ns);
        }
        if (this.numberOfLevelsToBuild != -1 && !(proceed = this.checkDepth(docParent))) {
            this.setBuildStatusProperty((XmlBuildable)((Object)docParent), BuildStatus.INCOMPLETE_LITERAL);
            return;
        }
        if (this.monitor.isCanceled()) {
            return;
        }
        XSDComponent ref = this.resolveSchemaRef(xsdComponent);
        if (this.useFragments) {
            XmlFragment fragment;
            XmlFragment xmlFragment = fragment = ref == null ? (XmlFragment)this.fragmentMap.get(xsdComponent) : (XmlFragment)this.fragmentMap.get(ref);
            if (fragment != null) {
                if (docParent instanceof XmlElementHolder) {
                    XmlFragmentUse use = this.docFactory.createXmlFragmentUse();
                    use.setFragment(fragment);
                    use.setName(fragment.getName());
                    use.setXsdComponent(ref == null ? xsdComponent : ref);
                    use.setNamespace(fragment.getRoot() == null ? null : fragment.getRoot().getNamespace());
                    use.setParent((XmlElementHolder)((Object)docParent));
                    return;
                }
                if (ModelerCore.DEBUG_XML) {
                    System.out.println("Can't add docFragment to " + docParent.getClass().getName());
                }
            }
        }
        boolean isRecursive = false;
        if (ref != null) {
            isRecursive = this.isRecursive(ref);
            this.recursionStack.push(ref);
        } else {
            isRecursive = this.isRecursive(xsdComponent);
            this.recursionStack.push(xsdComponent);
        }
        XmlDocumentEntity documentChild = docParent;
        if (xsdComponent instanceof XSDElementDeclaration && !((XSDElementDeclaration)xsdComponent).isAbstract()) {
            XmlElement element = this.docFactory.createXmlElement();
            element.setXsdComponent(xsdComponent);
            if (docParent instanceof XmlContainerNode) {
                this.addValueToList(docParent, element, ((XmlContainerNode)docParent).getElements());
            } else if (ModelerCore.DEBUG_XML) {
                System.out.println("Can't add element to " + docParent.getClass().getName());
            }
            XSDElementDeclaration xsdElement = (XSDElementDeclaration)xsdComponent;
            if (xsdElement.getLexicalValue() != null) {
                element.setValue(xsdElement.getLexicalValue());
                XSDConstraint constraint = xsdElement.getConstraint();
                if (XSDConstraint.DEFAULT_LITERAL.equals(constraint)) {
                    element.setValueType(ValueType.DEFAULT_LITERAL);
                } else if (XSDConstraint.FIXED_LITERAL.equals(constraint)) {
                    element.setValueType(ValueType.FIXED_LITERAL);
                }
            }
            documentChild = element;
            if (ref != null) {
                xsdComponent = ref;
            }
            name = ((XSDElementDeclaration)xsdComponent).getName();
            if (ref != null) {
                name = ((XSDElementDeclaration)ref).getName();
            }
            if ((newName = this.validator.createValidName(name)) != null) {
                name = newName;
            }
            element.setName(name);
            ++this.nodeCount;
            this.updateMonitor();
        } else if (xsdComponent instanceof XSDModelGroupDefinition || xsdComponent instanceof XSDAttributeGroupDefinition) {
            if (ref != null) {
                xsdComponent = ref;
            }
            this.updateMonitor();
        } else if (xsdComponent instanceof XSDAttributeDeclaration) {
            boolean prohibited = this.isProhibited((XSDAttributeDeclaration)xsdComponent);
            if (prohibited) {
                this.removeChildrenOfSameName(docParent, class$org$eclipse$xsd$XSDAttributeDeclaration == null ? (class$org$eclipse$xsd$XSDAttributeDeclaration = XmlDocumentBuilderImpl.class$("org.eclipse.xsd.XSDAttributeDeclaration")) : class$org$eclipse$xsd$XSDAttributeDeclaration, ((XSDAttributeDeclaration)xsdComponent).getName());
            } else {
                XmlAttribute attribute = this.docFactory.createXmlAttribute();
                attribute.setXsdComponent(xsdComponent);
                if (docParent instanceof XmlElement) {
                    this.addValueToList(docParent, attribute, ((XmlElement)docParent).getAttributes());
                } else if (ModelerCore.DEBUG_XML) {
                    System.out.println("Can't add attribute to " + docParent.getClass().getName());
                }
                documentChild = attribute;
                if (ref != null) {
                    xsdComponent = ref;
                }
                name = ((XSDAttributeDeclaration)xsdComponent).getName();
                if (ref != null) {
                    name = ((XSDAttributeDeclaration)ref).getName();
                }
                if ((newName = this.validator.createValidName(name)) != null) {
                    name = newName;
                }
                attribute.setName(name);
                ++this.nodeCount;
                this.updateMonitor();
            }
        } else if (this.isAllCompositor(xsdComponent)) {
            temp = null;
            iter = docParent.eContents().iterator();
            while (iter.hasNext()) {
                sibling = iter.next();
                if (!(sibling instanceof XmlAll)) continue;
                temp = (XmlAll)sibling;
                break;
            }
            if (temp == null) {
                temp = this.docFactory.createXmlAll();
                this.addValueToList(docParent, temp, ((XmlContainerHolder)((Object)docParent)).getContainers());
                if (ref != null) {
                    xsdComponent = ref;
                }
                ++this.nodeCount;
                this.updateMonitor();
            }
            temp.setXsdComponent(xsdComponent);
            documentChild = temp;
        } else if (this.isChoiceCompositor(xsdComponent)) {
            XmlChoice choice = this.docFactory.createXmlChoice();
            choice.setXsdComponent(xsdComponent);
            this.addValueToList(docParent, choice, ((XmlContainerHolder)((Object)docParent)).getContainers());
            documentChild = choice;
            ++this.nodeCount;
            this.updateMonitor();
        } else if (this.isSequenceCompositor(xsdComponent)) {
            temp = null;
            if (documentChild instanceof XmlSequence && this.isValidSequenceForReuse((EObject)((XmlSequence)documentChild).getXsdComponent(), (EObject)xsdComponent)) {
                temp = (XmlSequence)documentChild;
            }
            if (temp == null) {
                iter = docParent.eContents().iterator();
                while (iter.hasNext()) {
                    sibling = iter.next();
                    if (!(sibling instanceof XmlSequence) || !this.isValidSequenceForReuse((EObject)((XmlSequence)sibling).getXsdComponent(), (EObject)xsdComponent)) continue;
                    temp = (XmlSequence)sibling;
                    documentChild = temp;
                    break;
                }
                if (temp == null) {
                    documentChild = this.docFactory.createXmlSequence();
                    this.addValueToList(docParent, documentChild, ((XmlContainerHolder)((Object)docParent)).getContainers());
                    ++this.nodeCount;
                    this.updateMonitor();
                }
                ((XmlSequence)documentChild).setXsdComponent(xsdComponent);
            }
        } else if (ModelerCore.DEBUG_XML) {
            System.out.println("Found  unexpected " + xsdComponent.getClass().getName());
        }
        if (isRecursive) {
            if (documentChild instanceof XmlElement) {
                this.setRecursiveProperty((XmlElement)documentChild, true);
                this.setBuildStatusProperty((XmlElement)documentChild, BuildStatus.INCOMPLETE_LITERAL);
            }
            if (this.recursiveElementUUIDs.contains(documentChild.getObjectId())) {
                if (!this.recursionStack.isEmpty()) {
                    this.recursionStack.pop();
                }
                return;
            }
            this.recursiveElementUUIDs.add(documentChild.getObjectId());
            if (!this.recursionStack.isEmpty()) {
                this.recursionStack.pop();
            }
            return;
        }
        if (documentChild != docParent) {
            this.updateSchemaUris(documentChild, xsdComponent);
            if (this.nodeCount % 10000 == 0) {
                System.gc();
                Thread.yield();
            }
        }
        if ((typeEntity = XmlDocumentUtil.findXSDType(xsdComponent)) != null && typeEntity.eContainer() != null && !typeEntity.eContainer().equals(xsdComponent)) {
            this.addChildren(documentChild, (XSDComponent)typeEntity, taskName);
            if (xsdComponent instanceof XSDComplexTypeDefinition && this.isRecursive((XSDComponent)typeEntity)) {
                this.setRecursiveProperty((XmlElement)documentChild, false);
            }
        }
        if (!this.recursiveElementUUIDs.contains(documentChild.getObjectId())) {
            Iterator children = xsdComponent.eContents().iterator();
            while (children.hasNext()) {
                Object child = children.next();
                if (!(child instanceof XSDComponent)) continue;
                this.addChildren(documentChild, (XSDComponent)child, taskName);
            }
        }
        if (!this.recursionStack.isEmpty()) {
            this.recursionStack.pop();
        }
    }

    private void setBuildStatusProperty(XmlBuildable xb, BuildStatus status) {
        xb.setBuildState(status);
    }

    private void setRecursiveProperty(XmlElement element, boolean recursive) {
        element.setRecursive(recursive);
        XSDComponent xsdComponent = element.getXsdComponent();
        for (EObject parent = element.eContainer(); parent != null; parent = parent.eContainer()) {
            if (!(parent instanceof XmlElement) || ((XmlElement)parent).getXsdComponent() != xsdComponent) continue;
            ((XmlElement)parent).setRecursive(recursive);
            return;
        }
    }

    private boolean isRecursive(XSDComponent xsdComponent) {
        return this.recursionStack.contains(xsdComponent);
    }

    private boolean checkDepth(EObject child) {
        boolean isCompositor;
        boolean bl = isCompositor = child instanceof XmlAll || child instanceof XmlChoice || child instanceof XmlSequence;
        if (isCompositor || child == this.root) {
            return true;
        }
        int depth = 1;
        EObject parent = child.eContainer();
        while (parent != null && parent != this.root) {
            parent = parent.eContainer();
            ++depth;
        }
        return depth < this.numberOfLevelsToBuild;
    }

    private boolean isAllCompositor(XSDComponent xsdComponent) {
        if (xsdComponent instanceof XSDModelGroup) {
            return ((XSDModelGroup)xsdComponent).getCompositor().getValue() == 0;
        }
        return false;
    }

    private boolean isSequenceCompositor(XSDComponent xsdComponent) {
        if (xsdComponent instanceof XSDModelGroup) {
            return ((XSDModelGroup)xsdComponent).getCompositor().getValue() == 2;
        }
        return false;
    }

    private boolean isChoiceCompositor(XSDComponent xsdComponent) {
        if (xsdComponent instanceof XSDModelGroup) {
            return ((XSDModelGroup)xsdComponent).getCompositor().getValue() == 1;
        }
        return false;
    }

    private boolean isProhibited(XSDAttributeDeclaration attribute) {
        ArgCheck.isNotNull((Object)attribute);
        XSDAttributeUse attUse = (XSDAttributeUse)attribute.eContainer();
        if (attUse == null) {
            return false;
        }
        XSDAttributeUseCategory cat = attUse.getUse();
        if (cat == null) {
            return false;
        }
        int val = cat.getValue();
        return val == 1;
    }

    private void removeChildrenOfSameName(EObject parent, Class clazz, String name) {
        String newName = this.validator.createValidName(name);
        if (newName != null) {
            name = newName;
        }
        Iterator children = parent.eContents().iterator();
        while (children.hasNext()) {
            EObject next = (EObject)children.next();
            if (!clazz.isAssignableFrom(next.getClass())) continue;
            try {
                String name2 = ((XmlDocumentNode)next).getName();
                if (name == null && name2 == null) {
                    this.me.delete(next);
                    continue;
                }
                if (name == null || !name.equals(name2)) continue;
                this.me.delete(next);
            }
            catch (ModelerCoreException e) {
                ModelerCore.Util.log(4, (Throwable)e, XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.Error_removing_children_of_same_name_1"));
            }
        }
    }

    private void addValueToList(Object owner, Object value, EList feature) {
        try {
            ModelerCore.getModelEditor().addValue(owner, value, feature);
        }
        catch (ModelerCoreException err) {
            ModelerCore.Util.log(4, (Throwable)err, XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.Error_adding_object", value));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

