/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.webservice.util;

import com.metamatrix.metamodels.webservice.Message;
import com.metamatrix.metamodels.webservice.Output;
import com.metamatrix.metamodels.webservice.util.WebServiceComponentFinder;
import com.metamatrix.metamodels.xml.XmlDocument;
import com.metamatrix.metamodels.xml.XmlRoot;
import com.metamatrix.modeler.core.ModelerCoreException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDSchema;

public class ReferencedXSDSchemaFinder
extends WebServiceComponentFinder {
    private final Set xsds = new HashSet();
    private final Set targetNamespaces = new HashSet();

    public boolean visit(EObject object) throws ModelerCoreException {
        if (object instanceof Message) {
            Message msg = (Message)object;
            this.found((XSDComponent)msg.getContentComplexType());
            this.found((XSDComponent)msg.getContentSimpleType());
            this.found((XSDComponent)msg.getContentElement());
            if (msg instanceof Output) {
                this.found(((Output)msg).getXmlDocument());
            }
        }
        return true;
    }

    protected void found(XSDComponent xsdComponent) {
        XSDSchema schema;
        if (xsdComponent != null && (schema = xsdComponent.getSchema()) != null) {
            this.xsds.add(schema);
            String ns = schema.getTargetNamespace();
            if (ns != null && ns.trim().length() != 0) {
                this.targetNamespaces.add(ns);
            }
        }
    }

    protected void found(XmlDocument xmlDocument) {
        XmlRoot root;
        if (xmlDocument != null && (root = xmlDocument.getRoot()) != null) {
            this.found(root.getXsdComponent());
        }
    }

    public Set getXsdSchemas() {
        return this.xsds;
    }

    public Set getXsdTargetNamespaces() {
        return this.targetNamespaces;
    }
}

