/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.xsd.validator;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.internal.core.xml.xsd.XsdHeader;
import com.metamatrix.internal.core.xml.xsd.XsdHeaderReader;
import com.metamatrix.metamodels.xsd.XsdPlugin;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.validation.ResourceValidationRule;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.core.validation.ValidationProblem;
import com.metamatrix.modeler.core.validation.ValidationResult;
import com.metamatrix.modeler.internal.core.validation.ValidationProblemImpl;
import com.metamatrix.modeler.internal.core.validation.ValidationResultImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDResourceImpl;

public class XsdResourceValidationRule
implements ResourceValidationRule {
    public void validate(Resource resource, ValidationContext context) {
        ArgCheck.isNotNull((Object)resource);
        ArgCheck.isNotNull((Object)context);
        if (!(resource instanceof XSDResourceImpl)) {
            return;
        }
        XSDSchema schema = ((XSDResourceImpl)resource).getSchema();
        if (schema != null) {
            File f;
            ValidationResultImpl result = new ValidationResultImpl((Object)schema);
            URI uri = resource.getURI();
            if (uri.isFile() && (f = new File(uri.toFileString())).exists()) {
                try {
                    XsdHeader header = XsdHeaderReader.readHeader((File)f);
                    ArrayList<String> declarations = new ArrayList<String>();
                    if (header != null) {
                        declarations.addAll(Arrays.asList(header.getImportSchemaLocations()));
                        declarations.addAll(Arrays.asList(header.getIncludeSchemaLocations()));
                        Iterator i = declarations.iterator();
                        while (i.hasNext()) {
                            String uriString;
                            File importFile;
                            String location = (String)i.next();
                            if (StringUtil.isEmpty((String)location) || location.startsWith("http")) continue;
                            URI baseUri = URI.createFileURI((String)f.getAbsolutePath());
                            URI locationUri = URI.createURI((String)location);
                            if (baseUri.isHierarchical() && !baseUri.isRelative() && locationUri.isRelative()) {
                                locationUri = locationUri.resolve(baseUri);
                            }
                            if ((importFile = new File(uriString = locationUri.isFile() ? locationUri.toFileString() : URI.decode((String)locationUri.toString()))).exists()) continue;
                            String msg = XsdPlugin.Util.getString("XsdResourceValidationRule.Schema_directive_resolves_to_nonexistent_file", (Object)location);
                            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
                            result.addProblem((ValidationProblem)problem);
                        }
                    }
                }
                catch (Throwable e) {
                    ModelerCore.Util.log(e);
                }
            }
            if (result.hasProblems()) {
                context.addResult((ValidationResult)result);
            }
        }
    }
}

