/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.compare.selector;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.modeler.compare.selector.ModelContentsModelHelper;
import com.metamatrix.modeler.compare.selector.ModelHelper;
import com.metamatrix.modeler.compare.selector.TemporaryResourceModelSelector;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.core.resource.RegisteredUriConverter;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;

public class InputStreamModelSelector
extends TemporaryResourceModelSelector {
    public static final URI XMI_URI = URI.createURI((String)"streamscheme://metamatrix/hard-codedstream.xmi");
    public static final URI XML_URI = URI.createURI((String)"streamscheme://metamatrix/hard-codedstream.xml");
    public static final URI XSD_URI = URI.createURI((String)"streamscheme://metamatrix/hard-codedstream.xsd");
    public static final URI VDB_URI = URI.createURI((String)"streamscheme://metamatrix/hard-codedstream.vdb");
    private Resource resource;
    private final InputStream stream;
    private ModelContents contents;
    private ModelHelper helper;
    private final URI uri;

    public InputStreamModelSelector(InputStream stream, URI uri) {
        ArgCheck.isNotNull((Object)stream);
        this.stream = stream;
        this.uri = uri;
    }

    public void open() {
        if (this.resource == null) {
            URIConverter origConverter = this.getResourceSet().getURIConverter();
            RegisteredUriConverter converter = new RegisteredUriConverter(origConverter);
            converter.register(this.uri, this.stream);
            this.getResourceSet().setURIConverter((URIConverter)converter);
            this.resource = this.getResourceSet().getResource(this.uri, false);
            if (this.resource != null) {
                this.resource.unload();
            }
            this.resource = this.getResourceSet().getResource(this.uri, true);
            if (this.resource instanceof EmfResource) {
                this.contents = ((EmfResource)this.resource).getModelContents();
            }
            if (this.contents == null) {
                this.contents = new ModelContents(this.resource);
            }
        }
    }

    public Resource getResource() throws ModelerCoreException {
        if (this.resource == null) {
            this.open();
        }
        return this.resource;
    }

    public List getRootObjects() throws ModelerCoreException {
        return this.getResource().getContents();
    }

    public URI getUri() {
        try {
            return this.getResource().getURI();
        }
        catch (ModelerCoreException modelerCoreException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.resource != null) {
                this.resource.unload();
            }
            Object var2_1 = null;
            this.contents = null;
            this.helper = null;
            this.resource = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.contents = null;
            this.helper = null;
            this.resource = null;
            throw throwable;
        }
    }

    public ModelAnnotation getModelAnnotation() throws ModelWorkspaceException {
        return this.contents.getModelAnnotation();
    }

    public ModelHelper getModelHelper() throws ModelWorkspaceException {
        if (this.helper == null) {
            this.helper = new ModelContentsModelHelper(this.contents);
        }
        return this.helper;
    }

    public ModelContents getModelContents() throws ModelWorkspaceException {
        return this.contents;
    }

    public static URI getTemporatyResourceURI(IPath path) {
        if (ModelUtil.isXsdFile((IPath)path)) {
            return XSD_URI;
        }
        if (ModelUtil.isModelFile((IPath)path)) {
            return XMI_URI;
        }
        if (ModelUtil.isVdbArchiveFile((IPath)path)) {
            return VDB_URI;
        }
        return null;
    }
}

