/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.ddl;

import com.metamatrix.core.PluginUtil;
import com.metamatrix.core.util.PluginUtilImpl;
import com.metamatrix.core.xslt.Style;
import com.metamatrix.core.xslt.StyleFromResource;
import com.metamatrix.core.xslt.StyleFromUrlStream;
import com.metamatrix.core.xslt.StyleRegistry;
import com.metamatrix.core.xslt.impl.StyleRegistryImpl;
import com.metamatrix.modeler.ddl.DdlWriter;
import com.metamatrix.modeler.internal.ddl.DdlWriterImpl;
import java.net.URL;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public class DdlPlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.metamatrix.modeler.ddl";
    private static final String BUNDLE_NAME = "com.metamatrix.modeler.ddl.i18n";
    public static final PluginUtil Util = new PluginUtilImpl("com.metamatrix.modeler.ddl", "com.metamatrix.modeler.ddl.i18n", ResourceBundle.getBundle("com.metamatrix.modeler.ddl.i18n"));
    public static final String DELIMITER = ".";
    public static boolean DEBUG = false;
    private static final StyleRegistry STYLE_REGISTRY = new StyleRegistryImpl();

    public DdlPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
    }

    public void startup() throws CoreException {
        super.startup();
        ((PluginUtilImpl)Util).initializePlatformLogger((Plugin)this);
        DdlPlugin.loadStyleRegistryFromExtensions(STYLE_REGISTRY);
    }

    public static DdlWriter createDdlWriter() {
        return new DdlWriterImpl();
    }

    public static StyleRegistry getStyleRegistry() {
        return STYLE_REGISTRY;
    }

    protected static void loadStyleRegistryFromExtensions(StyleRegistry registry) {
        IPluginRegistry pluginRegistry = Platform.getPluginRegistry();
        IExtensionPoint ddlStyleXP = pluginRegistry.getExtensionPoint("com.metamatrix.modeler.ddl.style");
        IExtension[] extensions = ddlStyleXP.getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            ClassLoader loader;
            IExtension extension = extensions[i];
            String extensionName = extension.getLabel();
            String desc = null;
            String xsltPath = null;
            IConfigurationElement[] elements = extension.getConfigurationElements();
            for (int j = 0; j < elements.length; ++j) {
                IConfigurationElement element = elements[j];
                String elementName = element.getName();
                if ("description".equals(elementName)) {
                    desc = element.getValue();
                    continue;
                }
                if (!"xsltPath".equals(elementName)) continue;
                xsltPath = element.getValue();
            }
            if (extensionName == null || xsltPath == null) continue;
            Style ddlStyle = null;
            try {
                URL url = new URL(xsltPath);
                String protocol = url.getProtocol();
                if (protocol != null && protocol.trim().length() != 0) {
                    ddlStyle = new StyleFromUrlStream(extensionName, xsltPath, desc);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (ddlStyle == null && (loader = extension.getDeclaringPluginDescriptor().getPluginClassLoader()) != null) {
                ddlStyle = new StyleFromResource(loader, extensionName, xsltPath, desc);
            }
            if (ddlStyle == null) continue;
            registry.getStyles().add(ddlStyle);
        }
    }

    public static class EXTENSION_POINT {

        public static class DDL_STYLE {
            public static final String ID = "style";
            public static final String UNIQUE_ID = "com.metamatrix.modeler.ddl.style";

            public static class ELEMENTS {
                public static final String DESCRIPTION = "description";
                public static final String XSLT_PATH = "xsltPath";
            }
        }
    }
}

