/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.ddl;

import com.metamatrix.core.log.Logger;
import com.metamatrix.core.log.NullLogger;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.xslt.Style;
import com.metamatrix.core.xslt.XsltTransform;
import com.metamatrix.internal.core.xml.JdomHelper;
import com.metamatrix.modeler.core.ModelEditor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceSelections;
import com.metamatrix.modeler.ddl.DdlOptions;
import com.metamatrix.modeler.ddl.DdlPlugin;
import com.metamatrix.modeler.ddl.DdlWriter;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.ddl.DdlOptionsImpl;
import com.metamatrix.modeler.internal.ddl.IntermediateFormat;
import com.metamatrix.modeler.internal.ddl.ModelWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;

public class DdlWriterImpl
implements DdlWriter {
    public static final String EXPORT_TOOL_NAME = DdlPlugin.Util.getString("DdlWriterImpl.ExportToolName");
    public static final String EXPORT_TOOL_VERSION = DdlPlugin.Util.getString("DdlWriterImpl.ExportToolVersion");
    public static final int WRITTEN_WITH_NO_PROBLEMS = 4001;
    public static final int UNABLE_TO_GET_EMF_RESOURCE = 4002;
    public static final int WRITE_WITH_WARNINGS = 4003;
    public static final int WRITE_WITH_ERRORS = 4004;
    public static final int WRITE_WITH_WARNINGS_AND_ERRORS = 4005;
    public static final int WRITE_WITH_NO_WARNINGS_AND_ERRORS = 4006;
    public static final int UNEXPECTED_EXCEPTION = 4007;
    public static final int XSLT_PROBLEMS = 4008;
    public static final int UNEXPECTED_IO_EXCEPTION = 4009;
    public static final int TRANSFORMER_CONFIGURATION_EXCEPTION = 4010;
    public static final int ERROR_COMPUTING_RESOURCES_TO_BE_EXPORTED = 4011;
    private Logger logger = new NullLogger();
    private final DdlOptions options = new DdlOptionsImpl();

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger != null ? logger : new NullLogger();
    }

    public DdlOptions getOptions() {
        return this.options;
    }

    public IStatus write(Resource emfResource, String modelName, String modelFilename, OutputStream stream, IProgressMonitor monitor) {
        ArgCheck.isNotNull((Object)emfResource);
        ArgCheck.isNotNull((Object)stream);
        ArgCheck.isNotNull((Object)modelName);
        ModelContents contents = emfResource instanceof EmfResource ? ((EmfResource)emfResource).getModelContents() : new ModelContents(emfResource);
        ModelWrapper wrapper = new ModelWrapper(emfResource, contents, null, modelName, modelFilename);
        IntermediateFormat formatter = new IntermediateFormat(wrapper, this.options, monitor);
        return this.doWrite(formatter, stream, (IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
    }

    public IStatus write(ModelResource model, OutputStream stream, IProgressMonitor monitor) {
        ArgCheck.isNotNull((Object)model);
        ArgCheck.isNotNull((Object)stream);
        try {
            Resource emfResource = model.getEmfResource();
            ModelEditor editor = ModelerCore.getModelEditor();
            String modelName = editor.getModelName(model);
            String modelFilename = model.getPath().toString();
            ModelContents contents = ModelContents.getModelContents((ModelResource)model);
            ModelWrapper wrapper = new ModelWrapper(emfResource, contents, null, modelName, modelFilename);
            IntermediateFormat formatter = new IntermediateFormat(wrapper, this.options, monitor);
            return this.doWrite(formatter, stream, (IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
        }
        catch (ModelWorkspaceException e) {
            int code = 4002;
            Object[] params = new Object[]{model.getPath()};
            String msg = DdlPlugin.Util.getString("DdlWriterImpl.Error_getting_EMF_resource", params);
            return new Status(4, "com.metamatrix.modeler.ddl", 4002, msg, (Throwable)e);
        }
    }

    public IStatus write(ModelWorkspaceSelections selections, OutputStream stream, IProgressMonitor monitor) {
        ArgCheck.isNotNull((Object)selections);
        ArgCheck.isNotNull((Object)selections.getModelWorkspaceView());
        ArgCheck.isNotNull((Object)stream);
        List modelResources = null;
        try {
            modelResources = selections.getSelectedOrPartiallySelectedModelResources();
        }
        catch (ModelWorkspaceException e) {
            int code = 4011;
            return new Status(4, "com.metamatrix.modeler.ddl", 4011, e.getMessage(), (Throwable)e);
        }
        LinkedList<ModelWrapper> wrappers = new LinkedList<ModelWrapper>();
        Iterator iter = modelResources.iterator();
        while (iter.hasNext()) {
            ModelResource modelResource = (ModelResource)iter.next();
            IPath modelPath = modelResource.getPath();
            try {
                Resource emfResource = modelResource.getEmfResource();
                ModelEditor editor = ModelerCore.getModelEditor();
                String modelName = editor.getModelName(modelResource);
                String modelFilename = modelPath.toString();
                ModelContents contents = ModelContents.getModelContents((ModelResource)modelResource);
                ModelWrapper wrapper = new ModelWrapper(emfResource, contents, selections, modelName, modelFilename);
                wrappers.add(wrapper);
            }
            catch (ModelWorkspaceException e) {
                int code = 4002;
                Object[] params = new Object[]{modelPath};
                String msg = DdlPlugin.Util.getString("DdlWriterImpl.Error_getting_EMF_resource", params);
                return new Status(4, "com.metamatrix.modeler.ddl", 4002, msg, (Throwable)e);
            }
        }
        IntermediateFormat formatter = new IntermediateFormat(wrappers, this.options, monitor);
        return this.doWrite(formatter, stream, (IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus doWrite(IntermediateFormat formatter, OutputStream stream, IProgressMonitor monitor) {
        Status status;
        String msg;
        ArgCheck.isNotNull((Object)formatter);
        ArgCheck.isNotNull((Object)stream);
        String taskName = DdlPlugin.Util.getString("DdlWriterImpl.ProgressMonitor_main_task_name");
        int unitsPerPhase = 100;
        int numUnits = 600;
        monitor.beginTask(null, 600);
        monitor.setTaskName(taskName);
        ArrayList<Status> problems = new ArrayList<Status>();
        String PLUGINID = "com.metamatrix.modeler.ddl";
        try {
            Document intDoc = formatter.createDocument();
            Style style = this.options.getStyle();
            if (style != null) {
                XsltTransform xform = new XsltTransform(style);
                xform.transform(intDoc, stream);
            } else {
                XMLOutputter outputter = new XMLOutputter(JdomHelper.getFormat((String)"  ", (boolean)true));
                outputter.output(intDoc, stream);
            }
        }
        catch (TransformerConfigurationException e) {
            int code = 4010;
            msg = DdlPlugin.Util.getString("DdlWriterImpl.Error_while_initializing_and_configuring_XSLT_transformer");
            status = new Status(4, "com.metamatrix.modeler.ddl", 4010, msg, (Throwable)e);
            problems.add(status);
        }
        catch (IOException e) {
            int code = 4009;
            msg = DdlPlugin.Util.getString("DdlWriterImpl.Unexpected_I/O_exception");
            status = new Status(4, "com.metamatrix.modeler.ddl", 4009, msg, (Throwable)e);
            problems.add(status);
        }
        catch (TransformerException e) {
            int code = 4008;
            msg = DdlPlugin.Util.getString("DdlWriterImpl.Error_while_transforming_the_model_into_DDL");
            status = new Status(4, "com.metamatrix.modeler.ddl", 4008, msg, (Throwable)e);
            problems.add(status);
        }
        catch (Throwable e) {
            int code = 4007;
            msg = DdlPlugin.Util.getString("DdlWriterImpl.Unexpected_exception");
            status = new Status(4, "com.metamatrix.modeler.ddl", 4007, msg, e);
            problems.add(status);
        }
        finally {
            monitor.done();
        }
        IStatus resultStatus = null;
        if (problems.isEmpty()) {
            int code = 4001;
            msg = DdlPlugin.Util.getString("DdlWriterImpl.completed");
            status = new Status(0, "com.metamatrix.modeler.ddl", 4001, msg, null);
            resultStatus = status;
        } else if (problems.size() == 1) {
            resultStatus = (IStatus)problems.get(0);
        } else {
            int numErrors = 0;
            int numWarnings = 0;
            Iterator iter = problems.iterator();
            while (iter.hasNext()) {
                IStatus aStatus = (IStatus)iter.next();
                if (aStatus.getSeverity() == 2) {
                    ++numWarnings;
                    continue;
                }
                if (aStatus.getSeverity() != 4) continue;
                ++numErrors;
            }
            IStatus[] statusArray = problems.toArray(new IStatus[problems.size()]);
            if (numWarnings != 0 && numErrors == 0) {
                int code = 4003;
                Object[] params = new Object[]{new Integer(numWarnings)};
                String msg2 = DdlPlugin.Util.getString("DdlWriterImpl.warnings", params);
                resultStatus = new MultiStatus("com.metamatrix.modeler.ddl", 4003, statusArray, msg2, null);
            } else if (numWarnings == 0 && numErrors != 0) {
                int code = 4004;
                Object[] params = new Object[]{new Integer(numErrors)};
                String msg3 = DdlPlugin.Util.getString("DdlWriterImpl.errors", params);
                resultStatus = new MultiStatus("com.metamatrix.modeler.ddl", 4004, statusArray, msg3, null);
            } else if (numWarnings != 0 && numErrors != 0) {
                int code = 4005;
                Object[] params = new Object[]{new Integer(numWarnings), new Integer(numErrors)};
                String msg4 = DdlPlugin.Util.getString("DdlWriterImpl.warnings_and_errors", params);
                resultStatus = new MultiStatus("com.metamatrix.modeler.ddl", 4005, statusArray, msg4, null);
            } else {
                int code = 4006;
                String msg5 = DdlPlugin.Util.getString("DdlWriterImpl.no_warnings_or_errors");
                resultStatus = new MultiStatus("com.metamatrix.modeler.ddl", 4006, statusArray, msg5, null);
            }
        }
        return resultStatus;
    }
}

