/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.jdbc.data;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.jdbc.JdbcPlugin;
import com.metamatrix.modeler.jdbc.data.JdbcConversionException;
import com.metamatrix.modeler.jdbc.data.Response;
import com.metamatrix.modeler.jdbc.data.Results;
import com.metamatrix.modeler.jdbc.data.ResultsMetadata;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

public class ResultsImpl
implements Results {
    private final Response response;
    private final List rowList;
    private Object[] rowArray;
    private Results next;
    private Results previous;

    public ResultsImpl(Response response) {
        this(response, response.getRecords());
    }

    public ResultsImpl(Response response, List sublist) {
        this.response = response;
        this.rowList = sublist;
    }

    public ResultsMetadata getMetadata() {
        return this.response.getMetadata();
    }

    public int getRowCount() {
        return this.rowList.size();
    }

    public int getTotalRowCount() {
        return this.response.getRecords().size();
    }

    public Object[] getRows() {
        if (this.rowArray == null) {
            this.rowArray = this.rowList.toArray();
        }
        return this.rowArray;
    }

    public Object getObject(Object row, int columnIndex) {
        ArgCheck.isNotNull((Object)row);
        List record = (List)row;
        if (columnIndex >= record.size()) {
            return null;
        }
        return record.get(columnIndex);
    }

    public String getString(Object row, int columnIndex) throws JdbcConversionException {
        Object value = this.getObject(row, columnIndex);
        return value == null ? null : value.toString();
    }

    public boolean getBoolean(Object row, int columnIndex) throws JdbcConversionException {
        Object value = this.getObject(row, columnIndex);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        Object[] params = new Object[]{value, value.getClass()};
        String msg = JdbcPlugin.Util.getString("ResultsImpl.Unable_to_convert_to_boolean", params);
        throw new JdbcConversionException(msg);
    }

    public short getShort(Object row, int columnIndex) throws JdbcConversionException {
        Object value = this.getObject(row, columnIndex);
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer) {
            return ((Integer)value).shortValue();
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Long) {
            return ((Long)value).shortValue();
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).shortValue();
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).shortValue();
        }
        if (value instanceof String) {
            try {
                return Short.parseShort((String)value);
            }
            catch (NumberFormatException e) {
                Object[] params = new Object[]{value, value.getClass()};
                String msg = JdbcPlugin.Util.getString("ResultsImpl.Unable_to_convert_to_short", params);
                throw new JdbcConversionException((Throwable)e, msg);
            }
        }
        Object[] params = new Object[]{value, value.getClass()};
        String msg = JdbcPlugin.Util.getString("ResultsImpl.Unable_to_convert_to_short", params);
        throw new JdbcConversionException(msg);
    }

    public int getInt(Object row, int columnIndex) throws JdbcConversionException {
        Object value = this.getObject(row, columnIndex);
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Short) {
            return ((Short)value).intValue();
        }
        if (value instanceof Long) {
            return ((Long)value).intValue();
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).intValue();
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).intValue();
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                Object[] params = new Object[]{value, value.getClass()};
                String msg = JdbcPlugin.Util.getString("ResultsImpl.Unable_to_convert_to_int", params);
                throw new JdbcConversionException((Throwable)e, msg);
            }
        }
        if (value instanceof Float) {
            return ((Float)value).intValue();
        }
        Object[] params = new Object[]{value, value.getClass()};
        String msg = JdbcPlugin.Util.getString("ResultsImpl.Unable_to_convert_to_int", params);
        throw new JdbcConversionException(msg);
    }

    public long getLong(Object row, int columnIndex) throws JdbcConversionException {
        Object value = this.getObject(row, columnIndex);
        if (value == null) {
            return 0L;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof Short) {
            return ((Short)value).longValue();
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).longValue();
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).longValue();
        }
        if (value instanceof String) {
            try {
                return Long.parseLong((String)value);
            }
            catch (NumberFormatException e) {
                Object[] params = new Object[]{value, value.getClass()};
                String msg = JdbcPlugin.Util.getString("ResultsImpl.Unable_to_convert_to_long", params);
                throw new JdbcConversionException((Throwable)e, msg);
            }
        }
        Object[] params = new Object[]{value, value.getClass()};
        String msg = JdbcPlugin.Util.getString("ResultsImpl.Unable_to_convert_to_long", params);
        throw new JdbcConversionException(msg);
    }

    public float getFloat(Object row, int columnIndex) throws JdbcConversionException {
        Object value = this.getObject(row, columnIndex);
        if (value == null) {
            return 0.0f;
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof Double) {
            return ((Double)value).floatValue();
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).floatValue();
        }
        if (value instanceof String) {
            try {
                return Float.parseFloat((String)value);
            }
            catch (NumberFormatException e) {
                Object[] params = new Object[]{value, value.getClass()};
                String msg = JdbcPlugin.Util.getString("ResultsImpl.Unable_to_convert_to_float", params);
                throw new JdbcConversionException((Throwable)e, msg);
            }
        }
        Object[] params = new Object[]{value, value.getClass()};
        String msg = JdbcPlugin.Util.getString("ResultsImpl.Unable_to_convert_to_float", params);
        throw new JdbcConversionException(msg);
    }

    public double getDouble(Object row, int columnIndex) throws JdbcConversionException {
        Object value = this.getObject(row, columnIndex);
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).doubleValue();
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                Object[] params = new Object[]{value, value.getClass()};
                String msg = JdbcPlugin.Util.getString("ResultsImpl.Unable_to_convert_to_double", params);
                throw new JdbcConversionException((Throwable)e, msg);
            }
        }
        Object[] params = new Object[]{value, value.getClass()};
        String msg = JdbcPlugin.Util.getString("ResultsImpl.Unable_to_convert_to_double", params);
        throw new JdbcConversionException(msg);
    }

    public byte getByte(Object row, int columnIndex) throws JdbcConversionException {
        Object value = this.getObject(row, columnIndex);
        if (value == null) {
            return 0;
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).byteValue();
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).byteValue();
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).byteValue();
        }
        if (value instanceof String) {
            try {
                return Byte.parseByte((String)value);
            }
            catch (NumberFormatException e) {
                Object[] params = new Object[]{value, value.getClass()};
                String msg = JdbcPlugin.Util.getString("ResultsImpl.Unable_to_convert_to_byte", params);
                throw new JdbcConversionException((Throwable)e, msg);
            }
        }
        Object[] params = new Object[]{value, value.getClass()};
        String msg = JdbcPlugin.Util.getString("ResultsImpl.Unable_to_convert_to_byte", params);
        throw new JdbcConversionException(msg);
    }

    public byte[] getBytes(Object row, int columnIndex) throws JdbcConversionException {
        Object value = this.getObject(row, columnIndex);
        if (value == null) {
            return null;
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).toByteArray();
        }
        Object[] params = new Object[]{value, value.getClass()};
        String msg = JdbcPlugin.Util.getString("ResultsImpl.Unable_to_convert_to_byte_array", params);
        throw new JdbcConversionException(msg);
    }

    public java.sql.Date getDate(Object row, int columnIndex) throws JdbcConversionException {
        Object value = this.getObject(row, columnIndex);
        if (value == null) {
            return null;
        }
        if (value instanceof java.sql.Date) {
            return (java.sql.Date)value;
        }
        if (value instanceof Date) {
            long longvalue = ((Date)value).getTime();
            return new java.sql.Date(longvalue);
        }
        if (value instanceof Long) {
            long longValue = (Long)value;
            return new java.sql.Date(longValue);
        }
        if (value instanceof BigDecimal) {
            long longValue = ((BigDecimal)value).longValue();
            return new java.sql.Date(longValue);
        }
        if (value instanceof BigInteger) {
            long longValue = ((BigInteger)value).longValue();
            return new java.sql.Date(longValue);
        }
        Object[] params = new Object[]{value, value.getClass()};
        String msg = JdbcPlugin.Util.getString("ResultsImpl.Unable_to_convert_to_Date", params);
        throw new JdbcConversionException(msg);
    }

    public Timestamp getTimestamp(Object row, int columnIndex) throws JdbcConversionException {
        Object value = this.getObject(row, columnIndex);
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof Date) {
            long longvalue = ((Date)value).getTime();
            return new Timestamp(longvalue);
        }
        if (value instanceof Long) {
            long longValue = (Long)value;
            return new Timestamp(longValue);
        }
        if (value instanceof BigDecimal) {
            long longValue = ((BigDecimal)value).longValue();
            return new Timestamp(longValue);
        }
        if (value instanceof BigInteger) {
            long longValue = ((BigInteger)value).longValue();
            return new Timestamp(longValue);
        }
        Object[] params = new Object[]{value, value.getClass()};
        String msg = JdbcPlugin.Util.getString("ResultsImpl.Unable_to_convert_to_Timestamp", params);
        throw new JdbcConversionException(msg);
    }

    public void setObject(Object row, int columnIndex, Object newValue) {
        if (row == null) {
            return;
        }
        List record = (List)row;
        record.set(columnIndex, newValue);
    }

    public boolean hasNextResults() {
        return this.next != null;
    }

    public Results getNextResults() {
        return this.next;
    }

    public boolean hasPreviousResults() {
        return this.previous != null;
    }

    public Results getPreviousResults() {
        return this.previous;
    }

    public void setPrevious(Results prev) {
        this.previous = prev;
    }

    public void setNext(Results next) {
        this.next = next;
    }
}

