/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.jdbc.relational;

import com.metamatrix.core.log.Logger;
import com.metamatrix.core.log.NullLogger;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.jdbc.JdbcImportSettings;
import com.metamatrix.modeler.jdbc.metadata.JdbcDatabase;
import com.metamatrix.modeler.jdbc.relational.impl.Context;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ContextImpl
implements Context {
    private final Resource resource;
    private final ModelContents modelContents;
    private final JdbcDatabase jdbcDatabase;
    private final JdbcImportSettings importSettings;
    private final IProgressMonitor monitor;
    private final Logger logger;
    private final List errors = new ArrayList();
    private final List warnings = new ArrayList();
    private final Map eObjectByIPath = new HashMap();
    private boolean verbose;

    public ContextImpl(Resource resource, ModelContents contents, JdbcDatabase jdbcDatabase, JdbcImportSettings settings, IProgressMonitor monitor, Logger logger) {
        this.resource = resource;
        this.modelContents = contents;
        this.jdbcDatabase = jdbcDatabase;
        this.importSettings = settings;
        this.monitor = monitor != null ? monitor : new NullProgressMonitor();
        this.logger = logger != null ? logger : new NullLogger();
    }

    public Logger getLogger() {
        return this.logger;
    }

    public EObject findObject(IPath pathInModel) {
        ArgCheck.isNotNull((Object)pathInModel);
        EObject obj = (EObject)this.eObjectByIPath.get(pathInModel);
        return obj;
    }

    public EObject addNewObject(IPath path, EObject obj) {
        return this.eObjectByIPath.put(path, obj);
    }

    public Resource getResource() {
        return this.resource;
    }

    public ModelContents getModelContents() {
        return this.modelContents;
    }

    public JdbcDatabase getJdbcDatabase() {
        return this.jdbcDatabase;
    }

    public JdbcImportSettings getJdbcImportSettings() {
        return this.importSettings;
    }

    public IProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public List getErrors() {
        return this.errors;
    }

    public List getWarnings() {
        return this.warnings;
    }

    public void setVerboseLogging(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isVerbose() {
        return this.verbose;
    }
}

