/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.jdbc.relational.util;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import com.metamatrix.modeler.internal.jdbc.relational.ModelerJdbcRelationalConstants;
import com.metamatrix.modeler.jdbc.JdbcException;
import com.metamatrix.modeler.jdbc.JdbcManager;
import com.metamatrix.modeler.jdbc.JdbcPlugin;
import com.metamatrix.modeler.jdbc.JdbcSource;
import com.metamatrix.modeler.jdbc.relational.JdbcRelationalPlugin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class JdbcRelationalUtil
implements ModelerJdbcRelationalConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix((Class)(class$com$metamatrix$modeler$internal$jdbc$relational$util$JdbcRelationalUtil == null ? (class$com$metamatrix$modeler$internal$jdbc$relational$util$JdbcRelationalUtil = JdbcRelationalUtil.class$("com.metamatrix.modeler.internal.jdbc.relational.util.JdbcRelationalUtil")) : class$com$metamatrix$modeler$internal$jdbc$relational$util$JdbcRelationalUtil));
    private static final String FILENAME = "jdbcModel.xmi";
    private static final String JDBC_MANAGER_NAME = JdbcRelationalUtil.getString("jdbcManagerName");
    private static final String ESCAPE_CHARACTER = "\"";
    private static JdbcManager mgr;
    static /* synthetic */ Class class$com$metamatrix$modeler$internal$jdbc$relational$util$JdbcRelationalUtil;

    public static Connection connect(JdbcSource source, String password) throws CoreException, IOException, JdbcException, SQLException {
        ArgCheck.isNotNull((Object)source);
        return JdbcRelationalUtil.getJdbcManager().createConnection(source, source.getJdbcDriver(), password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static JdbcManager getJdbcManager() throws CoreException, IOException {
        if (JdbcRelationalUtil.mgr == null) {
            uri = URI.createFileURI((String)JdbcRelationalPlugin.getDefault().getStateLocation().append("jdbcModel.xmi").toString());
            file = new File(uri.toFileString());
            if (!file.exists()) {
                stream = JdbcRelationalPlugin.getDefault().openStream((IPath)new Path("jdbcModel.xmi"));
                try {
                    FileUtils.write((InputStream)stream, (File)file);
                    var4_3 = null;
                    ** if (stream == null) goto lbl-1000
                }
                catch (Throwable var3_7) {
                    var4_4 = null;
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            ModelerJdbcRelationalConstants.Util.log((Throwable)e);
                        }
                    }
                    throw var3_7;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        ModelerJdbcRelationalConstants.Util.log((Throwable)e);
                    }
                }
lbl-1000:
                // 2 sources

                {
                }
            }
            resrc = JdbcRelationalPlugin.getModelContainer().getOrCreateResource(uri);
            JdbcRelationalUtil.mgr = JdbcPlugin.createJdbcManager(JdbcRelationalUtil.JDBC_MANAGER_NAME, resrc);
        }
        return JdbcRelationalUtil.mgr;
    }

    public static JdbcManager getJdbcManager(String folder, ResourceSet container) throws CoreException {
        if (mgr == null) {
            URI uri = URI.createFileURI((String)new Path(folder).append(FILENAME).toString());
            Resource resrc = container.getResource(uri, true);
            mgr = JdbcPlugin.createJdbcManager(JDBC_MANAGER_NAME, resrc);
        }
        return mgr;
    }

    public static ModelResource getPhysicalModifiableRelationalModel(Object object) throws ModelWorkspaceException {
        ModelResource model = JdbcRelationalUtil.getRelationalModel(object);
        if (model != null && model.getModelType().getValue() == 0) {
            return model;
        }
        return null;
    }

    public static ModelResource getRelationalModel(Object object) throws ModelWorkspaceException {
        ModelResource model = ModelUtil.getModel((Object)object);
        if (model != null && "http://www.metamatrix.com/metamodels/Relational".equals(model.getPrimaryMetamodelDescriptor().getURI())) {
            return model;
        }
        return null;
    }

    public static String escapeDatabaseObjectName(String name) {
        if (Character.isDigit(name.charAt(0)) || name.indexOf(32) >= 0) {
            if (!name.startsWith(ESCAPE_CHARACTER)) {
                name = ESCAPE_CHARACTER + name;
            }
            if (!name.endsWith(ESCAPE_CHARACTER)) {
                name = name + ESCAPE_CHARACTER;
            }
        }
        return name;
    }

    private static String getString(String id) {
        return ModelerJdbcRelationalConstants.Util.getString(I18N_PREFIX + id);
    }

    private JdbcRelationalUtil() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

