/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.mapping.factory;

import com.metamatrix.metamodels.diagram.Diagram;
import com.metamatrix.metamodels.diagram.DiagramContainer;
import com.metamatrix.metamodels.diagram.DiagramEntity;
import com.metamatrix.metamodels.transformation.InputSet;
import com.metamatrix.metamodels.transformation.MappingClass;
import com.metamatrix.metamodels.transformation.MappingClassColumn;
import com.metamatrix.metamodels.transformation.MappingClassSet;
import com.metamatrix.metamodels.transformation.StagingTable;
import com.metamatrix.metamodels.transformation.TransformationFactory;
import com.metamatrix.modeler.core.ModelEditor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.core.util.ModelResourceContainerFactory;
import com.metamatrix.modeler.core.util.ModelVisitor;
import com.metamatrix.modeler.core.util.ModelVisitorProcessor;
import com.metamatrix.modeler.core.util.NewModelObjectHelperManager;
import com.metamatrix.modeler.internal.core.ClearEObjectReferences;
import com.metamatrix.modeler.internal.mapping.factory.CompositorBasedBuilderStrategy;
import com.metamatrix.modeler.internal.mapping.factory.IterationBasedBuilderStrategy;
import com.metamatrix.modeler.internal.mapping.factory.MappingClassGenerationVisitor;
import com.metamatrix.modeler.internal.mapping.factory.MappingClassSplitterVisitor;
import com.metamatrix.modeler.internal.mapping.factory.ModelMapperFactory;
import com.metamatrix.modeler.internal.mapping.factory.TreeMappingAdapter;
import com.metamatrix.modeler.mapping.ModelerMappingPlugin;
import com.metamatrix.modeler.mapping.PluginConstants;
import com.metamatrix.modeler.mapping.factory.IMappableTree;
import com.metamatrix.modeler.mapping.factory.ITreeToRelationalMapper;
import com.metamatrix.modeler.mapping.factory.MappableTreeIterator;
import com.metamatrix.modeler.mapping.factory.MappingClassBuilderStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;

public class MappingClassFactory {
    private static final String CLASS = (class$com$metamatrix$modeler$internal$mapping$factory$MappingClassFactory == null ? (class$com$metamatrix$modeler$internal$mapping$factory$MappingClassFactory = MappingClassFactory.class$("com.metamatrix.modeler.internal.mapping.factory.MappingClassFactory")) : class$com$metamatrix$modeler$internal$mapping$factory$MappingClassFactory).getName();
    private static MappingClassBuilderStrategy defaultStrategy;
    private static final String STRATEGY_PREF_KEY = "MappingClassFactory.defaultStrategy";
    private static final String COMPOSITOR_PREF_VALUE = "MappingClassFactory.compositorStrategy";
    private static final String ITERATION_PREF_VALUE = "MappingClassFactory.iterationStrategy";
    private EObject treeRoot;
    private ITreeToRelationalMapper mapper;
    private IMappableTree tree;
    private TreeMappingAdapter mapping;
    private AdapterFactory emfAdapter;
    private TransformationFactory metamodelFactory;
    private MappingClassSet mappingClassSet;
    static /* synthetic */ Class class$com$metamatrix$modeler$internal$mapping$factory$MappingClassFactory;
    static /* synthetic */ Class class$org$eclipse$emf$edit$provider$IItemLabelProvider;

    public static MappingClassBuilderStrategy getDefaultStrategy() {
        if (defaultStrategy == null) {
            String defValue = ModelerMappingPlugin.getDefault().getPluginPreferences().getString(STRATEGY_PREF_KEY);
            defaultStrategy = COMPOSITOR_PREF_VALUE.equals(defValue) ? MappingClassBuilderStrategy.compositorStrategy : MappingClassBuilderStrategy.iterationStrategy;
        }
        return defaultStrategy;
    }

    public static void setDefaultStrategy(MappingClassBuilderStrategy strategy) {
        if (strategy instanceof CompositorBasedBuilderStrategy) {
            ModelerMappingPlugin.getDefault().getPluginPreferences().setValue(STRATEGY_PREF_KEY, COMPOSITOR_PREF_VALUE);
        } else if (strategy instanceof IterationBasedBuilderStrategy) {
            ModelerMappingPlugin.getDefault().getPluginPreferences().setValue(STRATEGY_PREF_KEY, ITERATION_PREF_VALUE);
        }
        defaultStrategy = strategy;
    }

    public MappingClassFactory(ITreeToRelationalMapper mapper) {
        this.mapper = mapper;
        this.tree = mapper.getMappableTree();
        this.treeRoot = mapper.getMappableTree().getTreeRoot();
        this.mapping = new TreeMappingAdapter(this.treeRoot);
        this.metamodelFactory = TransformationFactory.eINSTANCE;
    }

    public MappingClassFactory(ITreeToRelationalMapper mapper, TreeMappingAdapter mapping) {
        this.mapper = mapper;
        this.tree = mapper.getMappableTree();
        this.treeRoot = mapper.getMappableTree().getTreeRoot();
        this.mapping = mapping;
        this.metamodelFactory = TransformationFactory.eINSTANCE;
    }

    public Set generateMappingClasses(EObject node, MappingClassBuilderStrategy strategy, boolean autoPopulateAttributes) {
        HashSet result = new HashSet();
        Map mappingClassMap = strategy.buildMappingClassMap(node, this.tree, this.mapper);
        if (PluginConstants.Util.isDebugEnabled("mappingClassFactory")) {
            PluginConstants.Util.printEntered(CLASS, this.printMap(mappingClassMap, "generateMappingClass"));
        }
        MappingClassGenerationVisitor visitor = new MappingClassGenerationVisitor(this.mapper, this, mappingClassMap, autoPopulateAttributes, true, result);
        MappableTreeIterator nodeIter = new MappableTreeIterator(this.tree);
        if (nodeIter.hasNext()) {
            nodeIter.next();
        }
        while (nodeIter.hasNext()) {
            visitor.visit((EObject)nodeIter.next());
        }
        return result;
    }

    public boolean canCreateMappingClass(EObject location) {
        if (this.mapping != null && this.mapping.getMappingClass(location) != null) {
            return false;
        }
        if (this.mapper != null) {
            return this.mapper.allowsMappingClass(location);
        }
        return false;
    }

    public boolean canCreateStagingTable(EObject location) {
        if (this.mapping != null && this.mapping.getStagingTable(location) != null) {
            return false;
        }
        if (this.mapper != null) {
            return this.mapper.allowsMappingClass(location);
        }
        return false;
    }

    public MappingClass createMappingClass(EObject location, boolean moveParentAttributes, boolean markRecursive) {
        MappingClass result = this.metamodelFactory.createMappingClass();
        if (result != null) {
            List allTransforms;
            ModelContents modelContents;
            result.setMappingClassSet(this.getMappingClassSet());
            result.setName(this.convertLocationNameToMappingClassName(location));
            InputSet inputSet = this.metamodelFactory.createInputSet();
            inputSet.setMappingClass(result);
            this.mapping.addLocation(result, location);
            if (markRecursive) {
                result.setRecursionAllowed(true);
            }
            if ((modelContents = ModelerCore.getModelEditor().getModelContents((EObject)result)) != null && (allTransforms = modelContents.getTransformations((EObject)result)).isEmpty()) {
                try {
                    NewModelObjectHelperManager.helpCreate((Object)result, null);
                }
                catch (ModelerCoreException err) {
                    PluginConstants.Util.log((Throwable)err);
                }
            }
            if (moveParentAttributes) {
                List documentNodes = this.getMappingClassExtentNodes(result);
                ArrayList<EObject> mappableDocumentNodes = new ArrayList<EObject>(documentNodes.size() + 1);
                if (this.mapper.isMappable(location)) {
                    mappableDocumentNodes.add(location);
                }
                Iterator iter = documentNodes.iterator();
                while (iter.hasNext()) {
                    EObject docNode = (EObject)iter.next();
                    if (!this.mapper.isMappable(docNode) || mappableDocumentNodes.contains(docNode)) continue;
                    mappableDocumentNodes.add(docNode);
                }
                if (!mappableDocumentNodes.isEmpty()) {
                    this.moveOrCreateMappingAttributes(result, mappableDocumentNodes, new HashMap(), false, new HashSet());
                }
            }
        }
        return result;
    }

    public List getMappingClassExtentNodes(MappingClass theMappingClass) {
        List locations = this.mapping.getLocations(theMappingClass);
        ArrayList extentNodes = new ArrayList();
        ArrayList columnLocations = new ArrayList();
        Iterator iter = theMappingClass.getColumns().iterator();
        while (iter.hasNext()) {
            columnLocations.addAll(this.mapping.getLocations((MappingClassColumn)iter.next()));
        }
        if (!locations.isEmpty()) {
            ArrayList mappingClassLocations = new ArrayList();
            Iterator mcIter = this.mapping.getAllMappingClasses().iterator();
            while (mcIter.hasNext()) {
                mappingClassLocations.addAll(this.mapping.getLocations((MappingClass)mcIter.next()));
            }
            int size = locations.size();
            for (int i = 0; i < size; ++i) {
                extentNodes.add(locations.get(i));
                extentNodes.addAll(this.gatherExtentNodes((EObject)locations.get(i), columnLocations, mappingClassLocations));
            }
        }
        return extentNodes;
    }

    public StagingTable createStagingTable(EObject location) {
        StagingTable result = this.metamodelFactory.createStagingTable();
        if (result != null) {
            List allTransforms;
            result.setMappingClassSet(this.getMappingClassSet());
            result.setName(this.convertLocationNameToStagingTableName(location));
            this.mapping.setLocation(result, location);
            ModelContents modelContents = ModelerCore.getModelEditor().getModelContents((EObject)result);
            if (modelContents != null && (allTransforms = modelContents.getTransformations((EObject)result)).isEmpty()) {
                try {
                    NewModelObjectHelperManager.helpCreate((Object)result, null);
                }
                catch (ModelerCoreException err) {
                    PluginConstants.Util.log((Throwable)err);
                }
            }
        }
        return result;
    }

    public void deleteStagingTable(StagingTable table) throws ModelerCoreException {
        this.mapping.unsetLocation(table);
        ModelerCore.getModelEditor().delete((EObject)table);
    }

    public void deleteMappingClass(MappingClass mappingClass) throws ModelerCoreException {
        this.mapping.removeMappingClass(mappingClass);
        ModelerCore.getModelEditor().delete((EObject)mappingClass);
    }

    public void deleteMappingClassColumn(MappingClassColumn column) throws ModelerCoreException {
        ArrayList locationList = new ArrayList(this.mapping.getLocations(column));
        Iterator iter = locationList.iterator();
        while (iter.hasNext()) {
            this.mapping.removeLocation(column, (EObject)iter.next());
        }
        ModelerCore.getModelEditor().delete((EObject)column);
    }

    public boolean canMergeMappingClasses(MappingClass upperMappingClass, MappingClass lowerMappingClass) {
        boolean result = false;
        List topLocations = this.mapping.getLocations(upperMappingClass);
        if (!topLocations.isEmpty()) {
            EObject topLocation = (EObject)topLocations.get(0);
            List bottomLocations = this.mapping.getLocations(lowerMappingClass);
            if (!bottomLocations.isEmpty()) {
                EObject bottomParent;
                EObject bottomLocation = (EObject)bottomLocations.get(0);
                EObject topParent = this.tree.getParent(topLocation);
                if (topParent.equals(bottomParent = this.tree.getParent(bottomLocation))) {
                    result = true;
                } else if (this.tree.isAncestorOf(topLocation, bottomLocation) || this.tree.isAncestorOf(bottomLocation, topLocation)) {
                    result = true;
                } else {
                    boolean keepGoing = true;
                    Object topChoice = null;
                    EObject bottomChoice = null;
                    while (keepGoing) {
                        if (topChoice == null && (topParent = this.tree.getParent(topParent)) != null && this.tree.isChoiceNode(topParent)) {
                            topChoice = topParent;
                        }
                        if (bottomChoice == null && (bottomParent = this.tree.getParent(bottomParent)) != null && this.tree.isChoiceNode(bottomParent)) {
                            bottomChoice = bottomParent;
                        }
                        if (topChoice != null && bottomChoice != null) {
                            result = topChoice.equals(bottomChoice);
                            keepGoing = false;
                        }
                        if (topParent != null && bottomParent != null) continue;
                        keepGoing = false;
                    }
                }
            }
        }
        return result;
    }

    public void mergeMappingClasses(MappingClass upperMappingClass, MappingClass lowerMappingClass, boolean removeDuplicates) throws ModelerCoreException {
        List upperLocations = this.mapping.getLocations(upperMappingClass);
        ArrayList lowerLocations = new ArrayList(this.mapping.getLocations(lowerMappingClass));
        boolean keepLooking = true;
        Iterator topIter = upperLocations.iterator();
        while (keepLooking && topIter.hasNext()) {
            EObject topLocation = (EObject)topIter.next();
            Iterator bottomIter = lowerLocations.iterator();
            while (keepLooking && bottomIter.hasNext()) {
                EObject bottomLocation = (EObject)bottomIter.next();
                if (!this.tree.isAncestorOf(topLocation, bottomLocation)) continue;
                keepLooking = false;
            }
        }
        if (keepLooking) {
            Iterator bottomIter = lowerLocations.iterator();
            while (bottomIter.hasNext()) {
                EObject location = (EObject)bottomIter.next();
                this.mapping.addLocation(upperMappingClass, location);
                this.mapping.removeLocation(lowerMappingClass, location);
            }
        }
        EList bottomAttributes = lowerMappingClass.getColumns();
        ArrayList copyOfChildren = new ArrayList(bottomAttributes);
        Iterator iter = copyOfChildren.iterator();
        MappingClassColumn nextAttribute = null;
        MappingClassColumn duplicateAttribute = null;
        while (iter.hasNext()) {
            Iterator locIter;
            nextAttribute = (MappingClassColumn)iter.next();
            List locations = this.mapping.getLocations(nextAttribute);
            duplicateAttribute = this.getDuplicateAttributeMO(upperMappingClass, nextAttribute);
            if (duplicateAttribute != null && !removeDuplicates) {
                EList existingColumns = upperMappingClass.getColumns();
                ArrayList<String> existingNames = new ArrayList<String>(existingColumns.size() + 2);
                Iterator nameIter = existingColumns.iterator();
                while (nameIter.hasNext()) {
                    existingNames.add(((MappingClassColumn)nameIter.next()).getName());
                }
                if (duplicateAttribute.getName().equals(nextAttribute.getName())) {
                    String dupeName = this.generateAttributeName(duplicateAttribute.getName(), existingNames, (EObject)duplicateAttribute);
                    List dupeLocations = this.mapping.getLocations(duplicateAttribute);
                    if (!dupeLocations.isEmpty()) {
                        dupeName = this.generateAttributeName(duplicateAttribute.getName(), existingNames, (EObject)dupeLocations.get(0));
                    }
                    ModelerCore.getModelEditor().rename((EObject)duplicateAttribute, dupeName);
                    existingNames.add(dupeName);
                }
                String newName = this.generateAttributeName(nextAttribute.getName(), existingNames, (EObject)nextAttribute);
                if (!locations.isEmpty()) {
                    newName = this.generateAttributeName(nextAttribute.getName(), existingNames, (EObject)locations.get(0));
                }
                ModelerCore.getModelEditor().rename((EObject)nextAttribute, newName);
            }
            if (!removeDuplicates) {
                ModelerCore.getModelEditor().move((Object)upperMappingClass, (EObject)nextAttribute);
                locIter = locations.iterator();
                while (locIter.hasNext()) {
                    this.mapping.addLocation(nextAttribute, (EObject)locIter.next());
                }
                continue;
            }
            if (duplicateAttribute != null) continue;
            ModelerCore.getModelEditor().move((Object)upperMappingClass, (EObject)nextAttribute);
            locIter = locations.iterator();
            while (locIter.hasNext()) {
                this.mapping.addLocation(nextAttribute, (EObject)locIter.next());
            }
        }
        this.mapping.removeMappingClass(lowerMappingClass);
        ModelContents modelContents = ModelerCore.getModelEditor().getModelContents((EObject)lowerMappingClass);
        if (modelContents != null) {
            List allDiagrams;
            List allTransforms = modelContents.getTransformations((EObject)lowerMappingClass);
            if (allTransforms != null && !allTransforms.isEmpty()) {
                Iterator tIter = allTransforms.iterator();
                while (tIter.hasNext()) {
                    ModelerCore.getModelEditor().delete((EObject)tIter.next(), true, false);
                }
            }
            if ((allDiagrams = modelContents.getDiagrams((EObject)lowerMappingClass)) != null && !allDiagrams.isEmpty()) {
                Iterator dIter = allDiagrams.iterator();
                while (dIter.hasNext()) {
                    ModelerCore.getModelEditor().delete((EObject)dIter.next(), true, false);
                }
            }
            this.clearDiagramRefs((EObject)lowerMappingClass);
        }
        ModelerCore.getModelEditor().delete((EObject)lowerMappingClass, true, false);
    }

    protected void clearDiagramRefs(EObject eObj) {
        ModelContents modelContents;
        if (eObj != null && (modelContents = ModelerCore.getModelEditor().getModelContents(eObj)) != null && modelContents.getDiagramContainer(false) != null) {
            DiagramContainer cntr = modelContents.getDiagramContainer(false);
            try {
                ClearEObjectReferences visitor = new ClearEObjectReferences(eObj);
                ModelVisitorProcessor processor = new ModelVisitorProcessor((ModelVisitor)visitor);
                processor.walk((EObject)cntr, 2);
                Iterator iter = visitor.getAffectedObjects().iterator();
                while (iter.hasNext()) {
                    EObject affectedObj = (EObject)iter.next();
                    if (!(affectedObj instanceof DiagramEntity) || ((DiagramEntity)affectedObj).getModelObject() != null) continue;
                    Diagram diagram = ((DiagramEntity)affectedObj).getDiagram();
                    diagram.getDiagramEntity().remove((Object)affectedObj);
                }
            }
            catch (ModelerCoreException err) {
                PluginConstants.Util.log((Throwable)err);
            }
        }
    }

    public boolean canSplitMappingClass(MappingClass theMappingClass, MappingClassBuilderStrategy strategy) {
        EObject location;
        boolean result = false;
        List locations = this.mapping.getLocations(theMappingClass);
        if (locations.size() > 1) {
            result = true;
        } else if (!locations.isEmpty() && (location = (EObject)locations.get(0)) != null) {
            Map mappingClassMap = strategy.buildMappingClassMap(location, this.tree, this.mapper);
            Iterator iter = mappingClassMap.keySet().iterator();
            while (iter.hasNext()) {
                EObject docNode = (EObject)iter.next();
                if (!this.shouldContainMappingClass(docNode) || this.mapping.getMappingClass(docNode) != null) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public void splitMappingClass(MappingClass mappingClass, MappingClassBuilderStrategy strategy, boolean moveAttributes) {
        Map mappingClassMap = strategy.buildMappingClassMap(this.tree.getTreeRoot(), this.tree, this.mapper);
        ArrayList docNodes = new ArrayList(this.mapping.getLocations(mappingClass));
        if (docNodes.size() > 1) {
            Iterator docIter = docNodes.iterator();
            EObject remainingNode = (EObject)docIter.next();
            while (docIter.hasNext()) {
                EObject docNode = (EObject)docIter.next();
                MappingClass newClass = this.createMappingClass(docNode, false, false);
                Collection nodesToMap = (Collection)mappingClassMap.get(docNode);
                if (nodesToMap == null || nodesToMap.isEmpty()) continue;
                this.moveOrCreateMappingAttributes(newClass, nodesToMap, new HashMap(), false, new HashSet());
            }
            ArrayList locationsToRemove = new ArrayList(docNodes);
            locationsToRemove.remove(remainingNode);
            Iterator removeIter = locationsToRemove.iterator();
            while (removeIter.hasNext()) {
                this.mapping.removeLocation(mappingClass, (EObject)removeIter.next());
            }
        } else {
            List referencedNodes = this.mapping.getLocations(mappingClass);
            EObject documentNode = (EObject)referencedNodes.get(0);
            MappingClassSplitterVisitor visitor = new MappingClassSplitterVisitor(mappingClass, this.mapping, this.mapper, this, mappingClassMap);
            MappableTreeIterator nodeIter = new MappableTreeIterator(this.tree, documentNode);
            while (nodeIter.hasNext()) {
                visitor.visit((EObject)nodeIter.next());
            }
        }
    }

    public boolean canAddLocation(MappingClassColumn column, EObject location) {
        boolean result = false;
        if (ModelMapperFactory.isXmlTreeNode(location)) {
            MappingClass mc;
            List mcLocations;
            boolean bl = result = !this.mapping.getLocations(column).contains(location);
            if (result && !(mcLocations = this.mapping.getLocations(mc = column.getMappingClass())).contains(location)) {
                Iterator locIter = mcLocations.iterator();
                while (locIter.hasNext()) {
                    if (!this.tree.isAncestorOf((EObject)locIter.next(), location)) continue;
                    result = true;
                    break;
                }
            }
            if (result) {
                result = this.mapping.getMappingClassColumn(location) == null;
            }
        }
        return result;
    }

    public void addLocation(MappingClassColumn column, EObject location) {
        this.mapping.addLocation(column, location);
    }

    public boolean canRemoveLocation(MappingClassColumn column, EObject location) {
        return this.mapping.getLocations(column).contains(location);
    }

    public void removeLocation(MappingClassColumn column, EObject location) {
        this.mapping.removeLocation(column, location);
    }

    String convertLocationNameToMappingClassName(EObject node) {
        String newName = this.getName(node);
        String possibleName = null;
        if (this.mapper.isContainerNode(node)) {
            Collection children = this.tree.getChildren(node);
            if (children.size() == 1) {
                EObject child = (EObject)children.iterator().next();
                newName = this.getName(child);
            } else {
                EObject parent = this.tree.getParent(node);
                if (parent != null && this.tree.getTreeRoot() != parent) {
                    newName = this.getName(parent);
                    possibleName = this.getName(parent) + '_' + this.getName(node);
                }
            }
        }
        List existingMappingClasses = this.mapping.getAllMappingClasses();
        ArrayList<String> names = new ArrayList<String>(existingMappingClasses.size());
        Iterator iter = existingMappingClasses.iterator();
        while (iter.hasNext()) {
            MappingClass mc = (MappingClass)iter.next();
            names.add(mc.getName());
        }
        if (names.contains(newName) && possibleName != null) {
            newName = possibleName;
        }
        String result = newName;
        int suffix = 0;
        boolean tryAgain = true;
        while (tryAgain) {
            if (names.contains(result)) {
                result = newName + ++suffix;
                continue;
            }
            tryAgain = false;
        }
        return result;
    }

    String convertLocationNameToStagingTableName(EObject node) {
        String newName = "ST_" + this.getName(node);
        List existingStagingTables = this.mapping.getAllStagingTables();
        ArrayList<String> names = new ArrayList<String>(existingStagingTables.size());
        Iterator iter = existingStagingTables.iterator();
        while (iter.hasNext()) {
            names.add(((StagingTable)iter.next()).getName());
        }
        String result = newName;
        int suffix = 0;
        boolean tryAgain = true;
        while (tryAgain) {
            if (names.contains(result)) {
                result = newName + ++suffix;
                continue;
            }
            tryAgain = false;
        }
        return result;
    }

    void moveOrCreateMappingAttributes(MappingClass mappingClass, Collection documentNodeList, Map nameAttributeMap, boolean initialBuild, Set datatypeAccumulator) {
        Iterator docNodeIter = documentNodeList.iterator();
        while (docNodeIter.hasNext()) {
            EObject nodeToMap = (EObject)docNodeIter.next();
            boolean createAttribute = true;
            MappingClassColumn attribute = null;
            if (!initialBuild) {
                attribute = this.mapping.getMappingClassColumn(nodeToMap);
            }
            if (attribute != null) {
                ArrayList locations = new ArrayList(this.mapping.getLocations(attribute));
                if (locations.size() > 1) {
                    this.mapping.removeLocation(attribute, nodeToMap);
                } else if (!this.mappingClassContainsAttribute((EObject)mappingClass, (EObject)attribute)) {
                    try {
                        this.mapping.removeLocation(attribute, nodeToMap);
                        ModelerCore.getModelEditor().move((Object)mappingClass, (EObject)attribute);
                        this.mapping.addLocation(attribute, nodeToMap);
                        createAttribute = false;
                        nameAttributeMap.put(attribute.getName(), attribute);
                    }
                    catch (Exception e) {
                        PluginConstants.Util.log((Throwable)e);
                    }
                } else {
                    if (nameAttributeMap.get(attribute.getName()) != null) {
                        nameAttributeMap.put(attribute.getName(), attribute);
                    }
                    createAttribute = false;
                }
            }
            if (!createAttribute) continue;
            MappingClassColumn mappingAttribute = null;
            try {
                boolean createNewAttribute = true;
                String attributeName = this.getName(nodeToMap);
                Iterator iter = nameAttributeMap.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    if (!attributeName.equalsIgnoreCase((String)entry.getKey())) continue;
                    mappingAttribute = (MappingClassColumn)nameAttributeMap.get(attributeName);
                    if (this.areDataTypesEquivalent(nodeToMap, mappingAttribute)) {
                        createNewAttribute = false;
                        break;
                    }
                    attributeName = this.generateAttributeName(attributeName, nameAttributeMap.keySet(), nodeToMap);
                    EObject clashNode = (EObject)this.mapping.getLocations(mappingAttribute).iterator().next();
                    String clashName = this.mapper.getMappableTree().getUniqueName(clashNode);
                    if (nameAttributeMap.keySet().contains(clashName)) break;
                    ModelerCore.getModelEditor().rename((EObject)mappingAttribute, clashName);
                    nameAttributeMap.put(clashName, mappingAttribute);
                    if (!clashName.equals(attributeName)) break;
                    attributeName = attributeName + '1';
                    break;
                }
                if (createNewAttribute) {
                    mappingAttribute = this.metamodelFactory.createMappingClassColumn();
                    mappingAttribute.setName(attributeName);
                    mappingAttribute.setMappingClass(mappingClass);
                    EObject datatype = this.tree.getDatatype(nodeToMap);
                    if (datatype != null) {
                        mappingAttribute.setType(datatype);
                        datatypeAccumulator.add(datatype);
                    }
                    nameAttributeMap.put(attributeName, mappingAttribute);
                }
                this.mapping.addLocation(mappingAttribute, nodeToMap);
            }
            catch (Exception e) {
                PluginConstants.Util.log((Throwable)e);
            }
        }
    }

    private boolean mappingClassContainsAttribute(EObject mappingClass, EObject mappingClassColumn) {
        boolean result = false;
        if (mappingClass.eContents() != null && !mappingClass.eContents().isEmpty()) {
            EList theList = mappingClass.eContents();
            Iterator iter = theList.iterator();
            Object nextObject = null;
            while (iter.hasNext() && !result) {
                nextObject = iter.next();
                if (!(nextObject instanceof EObject) || !((EObject)nextObject).equals(mappingClassColumn)) continue;
                result = true;
            }
        }
        return result;
    }

    private String getName(EObject node) {
        if (this.emfAdapter == null) {
            this.emfAdapter = ModelerCore.getMetamodels().getEmfAdapterFactory();
        }
        IItemLabelProvider provider = (IItemLabelProvider)this.emfAdapter.adapt((Notifier)node, (Object)(class$org$eclipse$emf$edit$provider$IItemLabelProvider == null ? (class$org$eclipse$emf$edit$provider$IItemLabelProvider = MappingClassFactory.class$("org.eclipse.emf.edit.provider.IItemLabelProvider")) : class$org$eclipse$emf$edit$provider$IItemLabelProvider));
        return provider.getText((Object)node);
    }

    private boolean shouldContainMappingClass(EObject node) {
        boolean result = false;
        if (this.mapper.allowsMappingClass(node)) {
            if (this.mapper.canIterate(node)) {
                result = true;
            } else if (this.mapper.isRecursive(node)) {
                result = true;
            }
        }
        return result;
    }

    private MappingClassSet getMappingClassSet() {
        if (this.mappingClassSet == null) {
            this.mappingClassSet = ModelResourceContainerFactory.getMappingClassSet((EObject)this.treeRoot, (boolean)true);
        }
        return this.mappingClassSet;
    }

    private boolean areDataTypesEquivalent(EObject documentNode, MappingClassColumn mappingAttribute) {
        List locations = this.mapping.getLocations(mappingAttribute);
        if (locations.isEmpty()) {
            return false;
        }
        EObject mappedNode = (EObject)locations.iterator().next();
        return this.mapper.getMappableTree().areEquivalent(mappedNode, documentNode);
    }

    private String generateAttributeName(String duplicateName, Collection existingNames, EObject node) {
        String baseName;
        int count = 0;
        String result = baseName = this.mapper.getMappableTree().getUniqueName(node);
        while (existingNames.contains(result)) {
            result = baseName + ++count;
        }
        return result;
    }

    private MappingClassColumn getDuplicateAttributeMO(MappingClass topMappingClass, MappingClassColumn proposedColumn) {
        EList topAttributes = topMappingClass.getColumns();
        if (topAttributes == null || topAttributes.isEmpty()) {
            return null;
        }
        MappingClassColumn nextColumn = null;
        Iterator iter = topAttributes.iterator();
        while (iter.hasNext()) {
            nextColumn = (MappingClassColumn)iter.next();
            if (!nextColumn.getName().equalsIgnoreCase(proposedColumn.getName())) continue;
            return nextColumn;
        }
        return null;
    }

    private List gatherExtentNodes(EObject locationNode, Collection columnLocations, Collection mappingClassLocations) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        Iterator childIter = this.mapper.getMappableTree().getChildren(locationNode).iterator();
        while (childIter.hasNext()) {
            EObject node = (EObject)childIter.next();
            if (columnLocations.contains(node)) {
                result.add(node);
                result.addAll(this.gatherExtentNodes(node, columnLocations, mappingClassLocations));
                continue;
            }
            if (mappingClassLocations.contains(node)) continue;
            result.add(node);
            result.addAll(this.gatherExtentNodes(node, columnLocations, mappingClassLocations));
        }
        return result;
    }

    private String printMap(Map map, String header) {
        StringBuffer buf = new StringBuffer("<><><>MappingClassFactory results from " + header);
        ModelEditor editor = ModelerCore.getModelEditor();
        Iterator keyIter = map.keySet().iterator();
        while (keyIter.hasNext()) {
            EObject location = (EObject)keyIter.next();
            buf.append("\n    " + editor.getModelRelativePath(location) + " == Mapping Class location");
            Iterator attIter = ((Collection)map.get(location)).iterator();
            while (attIter.hasNext()) {
                EObject node = (EObject)attIter.next();
                buf.append("\n       " + editor.getModelRelativePath(node) + " == attribute");
            }
        }
        return buf.toString();
    }

    public boolean canGenerateMappingClasses() {
        boolean canGenerate = true;
        if (this.getMappingClassSet() == null || !this.getMappingClassSet().eContents().isEmpty()) {
            canGenerate = false;
        }
        return canGenerate;
    }

    public EObject getTreeRoot() {
        return this.treeRoot;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

