/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.mapping.factory;

import com.metamatrix.metamodels.transformation.MappingClass;
import com.metamatrix.modeler.internal.mapping.factory.MappingClassFactory;
import com.metamatrix.modeler.mapping.factory.ITreeToRelationalMapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;

public class MappingClassGenerationVisitor {
    protected ITreeToRelationalMapper mapper;
    protected MappingClassFactory factory;
    protected Map attributeMap;
    protected boolean createAttributes;
    protected boolean markNextMappingClassRecursive = false;
    protected boolean initialBuild = false;
    protected Set datatypeAccumulator;

    public MappingClassGenerationVisitor(ITreeToRelationalMapper mapper, MappingClassFactory factory, Map mappingClassAttributeMap, boolean createAttributes, boolean initialBuild, Set datatypeAccumulator) {
        this.mapper = mapper;
        this.factory = factory;
        this.attributeMap = mappingClassAttributeMap;
        this.createAttributes = createAttributes;
        this.initialBuild = initialBuild;
        this.datatypeAccumulator = datatypeAccumulator;
    }

    public boolean visit(EObject object) {
        if (this.attributeMap.containsKey(object)) {
            Collection attributes = (Collection)this.attributeMap.get(object);
            if (attributes.size() == 0 && !this.mapper.isChoiceNode(object) && !this.mapper.isRecursive(object)) {
                return true;
            }
            if (this.mapper.isRecursive(object)) {
                this.markNextMappingClassRecursive = true;
            }
            MappingClass mappingClass = this.factory.createMappingClass(object, false, this.markNextMappingClassRecursive);
            this.markNextMappingClassRecursive = false;
            if (this.createAttributes) {
                HashMap nameAttributeMap = new HashMap();
                this.factory.moveOrCreateMappingAttributes(mappingClass, (Collection)this.attributeMap.get(object), nameAttributeMap, this.initialBuild, this.datatypeAccumulator);
            }
        } else if (this.mapper.isRecursive(object)) {
            this.markNextMappingClassRecursive = true;
        }
        return true;
    }
}

