/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.sdt.types;

import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.id.InvalidIDException;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.ObjectVector;
import com.metamatrix.metamodels.xsd.XsdUtil;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlDatatypeAspect;
import com.metamatrix.modeler.core.types.DatatypeManager;
import com.metamatrix.modeler.core.types.EnterpriseDatatypeInfo;
import com.metamatrix.modeler.internal.sdt.types.AbstractDatatypeManager;
import com.metamatrix.modeler.internal.sdt.types.BuiltInTypesManager;
import com.metamatrix.modeler.sdt.ModelerSdtPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class WorkspaceDatatypeManager
extends AbstractDatatypeManager
implements DatatypeManager {
    private BuiltInTypesManager builtInTypesMgr;
    static /* synthetic */ Class class$org$eclipse$xsd$XSDSimpleTypeDefinition;

    protected void doInitialize() throws ModelerCoreException {
        this.init();
    }

    private void init() throws ModelerCoreException {
        this.builtInTypesMgr = new BuiltInTypesManager();
        this.builtInTypesMgr.initialize(this.getContainer());
    }

    public DatatypeManager getBuiltInTypeManager() {
        return this.builtInTypesMgr;
    }

    public EObject getBuiltInDatatype(String name) throws ModelerCoreException {
        return this.builtInTypesMgr.getBuiltInDatatype(name);
    }

    public EObject[] getBuiltInPrimitiveTypes() throws ModelerCoreException {
        return this.builtInTypesMgr.getBuiltInPrimitiveTypes();
    }

    public EObject getBuiltInPrimitiveType(EObject type) {
        return this.builtInTypesMgr.getBuiltInPrimitiveType(type);
    }

    public boolean isBinary(EObject type) {
        return this.builtInTypesMgr.isBinary(type);
    }

    public boolean isCharacter(EObject type) {
        return this.builtInTypesMgr.isCharacter(type);
    }

    public boolean isNumeric(EObject type) {
        return this.builtInTypesMgr.isNumeric(type);
    }

    public boolean isBounded(EObject type) {
        return this.builtInTypesMgr.isBounded(type);
    }

    public boolean isEnumeration(EObject type) {
        return this.builtInTypesMgr.isEnumeration(type);
    }

    public ObjectID getUuid(EObject type) {
        Object uuid;
        if (this.isBuiltInDatatype(type)) {
            return this.builtInTypesMgr.getUuid(type);
        }
        SqlDatatypeAspect aspect = WorkspaceDatatypeManager.getSqlAspect(type);
        if (aspect != null && (uuid = aspect.getObjectID(type)) instanceof ObjectID) {
            return (ObjectID)uuid;
        }
        return null;
    }

    public String getUuidString(EObject type) {
        if (this.isBuiltInDatatype(type)) {
            return this.builtInTypesMgr.getUuidString(type);
        }
        SqlDatatypeAspect aspect = WorkspaceDatatypeManager.getSqlAspect(type);
        if (aspect != null) {
            return aspect.getUuidString(type);
        }
        return null;
    }

    public String getRuntimeTypeName(EObject type) {
        if (this.isBuiltInDatatype(type)) {
            return this.builtInTypesMgr.getRuntimeTypeName(type);
        }
        SqlDatatypeAspect aspect = WorkspaceDatatypeManager.getSqlAspect(type);
        if (aspect != null) {
            EObject basetype;
            EObject dtype = type;
            String result = aspect.getRuntimeTypeName(type);
            while ((result == null || result.length() == 0) && (basetype = (EObject)aspect.getBasetype(dtype)) != dtype) {
                if (aspect.isURType(basetype)) {
                    result = "string";
                    break;
                }
                if (aspect.isBuiltInDatatype(basetype)) {
                    result = aspect.getRuntimeTypeName(basetype);
                    break;
                }
                result = aspect.getRuntimeTypeName(basetype);
                dtype = basetype;
            }
            return result;
        }
        return null;
    }

    public Boolean getRuntimeTypeFixed(EObject type) {
        Boolean result = null;
        if (this.isBuiltInDatatype(type)) {
            result = this.builtInTypesMgr.getRuntimeTypeFixed(type);
        } else {
            SqlDatatypeAspect aspect = WorkspaceDatatypeManager.getSqlAspect(type);
            if (aspect != null) {
                result = aspect.getRuntimeTypeFixed(type);
            }
        }
        return result;
    }

    public Map getEnterpriseExtensionsMap(EObject type) {
        if (this.isBuiltInDatatype(type)) {
            return this.builtInTypesMgr.getEnterpriseExtensionsMap(type);
        }
        SqlDatatypeAspect aspect = WorkspaceDatatypeManager.getSqlAspect(type);
        if (aspect != null) {
            return aspect.getEnterpriseExtensionsMap(type);
        }
        return Collections.EMPTY_MAP;
    }

    public String getName(EObject type) {
        SqlDatatypeAspect aspect = WorkspaceDatatypeManager.getSqlAspect(type);
        if (aspect != null) {
            return aspect.getName(type);
        }
        return null;
    }

    public boolean isSimpleDatatype(EObject type) {
        SqlDatatypeAspect aspect = WorkspaceDatatypeManager.getSqlAspect(type);
        if (aspect != null) {
            return aspect.isSimpleDatatype(type);
        }
        return false;
    }

    public EObject getAnySimpleType() throws ModelerCoreException {
        return this.builtInTypesMgr.getAnySimpleType();
    }

    public EObject getAnyType() throws ModelerCoreException {
        return this.builtInTypesMgr.getAnyType();
    }

    public EObject getDefaultDatatypeForRuntimeTypeName(String runtimeTypeName) throws ModelerCoreException {
        return this.builtInTypesMgr.getDefaultDatatypeForRuntimeTypeName(runtimeTypeName);
    }

    public boolean isBuiltInDatatype(EObject datatype) {
        SqlDatatypeAspect aspect = WorkspaceDatatypeManager.getSqlAspect(datatype);
        if (aspect != null) {
            return aspect.isBuiltInDatatype(datatype);
        }
        return false;
    }

    public EObject getBaseType(EObject datatype) {
        if (this.isBuiltInDatatype(datatype)) {
            return this.builtInTypesMgr.getBaseType(datatype);
        }
        SqlDatatypeAspect aspect = WorkspaceDatatypeManager.getSqlAspect(datatype);
        if (aspect != null) {
            return (EObject)aspect.getBasetype(datatype);
        }
        return null;
    }

    public EObject getDatatypeForXsdType(EObject eObject) throws ModelerCoreException {
        ArgCheck.isNotNull((Object)eObject);
        if (eObject instanceof XSDSimpleTypeDefinition) {
            return this.getDatatypeForXsdType((XSDSimpleTypeDefinition)eObject);
        }
        if (eObject instanceof XSDComplexTypeDefinition) {
            return this.getDatatypeForXsdType((XSDComplexTypeDefinition)eObject);
        }
        return null;
    }

    public EObject[] getAllDatatypes() throws ModelerCoreException {
        EObject[] result = this.getDatatypes();
        ArrayList<EObject> tmp = new ArrayList<EObject>();
        tmp.addAll(Arrays.asList(result));
        tmp.addAll(Arrays.asList(this.builtInTypesMgr.getAllDatatypes()));
        WorkspaceDatatypeManager.removeDuplicates(tmp);
        WorkspaceDatatypeManager.sortByName(tmp);
        return tmp.toArray(new EObject[tmp.size()]);
    }

    public EObject[] getAllowableBaseTypeValues(EObject datatype) throws ModelerCoreException {
        ArrayList<EObject> tmp = new ArrayList<EObject>();
        tmp.addAll(Arrays.asList(this.getAllDatatypes()));
        tmp.remove(this.getAnySimpleType());
        tmp.remove(datatype);
        return tmp.toArray(new EObject[tmp.size()]);
    }

    public EObject[] getAllowableItemTypeValues(EObject datatype) throws ModelerCoreException {
        ArrayList<EObject> tmp = new ArrayList<EObject>();
        tmp.addAll(Arrays.asList(this.getAllDatatypes()));
        tmp.remove(datatype);
        return tmp.toArray(new EObject[tmp.size()]);
    }

    public EObject[] getAllowableMemberTypeValues(EObject datatype) throws ModelerCoreException {
        ArrayList<EObject> tmp = new ArrayList<EObject>();
        tmp.addAll(Arrays.asList(this.getAllDatatypes()));
        tmp.remove(datatype);
        return tmp.toArray(new EObject[tmp.size()]);
    }

    public EObject[] getAllowableTypeValues(EObject eObject, EStructuralFeature feature) throws ModelerCoreException {
        if (feature == null || eObject == null) {
            return this.getAllDatatypes();
        }
        if (eObject instanceof XSDSimpleTypeDefinition && feature.getFeatureID() == 28) {
            return this.getAllowableBaseTypeValues(eObject);
        }
        if (eObject instanceof XSDSimpleTypeDefinition && feature.getFeatureID() == 30) {
            return this.getAllowableItemTypeValues(eObject);
        }
        if (eObject instanceof XSDSimpleTypeDefinition && feature.getFeatureID() == 26) {
            return this.getAllowableMemberTypeValues(eObject);
        }
        return this.getAllDatatypes();
    }

    public EObject findDatatype(String id) throws ModelerCoreException {
        EObject result = this.builtInTypesMgr.findDatatype(id);
        if (result != null) {
            return result;
        }
        EObject rv = this.findEObject(id);
        if (rv instanceof XSDSimpleTypeDefinition) {
            return rv;
        }
        return null;
    }

    public String getRuntimeTypeJavaClassName(String id) throws ModelerCoreException {
        SqlDatatypeAspect aspect;
        String result = this.builtInTypesMgr.getRuntimeTypeJavaClassName(id);
        if (result != null) {
            return result;
        }
        EObject eObject = this.findDatatype(id);
        if (eObject != null && (aspect = WorkspaceDatatypeManager.getSqlAspect(eObject)) != null) {
            return aspect.getJavaClassName(eObject);
        }
        return null;
    }

    public String getRuntimeTypeName(String id) throws ModelerCoreException {
        SqlDatatypeAspect aspect;
        String result = this.builtInTypesMgr.getRuntimeTypeName(id);
        if (result != null) {
            return result;
        }
        EObject eObject = this.findDatatype(id);
        if (eObject != null && (aspect = WorkspaceDatatypeManager.getSqlAspect(eObject)) != null) {
            return aspect.getJavaClassName(eObject);
        }
        return null;
    }

    public EObject[] getSubtypes(EObject datatype) throws ModelerCoreException {
        EObject[] subtypes;
        ArgCheck.isInstanceOf((Class)(class$org$eclipse$xsd$XSDSimpleTypeDefinition == null ? (class$org$eclipse$xsd$XSDSimpleTypeDefinition = WorkspaceDatatypeManager.class$("org.eclipse.xsd.XSDSimpleTypeDefinition")) : class$org$eclipse$xsd$XSDSimpleTypeDefinition), (Object)datatype);
        ArrayList<EObject> tmp = new ArrayList<EObject>();
        SqlDatatypeAspect aspect = WorkspaceDatatypeManager.getSqlAspect(datatype);
        if (aspect != null && aspect.isURType(datatype)) {
            subtypes = this.builtInTypesMgr.getBuiltInPrimitiveTypes();
            tmp.addAll(Arrays.asList(subtypes));
        } else if (aspect != null && aspect.isBuiltInDatatype(datatype)) {
            subtypes = this.builtInTypesMgr.getSubtypes(datatype);
            tmp.addAll(Arrays.asList(subtypes));
        }
        EObject[] datatypes = this.getDatatypes();
        for (int i = 0; i < datatypes.length; ++i) {
            XSDSimpleTypeDefinition sdt = (XSDSimpleTypeDefinition)datatypes[i];
            if (sdt == null) continue;
            Object basetype = sdt.getBaseTypeDefinition();
            aspect = WorkspaceDatatypeManager.getSqlAspect((EObject)basetype);
            if (aspect != null && aspect.isBuiltInDatatype((EObject)basetype)) {
                basetype = this.builtInTypesMgr.getEmfType((EObject)basetype);
            }
            if (!datatype.equals(basetype)) continue;
            tmp.add((EObject)sdt);
        }
        WorkspaceDatatypeManager.removeDuplicates(tmp);
        WorkspaceDatatypeManager.sortByName(tmp);
        return tmp.toArray(new EObject[tmp.size()]);
    }

    public String getDescription(EObject type) {
        String description = null;
        SqlDatatypeAspect aspect = WorkspaceDatatypeManager.getSqlAspect(type);
        if (aspect != null) {
            description = aspect.getDescription(type);
        }
        return description == null ? "" : description;
    }

    protected EObject getDatatypeForXsdType(XSDSimpleTypeDefinition simpleType) throws ModelerCoreException {
        ArgCheck.isNotNull((Object)simpleType);
        Object builtInType = simpleType;
        while (!this.isBuiltInDatatype((EObject)builtInType)) {
            EObject baseType = this.getBaseType((EObject)builtInType);
            if (builtInType == baseType) {
                builtInType = null;
                break;
            }
            builtInType = baseType;
        }
        if (builtInType == null) {
            return this.getAnySimpleType();
        }
        return this.getBuiltInDatatype(builtInType.getName());
    }

    protected EObject getDatatypeForXsdType(XSDComplexTypeDefinition complexType) throws ModelerCoreException {
        ArgCheck.isNotNull((Object)complexType);
        return null;
    }

    protected EObject[] getDatatypes() throws ModelerCoreException {
        List resources = this.getDatatypeResources();
        return this.getDatatypes(resources);
    }

    protected EObject[] getDatatypes(List emfResources) {
        ArgCheck.isNotNull((Object)emfResources);
        ObjectVector tmp = new ObjectVector();
        Iterator iter = emfResources.iterator();
        while (iter.hasNext()) {
            Resource resource = (Resource)iter.next();
            tmp.addAll((Object[])this.getDatatypes(resource));
        }
        Object[] result = new EObject[tmp.size()];
        tmp.copyInto(result);
        return result;
    }

    protected EObject[] getDatatypes(Resource resource) {
        ArgCheck.isNotNull((Object)resource);
        ObjectVector tmp = new ObjectVector();
        Iterator iter = resource.getContents().iterator();
        while (iter.hasNext()) {
            EObject eObj = (EObject)iter.next();
            if (eObj == null || !(eObj instanceof XSDSchema)) continue;
            XSDSchema schema = (XSDSchema)eObj;
            Iterator iter2 = schema.eContents().iterator();
            while (iter2.hasNext()) {
                EObject eObj2 = (EObject)iter2.next();
                if (eObj2 == null || !(eObj2 instanceof XSDSimpleTypeDefinition)) continue;
                XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)eObj2;
                XsdUtil.checkForEnterpriseConversion(simpleType);
                tmp.add((Object)simpleType);
            }
        }
        Object[] result = new EObject[tmp.size()];
        tmp.copyInto(result);
        return result;
    }

    protected EObject findEObject(String id) throws ModelerCoreException {
        if (id == null) {
            return null;
        }
        EObject result = null;
        if (WorkspaceDatatypeManager.containsUuidPattern(id)) {
            String uuidString = WorkspaceDatatypeManager.extractUuidString(id);
            Container container = this.getContainer();
            if (container != null) {
                try {
                    ObjectID uuid = IDGenerator.getInstance().stringToObject(uuidString);
                    result = (EObject)container.getEObjectFinder().find((Object)uuid);
                }
                catch (InvalidIDException e) {
                    ModelerSdtPlugin.Util.log(4, (Throwable)e, e.getMessage());
                }
            }
            if (result != null) {
                return result instanceof XSDSimpleTypeDefinition ? result : null;
            }
            EObject[] allDatatypes = this.getAllDatatypes();
            for (int i = 0; i != allDatatypes.length; ++i) {
                EObject datatype = allDatatypes[i];
                SqlDatatypeAspect aspect = WorkspaceDatatypeManager.getSqlAspect(datatype);
                if (aspect == null || !uuidString.equals(aspect.getUuidString(datatype))) continue;
                return datatype;
            }
        }
        if (result == null) {
            List resources = this.getDatatypeResources();
            Iterator iter = resources.iterator();
            while (iter.hasNext()) {
                Resource emfResource = (Resource)iter.next();
                result = emfResource.getEObject(id);
                if (result == null) continue;
                return result instanceof XSDSimpleTypeDefinition ? result : null;
            }
        }
        return result;
    }

    public EObject[] getBuiltInDatatypes() throws ModelerCoreException {
        return this.builtInTypesMgr.getBuiltInDatatypes();
    }

    public boolean isEnterpriseDatatype(EObject simpleType) {
        return this.builtInTypesMgr.isEnterpriseDatatype(this.resolveWhenProxy(simpleType));
    }

    public EnterpriseDatatypeInfo getEnterpriseDatatypeInfo(XSDSimpleTypeDefinition simpleType) {
        return this.builtInTypesMgr.getEnterpriseDatatypeInfo((XSDSimpleTypeDefinition)this.resolveWhenProxy((EObject)simpleType));
    }

    public void setBasetypeDefinition(XSDSimpleTypeDefinition simpleType, XSDSimpleTypeDefinition baseType) {
        WorkspaceDatatypeManager.getSqlAspect((EObject)simpleType).setBasetype((XSDSimpleTypeDefinition)this.resolveWhenProxy((EObject)simpleType), (XSDSimpleTypeDefinition)this.resolveWhenProxy((EObject)baseType));
    }

    private EObject resolveWhenProxy(EObject e) {
        EObject resolvedEObject = e;
        if (e.eIsProxy() && (resolvedEObject = EcoreUtil.resolve(e, (ResourceSet)this.getContainer())).eIsProxy()) {
            throw new MetaMatrixRuntimeException(ModelerSdtPlugin.Util.getString("WorkspaceDatatypeManager.Error_EObject_can_not_be_a_proxy", (Object)resolvedEObject.toString()));
        }
        return resolvedEObject;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

