/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.jdbc;

import com.metamatrix.modeler.jdbc.JdbcDriver;
import com.metamatrix.modeler.jdbc.JdbcDriverProperty;
import com.metamatrix.modeler.jdbc.JdbcException;
import com.metamatrix.modeler.jdbc.JdbcFactory;
import com.metamatrix.modeler.jdbc.JdbcSource;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.resource.Resource;

public interface JdbcManager {
    public String getName();

    public boolean hasChanges();

    public void saveChanges(IProgressMonitor var1) throws IOException;

    public void reload(IProgressMonitor var1) throws JdbcException;

    public JdbcFactory getFactory();

    public List getJdbcDrivers();

    public List getJdbcSources();

    public JdbcDriver[] findDrivers(String var1);

    public JdbcSource[] findSources(String var1);

    public JdbcDriver[] findDrivers(JdbcSource var1);

    public JdbcDriver findBestDriver(JdbcSource var1);

    public IStatus isValid(JdbcSource var1);

    public IStatus isValid(JdbcDriver var1);

    public IStatus computeAvailableDriverClasses(JdbcDriver var1, boolean var2) throws JdbcException;

    public Connection createConnection(JdbcSource var1, JdbcDriver var2, String var3, IProgressMonitor var4) throws JdbcException, SQLException;

    public Connection createConnection(JdbcSource var1, JdbcDriver var2, String var3) throws JdbcException, SQLException;

    public JdbcDriverProperty[] getPropertyDescriptions(JdbcSource var1) throws JdbcException;

    public void saveConnections(OutputStream var1) throws IOException;

    public List loadConnections(Resource var1) throws IOException, JdbcException;
}

