/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.jdbc.metadata;

import com.metamatrix.modeler.jdbc.JdbcException;
import com.metamatrix.modeler.jdbc.metadata.JdbcNode;
import com.metamatrix.modeler.jdbc.metadata.JdbcNodeVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;

public class QualifiedNameRequirementVisitor
implements JdbcNodeVisitor {
    private final boolean includeCatalogs;
    private final boolean includeSchemas;
    private final Map jdbcNodesWithSamePathByPath;
    private final Set pathsWithClashes;

    public QualifiedNameRequirementVisitor(boolean includeCatalogs, boolean includeSchemas) {
        this.includeCatalogs = includeCatalogs;
        this.includeSchemas = includeSchemas;
        this.jdbcNodesWithSamePathByPath = new HashMap();
        this.pathsWithClashes = new HashSet();
    }

    public boolean visit(JdbcNode node) throws JdbcException {
        if (node == null || node.getSelectionMode() == 0) {
            return false;
        }
        IPath pathInModel = node.getPathInSource(this.includeCatalogs, this.includeSchemas);
        if (pathInModel == null) {
            return true;
        }
        ArrayList<JdbcNode> jdbcNodesWithSamePath = (ArrayList<JdbcNode>)this.jdbcNodesWithSamePathByPath.get(pathInModel);
        if (jdbcNodesWithSamePath == null) {
            jdbcNodesWithSamePath = new ArrayList<JdbcNode>();
            this.jdbcNodesWithSamePathByPath.put(pathInModel, jdbcNodesWithSamePath);
        }
        jdbcNodesWithSamePath.add(node);
        if (jdbcNodesWithSamePath.size() > 1) {
            this.pathsWithClashes.add(pathInModel);
        }
        return false;
    }

    public Collection getAmbiguousPaths() {
        return this.pathsWithClashes;
    }

    public List getNodesWithPath(IPath path) {
        List jdbcNodesWithSamePath = (List)this.jdbcNodesWithSamePathByPath.get(path);
        return jdbcNodesWithSamePath != null ? new ArrayList(jdbcNodesWithSamePath) : new ArrayList();
    }
}

