/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.jdbc.metadata.impl;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.jdbc.JdbcException;
import com.metamatrix.modeler.jdbc.JdbcPlugin;
import com.metamatrix.modeler.jdbc.metadata.JdbcCatalog;
import com.metamatrix.modeler.jdbc.metadata.JdbcDatabase;
import com.metamatrix.modeler.jdbc.metadata.JdbcNode;
import com.metamatrix.modeler.jdbc.metadata.JdbcSchema;
import com.metamatrix.modeler.jdbc.metadata.impl.JdbcNodeImpl;
import com.metamatrix.modeler.jdbc.metadata.impl.JdbcProcedureTypeImpl;
import com.metamatrix.modeler.jdbc.metadata.impl.JdbcTableTypeImpl;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class JdbcSchemaImpl
extends JdbcNodeImpl
implements JdbcSchema {
    public JdbcSchemaImpl(JdbcNode parent, String name) {
        super(103, name, parent);
        ArgCheck.isNotNull((Object)parent);
    }

    protected JdbcNode[] computeChildren() throws JdbcException {
        DatabaseMetaData metadata = this.getJdbcDatabase().getDatabaseMetaData();
        ArrayList<JdbcNodeImpl> children = new ArrayList<JdbcNodeImpl>();
        JdbcDatabase database = this.getJdbcDatabase();
        try {
            String[] tableTypes = database.getIncludes().getIncludedTableTypes();
            if (tableTypes == null) {
                tableTypes = database.getCapabilities().getTableTypes();
            }
            for (int i = 0; i < tableTypes.length; ++i) {
                children.add(new JdbcTableTypeImpl(this, tableTypes[i]));
            }
        }
        catch (Throwable t) {
            Object[] params = new Object[]{metadata.getClass().getName(), database};
            String msg = JdbcPlugin.Util.getString("JdbcSchemaImpl.Unexpected_exception_while_calling_getTableTypes()_and_processing_results", params);
            JdbcPlugin.Util.log(2, t, msg);
        }
        if (database.getIncludes().includeProcedures()) {
            String procTerm = null;
            try {
                procTerm = database.getCapabilities().getProcedureTerm();
            }
            catch (Throwable t) {
                procTerm = JdbcPlugin.Util.getString("JdbcSchemaImpl.ProcedureTypeName");
            }
            children.add(new JdbcProcedureTypeImpl(this, procTerm));
        }
        return children.toArray(new JdbcNode[children.size()]);
    }

    public String getTypeName() {
        try {
            return this.getJdbcDatabase().getCapabilities().getSchemaTerm();
        }
        catch (Throwable t) {
            return JdbcPlugin.Util.getString("JdbcSchemaImpl.SchemaTypeName");
        }
    }

    public String getFullyQualifiedName() {
        boolean includeSchemas = false;
        try {
            includeSchemas = this.getJdbcDatabase().getCapabilities().supportsSchemasInDataManipulation();
        }
        catch (JdbcException e) {
            JdbcPlugin.Util.log((Throwable)((Object)e));
        }
        catch (SQLException e) {
            // empty catch block
        }
        StringBuffer sb = new StringBuffer();
        String prefix = this.getParent().getFullyQualifiedName();
        if (prefix.length() != 0) {
            sb.append(prefix);
            sb.append(this.getQualifedNameDelimiter());
        }
        if (includeSchemas) {
            sb.append(this.getUnqualifiedName());
        }
        return sb.toString();
    }

    public IPath getPathInSource() {
        return this.getPath();
    }

    public IPath getPathInSource(boolean includeCatalog, boolean includeSchema) {
        if (includeSchema && includeCatalog) {
            return this.getPath();
        }
        if (includeSchema) {
            if (this.getParent() == this.getJdbcDatabase()) {
                return this.getPath();
            }
            return new Path(this.getName());
        }
        return null;
    }

    public JdbcNode getParentDatabaseObject(boolean includeCatalog, boolean includeSchema) {
        if (this.getParent() instanceof JdbcCatalog) {
            return includeCatalog ? this.getParent() : null;
        }
        return null;
    }

    public JdbcDatabase getJdbcDatabase() {
        return this.getParent().getJdbcDatabase();
    }
}

