/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.tools.toolshell;

import com.metamatrix.tools.ToolsPlugin;
import com.metamatrix.tools.toolshell.Command;
import com.metamatrix.tools.toolshell.CommandContext;
import com.metamatrix.tools.toolshell.ScriptFileCommand;
import com.metamatrix.tools.toolshell.Stopwatch;
import com.metamatrix.tools.toolshell.ToolShellCommandProcessor;
import com.metamatrix.tools.toolshell.database.DatabaseConnectionContext;
import com.metamatrix.tools.toolshell.log.MuxingPrintStream;
import com.metamatrix.tools.toolshell.log.ShellLogger;
import com.metamatrix.tools.toolshell.parser.CommandIterator;
import com.metamatrix.tools.toolshell.parser.CommandLoop;
import com.metamatrix.tools.toolshell.parser.Lexer;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;

public abstract class ToolShell {
    public static final String LINE_FEED = System.getProperty("line.separator");
    protected static final String DOUBLE_QUOTE_STR = "\"";
    protected static final char CONTINUE_CHAR = '.';
    protected static final String PROMPT_STRING = "> ";
    protected static final String SEMICOLON_STRING = ";";
    protected static final String ERROR = "ERROR: ";
    protected HashMap commands;
    protected List orderedCommands = new ArrayList();
    protected HashMap contexts = new HashMap();
    private CommandIterator commandIterator;
    private File shellDirectory;
    private boolean interactive;
    protected int verbosity = 0;
    private ShellLogger shellLogger;
    private PrintStream printStreamForCommandOutput;
    private boolean seenContinuation = false;
    static /* synthetic */ Class class$com$metamatrix$tools$toolshell$database$DatabaseConnectionContext;

    protected void setVerbosity(int verbosity) {
        this.verbosity = verbosity;
    }

    protected abstract void initializeCommandList();

    public void initializeCommands() {
        this.commands = new HashMap();
        this.initializeCommandList();
        Iterator iter = this.commands.values().iterator();
        while (iter.hasNext()) {
            Command command = (Command)iter.next();
            command.setToolShell(this);
        }
    }

    public void putCommand(Command command) {
        this.commands.put(command.getCommandName(), command);
        this.orderedCommands.add(command);
    }

    protected abstract String getPrompt();

    void printPrompt() {
        if (this.interactive) {
            System.out.print(LINE_FEED + this.getPrompt() + PROMPT_STRING);
        }
    }

    void printContinuationPrompt(boolean inBlock) {
        if (this.interactive) {
            StringBuffer p = new StringBuffer();
            if (!this.seenContinuation) {
                if (inBlock) {
                    p.append(ToolsPlugin.Util.getString("ToolShell.block_continuation_explanation"));
                } else {
                    p.append(ToolsPlugin.Util.getString("ToolShell.continuation_explanation"));
                }
                this.seenContinuation = true;
            }
            String prompt = this.getPrompt();
            for (int i = 0; i < prompt.length(); ++i) {
                p.append('.');
            }
            p.append(PROMPT_STRING);
            System.out.print(p.toString());
        }
    }

    protected void acceptCommands(Reader reader, boolean printElapsed) throws IOException {
        CommandIterator iter = this.createCommandIterator(reader);
        ToolShellCommandProcessor processor = new ToolShellCommandProcessor(this, true, printElapsed);
        CommandLoop loop = new CommandLoop(iter, processor, false);
        loop.process();
    }

    public boolean isCommandComplete(List commandWords) throws Exception {
        Command command = this.findCommand(commandWords);
        return command.isComplete(commandWords);
    }

    protected void runCommandFile(String fileName) throws IOException {
        String commandString = ScriptFileCommand.SCRIPT_COMMAND_STRING + " " + fileName;
        boolean running = true;
        Stopwatch stopwatch = new Stopwatch();
        this.printlnVerbose(commandString);
        List<Object> args = Arrays.asList(ScriptFileCommand.SCRIPT_COMMAND_STRING, fileName);
        try {
            Command command = this.findCommand(args);
            stopwatch.start();
            running = command.executeCommand(args.iterator());
            stopwatch.stop();
            if (running) {
                this.printlnVerbose(ToolsPlugin.Util.getString("ToolShell.elapsed_time", stopwatch.getElapsedTime()));
            }
        }
        catch (Throwable t) {
            this.printlnException(t);
        }
    }

    protected void runSingleCommand(String[] commandArray) throws IOException {
        int lastIndex;
        String lastWord;
        if (commandArray.length > 0 && (lastWord = commandArray[lastIndex = commandArray.length - 1]).endsWith(SEMICOLON_STRING)) {
            commandArray[lastIndex] = lastWord.substring(0, lastWord.length() - 1);
        }
        String commandString = "";
        for (int i = 0; i < commandArray.length - 1; ++i) {
            commandString = commandString + commandArray[i];
            commandString = commandString + " ";
        }
        commandString = commandString + commandArray[commandArray.length - 1];
        boolean running = true;
        Stopwatch stopwatch = new Stopwatch();
        Lexer lexer = new Lexer(new StringReader(commandString));
        CommandIterator commandIter = new CommandIterator(lexer);
        commandIter.read();
        List words = commandIter.getCommandWords();
        try {
            Command command = this.findCommand(words);
            stopwatch.start();
            running = command.executeCommand(words.iterator());
            stopwatch.stop();
            if (running) {
                this.printlnVerbose(ToolsPlugin.Util.getString("ToolShell.elapsed_time", stopwatch.getElapsedTime()));
            }
        }
        catch (Throwable t) {
            this.printlnException(t);
        }
    }

    public Command findCommand(List words) throws Exception {
        Command helpCommand;
        String commandString = "";
        Iterator iter = words.iterator();
        while (iter.hasNext()) {
            commandString = commandString + " " + iter.next();
            Command command = (Command)this.commands.get(commandString = commandString.toLowerCase().trim());
            if (command == null) continue;
            return command;
        }
        if (words.size() == 1 && ToolShell.isHelpSynonym((String)words.get(0)) && (helpCommand = (Command)this.commands.get("help")) != null) {
            return helpCommand;
        }
        throw new Exception(ToolsPlugin.Util.getString("ToolShell.invalid_command", (Object)commandString));
    }

    public void setContext(String contextType, CommandContext context) {
        this.contexts.put(contextType, context);
    }

    public CommandContext getContext(String contextType) {
        CommandContext context = (CommandContext)this.contexts.get(contextType);
        if (context == null) {
            try {
                context = (CommandContext)Class.forName(contextType).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(ToolsPlugin.Util.getString("ToolShell.invalid_context"), e);
            }
            this.contexts.put(contextType, context);
        }
        return context;
    }

    public CommandIterator createCommandIterator(Reader reader) {
        this.commandIterator = new CommandIterator(new Lexer(reader));
        return this.commandIterator;
    }

    public CommandIterator getCommandIterator() {
        return this.commandIterator;
    }

    public List getAvailableCommands() {
        return this.orderedCommands;
    }

    public void printHelp(String helpMsg) {
        if (this.verbosity != 1) {
            this.shellLogger.logln(ShellLogger.DEST.STDOUT, helpMsg);
        }
        this.shellLogger.logln(ShellLogger.DEST.LOG, helpMsg);
    }

    public void printlnVerbose(String line) {
        if (this.interactive || this.verbosity != 1) {
            this.shellLogger.logln(ShellLogger.DEST.STDOUT, line);
        }
        this.shellLogger.logln(ShellLogger.DEST.LOG, line);
    }

    public void printVerbose(String line) {
        if (this.interactive || this.verbosity != 1) {
            this.shellLogger.log(ShellLogger.DEST.STDOUT, line);
        }
        this.shellLogger.log(ShellLogger.DEST.LOG, line);
    }

    public void printlnError(String error) {
        this.shellLogger.logln(ShellLogger.DEST.STDERR, error);
        this.shellLogger.logln(ShellLogger.DEST.LOG, error);
    }

    public void printlnException(Throwable error) {
        if (error != null) {
            String errorMsg = error.getMessage();
            errorMsg = errorMsg != null ? ERROR + errorMsg : ERROR + error.getClass().getName();
            switch (this.verbosity) {
                case 1: {
                    this.shellLogger.logln(ShellLogger.DEST.LOG, error);
                    if (!this.interactive) break;
                    this.shellLogger.logln(ShellLogger.DEST.STDERR, errorMsg);
                    break;
                }
                case 0: 
                case 2: {
                    this.shellLogger.logln(ShellLogger.DEST.STDERR, errorMsg);
                    this.shellLogger.logln(ShellLogger.DEST.LOG, error);
                    break;
                }
                case 3: {
                    this.shellLogger.logln(ShellLogger.DEST.LOG, error);
                    this.shellLogger.logln(ShellLogger.DEST.STDERR, error);
                }
            }
        }
    }

    public void printlnSQLException(SQLException e) {
        while (e != null) {
            this.printlnException(e);
            e = e.getNextException();
        }
    }

    public PrintStream getPrintStreamForCommandOutput() {
        if (this.printStreamForCommandOutput == null) {
            ArrayList<PrintStream> outputStreams = new ArrayList<PrintStream>();
            outputStreams.add(this.shellLogger.getDestination(ShellLogger.DEST.LOG));
            if (this.interactive) {
                outputStreams.add(this.shellLogger.getDestination(ShellLogger.DEST.STDOUT));
            }
            PrintStream[] streams = new PrintStream[outputStreams.size()];
            for (int i = 0; i < outputStreams.size(); ++i) {
                streams[i] = (PrintStream)outputStreams.get(i);
            }
            this.printStreamForCommandOutput = new MuxingPrintStream(streams);
        }
        return this.printStreamForCommandOutput;
    }

    public boolean getPrintResults() {
        return true;
    }

    public void printlnProperties(Properties properties) {
        TreeSet<Object> keys = new TreeSet<Object>(properties.keySet());
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = properties.getProperty(key);
            this.printlnVerbose(key + "=" + value);
        }
    }

    public File getShellDirectory() {
        return this.shellDirectory;
    }

    public void setShellDirectory(File shellDirectory) {
        this.shellDirectory = shellDirectory;
    }

    public DatabaseConnectionContext getDatabaseConnectionContext() {
        DatabaseConnectionContext context = (DatabaseConnectionContext)this.getContext((class$com$metamatrix$tools$toolshell$database$DatabaseConnectionContext == null ? (class$com$metamatrix$tools$toolshell$database$DatabaseConnectionContext = ToolShell.class$("com.metamatrix.tools.toolshell.database.DatabaseConnectionContext")) : class$com$metamatrix$tools$toolshell$database$DatabaseConnectionContext).getName());
        return context;
    }

    public void close() throws Exception {
        Iterator iter = this.contexts.values().iterator();
        while (iter.hasNext()) {
            CommandContext context = (CommandContext)iter.next();
            context.close();
        }
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    public boolean getInteractive() {
        return this.interactive;
    }

    public boolean getDebug() {
        return this.verbosity == 3;
    }

    public void setLogger(ShellLogger shellLogger) {
        this.shellLogger = shellLogger;
    }

    public void logCommand(List commandWords) {
        String promptStr = LINE_FEED + this.getPrompt() + PROMPT_STRING;
        StringBuffer commandBuf = new StringBuffer();
        Iterator commandWordItr = commandWords.iterator();
        while (commandWordItr.hasNext()) {
            String aCommandWord = (String)commandWordItr.next();
            commandBuf.append(aCommandWord);
            commandBuf.append(' ');
        }
        commandBuf.replace(commandBuf.length() - 1, commandBuf.length(), SEMICOLON_STRING);
        this.shellLogger.logln(ShellLogger.DEST.COMMAND, commandBuf.toString());
        this.shellLogger.logln(ShellLogger.DEST.LOG, promptStr + commandBuf.toString());
    }

    public String getSystemLineSeparator() {
        return LINE_FEED;
    }

    public static boolean isHelpSynonym(String possibleHelp) {
        return possibleHelp.equalsIgnoreCase("help") || possibleHelp.equalsIgnoreCase("-help") || possibleHelp.equalsIgnoreCase("/help") || possibleHelp.equalsIgnoreCase("h") || possibleHelp.equalsIgnoreCase("-h") || possibleHelp.equalsIgnoreCase("/h") || possibleHelp.equals("?") || possibleHelp.equals("-?") || possibleHelp.equals("/?");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

