/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.tools.toolshell.database;

import com.metamatrix.tools.ToolsPlugin;
import com.metamatrix.tools.toolshell.database.DatabaseConnectionCommandImpl;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;

public class AutocommitCommand
extends DatabaseConnectionCommandImpl {
    private static final String AUTOCOMMIT_ON = ToolsPlugin.Util.getString("AutocommitCommand.autocommit_on");
    private static final String AUTOCOMMIT_OFF = ToolsPlugin.Util.getString("AutocommitCommand.autocommit_off");
    private static final String ILLEGAL_ARGUMENT_STRING = ToolsPlugin.Util.getString("AutocommitCommand.error_missing_argument");

    public boolean executeCommand(Iterator argIter) {
        try {
            Connection connection = this.getDatabaseConnectionContext().getConnection();
            argIter.next();
            if (!argIter.hasNext()) {
                throw new IllegalArgumentException(ILLEGAL_ARGUMENT_STRING);
            }
            if (connection == null) {
                this.printlnError(NOT_CONNECTED_ERROR_STRING);
                return true;
            }
            String autoCommit = (String)argIter.next();
            if (autoCommit.toLowerCase().trim().equals(AUTOCOMMIT_ON)) {
                connection.setAutoCommit(true);
            } else if (autoCommit.toLowerCase().trim().equals(AUTOCOMMIT_OFF)) {
                connection.setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            this.printlnSQLException(e);
        }
        catch (ClassNotFoundException e) {
            this.printlnException(e);
        }
        return true;
    }

    public String getCommandName() {
        return ToolsPlugin.Util.getString("AutocommitCommand.command_name");
    }

    public String getLongHelp(List argList) {
        return ToolsPlugin.Util.getString("AutocommitCommand.longHelp");
    }

    public String getShortHelp() {
        return ToolsPlugin.Util.getString("AutocommitCommand.shortHelp");
    }

    public String getArgHelp() {
        return ToolsPlugin.Util.getString("AutocommitCommand.argHelp");
    }
}

