/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.tools.toolshell.database;

import com.metamatrix.tools.ToolsPlugin;
import com.metamatrix.tools.toolshell.database.DatabaseConnectionCommandImpl;
import com.metamatrix.tools.toolshell.database.DatabaseConnectionContext;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;

public class ConnectCommand
extends DatabaseConnectionCommandImpl {
    private static final String MISSING_DRIVER_ERROR_STRING = ToolsPlugin.Util.getString("ConnectCommand.error_missing_driver_class");
    private static final String MISSING_URL_ERROR_STRING = ToolsPlugin.Util.getString("ConnectCommand.error_missing_url");

    public boolean executeCommand(Iterator argIter) {
        try {
            argIter.next();
            if (!argIter.hasNext()) {
                throw new IllegalArgumentException(MISSING_DRIVER_ERROR_STRING);
            }
            String driver = (String)argIter.next();
            if (!argIter.hasNext()) {
                throw new IllegalArgumentException(MISSING_URL_ERROR_STRING);
            }
            String url = (String)argIter.next();
            DatabaseConnectionContext dcContext = this.getDatabaseConnectionContext();
            dcContext.setDriver(driver);
            dcContext.setURL(url);
            dcContext.createConnection();
        }
        catch (SQLException e) {
            return true;
        }
        catch (ClassNotFoundException e) {
            return true;
        }
        return true;
    }

    public String getCommandName() {
        return ToolsPlugin.Util.getString("ConnectCommand.commandName");
    }

    public String getLongHelp(List argList) {
        return ToolsPlugin.Util.getString("ConnectCommand.longHelp");
    }

    public String getShortHelp() {
        return ToolsPlugin.Util.getString("ConnectCommand.shortHelp");
    }

    public String getArgHelp() {
        return ToolsPlugin.Util.getString("ConnectCommand.argHelp");
    }
}

