/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.tools.toolshell.database;

import com.metamatrix.tools.ToolsPlugin;
import com.metamatrix.tools.toolshell.database.DatabaseConnectionCommandImpl;
import com.metamatrix.tools.toolshell.database.DatabaseConnectionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;

public class FetchCommand
extends DatabaseConnectionCommandImpl {
    private static final String MISSING_ARGUMENT_ERROR_STRING = ToolsPlugin.Util.getString("FetchCommand.missing_fetch_size");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeCommand(Iterator argIter) {
        DatabaseConnectionContext dcContext = this.getDatabaseConnectionContext();
        try {
            Connection connection = dcContext.getConnection();
            argIter.next();
            if (!argIter.hasNext()) {
                throw new IllegalArgumentException(MISSING_ARGUMENT_ERROR_STRING);
            }
            if (connection == null) {
                this.printlnError(NOT_CONNECTED_ERROR_STRING);
                boolean bl = true;
                return bl;
            }
            String size = (String)argIter.next();
            int fetchSize = Integer.parseInt(size);
            dcContext.setFetchSize(fetchSize);
        }
        catch (SQLException e) {
            this.printlnSQLException(e);
        }
        catch (ClassNotFoundException e) {
            this.printlnException(e);
        }
        finally {
            dcContext.closeStatement();
        }
        return true;
    }

    public String getCommandName() {
        return ToolsPlugin.Util.getString("FetchCommand.commandName");
    }

    public String getLongHelp(List argList) {
        return ToolsPlugin.Util.getString("FetchCommand.longHelp");
    }

    public String getShortHelp() {
        return ToolsPlugin.Util.getString("FetchCommand.shortHelp");
    }

    public String getArgHelp() {
        return ToolsPlugin.Util.getString("FetchCommand.argHelp");
    }
}

