/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.tools.toolshell.database;

import com.metamatrix.tools.ToolsPlugin;
import com.metamatrix.tools.toolshell.database.DatabaseConnectionCommandImpl;
import com.metamatrix.tools.toolshell.database.DatabaseConnectionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;

public class MaxrowsCommand
extends DatabaseConnectionCommandImpl {
    private static final String MISSING_ARGUMENT_ERROR_STRING = ToolsPlugin.Util.getString("MaxrowsCommand.error_missing_max_rows");

    public boolean executeCommand(Iterator argIter) {
        DatabaseConnectionContext dcContext = this.getDatabaseConnectionContext();
        try {
            Connection connection = dcContext.getConnection();
            argIter.next();
            if (!argIter.hasNext()) {
                throw new IllegalArgumentException(MISSING_ARGUMENT_ERROR_STRING);
            }
            if (connection == null) {
                this.printlnError(NOT_CONNECTED_ERROR_STRING);
                return true;
            }
            String rowsString = (String)argIter.next();
            int maxrows = Integer.parseInt(rowsString);
            dcContext.setMaxRows(maxrows);
        }
        catch (SQLException e) {
            this.printlnSQLException(e);
        }
        catch (ClassNotFoundException e) {
            this.printlnException(e);
        }
        return true;
    }

    public String getCommandName() {
        return ToolsPlugin.Util.getString("MaxrowsCommand.commandName");
    }

    public String getLongHelp(List argList) {
        return ToolsPlugin.Util.getString("MaxrowsCommand.longHelp");
    }

    public String getShortHelp() {
        return ToolsPlugin.Util.getString("MaxrowsCommand.shortHelp");
    }

    public String getArgHelp() {
        return ToolsPlugin.Util.getString("MaxrowsCommand.argHelp");
    }
}

