/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc;

import com.metamatrix.connector.jdbc.JDBCPlugin;
import com.metamatrix.data.api.ValueChunk;
import com.metamatrix.data.api.ValueReference;
import com.metamatrix.data.basic.BasicValueChunk;
import com.metamatrix.data.exception.ConnectorException;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;

public class ClobValueReference
implements ValueReference {
    private Object value;
    private long size;
    private Reader in;
    private long currentPos;

    public ClobValueReference(Object value, long size) {
        this.value = value;
        this.size = size;
        if (value instanceof Clob) {
            Clob clob = (Clob)value;
            try {
                this.in = clob.getCharacterStream();
            }
            catch (SQLException ie) {}
        } else {
            char[] chars = (char[])value;
            this.in = new CharArrayReader(chars);
        }
    }

    public Object getValue() {
        return this.value;
    }

    public long getSize() {
        return this.size;
    }

    public ValueChunk createChunk(long startPos, int chunkSize) throws ConnectorException {
        if (chunkSize == 0) {
            return new BasicValueChunk((Object)new char[0], false, false);
        }
        if (startPos < this.currentPos && this.value instanceof Clob) {
            Clob clob = (Clob)this.value;
            try {
                this.in = clob.getCharacterStream();
            }
            catch (SQLException ie) {
                // empty catch block
            }
        }
        char[] chunk = new char[chunkSize];
        boolean isLast = false;
        if (this.size - startPos < (long)chunkSize) {
            chunk = new char[(int)(this.size - startPos)];
            isLast = true;
        } else {
            chunk = new char[chunkSize];
        }
        try {
            int read = this.in.read(chunk);
            if (read < 0) {
                isLast = true;
            }
        }
        catch (IOException ie) {
            throw new ConnectorException((Throwable)ie, JDBCPlugin.Util.getString("ClobValueReference.Unable_to_read_CLOB_data"));
        }
        this.currentPos = startPos + (long)chunk.length;
        return new BasicValueChunk((Object)chunk, false, isLast);
    }

    public boolean isBinary() {
        return false;
    }
}

