/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc;

import com.metamatrix.connector.jdbc.ConnectionStrategy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class ConnectionQueryStrategy
implements ConnectionStrategy {
    private String connTestquery;
    private long prevTime;
    private boolean isFailed = false;
    private int queryInterval;

    public ConnectionQueryStrategy(String query, int queryInterval) {
        this.connTestquery = query;
        this.prevTime = System.currentTimeMillis();
        this.queryInterval = queryInterval;
    }

    public void setQueryInterval(int queryInterval) {
        this.queryInterval = queryInterval;
    }

    public boolean isConnectionAlive(Connection connection) {
        try {
            if (connection.isClosed()) {
                return false;
            }
            return this.executeTestQuery(connection);
        }
        catch (SQLException e) {
            this.isFailed = true;
            return false;
        }
    }

    public boolean isConnectionFailed(Connection connection) {
        try {
            if (connection.isClosed()) {
                return this.isFailed;
            }
            return !this.executeTestQuery(connection);
        }
        catch (SQLException e) {
            this.isFailed = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean executeTestQuery(Connection connection) {
        boolean bl;
        Statement statement = null;
        try {
            try {
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.prevTime > (long)this.queryInterval) {
                    this.prevTime = currentTime;
                    statement = connection.createStatement();
                    statement.executeQuery(this.connTestquery);
                }
                this.isFailed = false;
                bl = true;
                Object var7_6 = null;
                if (statement == null) return bl;
            }
            catch (SQLException e) {
                this.isFailed = true;
                boolean bl2 = false;
                Object var7_7 = null;
                if (statement == null) return bl2;
                try {
                    statement.close();
                    return bl2;
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (statement == null) throw throwable;
            try {}
            catch (SQLException e2) {
                throw throwable;
            }
            statement.close();
            statement = null;
            throw throwable;
        }
        try {}
        catch (SQLException e2) {
            // empty catch block
            return bl;
        }
        statement.close();
        return bl;
    }
}

