/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc;

import com.metamatrix.connector.jdbc.ConnectionListener;
import com.metamatrix.connector.jdbc.JDBCPlugin;
import com.metamatrix.data.api.ConnectorEnvironment;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;

public class DefaultConnectionListener
implements ConnectionListener {
    ConnectionListener customListener = null;
    boolean alreadyReportedDetails = false;

    public void afterConnectionCreation(Connection connection, ConnectorEnvironment env) {
        if (this.alreadyReportedDetails) {
            return;
        }
        this.alreadyReportedDetails = true;
        try {
            StringBuffer sb = new StringBuffer();
            DatabaseMetaData dbmd = connection.getMetaData();
            sb.append("Commit=").append(connection.getAutoCommit());
            sb.append(";DatabaseProductName=").append(dbmd.getDatabaseProductName());
            sb.append(";DatabaseProductVersion=").append(dbmd.getDatabaseProductVersion());
            sb.append(";DriverMajorVersion=").append(dbmd.getDriverMajorVersion());
            sb.append(";DriverMajorVersion=").append(dbmd.getDriverMinorVersion());
            sb.append(";DriverName=").append(dbmd.getDriverName());
            sb.append(";DriverVersion=").append(dbmd.getDriverVersion());
            sb.append(";IsolationLevel=").append(dbmd.getDefaultTransactionIsolation());
            env.getLogger().logInfo(sb.toString());
        }
        catch (SQLException e) {
            String errorStr = JDBCPlugin.Util.getString("ConnectionListener.failed_to_report_jdbc_connection_details");
            env.getLogger().logInfo(errorStr);
        }
        if (this.customListener != null) {
            this.customListener.afterConnectionCreation(connection, env);
        }
    }

    public void beforeConnectionClose(Connection connection, ConnectorEnvironment env) {
        if (this.customListener != null) {
            this.customListener.beforeConnectionClose(connection, env);
        }
    }
}

