/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc;

import com.metamatrix.connector.jdbc.extension.SQLConversionVisitor;
import com.metamatrix.connector.jdbc.extension.SQLTranslator;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.ICommand;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SQLTranslatorWrapper
implements SQLTranslator {
    private SQLTranslator delegate;
    private Map functionModifiers;

    public SQLTranslatorWrapper(SQLTranslator translator) {
        this.delegate = translator;
    }

    public void initialize(ConnectorEnvironment env, RuntimeMetadata metadata) throws ConnectorException {
        this.delegate.initialize(env, metadata);
    }

    public ICommand modifyCommand(ICommand command, ExecutionContext context) throws ConnectorException {
        return this.delegate.modifyCommand(command, context);
    }

    public SQLConversionVisitor getTranslationVisitor() {
        return this.delegate.getTranslationVisitor();
    }

    public Map getFunctionModifiers() {
        if (this.functionModifiers == null) {
            this.loadModifiers();
        }
        return this.functionModifiers;
    }

    private synchronized void loadModifiers() {
        Map modifiers = this.delegate.getFunctionModifiers();
        HashMap cleanModifiers = new HashMap();
        Iterator modIter = modifiers.entrySet().iterator();
        while (modIter.hasNext()) {
            Map.Entry entry = modIter.next();
            String key = (String)entry.getKey();
            cleanModifiers.put(key.toLowerCase(), entry.getValue());
        }
        this.functionModifiers = cleanModifiers;
    }
}

