/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.extension.impl;

import com.metamatrix.common.util.exception.SQLExceptionUnroller;
import com.metamatrix.connector.jdbc.BlobValueReference;
import com.metamatrix.connector.jdbc.JDBCPlugin;
import com.metamatrix.connector.jdbc.extension.ValueTranslator;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.api.ValueReference;
import com.metamatrix.data.exception.ConnectorException;
import java.sql.Blob;
import java.sql.SQLException;

public class BlobValueTranslator
implements ValueTranslator {
    private int maxBlobBytes;
    private ConnectorEnvironment environment;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$com$metamatrix$common$types$BlobType;

    public void initialize(ConnectorEnvironment env) {
        this.environment = env;
        String propStr = env.getProperties().getProperty("MaxBlobBytes");
        if (propStr != null) {
            this.maxBlobBytes = Integer.parseInt(propStr);
        }
    }

    public Class getSourceType() {
        return class$java$sql$Blob == null ? (class$java$sql$Blob = BlobValueTranslator.class$("java.sql.Blob")) : class$java$sql$Blob;
    }

    public Class getTargetType() {
        return class$com$metamatrix$common$types$BlobType == null ? (class$com$metamatrix$common$types$BlobType = BlobValueTranslator.class$("com.metamatrix.common.types.BlobType")) : class$com$metamatrix$common$types$BlobType;
    }

    public Object translate(Object value, ExecutionContext context) throws ConnectorException {
        if (value instanceof Blob) {
            Blob blob = (Blob)value;
            try {
                if (this.maxBlobBytes != 0 && blob.length() > (long)this.maxBlobBytes) {
                    throw new ConnectorException(JDBCPlugin.Util.getString("JDBCTranslator.Retrieved_Blob_is_too_large_13", this.maxBlobBytes));
                }
                return this.environment.createValueReferenceReplacement((ValueReference)new BlobValueReference(blob, blob.length()), context);
            }
            catch (SQLException e) {
                throw new ConnectorException((Throwable)SQLExceptionUnroller.unRollException((SQLException)e), JDBCPlugin.Util.getString("JDBCTranslator.Error_determining_blob_length___15", (Object)e.getMessage()));
            }
        }
        byte[] bytes = (byte[])value;
        if (this.maxBlobBytes != 0 && bytes.length > this.maxBlobBytes) {
            throw new ConnectorException(JDBCPlugin.Util.getString("JDBCTranslator.Retrieved_Blob_is_too_large_13", this.maxBlobBytes));
        }
        return this.environment.createValueReferenceReplacement((ValueReference)new BlobValueReference(bytes, bytes.length), context);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

