/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.mysql;

import com.metamatrix.connector.jdbc.extension.impl.BasicFunctionModifier;
import com.metamatrix.connector.jdbc.extension.impl.DropFunctionModifier;
import com.metamatrix.data.language.IExpression;
import com.metamatrix.data.language.IFunction;
import com.metamatrix.data.language.ILanguageFactory;
import com.metamatrix.data.language.ILiteral;
import java.util.Arrays;
import java.util.List;

class MySQLConvertModifier
extends BasicFunctionModifier {
    private static DropFunctionModifier DROP_MODIFIER = new DropFunctionModifier();
    private ILanguageFactory langFactory;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Double;

    MySQLConvertModifier(ILanguageFactory langFactory) {
        this.langFactory = langFactory;
    }

    public List translate(IFunction function) {
        return null;
    }

    public IExpression modify(IFunction function) {
        IExpression[] args = function.getParameters();
        if (args[0] != null && args[0] instanceof ILiteral && ((ILiteral)args[0]).getValue() == null && args[1] != null && args[1] instanceof ILiteral) {
            return DROP_MODIFIER.modify(function);
        }
        if (args[1] != null && args[1] instanceof ILiteral) {
            String target = ((String)((ILiteral)args[1]).getValue()).toLowerCase();
            if (target.equals("string")) {
                return this.convertToString(function);
            }
            if (target.equals("byte") || target.equals("short") || target.equals("integer")) {
                return this.convertToNativeType(function, "SIGNED INTEGER");
            }
            if (target.equals("long") || target.equals("biginteger")) {
                return this.convertToNativeType(function, "SIGNED");
            }
            if (target.equals("float") || target.equals("double") || target.equals("bigdecimal")) {
                return this.convertToNumeric(function);
            }
            if (target.equals("date")) {
                return this.convertToDateTime("DATE", args[0], class$java$sql$Date == null ? (class$java$sql$Date = MySQLConvertModifier.class$("java.sql.Date")) : class$java$sql$Date);
            }
            if (target.equals("time")) {
                return this.convertToDateTime("TIME", args[0], class$java$sql$Time == null ? (class$java$sql$Time = MySQLConvertModifier.class$("java.sql.Time")) : class$java$sql$Time);
            }
            if (target.equals("timestamp")) {
                return this.convertToDateTime("TIMESTAMP", args[0], class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = MySQLConvertModifier.class$("java.sql.Timestamp")) : class$java$sql$Timestamp);
            }
            if (target.equals("char")) {
                return this.convertToNativeType(function, "CHAR (1)");
            }
            if (target.equals("boolean")) {
                return this.convertToBoolean(function);
            }
        }
        return DROP_MODIFIER.modify(function);
    }

    private IExpression convertToString(IFunction function) {
        int srcCode = this.getSrcCode(function);
        switch (srcCode) {
            case 2: {
                List<IExpression> when = Arrays.asList(this.langFactory.createLiteral((Object)new Integer(1), class$java$lang$Integer == null ? (class$java$lang$Integer = MySQLConvertModifier.class$("java.lang.Integer")) : class$java$lang$Integer));
                List<IExpression> then = Arrays.asList(this.langFactory.createLiteral((Object)"1", class$java$lang$String == null ? (class$java$lang$String = MySQLConvertModifier.class$("java.lang.String")) : class$java$lang$String));
                ILiteral elseExpr = this.langFactory.createLiteral((Object)"0", class$java$lang$String == null ? (class$java$lang$String = MySQLConvertModifier.class$("java.lang.String")) : class$java$lang$String);
                return this.langFactory.createCaseExpression(function.getParameters()[0], when, then, (IExpression)elseExpr, class$java$lang$String == null ? (class$java$lang$String = MySQLConvertModifier.class$("java.lang.String")) : class$java$lang$String);
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return this.convertToNativeType(function, "CHAR");
            }
            case 11: {
                return this.convertDateTimeToString(function, "%Y-%m-%d");
            }
            case 12: {
                return this.convertDateTimeToString(function, "%H:%i:%S");
            }
            case 13: {
                return this.convertDateTimeToString(function, "%Y-%m-%d %H:%i:%S.%f");
            }
        }
        return DROP_MODIFIER.modify(function);
    }

    private IExpression convertToNativeType(IFunction function, String targetType) {
        IExpression[] args = function.getParameters();
        function.setName("convert");
        args[1] = this.langFactory.createLiteral((Object)targetType, class$java$lang$String == null ? (class$java$lang$String = MySQLConvertModifier.class$("java.lang.String")) : class$java$lang$String);
        function.setParameters(args);
        return function;
    }

    private IExpression convertToNumeric(IFunction function) {
        return this.langFactory.createFunction("+", new IExpression[]{function.getParameters()[0], this.langFactory.createLiteral((Object)new Double(0.0), class$java$lang$Double == null ? (class$java$lang$Double = MySQLConvertModifier.class$("java.lang.Double")) : class$java$lang$Double)}, class$java$lang$Double == null ? (class$java$lang$Double = MySQLConvertModifier.class$("java.lang.Double")) : class$java$lang$Double);
    }

    private IExpression convertToDateTime(String functionName, IExpression value, Class targetType) {
        return this.langFactory.createFunction(functionName, new IExpression[]{value}, targetType);
    }

    private IExpression convertToBoolean(IFunction function) {
        int srcCode = this.getSrcCode(function);
        switch (srcCode) {
            case 0: {
                List<IExpression> when = Arrays.asList(this.langFactory.createLiteral((Object)"true", class$java$lang$String == null ? (class$java$lang$String = MySQLConvertModifier.class$("java.lang.String")) : class$java$lang$String));
                List<IExpression> then = Arrays.asList(this.langFactory.createLiteral((Object)new Integer(1), class$java$lang$Integer == null ? (class$java$lang$Integer = MySQLConvertModifier.class$("java.lang.Integer")) : class$java$lang$Integer));
                ILiteral elseExpr = this.langFactory.createLiteral((Object)new Integer(0), class$java$lang$Integer == null ? (class$java$lang$Integer = MySQLConvertModifier.class$("java.lang.Integer")) : class$java$lang$Integer);
                return this.langFactory.createCaseExpression(function.getParameters()[0], when, then, (IExpression)elseExpr, class$java$lang$Integer == null ? (class$java$lang$Integer = MySQLConvertModifier.class$("java.lang.Integer")) : class$java$lang$Integer);
            }
        }
        return DROP_MODIFIER.modify(function);
    }

    private IFunction convertDateTimeToString(IFunction function, String format) {
        IExpression[] args = function.getParameters();
        function.setName("date_format");
        args[1] = this.langFactory.createLiteral((Object)format, class$java$lang$String == null ? (class$java$lang$String = MySQLConvertModifier.class$("java.lang.String")) : class$java$lang$String);
        function.setParameters(args);
        return function;
    }

    private int getSrcCode(IFunction function) {
        IExpression[] args = function.getParameters();
        Class srcType = args[0].getType();
        return (Integer)typeMap.get(srcType);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

