/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.postgresql;

import com.metamatrix.connector.jdbc.extension.FunctionModifier;
import com.metamatrix.connector.jdbc.extension.impl.BasicFunctionModifier;
import com.metamatrix.connector.jdbc.extension.impl.DropFunctionModifier;
import com.metamatrix.data.language.IExpression;
import com.metamatrix.data.language.IFunction;
import com.metamatrix.data.language.ILanguageFactory;
import com.metamatrix.data.language.ILiteral;
import java.util.Arrays;
import java.util.List;

class PostgreSQLConvertModifier
extends BasicFunctionModifier
implements FunctionModifier {
    private static DropFunctionModifier DROP_MODIFIER = new DropFunctionModifier();
    private ILanguageFactory langFactory;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;

    PostgreSQLConvertModifier(ILanguageFactory langFactory) {
        this.langFactory = langFactory;
    }

    public List translate(IFunction function) {
        return null;
    }

    public IExpression modify(IFunction function) {
        IExpression[] args = function.getParameters();
        if (args[0] != null && args[0] instanceof ILiteral && ((ILiteral)args[0]).getValue() == null && args[1] != null && args[1] instanceof ILiteral) {
            return DROP_MODIFIER.modify(function);
        }
        if (args[1] != null && args[1] instanceof ILiteral) {
            String target = ((String)((ILiteral)args[1]).getValue()).toLowerCase();
            if (target.equals("string")) {
                return this.convertToString(function);
            }
            if (target.equals("short")) {
                return this.createCastFunction(args[0], "smallint", class$java$lang$Short == null ? (class$java$lang$Short = PostgreSQLConvertModifier.class$("java.lang.Short")) : class$java$lang$Short);
            }
            if (target.equals("integer")) {
                return this.createCastFunction(args[0], "integer", class$java$lang$Integer == null ? (class$java$lang$Integer = PostgreSQLConvertModifier.class$("java.lang.Integer")) : class$java$lang$Integer);
            }
            if (target.equals("long")) {
                return this.createCastFunction(args[0], "bigint", class$java$lang$Long == null ? (class$java$lang$Long = PostgreSQLConvertModifier.class$("java.lang.Long")) : class$java$lang$Long);
            }
            if (target.equals("biginteger")) {
                return this.createCastFunction(args[0], "numeric", class$java$math$BigInteger == null ? (class$java$math$BigInteger = PostgreSQLConvertModifier.class$("java.math.BigInteger")) : class$java$math$BigInteger);
            }
            if (target.equals("float")) {
                return this.createCastFunction(args[0], "real", class$java$lang$Float == null ? (class$java$lang$Float = PostgreSQLConvertModifier.class$("java.lang.Float")) : class$java$lang$Float);
            }
            if (target.equals("double")) {
                return this.createCastFunction(args[0], "float8", class$java$lang$Double == null ? (class$java$lang$Double = PostgreSQLConvertModifier.class$("java.lang.Double")) : class$java$lang$Double);
            }
            if (target.equals("bigdecimal")) {
                return this.createCastFunction(args[0], "decimal", class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = PostgreSQLConvertModifier.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
            }
            if (target.equals("date")) {
                return this.convertToDate(function);
            }
            if (target.equals("time")) {
                return this.convertToTime(function);
            }
            if (target.equals("timestamp")) {
                return this.convertToTimestamp(function);
            }
            if (target.equals("char")) {
                return this.createCastFunction(args[0], "varchar", class$java$lang$String == null ? (class$java$lang$String = PostgreSQLConvertModifier.class$("java.lang.String")) : class$java$lang$String);
            }
            if (target.equals("boolean")) {
                return this.createCastFunction(args[0], "boolean", class$java$lang$Boolean == null ? (class$java$lang$Boolean = PostgreSQLConvertModifier.class$("java.lang.Boolean")) : class$java$lang$Boolean);
            }
            if (target.equals("byte")) {
                return this.createCastFunction(args[0], "smallint", class$java$lang$Byte == null ? (class$java$lang$Byte = PostgreSQLConvertModifier.class$("java.lang.Byte")) : class$java$lang$Byte);
            }
        }
        return DROP_MODIFIER.modify(function);
    }

    private IExpression convertToDate(IFunction function) {
        IExpression[] args = function.getParameters();
        int srcCode = this.getSrcCode(function);
        switch (srcCode) {
            case 0: {
                return this.createConversionFunction("to_date", args[0], "YYYY-MM-DD", class$java$sql$Date == null ? (class$java$sql$Date = PostgreSQLConvertModifier.class$("java.sql.Date")) : class$java$sql$Date);
            }
            case 13: {
                return this.createCastFunction(args[0], "date", class$java$sql$Date == null ? (class$java$sql$Date = PostgreSQLConvertModifier.class$("java.sql.Date")) : class$java$sql$Date);
            }
        }
        return DROP_MODIFIER.modify(function);
    }

    private IExpression convertToTime(IFunction function) {
        IExpression[] args = function.getParameters();
        int srcCode = this.getSrcCode(function);
        switch (srcCode) {
            case 0: {
                IFunction prependedPart0 = this.langFactory.createFunction("||", new IExpression[]{this.langFactory.createLiteral((Object)"1970-01-01 ", class$java$lang$String == null ? (class$java$lang$String = PostgreSQLConvertModifier.class$("java.lang.String")) : class$java$lang$String), args[0]}, class$java$lang$String == null ? (class$java$lang$String = PostgreSQLConvertModifier.class$("java.lang.String")) : class$java$lang$String);
                return this.createConversionFunction("to_timestamp", (IExpression)prependedPart0, "YYYY-MM-DD HH24:MI:SS", class$java$sql$Time == null ? (class$java$sql$Time = PostgreSQLConvertModifier.class$("java.sql.Time")) : class$java$sql$Time);
            }
            case 13: {
                return this.createCastFunction(args[0], "time", class$java$sql$Time == null ? (class$java$sql$Time = PostgreSQLConvertModifier.class$("java.sql.Time")) : class$java$sql$Time);
            }
        }
        return DROP_MODIFIER.modify(function);
    }

    private IExpression convertToTimestamp(IFunction function) {
        IExpression[] args = function.getParameters();
        int srcCode = this.getSrcCode(function);
        switch (srcCode) {
            case 0: {
                return this.createConversionFunction("to_timestamp", args[0], "YYYY-MM-DD HH24:MI:SS.UF", class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = PostgreSQLConvertModifier.class$("java.sql.Timestamp")) : class$java$sql$Timestamp);
            }
            case 11: 
            case 12: {
                IFunction inner = this.createStringFunction(args[0], "YYYY-MM-DD HH24:MI:SS");
                return this.createConversionFunction("to_timestamp", (IExpression)inner, "YYYY-MM-DD HH24:MI:SS", class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = PostgreSQLConvertModifier.class$("java.sql.Timestamp")) : class$java$sql$Timestamp);
            }
        }
        return DROP_MODIFIER.modify(function);
    }

    private IExpression convertToString(IFunction function) {
        IExpression[] args = function.getParameters();
        int srcCode = this.getSrcCode(function);
        switch (srcCode) {
            case 2: {
                List<IExpression> when = Arrays.asList(this.langFactory.createLiteral((Object)Boolean.TRUE, class$java$lang$Boolean == null ? (class$java$lang$Boolean = PostgreSQLConvertModifier.class$("java.lang.Boolean")) : class$java$lang$Boolean));
                List<IExpression> then = Arrays.asList(this.langFactory.createLiteral((Object)"1", class$java$lang$String == null ? (class$java$lang$String = PostgreSQLConvertModifier.class$("java.lang.String")) : class$java$lang$String));
                ILiteral elseExpr = this.langFactory.createLiteral((Object)"0", class$java$lang$String == null ? (class$java$lang$String = PostgreSQLConvertModifier.class$("java.lang.String")) : class$java$lang$String);
                return this.langFactory.createCaseExpression(function.getParameters()[0], when, then, (IExpression)elseExpr, class$java$lang$String == null ? (class$java$lang$String = PostgreSQLConvertModifier.class$("java.lang.String")) : class$java$lang$String);
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return this.createCastFunction(args[0], "varchar", class$java$lang$String == null ? (class$java$lang$String = PostgreSQLConvertModifier.class$("java.lang.String")) : class$java$lang$String);
            }
            case 11: {
                return this.createStringFunction(args[0], "YYYY-MM-DD");
            }
            case 12: {
                return this.createStringFunction(args[0], "HH24:MI:SS");
            }
            case 13: {
                return this.createStringFunction(args[0], "YYYY-MM-DD HH24:MI:SS.US");
            }
        }
        return DROP_MODIFIER.modify(function);
    }

    private IFunction createStringFunction(IExpression args0, String format) {
        return this.createConversionFunction("to_char", args0, format, class$java$lang$String == null ? (class$java$lang$String = PostgreSQLConvertModifier.class$("java.lang.String")) : class$java$lang$String);
    }

    private IFunction createCastFunction(IExpression value, String typeName, Class targetClass) {
        return this.createConversionFunction("cast", value, typeName, targetClass);
    }

    private IFunction createConversionFunction(String functionName, IExpression value, String target, Class targetClass) {
        return this.langFactory.createFunction(functionName, new IExpression[]{value, this.langFactory.createLiteral((Object)target, class$java$lang$String == null ? (class$java$lang$String = PostgreSQLConvertModifier.class$("java.lang.String")) : class$java$lang$String)}, targetClass);
    }

    private int getSrcCode(IFunction function) {
        IExpression[] args = function.getParameters();
        Class srcType = args[0].getType();
        return (Integer)typeMap.get(srcType);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

