/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.misc;

import EDU.oswego.cs.dl.util.concurrent.Rendezvous;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import EDU.oswego.cs.dl.util.concurrent.misc.UpdateCommand;
import java.io.Serializable;

abstract class RNG
implements Serializable,
Comparable {
    static final int firstSeed = 4321;
    static final int rmod = Integer.MAX_VALUE;
    static final int rmul = 16807;
    static int lastSeed = 4321;
    static final int smod = 32749;
    static final int smul = 3125;
    static final Object constructionLock = class$EDU$oswego$cs$dl$util$concurrent$misc$RNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$RNG = RNG.class$("EDU.oswego.cs.dl.util.concurrent.misc.RNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$RNG;
    static final SynchronizedInt computeLoops = new SynchronizedInt(16, constructionLock);
    static final SynchronizedInt syncMode = new SynchronizedInt(0, constructionLock);
    static final SynchronizedInt producerMode = new SynchronizedInt(0, constructionLock);
    static final SynchronizedInt consumerMode = new SynchronizedInt(0, constructionLock);
    static final SynchronizedInt bias = new SynchronizedInt(0, constructionLock);
    static final SynchronizedLong timeout = new SynchronizedLong(100L, constructionLock);
    static final SynchronizedInt exchangeParties = new SynchronizedInt(1, constructionLock);
    static final SynchronizedInt sequenceNumber = new SynchronizedInt(0, constructionLock);
    static final SynchronizedInt itersPerBarrier = new SynchronizedInt(0, constructionLock);
    static Rendezvous[] exchangers_;
    final int cloops = computeLoops.get();
    final int pcBias = bias.get();
    final int smode = syncMode.get();
    final int pmode = producerMode.get();
    final int cmode = consumerMode.get();
    final long waitTime = timeout.get();
    Rendezvous exchanger_ = null;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$RNG;

    RNG() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reset(int n2) {
        Object object = constructionLock;
        synchronized (object) {
            sequenceNumber.set(-1);
            int n3 = exchangeParties.get();
            if (n2 < n3) {
                n3 = n2;
            }
            if (n2 % n3 != 0) {
                throw new Error("need even multiple of parties");
            }
            exchangers_ = new Rendezvous[n2 / n3];
            for (int i2 = 0; i2 < exchangers_.length; ++i2) {
                RNG.exchangers_[i2] = new Rendezvous(n3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long nextSeed() {
        Object object = constructionLock;
        synchronized (object) {
            long l2 = lastSeed;
            lastSeed = lastSeed * 3125 % 32749;
            if (lastSeed == 0) {
                lastSeed = (int)System.currentTimeMillis();
            }
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Rendezvous getExchanger() {
        if (this.exchanger_ == null) {
            Object object = constructionLock;
            synchronized (object) {
                int n2 = sequenceNumber.increment();
                this.exchanger_ = exchangers_[n2 % exchangers_.length];
            }
        }
        return this.exchanger_;
    }

    public void exchange() throws InterruptedException {
        Rendezvous rendezvous = this.getExchanger();
        Runnable runnable = (Runnable)rendezvous.rendezvous(new UpdateCommand(this));
        if (runnable != null) {
            runnable.run();
        }
    }

    public int compareTo(Object object) {
        int n2;
        int n3 = this.hashCode();
        if (n3 < (n2 = object.hashCode())) {
            return -1;
        }
        if (n3 > n2) {
            return 1;
        }
        return 0;
    }

    protected final long compute(long l2) {
        int n2 = (int)((l2 & Integer.MAX_VALUE) % (long)(this.cloops * 2)) + 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            l2 = l2 * 16807L % Integer.MAX_VALUE;
        }
        return l2 == 0L ? 4321L : l2;
    }

    protected abstract void set(long var1);

    protected abstract long internalGet();

    protected abstract void internalUpdate();

    public long get() {
        return this.internalGet();
    }

    public void update() {
        this.internalUpdate();
    }

    public long next() {
        this.internalUpdate();
        return this.internalGet();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

