/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.actions;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.actions.ActionDefinition;
import com.metamatrix.common.actions.AttributeDefinition;
import com.metamatrix.common.actions.ExchangeObject;
import com.metamatrix.common.actions.NamedObjectActionDefinition;

public class ExchangeNamedObject
extends ExchangeObject
implements NamedObjectActionDefinition {
    public ExchangeNamedObject(Object target, AttributeDefinition attribute, String name, Object previousValue, Object newValue) {
        super(target, attribute != null ? new Integer(attribute.getCode()) : null, new Object[]{name, previousValue, newValue});
        if (name == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.004.0010"));
        }
    }

    public ExchangeNamedObject(Object target, AttributeDefinition attribute, Object[] args) {
        super(target, attribute != null ? new Integer(attribute.getCode()) : null, args);
        if (args.length >= 2 && args[args.length - 2] == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.004.0010"));
        }
    }

    protected ExchangeNamedObject(Object target, Integer attributeCode, Object[] args) {
        super(target, attributeCode, args);
    }

    protected ExchangeNamedObject(ExchangeNamedObject rhs) {
        super(rhs);
    }

    public synchronized String getName() {
        return (String)this.getArguments()[0];
    }

    public synchronized Object getPreviousValue() {
        if (this.getArguments().length > 1) {
            return this.getArguments()[1];
        }
        return "";
    }

    public synchronized Object getNewValue() {
        if (this.getArguments().length > 2) {
            return this.getArguments()[2];
        }
        return "";
    }

    public synchronized void setName(String newName) {
        this.getArguments()[0] = newName;
    }

    public synchronized String getActionDescription() {
        StringBuffer buff = new StringBuffer();
        Object target = this.getTarget();
        String targetClassName = target.getClass().getName();
        String attrDesc = this.getAttributeDescription();
        buff.append("Set ");
        if (attrDesc.length() > 0) {
            buff.append(this.getAttributeDescription() + " \"" + this.getName() + "\" from ");
        }
        buff.append(targetClassName.substring(targetClassName.lastIndexOf(46) + 1) + " " + target.toString());
        return buff.toString();
    }

    public String toString() {
        return this.getActionDescription() + "; new value = " + this.getNewValue() + ", previous value = " + this.getPreviousValue();
    }

    public synchronized Object clone() {
        return new ExchangeNamedObject(this);
    }

    public synchronized ActionDefinition getUndoActionDefinition() {
        return new ExchangeNamedObject(this.getTarget(), this.getAttributeCode(), this.getArguments());
    }
}

