/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.cache;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Date;

public class ObjectCacheStatistics
implements Serializable,
Cloneable {
    private long totalAdds = 0L;
    private long totalPurges = 0L;
    private long totalSuccessfulFinds = 0L;
    private long totalFailedFinds = 0L;
    private long totalFailedFindsByExpiration = 0L;
    private int sizeWatermark = 0;
    private long costWatermark = 0L;
    private int size = 0;
    private long cost = 0L;
    private long lastModified = 0L;
    private static NumberFormat FORMATTER = NumberFormat.getInstance();
    private static FieldPosition POSITION;

    public ObjectCacheStatistics() {
        this.lastModified = System.currentTimeMillis();
    }

    public ObjectCacheStatistics(long adds, long purges, int size, int sizeWatermark, long cost, long costWatermark, long successfulFinds, long failedFinds, long failedFindsByExpiration, long lastModified) {
        this.totalAdds = adds > 0L ? adds : 0L;
        this.totalPurges = purges > 0L ? purges : 0L;
        this.sizeWatermark = sizeWatermark > 0 ? sizeWatermark : 0;
        this.size = size > 0 ? size : 0;
        this.cost = cost > 0L ? cost : 0L;
        this.costWatermark = costWatermark > 0L ? costWatermark : 0L;
        this.totalSuccessfulFinds = successfulFinds > 0L ? successfulFinds : 0L;
        this.totalFailedFinds = failedFinds > 0L ? failedFinds : 0L;
        this.totalFailedFindsByExpiration = failedFindsByExpiration > 0L ? failedFindsByExpiration : 0L;
        this.lastModified = lastModified;
    }

    public synchronized long getTotalAdds() {
        return this.totalAdds;
    }

    public synchronized long getTotalPurges() {
        return this.totalPurges;
    }

    public synchronized long getTotalSuccessfulFinds() {
        return this.totalSuccessfulFinds;
    }

    public synchronized long getTotalFailedFinds() {
        return this.totalFailedFinds;
    }

    public synchronized long getTotalFailedFindsDueToExpiration() {
        return this.totalFailedFindsByExpiration;
    }

    public synchronized int getSizeWatermark() {
        return this.sizeWatermark;
    }

    public synchronized long getCostWatermark() {
        return this.costWatermark;
    }

    public synchronized int getSize() {
        return this.size;
    }

    public synchronized long getCost() {
        return this.cost;
    }

    public synchronized long getLastModified() {
        return this.lastModified;
    }

    public synchronized Date getDateLastModified() {
        return new Date(this.lastModified);
    }

    public synchronized void removeEntries(int count, long cost) {
        this.totalPurges += (long)count;
        this.size -= count;
        this.cost -= cost;
        this.lastModified = System.currentTimeMillis();
    }

    public synchronized void addEntries(int count, long cost) {
        this.totalAdds += (long)count;
        this.size += count;
        this.cost += cost;
        if (this.size > this.sizeWatermark) {
            this.sizeWatermark = this.size;
        }
        this.lastModified = System.currentTimeMillis();
    }

    public synchronized void recordCacheAccess(boolean hit, boolean expired) {
        if (hit) {
            ++this.totalSuccessfulFinds;
        } else {
            ++this.totalFailedFinds;
            if (expired) {
                ++this.totalFailedFindsByExpiration;
            }
        }
    }

    public synchronized Object clone() {
        return new ObjectCacheStatistics(this.totalAdds, this.totalPurges, this.size, this.sizeWatermark, this.cost, this.costWatermark, this.totalSuccessfulFinds, this.totalFailedFinds, this.totalFailedFindsByExpiration, this.lastModified);
    }

    public synchronized String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("   Current size:                                 " + this.size + "\n");
        buffer.append("   Current cost:                                 " + this.cost + "\n");
        buffer.append("   High size watermark:                          " + this.sizeWatermark + "\n");
        buffer.append("   High cost watermark:                          " + this.costWatermark + "\n");
        buffer.append("   Total Successful Finds:                       " + this.totalSuccessfulFinds + "\n");
        buffer.append("   Total Failed Finds:                           " + this.totalFailedFinds + "\n");
        buffer.append("   Percentage of failed finds due to staleness:  ");
        double staleFinds = 0.0;
        if (this.totalFailedFinds > 0L) {
            staleFinds = (float)this.totalFailedFindsByExpiration / (float)this.totalFailedFinds;
        }
        FORMATTER.format(staleFinds * 100.0, buffer, POSITION);
        buffer.append("%\n");
        buffer.append("   Total Additions:                              " + this.totalAdds + "\n");
        buffer.append("   Total Purges:                                 " + this.totalPurges + "\n");
        buffer.append("   Last modified:                                " + new Date(this.lastModified) + "\n");
        return buffer.toString();
    }

    static {
        FORMATTER.setMaximumFractionDigits(2);
        POSITION = new FieldPosition(0);
    }
}

