/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.cache.policy;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.cache.ObjectCacheException;
import com.metamatrix.common.cache.policy.ObjectCachePolicy;
import com.metamatrix.common.cache.policy.ResourceRecaptureStrategy;
import java.util.Properties;

public class SeparateThreadResourceRecaptureStrategy
extends ResourceRecaptureStrategy {
    private RecaptureWorker worker;

    protected void initialize() throws ObjectCacheException {
        Properties env = this.getPolicy().getEnvironment();
        long initialInterval = 0L;
        long maximumInterval = 0L;
        long intervalAdjustmentRate = 0L;
        float intervalIncreaseFactor = 0.0f;
        float intervalDecreaseFactor = 0.0f;
        boolean constant = true;
        String value = env.getProperty("com.metamatrix.common.cache.ObjectCache.ResourceRecaptureIntervalRate");
        if (value != null) {
            try {
                intervalAdjustmentRate = Long.parseLong(value);
            }
            catch (Exception e2) {
                throw new ObjectCacheException(e2, "ERR.003.008.0016", CommonPlugin.Util.getString("ERR.003.008.0016", new Object[]{value, "com.metamatrix.common.cache.ObjectCache.ResourceRecaptureIntervalRate"}));
            }
            value = env.getProperty("com.metamatrix.common.cache.ObjectCache.ResourceRecaptureIntervalCeiling");
            if (value != null) {
                try {
                    maximumInterval = Long.parseLong(value);
                }
                catch (Exception e3) {
                    throw new ObjectCacheException(e3, "ERR.003.008.0016", CommonPlugin.Util.getString("ERR.003.008.0016", new Object[]{value, "com.metamatrix.common.cache.ObjectCache.ResourceRecaptureIntervalCeiling"}));
                }
            }
            if ((value = env.getProperty("com.metamatrix.common.cache.ObjectCache.ResourceRecaptureIntervalIncrement")) != null) {
                try {
                    intervalIncreaseFactor = Float.parseFloat(value);
                }
                catch (Exception e4) {
                    throw new ObjectCacheException(e4, "ERR.003.008.0016", CommonPlugin.Util.getString("ERR.003.008.0016", new Object[]{value, "com.metamatrix.common.cache.ObjectCache.ResourceRecaptureIntervalIncrement"}));
                }
            }
            if ((value = env.getProperty("com.metamatrix.common.cache.ObjectCache.ResourceRecaptureIntervalDecrement")) != null) {
                try {
                    intervalDecreaseFactor = Float.parseFloat(value);
                }
                catch (Exception e5) {
                    throw new ObjectCacheException(e5, "ERR.003.008.0016", CommonPlugin.Util.getString("ERR.003.008.0016", new Object[]{value, "com.metamatrix.common.cache.ObjectCache.ResourceRecaptureIntervalDecrement"}));
                }
            }
            constant = false;
        }
        if ((value = env.getProperty("com.metamatrix.common.cache.ObjectCache.ResourceRecaptureInterval")) != null) {
            try {
                initialInterval = Long.parseLong(value);
            }
            catch (Exception e6) {
                throw new ObjectCacheException(e6, "ERR.003.008.0016", CommonPlugin.Util.getString("ERR.003.008.0016", new Object[]{value, "com.metamatrix.common.cache.ObjectCache.ResourceRecaptureInterval"}));
            }
        }
        this.worker = null;
        this.worker = constant ? new RecaptureWorker(this.getPolicy(), initialInterval) : new RecaptureWorker(this.getPolicy(), initialInterval, maximumInterval, intervalAdjustmentRate, intervalIncreaseFactor, intervalDecreaseFactor);
        new Thread((Runnable)this.worker, "RecaptureWorker").start();
    }

    public void stop() {
        try {
            this.worker.stopRecapture();
        }
        catch (SecurityException e2) {
            e2.printStackTrace();
        }
    }

    public static class RecaptureWorker
    implements Runnable {
        private long initialInterval;
        private long intervalAdjustmentRate;
        private float intervalIncreaseFactor;
        private float intervalDecreaseFactor;
        private ObjectCachePolicy policy;
        private Object lock = new Object();
        private long currentInterval = 0L;
        private long failedRecaptures = 0L;
        private long successfulRecaptures = 0L;
        private long checksSinceLastAdjustment = 0L;
        private long totalIntervalDecreases = 0L;
        private long totalIntervalIncreases = 0L;
        private long totalChecks = 0L;
        private boolean continueChecks = true;

        protected void finalize() {
            this.policy = null;
        }

        public RecaptureWorker(ObjectCachePolicy policy, long initialInterval) {
            this.policy = policy;
            this.currentInterval = this.initialInterval = initialInterval;
            this.intervalAdjustmentRate = 0L;
            this.intervalIncreaseFactor = 0.0f;
            this.intervalDecreaseFactor = 0.0f;
        }

        public RecaptureWorker(ObjectCachePolicy policy, long initialInterval, long maximumInterval, long intervalAdjustmentRate, float intervalIncreaseFactor, float intervalDecreaseFactor) {
            this.policy = policy;
            this.currentInterval = this.initialInterval = initialInterval;
            this.intervalAdjustmentRate = intervalAdjustmentRate;
            this.intervalIncreaseFactor = intervalIncreaseFactor;
            this.intervalDecreaseFactor = intervalDecreaseFactor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopRecapture() {
            Object object = this.lock;
            synchronized (object) {
                this.continueChecks = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                while (this.continueChecks) {
                    Thread.sleep(this.currentInterval);
                    Object object = this.lock;
                    // MONITORENTER : object
                    if (!this.continueChecks) {
                        // MONITOREXIT : object
                        return;
                    }
                    boolean reducedResources = false;
                    ObjectCachePolicy objectCachePolicy = this.policy;
                    // MONITORENTER : objectCachePolicy
                    if (this.policy.exceedsResources()) {
                        reducedResources = true;
                        this.policy.reduceResourceUsage();
                    }
                    // MONITOREXIT : objectCachePolicy
                    if (reducedResources) {
                        ++this.successfulRecaptures;
                    } else {
                        ++this.failedRecaptures;
                    }
                    ++this.totalChecks;
                    ++this.checksSinceLastAdjustment;
                    if (this.intervalAdjustmentRate > 0L && this.checksSinceLastAdjustment >= this.intervalAdjustmentRate) {
                        float newInterval = 0.0f;
                        if (this.successfulRecaptures == 0L) {
                            newInterval = (float)this.currentInterval * this.intervalIncreaseFactor;
                            ++this.totalIntervalIncreases;
                            this.currentInterval = (long)newInterval;
                        } else if (this.failedRecaptures == 0L) {
                            newInterval = (float)this.currentInterval * this.intervalDecreaseFactor;
                            ++this.totalIntervalDecreases;
                            this.currentInterval = (long)newInterval;
                        }
                        this.checksSinceLastAdjustment = 0L;
                    }
                    // MONITOREXIT : object
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

