/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.model;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.actions.AbstractObjectEditor;
import com.metamatrix.common.actions.ActionDefinition;
import com.metamatrix.common.actions.AddObject;
import com.metamatrix.common.actions.BasicModificationActionQueue;
import com.metamatrix.common.actions.CreateObject;
import com.metamatrix.common.actions.DestroyObject;
import com.metamatrix.common.actions.ExchangeBoolean;
import com.metamatrix.common.actions.ExchangeInt;
import com.metamatrix.common.actions.ExchangeLong;
import com.metamatrix.common.actions.ExchangeObject;
import com.metamatrix.common.actions.RemoveObject;
import com.metamatrix.common.config.api.ComponentDefn;
import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ComponentObjectID;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeDefn;
import com.metamatrix.common.config.api.ComponentTypeDefnID;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ConnectorBindingID;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.DeployedComponentID;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.config.api.ProductServiceConfigID;
import com.metamatrix.common.config.api.ProductType;
import com.metamatrix.common.config.api.ProductTypeID;
import com.metamatrix.common.config.api.PropDefnAllowedValue;
import com.metamatrix.common.config.api.PropDefnAllowedValueID;
import com.metamatrix.common.config.api.ResourceDescriptor;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.ServiceComponentDefnID;
import com.metamatrix.common.config.api.SharedResource;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.api.VMComponentDefnID;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.api.exceptions.InvalidComponentException;
import com.metamatrix.common.config.model.BasicComponentDefn;
import com.metamatrix.common.config.model.BasicComponentObject;
import com.metamatrix.common.config.model.BasicComponentType;
import com.metamatrix.common.config.model.BasicComponentTypeDefn;
import com.metamatrix.common.config.model.BasicConfiguration;
import com.metamatrix.common.config.model.BasicConfigurationInfo;
import com.metamatrix.common.config.model.BasicConnectorBinding;
import com.metamatrix.common.config.model.BasicDeployedComponent;
import com.metamatrix.common.config.model.BasicHost;
import com.metamatrix.common.config.model.BasicProductServiceConfig;
import com.metamatrix.common.config.model.BasicProductType;
import com.metamatrix.common.config.model.BasicPropDefnAllowedValue;
import com.metamatrix.common.config.model.BasicResourceDescriptor;
import com.metamatrix.common.config.model.BasicServiceComponentDefn;
import com.metamatrix.common.config.model.BasicSharedResource;
import com.metamatrix.common.config.model.BasicUtil;
import com.metamatrix.common.config.model.BasicVMComponentDefn;
import com.metamatrix.common.config.model.ConfigurationModel;
import com.metamatrix.common.config.model.ConfigurationObjectEditorHelper;
import com.metamatrix.common.log.LogConfiguration;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.log.config.BasicLogConfiguration;
import com.metamatrix.common.log.config.LogConfigurationException;
import com.metamatrix.common.namedobject.BaseID;
import com.metamatrix.common.namedobject.BaseObject;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.core.id.ObjectIDFactory;
import com.metamatrix.core.id.UUIDFactory;
import com.metamatrix.core.util.Assertion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class BasicConfigurationObjectEditor
extends AbstractObjectEditor
implements ConfigurationObjectEditor {
    private static final long serialVersionUID = -51562836234358446L;
    private ObjectIDFactory factory = null;
    static /* synthetic */ Class class$com$metamatrix$common$config$api$Host;
    static /* synthetic */ Class class$com$metamatrix$common$config$model$BasicConfiguration;
    static /* synthetic */ Class class$com$metamatrix$common$config$api$Configuration;
    static /* synthetic */ Class class$com$metamatrix$common$config$api$ComponentType;
    static /* synthetic */ Class class$com$metamatrix$common$config$model$BasicComponentType;
    static /* synthetic */ Class class$com$metamatrix$common$config$api$ComponentTypeDefn;
    static /* synthetic */ Class class$com$metamatrix$common$config$api$ComponentTypeID;
    static /* synthetic */ Class class$com$metamatrix$common$object$PropertyDefinition;
    static /* synthetic */ Class class$com$metamatrix$common$config$api$DeployedComponent;
    static /* synthetic */ Class class$com$metamatrix$common$config$api$HostID;
    static /* synthetic */ Class class$com$metamatrix$common$config$api$VMComponentDefnID;
    static /* synthetic */ Class class$com$metamatrix$common$config$api$ServiceComponentDefn;
    static /* synthetic */ Class class$com$metamatrix$common$config$api$ProductServiceConfigID;
    static /* synthetic */ Class class$com$metamatrix$common$config$api$ConfigurationID;
    static /* synthetic */ Class class$com$metamatrix$common$config$api$ServiceComponentDefnID;
    static /* synthetic */ Class class$com$metamatrix$common$config$api$VMComponentDefn;
    static /* synthetic */ Class class$com$metamatrix$common$config$api$ResourceDescriptor;
    static /* synthetic */ Class class$com$metamatrix$common$config$api$SharedResource;
    static /* synthetic */ Class class$com$metamatrix$common$config$api$ProductServiceConfig;
    static /* synthetic */ Class class$com$metamatrix$common$config$model$BasicProductServiceConfig;
    static /* synthetic */ Class class$com$metamatrix$common$config$model$BasicServiceComponentDefn;
    static /* synthetic */ Class class$com$metamatrix$common$config$api$ComponentObject;
    static /* synthetic */ Class class$com$metamatrix$common$config$model$BasicComponentObject;
    static /* synthetic */ Class class$com$metamatrix$common$config$model$BasicComponentTypeDefn;
    static /* synthetic */ Class class$com$metamatrix$common$config$api$PropDefnAllowedValue;
    static /* synthetic */ Class class$com$metamatrix$common$config$model$BasicVMComponentDefn;
    static /* synthetic */ Class class$com$metamatrix$common$config$model$BasicComponentDefn;
    static /* synthetic */ Class class$com$metamatrix$common$config$model$BasicDeployedComponent;
    static /* synthetic */ Class class$com$metamatrix$common$config$api$ConnectorBinding;

    private ObjectIDFactory getObjectIDFactory() {
        if (this.factory == null) {
            this.factory = new UUIDFactory();
        }
        return this.factory;
    }

    public BasicConfigurationObjectEditor(boolean createActions) {
        super(createActions);
        if (this.doCreateActions()) {
            this.setDestination(new BasicModificationActionQueue());
        }
    }

    public BasicConfigurationObjectEditor() {
        this(false);
    }

    public ComponentObject undoAction(ActionDefinition action, ComponentObject target) {
        if (action == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0088"));
        }
        ComponentDefn result = null;
        if (action instanceof CreateObject) {
            return result;
        }
        if (action instanceof DestroyObject) {
            Object[] args = action.getArguments();
            result = (ComponentDefn)args[0];
        } else {
            result = (ComponentDefn)target;
        }
        return result;
    }

    DeployedComponent undoAction(ActionDefinition action, DeployedComponent target) {
        if (action == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0088"));
        }
        DeployedComponent result = null;
        if (action instanceof CreateObject) {
            return result;
        }
        if (action instanceof DestroyObject) {
            // empty if block
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Configuration undoAction(ActionDefinition action, BaseObject target) {
        if (action == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0088"));
        }
        Configuration result = null;
        if (action instanceof CreateObject) {
            return result;
        }
        if (action instanceof DestroyObject) {
            Object[] args = action.getArguments();
            return (Configuration)args[0];
        }
        result = (Configuration)target;
        if (action instanceof ExchangeObject) {
            ExchangeObject anAction = (ExchangeObject)action;
            if (target instanceof BasicConfiguration) {
                return result;
            }
            if (target instanceof BasicServiceComponentDefn) {
                BasicServiceComponentDefn bc = (BasicServiceComponentDefn)target;
                if (anAction.getAttributeCode().intValue() != ConfigurationModel.Attribute.PROPERTIES.getCode()) return result;
                bc.setProperties((Properties)anAction.getPreviousValue());
                return result;
            }
            if (target instanceof BasicVMComponentDefn) {
                BasicVMComponentDefn dg = (BasicVMComponentDefn)target;
                if (anAction.getAttributeCode().intValue() != ConfigurationModel.Attribute.PROPERTIES.getCode()) return result;
                dg.setProperties((Properties)anAction.getPreviousValue());
                return result;
            }
            if (target instanceof BasicDeployedComponent) {
                return result;
            }
            if (target instanceof BasicHost) {
                return result;
            }
            if (!(target instanceof BasicConfigurationInfo)) return result;
            return result;
        } else {
            if (action instanceof AddObject) {
                return result;
            }
            if (action instanceof RemoveObject) {
                if (target instanceof BasicConfiguration) {
                    return result;
                }
                if (target instanceof BasicServiceComponentDefn) {
                    return result;
                }
                if (target instanceof BasicVMComponentDefn) {
                    return result;
                }
                if (target instanceof BasicDeployedComponent) {
                    return result;
                }
                if (target instanceof BasicHost) {
                    return result;
                }
                if (!(target instanceof BasicConfigurationInfo)) return result;
                return result;
            }
            if (action instanceof ExchangeInt) {
                return result;
            }
            if (action instanceof ExchangeLong) {
                return result;
            }
            if (!(action instanceof ExchangeBoolean)) return result;
            ExchangeBoolean anAction = (ExchangeBoolean)action;
            if (!(target instanceof BasicConfiguration)) return result;
            BasicConfiguration config = (BasicConfiguration)target;
            if (anAction.getAttributeCode().intValue() == ConfigurationModel.Attribute.IS_RELEASED.getCode()) {
                config.setIsRelease(anAction.getPreviousValue());
                return result;
            }
            if (anAction.getAttributeCode().intValue() != ConfigurationModel.Attribute.IS_DEPLOYED.getCode()) return result;
            config.setIsDeployed(anAction.getPreviousValue());
        }
        return result;
    }

    public Host createHost(String hostName) {
        if (hostName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0077"));
        }
        BasicComponentDefn bh = BasicUtil.createComponentDefn(7, Configuration.NEXT_STARTUP_ID, Host.HOST_COMPONENT_TYPE_ID, hostName);
        this.createCreationAction(bh.getID(), bh);
        try {
            Host newHost = (Host)bh.clone();
            return newHost;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0078", new Object[]{(class$com$metamatrix$common$config$api$Host == null ? (class$com$metamatrix$common$config$api$Host = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.Host")) : class$com$metamatrix$common$config$api$Host).getName(), e2.getMessage()}));
        }
    }

    public Host createHost(ConfigurationID configurationID, String hostName) {
        if (hostName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0077"));
        }
        if (configurationID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0079"));
        }
        BasicComponentDefn bh = BasicUtil.createComponentDefn(7, configurationID, Host.HOST_COMPONENT_TYPE_ID, hostName);
        this.createCreationAction(bh.getID(), bh);
        try {
            Host newHost = (Host)bh.clone();
            return newHost;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0078", new Object[]{(class$com$metamatrix$common$config$api$Host == null ? (class$com$metamatrix$common$config$api$Host = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.Host")) : class$com$metamatrix$common$config$api$Host).getName(), e2.getMessage()}));
        }
    }

    public Host createHost(Configuration configuration, String hostName) {
        if (hostName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0077"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0079"));
        }
        BasicComponentDefn bh = BasicUtil.createComponentDefn(7, (ConfigurationID)configuration.getID(), Host.HOST_COMPONENT_TYPE_ID, hostName);
        this.createCreationAction(bh.getID(), bh);
        try {
            Host newHost = (Host)bh.clone();
            BasicConfiguration bc = (BasicConfiguration)this.verifyTargetClass(configuration, class$com$metamatrix$common$config$model$BasicConfiguration == null ? (class$com$metamatrix$common$config$model$BasicConfiguration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicConfiguration")) : class$com$metamatrix$common$config$model$BasicConfiguration);
            bc.addHost(newHost);
            return newHost;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0078", new Object[]{(class$com$metamatrix$common$config$api$Host == null ? (class$com$metamatrix$common$config$api$Host = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.Host")) : class$com$metamatrix$common$config$api$Host).getName(), e2.getMessage()}));
        }
    }

    public Host createHost(Configuration configuration, Host original, String newName) {
        if (newName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0077"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0079"));
        }
        if (original == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0080", newName));
        }
        BasicComponentDefn bh = BasicUtil.createComponentDefn(7, (ConfigurationID)configuration.getID(), Host.HOST_COMPONENT_TYPE_ID, newName);
        this.createCreationAction(bh.getID(), bh);
        this.modifyProperties(bh, original.getProperties(), 1);
        try {
            Host newHost = (Host)bh.clone();
            BasicConfiguration bc = (BasicConfiguration)this.verifyTargetClass(configuration, class$com$metamatrix$common$config$model$BasicConfiguration == null ? (class$com$metamatrix$common$config$model$BasicConfiguration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicConfiguration")) : class$com$metamatrix$common$config$model$BasicConfiguration);
            bc.addHost(newHost);
            return newHost;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0078", new Object[]{(class$com$metamatrix$common$config$api$Host == null ? (class$com$metamatrix$common$config$api$Host = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.Host")) : class$com$metamatrix$common$config$api$Host).getName(), e2.getMessage()}));
        }
    }

    public Configuration createConfiguration(String configurationName) {
        if (configurationName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0081"));
        }
        ConfigurationID id = null;
        id = new ConfigurationID(configurationName);
        BasicConfigurationInfo info = new BasicConfigurationInfo(id);
        BasicConfiguration config = new BasicConfiguration(info, Configuration.CONFIG_COMPONENT_TYPE_ID);
        this.createCreationAction(id, config);
        try {
            Configuration newConfig = (Configuration)config.clone();
            return newConfig;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0078", new Object[]{(class$com$metamatrix$common$config$api$Configuration == null ? (class$com$metamatrix$common$config$api$Configuration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.Configuration")) : class$com$metamatrix$common$config$api$Configuration).getName(), e2.getMessage()}));
        }
    }

    public Configuration createConfiguration(String configurationName, Date creationDate, Date lastChangedDate) {
        if (configurationName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0081"));
        }
        ConfigurationID id = null;
        id = new ConfigurationID(configurationName);
        BasicConfigurationInfo info = new BasicConfigurationInfo(id);
        info.setCreationDate(creationDate);
        info.setLastChangedDate(lastChangedDate);
        BasicConfiguration config = new BasicConfiguration(info, Configuration.CONFIG_COMPONENT_TYPE_ID);
        this.createCreationAction(id, config);
        try {
            Configuration newConfig = (Configuration)config.clone();
            return newConfig;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0078", new Object[]{(class$com$metamatrix$common$config$api$Configuration == null ? (class$com$metamatrix$common$config$api$Configuration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.Configuration")) : class$com$metamatrix$common$config$api$Configuration).getName(), e2.getMessage()}));
        }
    }

    public void createConfiguration(ConfigurationID configID, Collection configObjects) {
        if (configID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0082"));
        }
        if (configObjects == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0083"));
        }
        if (configObjects.isEmpty()) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0083"));
        }
        this.createCreationAction(configID, configObjects);
    }

    public Configuration createConfiguration(Configuration original, String newName) {
        if (original == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0079"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0081"));
        }
        if (original.getName().equals(newName)) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0084", newName));
        }
        BasicConfiguration config = (BasicConfiguration)this.createConfiguration(newName);
        this.modifyProperties(config, original.getProperties(), 1);
        if (original.getHosts() != null) {
            Iterator hIt = original.getHosts().iterator();
            while (hIt.hasNext()) {
                Host h2 = (Host)hIt.next();
                this.createHost(config, h2, h2.getName());
            }
        }
        Iterator pools = original.getResourcePools().iterator();
        while (pools.hasNext()) {
            ResourceDescriptor rd = (ResourceDescriptor)pools.next();
            this.createResourceDescriptor((Configuration)config, rd, rd.getName());
        }
        Iterator svcDefns = original.getServiceComponentDefns().iterator();
        while (svcDefns.hasNext()) {
            ServiceComponentDefn sDefn = (ServiceComponentDefn)svcDefns.next();
            this.createServiceComponentDefn((Configuration)config, sDefn, sDefn.getName());
        }
        Iterator vmsDefns = original.getVMComponentDefns().iterator();
        while (vmsDefns.hasNext()) {
            VMComponentDefn vDefn = (VMComponentDefn)vmsDefns.next();
            this.createVMComponentDefn(config, vDefn, vDefn.getName());
        }
        Iterator bindings = original.getConnectorBindings().iterator();
        while (bindings.hasNext()) {
            ConnectorBinding cc = (ConnectorBinding)bindings.next();
            this.createConnectorComponent(config, cc, cc.getName());
        }
        Iterator pscs = original.getPSCs().iterator();
        while (pscs.hasNext()) {
            ProductServiceConfig psc = (ProductServiceConfig)pscs.next();
            this.createProductServiceConfig((Configuration)config, psc, psc.getName());
        }
        ConfigurationID configID = (ConfigurationID)config.getID();
        VMComponentDefnID vmID = null;
        ProductServiceConfigID pscID = null;
        DeployedComponent originalDeployed = null;
        ServiceComponentDefn service = null;
        Iterator iter = original.getDeployedComponents().iterator();
        while (iter.hasNext()) {
            ServiceComponentDefnID serviceID;
            originalDeployed = (DeployedComponent)iter.next();
            if (originalDeployed.isDeployedConnector()) {
                serviceID = new ConnectorBindingID(configID, originalDeployed.getServiceComponentDefnID().getName());
                pscID = new ProductServiceConfigID(configID, originalDeployed.getProductServiceConfigID().getName());
                vmID = new VMComponentDefnID(configID, originalDeployed.getHostID(), originalDeployed.getVMComponentDefnID().getName());
                service = config.getConnectorBinding(serviceID);
                if (service == null) {
                    throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0086", new Object[]{serviceID, originalDeployed.getName()}));
                }
                this.createDeployedServiceComponent(originalDeployed.getName(), config, originalDeployed.getHostID(), vmID, service, pscID);
                continue;
            }
            if (!originalDeployed.isDeployedService()) continue;
            serviceID = new ServiceComponentDefnID(configID, originalDeployed.getServiceComponentDefnID().getName());
            pscID = new ProductServiceConfigID(configID, originalDeployed.getProductServiceConfigID().getName());
            vmID = new VMComponentDefnID(configID, originalDeployed.getHostID(), originalDeployed.getVMComponentDefnID().getName());
            service = config.getServiceComponentDefn(serviceID);
            if (service == null) {
                throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0085", new Object[]{serviceID, originalDeployed.getName()}));
            }
            this.createDeployedServiceComponent(originalDeployed.getName(), config, originalDeployed.getHostID(), vmID, service, pscID);
        }
        try {
            Configuration newConfig = (Configuration)config.clone();
            return newConfig;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0078", new Object[]{(class$com$metamatrix$common$config$api$Configuration == null ? (class$com$metamatrix$common$config$api$Configuration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.Configuration")) : class$com$metamatrix$common$config$api$Configuration).getName(), e2.getMessage()}));
        }
    }

    public ComponentType createComponentType(int classTypeCode, String name, ComponentTypeID parentID, ComponentTypeID superID, boolean deployable, boolean monitored) {
        if (name == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", (class$com$metamatrix$common$config$api$ComponentType == null ? (class$com$metamatrix$common$config$api$ComponentType = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentType")) : class$com$metamatrix$common$config$api$ComponentType).getName()));
        }
        BasicComponentType type = BasicUtil.createComponentType(classTypeCode, name, parentID, superID, deployable, monitored);
        this.createCreationAction(type.getID(), type);
        try {
            ComponentType newType = (ComponentType)type.clone();
            return newType;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0078", new Object[]{(class$com$metamatrix$common$config$api$ComponentType == null ? (class$com$metamatrix$common$config$api$ComponentType = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentType")) : class$com$metamatrix$common$config$api$ComponentType).getName(), e2.getMessage()}));
        }
    }

    public ComponentType createComponentType(ComponentType componentType, String name) {
        if (componentType == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ComponentType == null ? (class$com$metamatrix$common$config$api$ComponentType = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentType")) : class$com$metamatrix$common$config$api$ComponentType).getName()));
        }
        if (name == null) {
            name = componentType.getFullName();
        }
        BasicComponentType basicType = (BasicComponentType)this.verifyTargetClass(componentType, class$com$metamatrix$common$config$model$BasicComponentType == null ? (class$com$metamatrix$common$config$model$BasicComponentType = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicComponentType")) : class$com$metamatrix$common$config$model$BasicComponentType);
        BasicComponentType newType = BasicUtil.createComponentType(basicType.getComponentTypeCode(), name, basicType.getParentComponentTypeID(), basicType.getSuperComponentTypeID(), basicType.isDeployable(), basicType.isMonitored());
        newType.setComponentTypeDefinitions(basicType.getComponentTypeDefinitions());
        this.createCreationAction(newType.getID(), newType);
        try {
            ComponentType nType = (ComponentType)newType.clone();
            return nType;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0078", new Object[]{(class$com$metamatrix$common$config$api$ComponentType == null ? (class$com$metamatrix$common$config$api$ComponentType = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentType")) : class$com$metamatrix$common$config$api$ComponentType).getName(), e2.getMessage()}));
        }
    }

    public ProductType createProductType(String name, Collection serviceComponentTypes, boolean deployable, boolean monitored) {
        BasicProductType productType = (BasicProductType)this.createProductType(name, deployable, monitored);
        ComponentType serviceComponentType = null;
        Iterator iter = serviceComponentTypes.iterator();
        while (iter.hasNext()) {
            serviceComponentType = (ComponentType)iter.next();
            productType.addServiceTypeID((ComponentTypeID)serviceComponentType.getID());
        }
        return productType;
    }

    public ProductType createProductType(String name, boolean deployable, boolean monitored) {
        BasicProductType productType = (BasicProductType)BasicUtil.createComponentType(3, name, null, ProductType.PRODUCT_SUPER_TYPE_ID, deployable, monitored);
        return productType;
    }

    public BasicComponentDefn createComponentDefn(int defnTypeCode, ConfigurationID configID, ComponentTypeID typeID, String defnName) {
        if (defnName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", (class$com$metamatrix$common$config$api$ComponentType == null ? (class$com$metamatrix$common$config$api$ComponentType = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentType")) : class$com$metamatrix$common$config$api$ComponentType).getName()));
        }
        BasicComponentDefn defn = BasicUtil.createComponentDefn(defnTypeCode, configID, typeID, defnName);
        return defn;
    }

    public ComponentTypeDefn createComponentTypeDefn(ComponentType type, PropertyDefinition propertyDefinition, boolean isEffectiveImmediately) {
        if (type == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ComponentType == null ? (class$com$metamatrix$common$config$api$ComponentType = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentType")) : class$com$metamatrix$common$config$api$ComponentType).getName()));
        }
        if (propertyDefinition == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", (class$com$metamatrix$common$config$api$ComponentTypeDefn == null ? (class$com$metamatrix$common$config$api$ComponentTypeDefn = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentTypeDefn")) : class$com$metamatrix$common$config$api$ComponentTypeDefn).getName()));
        }
        ComponentTypeDefnID defnID = new ComponentTypeDefnID(propertyDefinition.getName());
        BasicComponentTypeDefn defn = new BasicComponentTypeDefn(defnID, (ComponentTypeID)type.getID(), propertyDefinition, false, isEffectiveImmediately);
        this.createCreationAction(defnID, defn);
        try {
            ComponentTypeDefn newDefn = (ComponentTypeDefn)defn.clone();
            BasicComponentType basicType = (BasicComponentType)this.verifyTargetClass(type, class$com$metamatrix$common$config$model$BasicComponentType == null ? (class$com$metamatrix$common$config$model$BasicComponentType = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicComponentType")) : class$com$metamatrix$common$config$model$BasicComponentType);
            basicType.addComponentTypeDefinition(newDefn);
            return newDefn;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0078", new Object[]{(class$com$metamatrix$common$config$api$ComponentTypeDefn == null ? (class$com$metamatrix$common$config$api$ComponentTypeDefn = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentTypeDefn")) : class$com$metamatrix$common$config$api$ComponentTypeDefn).getName(), e2.getMessage()}));
        }
    }

    public ComponentTypeDefn createComponentTypeDefn(ComponentType type, PropertyDefinition propertyDefinition) {
        return this.createComponentTypeDefn(type, propertyDefinition, false);
    }

    public ComponentTypeDefn createComponentTypeDefn(ComponentTypeID typeID, PropertyDefinition propertyDefinition, boolean isEffectiveImmediately) {
        if (typeID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ComponentTypeID == null ? (class$com$metamatrix$common$config$api$ComponentTypeID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentTypeID")) : class$com$metamatrix$common$config$api$ComponentTypeID).getName()));
        }
        if (propertyDefinition == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$object$PropertyDefinition == null ? (class$com$metamatrix$common$object$PropertyDefinition = BasicConfigurationObjectEditor.class$("com.metamatrix.common.object.PropertyDefinition")) : class$com$metamatrix$common$object$PropertyDefinition).getName()));
        }
        ComponentTypeDefnID defnID = new ComponentTypeDefnID(propertyDefinition.getName());
        BasicComponentTypeDefn defn = new BasicComponentTypeDefn(defnID, typeID, propertyDefinition, false, isEffectiveImmediately);
        this.createCreationAction(defnID, defn);
        try {
            ComponentTypeDefn newDefn = (ComponentTypeDefn)defn.clone();
            return newDefn;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0078", new Object[]{(class$com$metamatrix$common$config$api$ComponentTypeDefn == null ? (class$com$metamatrix$common$config$api$ComponentTypeDefn = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentTypeDefn")) : class$com$metamatrix$common$config$api$ComponentTypeDefn).getName(), e2.getMessage()}));
        }
    }

    public ComponentTypeDefn createComponentTypeDefn(ComponentTypeID typeID, PropertyDefinition propertyDefinition) {
        return this.createComponentTypeDefn(typeID, propertyDefinition, false);
    }

    public PropDefnAllowedValue createPropDefnAllowedValue(ComponentTypeDefn typeDefn, PropertyDefinition propDefn, String value) throws InvalidComponentException {
        int maxCode = Integer.MIN_VALUE;
        Iterator it = typeDefn.getAllowedValues().iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            BasicPropDefnAllowedValue defnValue = (BasicPropDefnAllowedValue)obj;
            int allowedCode = defnValue.getAllowedCode();
            if (allowedCode <= maxCode) continue;
            maxCode = allowedCode;
        }
        maxCode = maxCode == Integer.MIN_VALUE ? 1 : ++maxCode;
        StringBuffer sb = new StringBuffer(typeDefn.getFullName());
        sb.append(".");
        sb.append(new Integer(maxCode).toString());
        PropDefnAllowedValueID id = new PropDefnAllowedValueID(sb.toString());
        BasicPropDefnAllowedValue bv = new BasicPropDefnAllowedValue((ComponentTypeDefnID)typeDefn.getID(), typeDefn.getComponentTypeID(), id, value);
        this.createCreationAction(id, bv);
        propDefn.getAllowedValues().add(bv);
        return bv;
    }

    public DeployedComponent createDeployedServiceComponent(String name, Configuration configuration, HostID hostId, VMComponentDefnID vmId, ServiceComponentDefn serviceComponentDefn, ProductServiceConfigID pscID) {
        if (name == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", (class$com$metamatrix$common$config$api$DeployedComponent == null ? (class$com$metamatrix$common$config$api$DeployedComponent = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.DeployedComponent")) : class$com$metamatrix$common$config$api$DeployedComponent).getName()));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$Configuration == null ? (class$com$metamatrix$common$config$api$Configuration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.Configuration")) : class$com$metamatrix$common$config$api$Configuration).getName()));
        }
        if (hostId == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$HostID == null ? (class$com$metamatrix$common$config$api$HostID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.HostID")) : class$com$metamatrix$common$config$api$HostID).getName()));
        }
        if (vmId == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$VMComponentDefnID == null ? (class$com$metamatrix$common$config$api$VMComponentDefnID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.VMComponentDefnID")) : class$com$metamatrix$common$config$api$VMComponentDefnID).getName()));
        }
        if (serviceComponentDefn == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ServiceComponentDefn == null ? (class$com$metamatrix$common$config$api$ServiceComponentDefn = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ServiceComponentDefn")) : class$com$metamatrix$common$config$api$ServiceComponentDefn).getName()));
        }
        if (pscID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ProductServiceConfigID == null ? (class$com$metamatrix$common$config$api$ProductServiceConfigID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ProductServiceConfigID")) : class$com$metamatrix$common$config$api$ProductServiceConfigID).getName()));
        }
        ConfigurationID configID = (ConfigurationID)configuration.getID();
        BasicDeployedComponent deployComponent = BasicUtil.createDeployedComponent(name, configID, hostId, vmId, (ServiceComponentDefnID)serviceComponentDefn.getID(), pscID, serviceComponentDefn.getComponentTypeID());
        this.createCreationAction(deployComponent.getID(), deployComponent);
        try {
            DeployedComponent newDefn = (DeployedComponent)deployComponent.clone();
            BasicConfiguration bc = (BasicConfiguration)this.verifyTargetClass(configuration, class$com$metamatrix$common$config$model$BasicConfiguration == null ? (class$com$metamatrix$common$config$model$BasicConfiguration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicConfiguration")) : class$com$metamatrix$common$config$model$BasicConfiguration);
            bc.addDeployedComponent(newDefn);
            return newDefn;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0078", new Object[]{(class$com$metamatrix$common$config$api$DeployedComponent == null ? (class$com$metamatrix$common$config$api$DeployedComponent = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.DeployedComponent")) : class$com$metamatrix$common$config$api$DeployedComponent).getName(), e2.getMessage()}));
        }
    }

    public DeployedComponent createDeployedServiceComponent(String name, ConfigurationID configurationID, HostID hostId, VMComponentDefnID vmId, ServiceComponentDefnID serviceComponentDefnID, ProductServiceConfigID pscID, ComponentTypeID serviceComponentTypeID) {
        if (name == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", (class$com$metamatrix$common$config$api$DeployedComponent == null ? (class$com$metamatrix$common$config$api$DeployedComponent = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.DeployedComponent")) : class$com$metamatrix$common$config$api$DeployedComponent).getName()));
        }
        if (configurationID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ConfigurationID == null ? (class$com$metamatrix$common$config$api$ConfigurationID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ConfigurationID")) : class$com$metamatrix$common$config$api$ConfigurationID).getName()));
        }
        if (hostId == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$HostID == null ? (class$com$metamatrix$common$config$api$HostID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.HostID")) : class$com$metamatrix$common$config$api$HostID).getName()));
        }
        if (vmId == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$VMComponentDefnID == null ? (class$com$metamatrix$common$config$api$VMComponentDefnID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.VMComponentDefnID")) : class$com$metamatrix$common$config$api$VMComponentDefnID).getName()));
        }
        if (serviceComponentDefnID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ServiceComponentDefnID == null ? (class$com$metamatrix$common$config$api$ServiceComponentDefnID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ServiceComponentDefnID")) : class$com$metamatrix$common$config$api$ServiceComponentDefnID).getName()));
        }
        if (serviceComponentTypeID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ComponentTypeID == null ? (class$com$metamatrix$common$config$api$ComponentTypeID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentTypeID")) : class$com$metamatrix$common$config$api$ComponentTypeID).getName()));
        }
        if (pscID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ProductServiceConfigID == null ? (class$com$metamatrix$common$config$api$ProductServiceConfigID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ProductServiceConfigID")) : class$com$metamatrix$common$config$api$ProductServiceConfigID).getName()));
        }
        BasicDeployedComponent deployComponent = BasicUtil.createDeployedComponent(name, configurationID, hostId, vmId, serviceComponentDefnID, pscID, serviceComponentTypeID);
        this.createCreationAction(deployComponent.getID(), deployComponent);
        try {
            DeployedComponent newDefn = (DeployedComponent)deployComponent.clone();
            return newDefn;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0078", new Object[]{(class$com$metamatrix$common$config$api$DeployedComponent == null ? (class$com$metamatrix$common$config$api$DeployedComponent = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.DeployedComponent")) : class$com$metamatrix$common$config$api$DeployedComponent).getName(), e2.getMessage()}));
        }
    }

    public DeployedComponent createDeployedVMComponentx(String name, Configuration configuration, VMComponentDefn vmComponentDefn) {
        if (name == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", (class$com$metamatrix$common$config$api$DeployedComponent == null ? (class$com$metamatrix$common$config$api$DeployedComponent = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.DeployedComponent")) : class$com$metamatrix$common$config$api$DeployedComponent).getName()));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$Configuration == null ? (class$com$metamatrix$common$config$api$Configuration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.Configuration")) : class$com$metamatrix$common$config$api$Configuration).getName()));
        }
        if (vmComponentDefn == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$VMComponentDefn == null ? (class$com$metamatrix$common$config$api$VMComponentDefn = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.VMComponentDefn")) : class$com$metamatrix$common$config$api$VMComponentDefn).getName()));
        }
        ConfigurationID configID = (ConfigurationID)configuration.getID();
        BasicDeployedComponent deployComponent = BasicUtil.createDeployedVMComponent(name, configID, vmComponentDefn.getHostID(), (VMComponentDefnID)vmComponentDefn.getID(), vmComponentDefn.getComponentTypeID());
        this.createCreationAction(deployComponent.getID(), deployComponent);
        try {
            DeployedComponent newDefn = (DeployedComponent)deployComponent.clone();
            BasicConfiguration bc = (BasicConfiguration)this.verifyTargetClass(configuration, class$com$metamatrix$common$config$model$BasicConfiguration == null ? (class$com$metamatrix$common$config$model$BasicConfiguration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicConfiguration")) : class$com$metamatrix$common$config$model$BasicConfiguration);
            bc.addDeployedComponent(newDefn);
            return newDefn;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0078", new Object[]{(class$com$metamatrix$common$config$api$DeployedComponent == null ? (class$com$metamatrix$common$config$api$DeployedComponent = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.DeployedComponent")) : class$com$metamatrix$common$config$api$DeployedComponent).getName(), e2.getMessage()}));
        }
    }

    public DeployedComponent createDeployedVMComponentx(String instanceName, ConfigurationID configurationID, HostID hostId, VMComponentDefnID vmComponentDefnID, ComponentTypeID componentTypeID) {
        if (instanceName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", (class$com$metamatrix$common$config$api$DeployedComponent == null ? (class$com$metamatrix$common$config$api$DeployedComponent = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.DeployedComponent")) : class$com$metamatrix$common$config$api$DeployedComponent).getName()));
        }
        if (configurationID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ConfigurationID == null ? (class$com$metamatrix$common$config$api$ConfigurationID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ConfigurationID")) : class$com$metamatrix$common$config$api$ConfigurationID).getName()));
        }
        if (hostId == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$HostID == null ? (class$com$metamatrix$common$config$api$HostID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.HostID")) : class$com$metamatrix$common$config$api$HostID).getName()));
        }
        if (vmComponentDefnID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$VMComponentDefnID == null ? (class$com$metamatrix$common$config$api$VMComponentDefnID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.VMComponentDefnID")) : class$com$metamatrix$common$config$api$VMComponentDefnID).getName()));
        }
        if (componentTypeID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ComponentTypeID == null ? (class$com$metamatrix$common$config$api$ComponentTypeID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentTypeID")) : class$com$metamatrix$common$config$api$ComponentTypeID).getName()));
        }
        BasicDeployedComponent deployComponent = BasicUtil.createDeployedVMComponent(instanceName, configurationID, hostId, vmComponentDefnID, componentTypeID);
        this.createCreationAction(deployComponent.getID(), deployComponent);
        try {
            DeployedComponent newDefn = (DeployedComponent)deployComponent.clone();
            return newDefn;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0078", new Object[]{(class$com$metamatrix$common$config$api$DeployedComponent == null ? (class$com$metamatrix$common$config$api$DeployedComponent = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.DeployedComponent")) : class$com$metamatrix$common$config$api$DeployedComponent).getName(), e2.getMessage()}));
        }
    }

    public ServiceComponentDefn createServiceComponentDefn(ConfigurationID configurationID, ComponentTypeID typeID, String componentName) {
        if (configurationID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ConfigurationID == null ? (class$com$metamatrix$common$config$api$ConfigurationID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ConfigurationID")) : class$com$metamatrix$common$config$api$ConfigurationID).getName()));
        }
        if (typeID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ComponentTypeID == null ? (class$com$metamatrix$common$config$api$ComponentTypeID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentTypeID")) : class$com$metamatrix$common$config$api$ComponentTypeID).getName()));
        }
        if (componentName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", (class$com$metamatrix$common$config$api$ServiceComponentDefn == null ? (class$com$metamatrix$common$config$api$ServiceComponentDefn = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ServiceComponentDefn")) : class$com$metamatrix$common$config$api$ServiceComponentDefn).getName()));
        }
        String routingUUID = typeID.getName().equals("RuntimeMetadataService") ? "RuntimeMetadataService" : ((Object)this.getObjectIDFactory().create()).toString();
        return this.createServiceComponentDefn(configurationID, typeID, componentName, routingUUID);
    }

    public ServiceComponentDefn createServiceComponentDefn(ConfigurationID configurationID, ComponentTypeID typeID, String componentName, String routingUUID) {
        if (configurationID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ConfigurationID == null ? (class$com$metamatrix$common$config$api$ConfigurationID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ConfigurationID")) : class$com$metamatrix$common$config$api$ConfigurationID).getName()));
        }
        if (typeID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ComponentTypeID == null ? (class$com$metamatrix$common$config$api$ComponentTypeID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentTypeID")) : class$com$metamatrix$common$config$api$ComponentTypeID).getName()));
        }
        if (componentName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", (class$com$metamatrix$common$config$api$ServiceComponentDefn == null ? (class$com$metamatrix$common$config$api$ServiceComponentDefn = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ServiceComponentDefn")) : class$com$metamatrix$common$config$api$ServiceComponentDefn).getName()));
        }
        if (routingUUID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0090", componentName));
        }
        BasicServiceComponentDefn defn = (BasicServiceComponentDefn)BasicUtil.createComponentDefn(1, configurationID, typeID, componentName);
        defn.setRoutingUUID(routingUUID);
        this.createCreationAction(defn.getID(), defn);
        try {
            ServiceComponentDefn newDefn = (ServiceComponentDefn)defn.clone();
            return newDefn;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0078", new Object[]{(class$com$metamatrix$common$config$api$ServiceComponentDefn == null ? (class$com$metamatrix$common$config$api$ServiceComponentDefn = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ServiceComponentDefn")) : class$com$metamatrix$common$config$api$ServiceComponentDefn).getName(), e2.getMessage()}));
        }
    }

    public ServiceComponentDefn createServiceComponentDefn(Configuration configuration, ComponentTypeID typeID, String componentName, ProductServiceConfigID pscID) {
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$Configuration == null ? (class$com$metamatrix$common$config$api$Configuration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.Configuration")) : class$com$metamatrix$common$config$api$Configuration).getName()));
        }
        if (pscID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ProductServiceConfigID == null ? (class$com$metamatrix$common$config$api$ProductServiceConfigID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ProductServiceConfigID")) : class$com$metamatrix$common$config$api$ProductServiceConfigID).getName()));
        }
        ProductServiceConfig psc = (ProductServiceConfig)configuration.getComponentDefn(pscID);
        Assertion.isNotNull(psc, "PSC " + pscID + " does not exist");
        ConfigurationID configurationID = (ConfigurationID)configuration.getID();
        BasicServiceComponentDefn newServiceDefn = (BasicServiceComponentDefn)BasicUtil.createComponentDefn(1, configurationID, typeID, componentName);
        this.addServiceComponentDefn(psc, (ServiceComponentDefnID)newServiceDefn.getID());
        try {
            ServiceComponentDefn newDefn = (ServiceComponentDefn)newServiceDefn.clone();
            BasicConfiguration bc = (BasicConfiguration)this.verifyTargetClass(configuration, class$com$metamatrix$common$config$model$BasicConfiguration == null ? (class$com$metamatrix$common$config$model$BasicConfiguration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicConfiguration")) : class$com$metamatrix$common$config$model$BasicConfiguration);
            bc.addComponentDefn(newDefn);
            this.deployServiceDefn(bc, newDefn, pscID);
            return newDefn;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0078", new Object[]{(class$com$metamatrix$common$config$api$ServiceComponentDefn == null ? (class$com$metamatrix$common$config$api$ServiceComponentDefn = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ServiceComponentDefn")) : class$com$metamatrix$common$config$api$ServiceComponentDefn).getName(), e2.getMessage()}));
        }
    }

    public ServiceComponentDefn createServiceComponentDefn(Configuration configuration, ComponentTypeID typeID, String componentName) {
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$Configuration == null ? (class$com$metamatrix$common$config$api$Configuration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.Configuration")) : class$com$metamatrix$common$config$api$Configuration).getName()));
        }
        if (typeID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ComponentTypeID == null ? (class$com$metamatrix$common$config$api$ComponentTypeID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentTypeID")) : class$com$metamatrix$common$config$api$ComponentTypeID).getName()));
        }
        if (componentName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", (class$com$metamatrix$common$config$api$ServiceComponentDefn == null ? (class$com$metamatrix$common$config$api$ServiceComponentDefn = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ServiceComponentDefn")) : class$com$metamatrix$common$config$api$ServiceComponentDefn).getName()));
        }
        String routingUUID = componentName.equals("RuntimeMetadataService") ? "RuntimeMetadataService" : ((Object)this.getObjectIDFactory().create()).toString();
        return this.createServiceComponentDefn(configuration, typeID, componentName, routingUUID);
    }

    public ServiceComponentDefn createServiceComponentDefn(Configuration configuration, ComponentTypeID typeID, String componentName, String routingUUID) {
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0079"));
        }
        if (typeID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ComponentTypeID == null ? (class$com$metamatrix$common$config$api$ComponentTypeID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentTypeID")) : class$com$metamatrix$common$config$api$ComponentTypeID).getName()));
        }
        if (componentName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", (class$com$metamatrix$common$config$api$ServiceComponentDefn == null ? (class$com$metamatrix$common$config$api$ServiceComponentDefn = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ServiceComponentDefn")) : class$com$metamatrix$common$config$api$ServiceComponentDefn).getName()));
        }
        if (routingUUID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0090", componentName));
        }
        ConfigurationID configurationID = (ConfigurationID)configuration.getID();
        BasicServiceComponentDefn serviceDefn = (BasicServiceComponentDefn)BasicUtil.createComponentDefn(1, configurationID, typeID, componentName);
        serviceDefn.setRoutingUUID(routingUUID);
        this.createCreationAction(serviceDefn.getID(), serviceDefn);
        try {
            ServiceComponentDefn newDefn = (ServiceComponentDefn)serviceDefn.clone();
            BasicConfiguration bc = (BasicConfiguration)this.verifyTargetClass(configuration, class$com$metamatrix$common$config$model$BasicConfiguration == null ? (class$com$metamatrix$common$config$model$BasicConfiguration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicConfiguration")) : class$com$metamatrix$common$config$model$BasicConfiguration);
            bc.addComponentDefn(newDefn);
            return newDefn;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0078", new Object[]{(class$com$metamatrix$common$config$api$ServiceComponentDefn == null ? (class$com$metamatrix$common$config$api$ServiceComponentDefn = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ServiceComponentDefn")) : class$com$metamatrix$common$config$api$ServiceComponentDefn).getName(), e2.getMessage()}));
        }
    }

    public ServiceComponentDefn createServiceComponentDefn(Configuration configuration, ServiceComponentDefn originalServiceComponentDefn, String newName) {
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$Configuration == null ? (class$com$metamatrix$common$config$api$Configuration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.Configuration")) : class$com$metamatrix$common$config$api$Configuration).getName()));
        }
        if (originalServiceComponentDefn == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ServiceComponentDefn == null ? (class$com$metamatrix$common$config$api$ServiceComponentDefn = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ServiceComponentDefn")) : class$com$metamatrix$common$config$api$ServiceComponentDefn).getName()));
        }
        if (newName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", (class$com$metamatrix$common$config$api$ServiceComponentDefn == null ? (class$com$metamatrix$common$config$api$ServiceComponentDefn = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ServiceComponentDefn")) : class$com$metamatrix$common$config$api$ServiceComponentDefn).getName()));
        }
        ConfigurationID configurationID = (ConfigurationID)configuration.getID();
        BasicServiceComponentDefn serviceDefn = (BasicServiceComponentDefn)BasicUtil.createComponentDefn(1, configurationID, originalServiceComponentDefn.getComponentTypeID(), newName);
        serviceDefn.setIsQueuedService(originalServiceComponentDefn.isQueuedService());
        if (serviceDefn.getComponentTypeID().getName().equals("RuntimeMetadataService")) {
            serviceDefn.setRoutingUUID("RuntimeMetadataService");
        } else {
            serviceDefn.setRoutingUUID(originalServiceComponentDefn.getRoutingUUID());
        }
        this.createCreationAction(serviceDefn.getID(), serviceDefn);
        this.modifyProperties(serviceDefn, originalServiceComponentDefn.getProperties(), 1);
        try {
            ServiceComponentDefn newServiceDefn = (ServiceComponentDefn)serviceDefn.clone();
            BasicConfiguration bc = (BasicConfiguration)this.verifyTargetClass(configuration, class$com$metamatrix$common$config$model$BasicConfiguration == null ? (class$com$metamatrix$common$config$model$BasicConfiguration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicConfiguration")) : class$com$metamatrix$common$config$model$BasicConfiguration);
            bc.addComponentDefn(newServiceDefn);
            return newServiceDefn;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0078", new Object[]{(class$com$metamatrix$common$config$api$ServiceComponentDefn == null ? (class$com$metamatrix$common$config$api$ServiceComponentDefn = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ServiceComponentDefn")) : class$com$metamatrix$common$config$api$ServiceComponentDefn).getName(), e2.getMessage()}));
        }
    }

    public ResourceDescriptor createResourceDescriptor(ConfigurationID configurationID, ComponentTypeID typeID, String descriptorName) {
        if (configurationID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ConfigurationID == null ? (class$com$metamatrix$common$config$api$ConfigurationID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ConfigurationID")) : class$com$metamatrix$common$config$api$ConfigurationID).getName()));
        }
        if (typeID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ComponentTypeID == null ? (class$com$metamatrix$common$config$api$ComponentTypeID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentTypeID")) : class$com$metamatrix$common$config$api$ComponentTypeID).getName()));
        }
        if (descriptorName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", (class$com$metamatrix$common$config$api$ResourceDescriptor == null ? (class$com$metamatrix$common$config$api$ResourceDescriptor = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ResourceDescriptor")) : class$com$metamatrix$common$config$api$ResourceDescriptor).getName()));
        }
        BasicResourceDescriptor defn = (BasicResourceDescriptor)BasicUtil.createComponentDefn(9, configurationID, typeID, descriptorName);
        this.createCreationAction(defn.getID(), defn);
        try {
            ResourceDescriptor newDefn = (ResourceDescriptor)defn.clone();
            return newDefn;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0078", new Object[]{(class$com$metamatrix$common$config$api$ResourceDescriptor == null ? (class$com$metamatrix$common$config$api$ResourceDescriptor = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ResourceDescriptor")) : class$com$metamatrix$common$config$api$ResourceDescriptor).getName(), e2.getMessage()}));
        }
    }

    public ResourceDescriptor createResourceDescriptor(Configuration configuration, ComponentTypeID typeID, String descriptorName) {
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0079"));
        }
        if (typeID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ComponentTypeID == null ? (class$com$metamatrix$common$config$api$ComponentTypeID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentTypeID")) : class$com$metamatrix$common$config$api$ComponentTypeID).getName()));
        }
        if (descriptorName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", (class$com$metamatrix$common$config$api$ResourceDescriptor == null ? (class$com$metamatrix$common$config$api$ResourceDescriptor = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ResourceDescriptor")) : class$com$metamatrix$common$config$api$ResourceDescriptor).getName()));
        }
        ConfigurationID configID = (ConfigurationID)configuration.getID();
        BasicResourceDescriptor defn = (BasicResourceDescriptor)BasicUtil.createComponentDefn(9, configID, typeID, descriptorName);
        this.createCreationAction(defn.getID(), defn);
        try {
            ResourceDescriptor newDefn = (ResourceDescriptor)defn.clone();
            BasicConfiguration bc = (BasicConfiguration)this.verifyTargetClass(configuration, class$com$metamatrix$common$config$model$BasicConfiguration == null ? (class$com$metamatrix$common$config$model$BasicConfiguration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicConfiguration")) : class$com$metamatrix$common$config$model$BasicConfiguration);
            bc.addComponentDefn(newDefn);
            return newDefn;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0078", new Object[]{(class$com$metamatrix$common$config$api$ResourceDescriptor == null ? (class$com$metamatrix$common$config$api$ResourceDescriptor = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ResourceDescriptor")) : class$com$metamatrix$common$config$api$ResourceDescriptor).getName(), e2.getMessage()}));
        }
    }

    public ResourceDescriptor createResourceDescriptor(Configuration configuration, ResourceDescriptor original, String newName) {
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$Configuration == null ? (class$com$metamatrix$common$config$api$Configuration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.Configuration")) : class$com$metamatrix$common$config$api$Configuration).getName()));
        }
        if (original == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ResourceDescriptor == null ? (class$com$metamatrix$common$config$api$ResourceDescriptor = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ResourceDescriptor")) : class$com$metamatrix$common$config$api$ResourceDescriptor).getName()));
        }
        if (newName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", (class$com$metamatrix$common$config$api$ResourceDescriptor == null ? (class$com$metamatrix$common$config$api$ResourceDescriptor = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ResourceDescriptor")) : class$com$metamatrix$common$config$api$ResourceDescriptor).getName()));
        }
        ConfigurationID configurationID = (ConfigurationID)configuration.getID();
        BasicResourceDescriptor defn = (BasicResourceDescriptor)BasicUtil.createComponentDefn(9, configurationID, original.getComponentTypeID(), newName);
        this.createCreationAction(defn.getID(), defn);
        this.modifyProperties(defn, original.getProperties(), 1);
        try {
            ResourceDescriptor newDefn = (ResourceDescriptor)defn.clone();
            BasicConfiguration bc = (BasicConfiguration)this.verifyTargetClass(configuration, class$com$metamatrix$common$config$model$BasicConfiguration == null ? (class$com$metamatrix$common$config$model$BasicConfiguration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicConfiguration")) : class$com$metamatrix$common$config$model$BasicConfiguration);
            bc.addComponentDefn(newDefn);
            return newDefn;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0078", new Object[]{(class$com$metamatrix$common$config$api$ResourceDescriptor == null ? (class$com$metamatrix$common$config$api$ResourceDescriptor = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ResourceDescriptor")) : class$com$metamatrix$common$config$api$ResourceDescriptor).getName(), e2.getMessage()}));
        }
    }

    public SharedResource createSharedResource(ComponentTypeID typeID, String resourceName) {
        if (typeID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ComponentTypeID == null ? (class$com$metamatrix$common$config$api$ComponentTypeID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentTypeID")) : class$com$metamatrix$common$config$api$ComponentTypeID).getName()));
        }
        if (resourceName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", (class$com$metamatrix$common$config$api$SharedResource == null ? (class$com$metamatrix$common$config$api$SharedResource = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.SharedResource")) : class$com$metamatrix$common$config$api$SharedResource).getName()));
        }
        BasicSharedResource defn = (BasicSharedResource)BasicUtil.createComponentObject(10, typeID, resourceName);
        this.createCreationAction(defn.getID(), defn);
        try {
            SharedResource newDefn = (SharedResource)defn.clone();
            return newDefn;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0078", new Object[]{(class$com$metamatrix$common$config$api$SharedResource == null ? (class$com$metamatrix$common$config$api$SharedResource = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.SharedResource")) : class$com$metamatrix$common$config$api$SharedResource).getName(), e2.getMessage()}));
        }
    }

    public VMComponentDefn createVMComponentDefn(ConfigurationID configurationID, HostID hostID, ComponentTypeID typeID, String componentName) {
        if (configurationID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ConfigurationID == null ? (class$com$metamatrix$common$config$api$ConfigurationID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ConfigurationID")) : class$com$metamatrix$common$config$api$ConfigurationID).getName()));
        }
        if (typeID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ComponentTypeID == null ? (class$com$metamatrix$common$config$api$ComponentTypeID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentTypeID")) : class$com$metamatrix$common$config$api$ComponentTypeID).getName()));
        }
        if (componentName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", (class$com$metamatrix$common$config$api$VMComponentDefn == null ? (class$com$metamatrix$common$config$api$VMComponentDefn = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.VMComponentDefn")) : class$com$metamatrix$common$config$api$VMComponentDefn).getName()));
        }
        BasicVMComponentDefn defn = (BasicVMComponentDefn)BasicUtil.createComponentDefn(5, configurationID, hostID, typeID, componentName);
        this.createCreationAction(defn.getID(), defn);
        try {
            VMComponentDefn newDefn = (VMComponentDefn)defn.clone();
            return newDefn;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0078", new Object[]{(class$com$metamatrix$common$config$api$VMComponentDefn == null ? (class$com$metamatrix$common$config$api$VMComponentDefn = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.VMComponentDefn")) : class$com$metamatrix$common$config$api$VMComponentDefn).getName(), e2.getMessage()}));
        }
    }

    public VMComponentDefn createVMComponentDefn(Configuration configuration, HostID hostID, ComponentTypeID typeID, String componentName) {
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$Configuration == null ? (class$com$metamatrix$common$config$api$Configuration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.Configuration")) : class$com$metamatrix$common$config$api$Configuration).getName()));
        }
        VMComponentDefn newDefn = this.createVMComponentDefn((ConfigurationID)configuration.getID(), hostID, typeID, componentName);
        BasicConfiguration bc = (BasicConfiguration)this.verifyTargetClass(configuration, class$com$metamatrix$common$config$model$BasicConfiguration == null ? (class$com$metamatrix$common$config$model$BasicConfiguration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicConfiguration")) : class$com$metamatrix$common$config$model$BasicConfiguration);
        bc.addComponentDefn(newDefn);
        return newDefn;
    }

    public VMComponentDefn createVMComponentDefn(Configuration configuration, VMComponentDefn original, String newName) {
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$Configuration == null ? (class$com$metamatrix$common$config$api$Configuration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.Configuration")) : class$com$metamatrix$common$config$api$Configuration).getName()));
        }
        if (original == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$VMComponentDefn == null ? (class$com$metamatrix$common$config$api$VMComponentDefn = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.VMComponentDefn")) : class$com$metamatrix$common$config$api$VMComponentDefn).getName()));
        }
        BasicVMComponentDefn defn = (BasicVMComponentDefn)this.createVMComponentDefn((ConfigurationID)configuration.getID(), original.getHostID(), original.getComponentTypeID(), newName);
        Properties props = original.getProperties();
        props.putAll((Map<?, ?>)defn.getEditableProperties());
        this.modifyProperties(defn, props, 1);
        this.createDeployedVMComponentx(defn.getName(), configuration, defn);
        try {
            VMComponentDefn newDefn = (VMComponentDefn)defn.clone();
            BasicConfiguration bc = (BasicConfiguration)this.verifyTargetClass(configuration, class$com$metamatrix$common$config$model$BasicConfiguration == null ? (class$com$metamatrix$common$config$model$BasicConfiguration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicConfiguration")) : class$com$metamatrix$common$config$model$BasicConfiguration);
            bc.addComponentDefn(newDefn);
            return newDefn;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0078", new Object[]{(class$com$metamatrix$common$config$api$VMComponentDefn == null ? (class$com$metamatrix$common$config$api$VMComponentDefn = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.VMComponentDefn")) : class$com$metamatrix$common$config$api$VMComponentDefn).getName(), e2.getMessage()}));
        }
    }

    public ProductServiceConfig createProductServiceConfig(Configuration configuration, ProductServiceConfig originalPSC, String newName) {
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$Configuration == null ? (class$com$metamatrix$common$config$api$Configuration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.Configuration")) : class$com$metamatrix$common$config$api$Configuration).getName()));
        }
        if (originalPSC == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ProductServiceConfig == null ? (class$com$metamatrix$common$config$api$ProductServiceConfig = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ProductServiceConfig")) : class$com$metamatrix$common$config$api$ProductServiceConfig).getName()));
        }
        if (newName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", (class$com$metamatrix$common$config$api$ProductServiceConfig == null ? (class$com$metamatrix$common$config$api$ProductServiceConfig = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ProductServiceConfig")) : class$com$metamatrix$common$config$api$ProductServiceConfig).getName()));
        }
        ProductServiceConfig psc = this.createProductServiceConfig(configuration, (ProductTypeID)originalPSC.getComponentTypeID(), newName);
        this.modifyProperties(psc, originalPSC.getProperties(), 1);
        Iterator iter = originalPSC.getServiceComponentDefnIDs().iterator();
        ServiceComponentDefnID originalServiceDefnID = null;
        while (iter.hasNext()) {
            originalServiceDefnID = (ServiceComponentDefnID)iter.next();
            this.addServiceComponentDefn(psc, originalServiceDefnID);
        }
        try {
            ProductServiceConfig newPSC = (ProductServiceConfig)psc.clone();
            BasicConfiguration bc = (BasicConfiguration)this.verifyTargetClass(configuration, class$com$metamatrix$common$config$model$BasicConfiguration == null ? (class$com$metamatrix$common$config$model$BasicConfiguration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicConfiguration")) : class$com$metamatrix$common$config$model$BasicConfiguration);
            bc.addComponentDefn(newPSC);
            return newPSC;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0078", new Object[]{(class$com$metamatrix$common$config$api$ProductServiceConfig == null ? (class$com$metamatrix$common$config$api$ProductServiceConfig = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ProductServiceConfig")) : class$com$metamatrix$common$config$api$ProductServiceConfig).getName(), e2.getMessage()}));
        }
    }

    public ProductServiceConfig createProductServiceConfig(ConfigurationID configurationID, ProductTypeID productTypeID, String componentName) {
        if (configurationID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ConfigurationID == null ? (class$com$metamatrix$common$config$api$ConfigurationID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ConfigurationID")) : class$com$metamatrix$common$config$api$ConfigurationID).getName()));
        }
        if (productTypeID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ComponentTypeID == null ? (class$com$metamatrix$common$config$api$ComponentTypeID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentTypeID")) : class$com$metamatrix$common$config$api$ComponentTypeID).getName()));
        }
        if (componentName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", (class$com$metamatrix$common$config$api$ProductServiceConfig == null ? (class$com$metamatrix$common$config$api$ProductServiceConfig = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ProductServiceConfig")) : class$com$metamatrix$common$config$api$ProductServiceConfig).getName()));
        }
        BasicProductServiceConfig psc = (BasicProductServiceConfig)BasicUtil.createComponentDefn(6, configurationID, productTypeID, componentName);
        this.createCreationAction(psc.getID(), psc);
        try {
            ProductServiceConfig newPSC = (ProductServiceConfig)psc.clone();
            return newPSC;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0078", new Object[]{(class$com$metamatrix$common$config$api$ProductServiceConfig == null ? (class$com$metamatrix$common$config$api$ProductServiceConfig = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ProductServiceConfig")) : class$com$metamatrix$common$config$api$ProductServiceConfig).getName(), e2.getMessage()}));
        }
    }

    public ProductServiceConfig createProductServiceConfig(Configuration config, ProductTypeID productTypeID, String name) {
        ProductServiceConfig psc = this.createProductServiceConfig((ConfigurationID)config.getID(), productTypeID, name);
        BasicConfiguration bc = (BasicConfiguration)this.verifyTargetClass(config, class$com$metamatrix$common$config$model$BasicConfiguration == null ? (class$com$metamatrix$common$config$model$BasicConfiguration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicConfiguration")) : class$com$metamatrix$common$config$model$BasicConfiguration);
        bc.addComponentDefn(psc);
        return psc;
    }

    public Collection deployProductServiceConfig(Configuration configuration, ProductServiceConfig psc, HostID hostId, VMComponentDefnID vmId) {
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$Configuration == null ? (class$com$metamatrix$common$config$api$Configuration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.Configuration")) : class$com$metamatrix$common$config$api$Configuration).getName()));
        }
        if (hostId == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$HostID == null ? (class$com$metamatrix$common$config$api$HostID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.HostID")) : class$com$metamatrix$common$config$api$HostID).getName()));
        }
        if (vmId == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$VMComponentDefnID == null ? (class$com$metamatrix$common$config$api$VMComponentDefnID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.VMComponentDefnID")) : class$com$metamatrix$common$config$api$VMComponentDefnID).getName()));
        }
        if (psc == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ProductServiceConfig == null ? (class$com$metamatrix$common$config$api$ProductServiceConfig = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ProductServiceConfig")) : class$com$metamatrix$common$config$api$ProductServiceConfig).getName()));
        }
        ProductServiceConfigID pscID = (ProductServiceConfigID)psc.getID();
        Collection serviceComponentDefnIDs = psc.getServiceComponentDefnIDs();
        HashSet<DeployedComponent> result = new HashSet<DeployedComponent>(serviceComponentDefnIDs.size());
        Iterator iter = serviceComponentDefnIDs.iterator();
        ServiceComponentDefn serviceDefn = null;
        ServiceComponentDefnID serviceDefnID = null;
        while (iter.hasNext()) {
            DeployedComponentID id;
            serviceDefnID = (ServiceComponentDefnID)iter.next();
            serviceDefn = (ServiceComponentDefn)configuration.getComponentDefn(serviceDefnID);
            if (!psc.isServiceEnabled(serviceDefnID) || configuration.getDeployedComponent(id = new DeployedComponentID(serviceDefnID.getName(), (ConfigurationID)configuration.getID(), hostId, vmId, pscID, serviceDefnID)) != null) continue;
            DeployedComponent dc = this.createDeployedServiceComponent(serviceDefnID.getName(), configuration, hostId, vmId, serviceDefn, pscID);
            result.add(dc);
        }
        return result;
    }

    public ProductServiceConfig updateProductServiceConfig(Configuration config, ProductServiceConfig psc, Collection newServiceIDList) throws ConfigurationException {
        ServiceComponentDefnID sid;
        Iterator it;
        if (config == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$Configuration == null ? (class$com$metamatrix$common$config$api$Configuration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.Configuration")) : class$com$metamatrix$common$config$api$Configuration).getName()));
        }
        if (psc == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ProductServiceConfig == null ? (class$com$metamatrix$common$config$api$ProductServiceConfig = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ProductServiceConfig")) : class$com$metamatrix$common$config$api$ProductServiceConfig).getName()));
        }
        if (newServiceIDList == null) {
            return psc;
        }
        HashSet set = new HashSet();
        set.addAll(psc.getServiceComponentDefnIDs());
        ProductServiceConfig c2 = null;
        try {
            c2 = (ProductServiceConfig)psc.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0078", new Object[]{(class$com$metamatrix$common$config$api$ProductServiceConfig == null ? (class$com$metamatrix$common$config$api$ProductServiceConfig = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ProductServiceConfig")) : class$com$metamatrix$common$config$api$ProductServiceConfig).getName(), e2.getMessage()}));
        }
        BasicProductServiceConfig basicPSC = (BasicProductServiceConfig)this.verifyTargetClass(c2, class$com$metamatrix$common$config$model$BasicProductServiceConfig == null ? (class$com$metamatrix$common$config$model$BasicProductServiceConfig = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicProductServiceConfig")) : class$com$metamatrix$common$config$model$BasicProductServiceConfig);
        basicPSC.resetServices();
        ProductServiceConfigID pscID = (ProductServiceConfigID)psc.getID();
        if (newServiceIDList.isEmpty()) {
            basicPSC.resetServices();
        } else {
            it = newServiceIDList.iterator();
            while (it.hasNext()) {
                sid = (ServiceComponentDefnID)it.next();
                ServiceComponentDefn sd = (ServiceComponentDefn)config.getComponentDefn(sid);
                if (psc.containsService(sid)) {
                    set.remove(sid);
                } else {
                    this.deployServiceDefn(config, sd, pscID);
                }
                basicPSC.addServiceComponentDefnID(sid);
            }
        }
        it = set.iterator();
        while (it.hasNext()) {
            sid = (ServiceComponentDefnID)it.next();
            ServiceComponentDefn sdefn = (ServiceComponentDefn)config.getComponentDefn(sid);
            this.setEnabled(config, sdefn, psc, false, true);
        }
        this.createExchangeAction(pscID, ConfigurationModel.Attribute.UPDATE_PSC, newServiceIDList, Boolean.TRUE);
        return basicPSC;
    }

    public ComponentType updateComponentType(ComponentType origType, ComponentType replaceType) {
        if (replaceType == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ComponentType == null ? (class$com$metamatrix$common$config$api$ComponentType = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentType")) : class$com$metamatrix$common$config$api$ComponentType).getName()));
        }
        this.createExchangeAction(replaceType.getID(), ConfigurationModel.Attribute.UPDATE_COMPONENT_TYPE, origType, replaceType);
        return replaceType;
    }

    public void setRoutingUUID(ServiceComponentDefn serviceComponentDefn, String newRoutingUUID) {
        if (serviceComponentDefn == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ServiceComponentDefn == null ? (class$com$metamatrix$common$config$api$ServiceComponentDefn = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ServiceComponentDefn")) : class$com$metamatrix$common$config$api$ServiceComponentDefn).getName()));
        }
        String oldUUID = serviceComponentDefn.getRoutingUUID();
        BasicServiceComponentDefn basicService = (BasicServiceComponentDefn)this.verifyTargetClass(serviceComponentDefn, class$com$metamatrix$common$config$model$BasicServiceComponentDefn == null ? (class$com$metamatrix$common$config$model$BasicServiceComponentDefn = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicServiceComponentDefn")) : class$com$metamatrix$common$config$model$BasicServiceComponentDefn);
        basicService.setRoutingUUID(newRoutingUUID);
        this.createExchangeAction(basicService.getID(), ConfigurationModel.Attribute.ROUTING_UUID, oldUUID, newRoutingUUID);
    }

    public ProductServiceConfig setEnabled(ServiceComponentDefnID serviceComponentDefnID, ProductServiceConfig psc, boolean enabled) {
        if (serviceComponentDefnID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ServiceComponentDefnID == null ? (class$com$metamatrix$common$config$api$ServiceComponentDefnID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ServiceComponentDefnID")) : class$com$metamatrix$common$config$api$ServiceComponentDefnID).getName()));
        }
        if (psc == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ProductServiceConfig == null ? (class$com$metamatrix$common$config$api$ProductServiceConfig = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ProductServiceConfig")) : class$com$metamatrix$common$config$api$ProductServiceConfig).getName()));
        }
        if (!psc.containsService(serviceComponentDefnID)) {
            return psc;
        }
        boolean oldEnabled = psc.isServiceEnabled(serviceComponentDefnID);
        if (enabled != oldEnabled) {
            BasicProductServiceConfig basicPSC = (BasicProductServiceConfig)this.verifyTargetClass(psc, class$com$metamatrix$common$config$model$BasicProductServiceConfig == null ? (class$com$metamatrix$common$config$model$BasicProductServiceConfig = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicProductServiceConfig")) : class$com$metamatrix$common$config$model$BasicProductServiceConfig);
            basicPSC.setServiceEnabled(serviceComponentDefnID, enabled);
            this.createExchangeAction(basicPSC.getID(), ConfigurationModel.Attribute.IS_ENABLED, serviceComponentDefnID, enabled);
            return basicPSC;
        }
        return psc;
    }

    public Collection setEnabled(Configuration configuration, ServiceComponentDefn serviceComponentDefn, ProductServiceConfig psc, boolean enabled, boolean deleteDeployedComps) throws ConfigurationException {
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$Configuration == null ? (class$com$metamatrix$common$config$api$Configuration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.Configuration")) : class$com$metamatrix$common$config$api$Configuration).getName()));
        }
        if (serviceComponentDefn == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ServiceComponentDefn == null ? (class$com$metamatrix$common$config$api$ServiceComponentDefn = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ServiceComponentDefn")) : class$com$metamatrix$common$config$api$ServiceComponentDefn).getName()));
        }
        if (psc == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ProductServiceConfig == null ? (class$com$metamatrix$common$config$api$ProductServiceConfig = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ProductServiceConfig")) : class$com$metamatrix$common$config$api$ProductServiceConfig).getName()));
        }
        Collection<DeployedComponent> result = null;
        ServiceComponentDefnID svcID = (ServiceComponentDefnID)serviceComponentDefn.getID();
        if (!psc.containsService(svcID)) {
            throw new ConfigurationException(CommonPlugin.Util.getString("ERR.003.001.0091", new Object[]{svcID, psc.getName()}));
        }
        boolean oldEnabled = psc.isServiceEnabled(svcID);
        if (enabled != oldEnabled) {
            psc = this.setEnabled(svcID, psc, enabled);
            BasicConfiguration targetConfig = (BasicConfiguration)this.verifyTargetClass(configuration, class$com$metamatrix$common$config$model$BasicConfiguration == null ? (class$com$metamatrix$common$config$model$BasicConfiguration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicConfiguration")) : class$com$metamatrix$common$config$model$BasicConfiguration);
            Collection deps = targetConfig.getDeployedComponents(svcID, (ProductServiceConfigID)psc.getID());
            if (!enabled && deleteDeployedComps) {
                if (!deps.isEmpty()) {
                    result = new ArrayList(deps.size());
                    Iterator it = deps.iterator();
                    while (it.hasNext()) {
                        DeployedComponent deployedService = (DeployedComponent)it.next();
                        DeployedComponentID deployedServiceID = (DeployedComponentID)deployedService.getID();
                        this.createDestroyAction(deployedServiceID, deployedService);
                        targetConfig.removeComponentObject(deployedServiceID);
                        DeployedComponent ds = targetConfig.getDeployedComponent(deployedServiceID);
                        if (ds != null) {
                            throw new ConfigurationException("Deployed Component " + deployedServiceID + " was not removed");
                        }
                        try {
                            DeployedComponent newService = (DeployedComponent)deployedService.clone();
                            result.add(newService);
                        }
                        catch (CloneNotSupportedException e2) {
                            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0078", new Object[]{(class$com$metamatrix$common$config$api$DeployedComponent == null ? (class$com$metamatrix$common$config$api$DeployedComponent = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.DeployedComponent")) : class$com$metamatrix$common$config$api$DeployedComponent).getName(), e2.getMessage()}));
                        }
                    }
                }
            } else if (enabled) {
                ProductServiceConfigID pscID = (ProductServiceConfigID)psc.getID();
                result = this.deployServiceDefn(targetConfig, serviceComponentDefn, pscID);
            }
            targetConfig.addComponentDefn(psc);
        }
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    public ProductServiceConfig addServiceComponentDefn(Configuration configuration, ProductServiceConfig psc, ServiceComponentDefnID serviceComponentDefnID) {
        return this.addServiceComponentDefn(psc, serviceComponentDefnID);
    }

    public ProductServiceConfig addServiceComponentDefn(ProductServiceConfig psc, ServiceComponentDefnID serviceComponentDefnID) {
        if (psc == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ProductServiceConfig == null ? (class$com$metamatrix$common$config$api$ProductServiceConfig = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ProductServiceConfig")) : class$com$metamatrix$common$config$api$ProductServiceConfig).getName()));
        }
        if (serviceComponentDefnID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ServiceComponentDefnID == null ? (class$com$metamatrix$common$config$api$ServiceComponentDefnID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ServiceComponentDefnID")) : class$com$metamatrix$common$config$api$ServiceComponentDefnID).getName()));
        }
        BasicProductServiceConfig basicPSC = (BasicProductServiceConfig)this.verifyTargetClass(psc, class$com$metamatrix$common$config$model$BasicProductServiceConfig == null ? (class$com$metamatrix$common$config$model$BasicProductServiceConfig = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicProductServiceConfig")) : class$com$metamatrix$common$config$model$BasicProductServiceConfig);
        basicPSC.addServiceComponentDefnID(serviceComponentDefnID);
        this.createExchangeAction(serviceComponentDefnID, ConfigurationModel.Attribute.PSC_NAME, null, basicPSC.getID());
        try {
            ProductServiceConfig newDefn = (ProductServiceConfig)basicPSC.clone();
            return newDefn;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0078", new Object[]{(class$com$metamatrix$common$config$api$ProductServiceConfig == null ? (class$com$metamatrix$common$config$api$ProductServiceConfig = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ProductServiceConfig")) : class$com$metamatrix$common$config$api$ProductServiceConfig).getName(), e2.getMessage()}));
        }
    }

    public ProductType addServiceComponentType(ProductType productType, ComponentType serviceComponentType) {
        BasicProductType basicProdType = (BasicProductType)productType;
        ComponentTypeID productTypeID = (ComponentTypeID)basicProdType.getID();
        this.setParentComponentTypeID(serviceComponentType, productTypeID);
        basicProdType.addServiceTypeID((ComponentTypeID)serviceComponentType.getID());
        return basicProdType;
    }

    public ProductType removeServiceComponentType(ProductType productType, ComponentType serviceComponentType) {
        BasicProductType basicProdType = (BasicProductType)productType;
        ComponentTypeID productTypeID = (ComponentTypeID)basicProdType.getID();
        this.setParentComponentTypeID(serviceComponentType, productTypeID);
        basicProdType.removeServiceTypeID((ComponentTypeID)serviceComponentType.getID());
        return basicProdType;
    }

    public Configuration setLogConfiguration(Configuration t2, LogConfiguration logConfiguration) {
        BasicConfiguration target = (BasicConfiguration)this.verifyTargetClass(t2, class$com$metamatrix$common$config$model$BasicConfiguration == null ? (class$com$metamatrix$common$config$model$BasicConfiguration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicConfiguration")) : class$com$metamatrix$common$config$model$BasicConfiguration);
        try {
            LogConfiguration oldLogConfig = t2.getLogConfiguration();
            Set discardedContexts = oldLogConfig.getDiscardedContexts();
            Properties props = BasicLogConfiguration.getLogConfigurationProperties(logConfiguration);
            String contextValue = props.getProperty("metamatrix.log.contexts");
            if (contextValue == null && !discardedContexts.isEmpty()) {
                this.removeProperty(t2, "metamatrix.log.contexts");
            } else if (contextValue != null && discardedContexts.isEmpty()) {
                this.addProperty(t2, "metamatrix.log.contexts", contextValue);
            } else if (contextValue != null && !discardedContexts.isEmpty()) {
                this.setProperty(t2, "metamatrix.log.contexts", contextValue);
            }
            this.setProperty(t2, "metamatrix.log", props.getProperty("metamatrix.log"));
        }
        catch (LogConfigurationException e2) {
            LogManager.logError("CONFIG", (Throwable)e2, CommonPlugin.Util.getString("ERR.003.001.0001"));
        }
        return target;
    }

    public ComponentObject addProperty(ComponentObject t2, String name, String value) {
        if (t2 == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ComponentObject == null ? (class$com$metamatrix$common$config$api$ComponentObject = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentObject")) : class$com$metamatrix$common$config$api$ComponentObject).getName()));
        }
        if (name == null || value == null) {
            return t2;
        }
        BasicComponentObject target = (BasicComponentObject)this.verifyTargetClass(t2, class$com$metamatrix$common$config$model$BasicComponentObject == null ? (class$com$metamatrix$common$config$model$BasicComponentObject = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicComponentObject")) : class$com$metamatrix$common$config$model$BasicComponentObject);
        this.createAddNamedAction(target.getID(), ConfigurationModel.Attribute.PROPERTY, name, value);
        target.addProperty(name, value);
        return target;
    }

    public ComponentObject setProperty(ComponentObject t2, String name, String value) {
        if (t2 == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ComponentObject == null ? (class$com$metamatrix$common$config$api$ComponentObject = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentObject")) : class$com$metamatrix$common$config$api$ComponentObject).getName()));
        }
        if (name == null || value == null) {
            return t2;
        }
        BasicComponentObject target = (BasicComponentObject)this.verifyTargetClass(t2, class$com$metamatrix$common$config$model$BasicComponentObject == null ? (class$com$metamatrix$common$config$model$BasicComponentObject = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicComponentObject")) : class$com$metamatrix$common$config$model$BasicComponentObject);
        String oldValue = target.getProperty(name);
        this.createExchangeNamedAction(target.getID(), ConfigurationModel.Attribute.PROPERTY, name, oldValue, value);
        target.removeProperty(name);
        target.addProperty(name, value);
        return target;
    }

    public ComponentObject removeProperty(ComponentObject t2, String name) {
        if (t2 == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ComponentObject == null ? (class$com$metamatrix$common$config$api$ComponentObject = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentObject")) : class$com$metamatrix$common$config$api$ComponentObject).getName()));
        }
        if (name == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0092"));
        }
        BasicComponentObject target = (BasicComponentObject)this.verifyTargetClass(t2, class$com$metamatrix$common$config$model$BasicComponentObject == null ? (class$com$metamatrix$common$config$model$BasicComponentObject = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicComponentObject")) : class$com$metamatrix$common$config$model$BasicComponentObject);
        String value = target.getProperty(name);
        this.createRemoveNamedAction(target.getID(), ConfigurationModel.Attribute.PROPERTY, name, value);
        target.removeProperty(name);
        return target;
    }

    public ComponentTypeDefn modifyComponentTypeDefn(ComponentTypeDefn original, ComponentTypeDefn updated) {
        if (updated == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ComponentTypeDefn == null ? (class$com$metamatrix$common$config$api$ComponentTypeDefn = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentTypeDefn")) : class$com$metamatrix$common$config$api$ComponentTypeDefn).getName()));
        }
        BasicComponentTypeDefn target = (BasicComponentTypeDefn)this.verifyTargetClass(updated, class$com$metamatrix$common$config$model$BasicComponentTypeDefn == null ? (class$com$metamatrix$common$config$model$BasicComponentTypeDefn = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicComponentTypeDefn")) : class$com$metamatrix$common$config$model$BasicComponentTypeDefn);
        this.createExchangeAction(target.getID(), ConfigurationModel.Attribute.COMPONENT_TYPE_DEFN, original, updated);
        return target;
    }

    public ComponentObject modifyProperties(ComponentObject t2, Properties props, int command) {
        if (t2 == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ComponentObject == null ? (class$com$metamatrix$common$config$api$ComponentObject = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentObject")) : class$com$metamatrix$common$config$api$ComponentObject).getName()));
        }
        BasicComponentObject target = (BasicComponentObject)this.verifyTargetClass(t2, class$com$metamatrix$common$config$model$BasicComponentObject == null ? (class$com$metamatrix$common$config$model$BasicComponentObject = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicComponentObject")) : class$com$metamatrix$common$config$model$BasicComponentObject);
        super.verifyCommand(command);
        Properties newProps = null;
        switch (command) {
            case 1: {
                newProps = new Properties();
                newProps.putAll((Map<?, ?>)target.getEditableProperties());
                newProps.putAll((Map<?, ?>)props);
                this.createAddAction(target.getID(), ConfigurationModel.Attribute.PROPERTIES, props);
                target.addProperties(newProps);
                break;
            }
            case 2: {
                newProps = new Properties();
                newProps.putAll((Map<?, ?>)target.getEditableProperties());
                Iterator<Object> iter = props.keySet().iterator();
                while (iter.hasNext()) {
                    newProps.remove(iter.next());
                }
                this.createRemoveAction(target.getID(), ConfigurationModel.Attribute.PROPERTIES, props);
                target.setProperties(newProps);
                break;
            }
            case 0: {
                this.createExchangeAction(target.getID(), ConfigurationModel.Attribute.PROPERTIES, target.getEditableProperties(), props);
                target.setProperties(props);
            }
        }
        return target;
    }

    public Configuration setIsReleased(Configuration t2, boolean newValue) {
        if (t2 == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0079"));
        }
        BasicConfiguration target = (BasicConfiguration)this.verifyTargetClass(t2, class$com$metamatrix$common$config$model$BasicConfiguration == null ? (class$com$metamatrix$common$config$model$BasicConfiguration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicConfiguration")) : class$com$metamatrix$common$config$model$BasicConfiguration);
        BasicConfigurationInfo info = (BasicConfigurationInfo)target.getInfo();
        boolean oldValue = info.isReleased();
        if (oldValue != newValue) {
            this.createExchangeBoolean(target.getID(), ConfigurationModel.Attribute.IS_RELEASED, oldValue, newValue);
            info.setIsReleased(newValue);
            target.setInfo(info);
        }
        return target;
    }

    public Configuration setIsDeployed(Configuration t2, boolean newValue) {
        if (t2 == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$Configuration == null ? (class$com$metamatrix$common$config$api$Configuration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.Configuration")) : class$com$metamatrix$common$config$api$Configuration).getName()));
        }
        BasicConfiguration target = (BasicConfiguration)this.verifyTargetClass(t2, class$com$metamatrix$common$config$model$BasicConfiguration == null ? (class$com$metamatrix$common$config$model$BasicConfiguration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicConfiguration")) : class$com$metamatrix$common$config$model$BasicConfiguration);
        BasicConfigurationInfo info = (BasicConfigurationInfo)target.getInfo();
        boolean oldValue = info.isDeployed();
        if (oldValue != newValue) {
            this.createExchangeBoolean(target.getID(), ConfigurationModel.Attribute.IS_DEPLOYED, oldValue, newValue);
            info.setIsDeployed(newValue);
            target.setInfo(info);
        }
        return target;
    }

    public ComponentType setIsDeployable(ComponentType t2, boolean newValue) {
        if (t2 == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ComponentType == null ? (class$com$metamatrix$common$config$api$ComponentType = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentType")) : class$com$metamatrix$common$config$api$ComponentType).getName()));
        }
        BasicComponentType target = (BasicComponentType)this.verifyTargetClass(t2, class$com$metamatrix$common$config$model$BasicComponentType == null ? (class$com$metamatrix$common$config$model$BasicComponentType = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicComponentType")) : class$com$metamatrix$common$config$model$BasicComponentType);
        boolean oldValue = target.isDeployable();
        if (!oldValue != newValue) {
            this.createExchangeBoolean(target.getID(), ConfigurationModel.Attribute.IS_DEPLOYABLE, oldValue, newValue);
            target.setIsDeployable(newValue);
        }
        return target;
    }

    public ComponentType setIsDeprecated(ComponentType t2, boolean newValue) {
        if (t2 == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ComponentType == null ? (class$com$metamatrix$common$config$api$ComponentType = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentType")) : class$com$metamatrix$common$config$api$ComponentType).getName()));
        }
        BasicComponentType target = (BasicComponentType)this.verifyTargetClass(t2, class$com$metamatrix$common$config$model$BasicComponentType == null ? (class$com$metamatrix$common$config$model$BasicComponentType = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicComponentType")) : class$com$metamatrix$common$config$model$BasicComponentType);
        boolean oldValue = target.isDeprecated();
        if (!oldValue != newValue) {
            this.createExchangeBoolean(target.getID(), ConfigurationModel.Attribute.IS_DEPRECATED, oldValue, newValue);
            target.setIsDeprecated(newValue);
        }
        return target;
    }

    public ComponentType setIsMonitored(ComponentType t2, boolean newValue) {
        if (t2 == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ComponentType == null ? (class$com$metamatrix$common$config$api$ComponentType = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentType")) : class$com$metamatrix$common$config$api$ComponentType).getName()));
        }
        BasicComponentType target = (BasicComponentType)this.verifyTargetClass(t2, class$com$metamatrix$common$config$model$BasicComponentType == null ? (class$com$metamatrix$common$config$model$BasicComponentType = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicComponentType")) : class$com$metamatrix$common$config$model$BasicComponentType);
        boolean oldValue = target.isMonitored();
        if (!oldValue != newValue) {
            this.createExchangeBoolean(target.getID(), ConfigurationModel.Attribute.IS_MONITORED, oldValue, newValue);
            target.setIsMonitored(newValue);
        }
        return target;
    }

    public ComponentObject setComponentType(ComponentObject t2, ComponentTypeID componentType) {
        if (t2 == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ComponentObject == null ? (class$com$metamatrix$common$config$api$ComponentObject = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentObject")) : class$com$metamatrix$common$config$api$ComponentObject).getName()));
        }
        if (componentType == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ComponentType == null ? (class$com$metamatrix$common$config$api$ComponentType = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentType")) : class$com$metamatrix$common$config$api$ComponentType).getName()));
        }
        BasicComponentObject target = (BasicComponentObject)this.verifyTargetClass(t2, class$com$metamatrix$common$config$model$BasicComponentObject == null ? (class$com$metamatrix$common$config$model$BasicComponentObject = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicComponentObject")) : class$com$metamatrix$common$config$model$BasicComponentObject);
        ComponentTypeID oldValue = target.getComponentTypeID();
        if (!oldValue.equals(componentType)) {
            this.createExchangeAction(target.getID(), ConfigurationModel.Attribute.COMPONENT_TYPEID, oldValue, componentType);
            target.setComponentTypeID(componentType);
        }
        return target;
    }

    public ComponentType setParentComponentTypeID(ComponentType t2, ComponentTypeID parentID) {
        if (t2 == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ComponentType == null ? (class$com$metamatrix$common$config$api$ComponentType = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentType")) : class$com$metamatrix$common$config$api$ComponentType).getName()));
        }
        BasicComponentType target = (BasicComponentType)this.verifyTargetClass(t2, class$com$metamatrix$common$config$model$BasicComponentType == null ? (class$com$metamatrix$common$config$model$BasicComponentType = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicComponentType")) : class$com$metamatrix$common$config$model$BasicComponentType);
        ComponentTypeID oldValue = target.getParentComponentTypeID();
        if (parentID == null && oldValue != null || oldValue == null || !oldValue.equals(parentID)) {
            this.createExchangeAction(target.getID(), ConfigurationModel.Attribute.PARENT_COMPONENT_TYPEID, oldValue, parentID);
            target.setParentComponentTypeID(parentID);
        }
        return target;
    }

    public ComponentType setSuperComponentTypeID(ComponentType t2, ComponentTypeID superID) {
        if (t2 == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ComponentType == null ? (class$com$metamatrix$common$config$api$ComponentType = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentType")) : class$com$metamatrix$common$config$api$ComponentType).getName()));
        }
        BasicComponentType target = (BasicComponentType)this.verifyTargetClass(t2, class$com$metamatrix$common$config$model$BasicComponentType == null ? (class$com$metamatrix$common$config$model$BasicComponentType = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicComponentType")) : class$com$metamatrix$common$config$model$BasicComponentType);
        ComponentTypeID oldValue = target.getParentComponentTypeID();
        if (superID == null && oldValue != null || !oldValue.equals(superID)) {
            this.createExchangeAction(target.getID(), ConfigurationModel.Attribute.SUPER_COMPONENT_TYPEID, oldValue, superID);
            target.setSuperComponentTypeID(superID);
        }
        return target;
    }

    public ComponentType setLastChangedHistory(ComponentType type, String lastChangedBy, String lastChangedDate) {
        return ConfigurationObjectEditorHelper.setLastChangedHistory(type, lastChangedBy, lastChangedDate);
    }

    public ComponentType setCreationChangedHistory(ComponentType type, String createdBy, String creationDate) {
        return ConfigurationObjectEditorHelper.setCreationChangedHistory(type, createdBy, creationDate);
    }

    public ComponentObject setLastChangedHistory(ComponentObject defn, String lastChangedBy, String lastChangedDate) {
        return ConfigurationObjectEditorHelper.setLastChangedHistory(defn, lastChangedBy, lastChangedDate);
    }

    public ComponentObject setCreationChangedHistory(ComponentObject defn, String createdBy, String creationDate) {
        return ConfigurationObjectEditorHelper.setCreationChangedHistory(defn, createdBy, creationDate);
    }

    public void delete(Host target) throws ConfigurationException {
        if (target == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$Host == null ? (class$com$metamatrix$common$config$api$Host = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.Host")) : class$com$metamatrix$common$config$api$Host).getName()));
        }
        this.createDestroyAction(target.getID(), target);
    }

    public void delete(ComponentTypeDefn target, ComponentType type) throws ConfigurationException {
        if (target == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ComponentTypeDefn == null ? (class$com$metamatrix$common$config$api$ComponentTypeDefn = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentTypeDefn")) : class$com$metamatrix$common$config$api$ComponentTypeDefn).getName()));
        }
        if (type == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ComponentType == null ? (class$com$metamatrix$common$config$api$ComponentType = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentType")) : class$com$metamatrix$common$config$api$ComponentType).getName()));
        }
        BasicComponentType basicType = (BasicComponentType)this.verifyTargetClass(type, class$com$metamatrix$common$config$model$BasicComponentType == null ? (class$com$metamatrix$common$config$model$BasicComponentType = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicComponentType")) : class$com$metamatrix$common$config$model$BasicComponentType);
        this.createDestroyAction(target.getID(), target);
        basicType.removeComponentTypeDefinition(target);
    }

    public void delete(PropDefnAllowedValue target) throws ConfigurationException {
        if (target == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$PropDefnAllowedValue == null ? (class$com$metamatrix$common$config$api$PropDefnAllowedValue = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.PropDefnAllowedValue")) : class$com$metamatrix$common$config$api$PropDefnAllowedValue).getName()));
        }
        this.createDestroyAction(target.getID(), target);
    }

    public void delete(ComponentType target) throws ConfigurationException {
        if (target == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ComponentType == null ? (class$com$metamatrix$common$config$api$ComponentType = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentType")) : class$com$metamatrix$common$config$api$ComponentType).getName()));
        }
        BasicComponentType basicType = (BasicComponentType)this.verifyTargetClass(target, class$com$metamatrix$common$config$model$BasicComponentType == null ? (class$com$metamatrix$common$config$model$BasicComponentType = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicComponentType")) : class$com$metamatrix$common$config$model$BasicComponentType);
        this.createDestroyAction(basicType.getID(), basicType);
    }

    public void delete(ConfigurationID targetID) throws ConfigurationException {
        if (targetID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ConfigurationID == null ? (class$com$metamatrix$common$config$api$ConfigurationID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ConfigurationID")) : class$com$metamatrix$common$config$api$ConfigurationID).getName()));
        }
        this.createDestroyAction(targetID, targetID);
    }

    public void delete(Configuration target) throws ConfigurationException {
        this.delete(target, false);
    }

    public void delete(Configuration target, boolean deleteDependencies) throws ConfigurationException {
        if (target == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$Configuration == null ? (class$com$metamatrix$common$config$api$Configuration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.Configuration")) : class$com$metamatrix$common$config$api$Configuration).getName()));
        }
        BasicConfiguration basicConfig = (BasicConfiguration)this.verifyTargetClass(target, class$com$metamatrix$common$config$model$BasicConfiguration == null ? (class$com$metamatrix$common$config$model$BasicConfiguration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicConfiguration")) : class$com$metamatrix$common$config$model$BasicConfiguration);
        this.delete((ConfigurationID)basicConfig.getID());
    }

    public SharedResource delete(SharedResource target) throws ConfigurationException {
        this.createDestroyAction(target.getID(), target);
        return target;
    }

    public Configuration delete(ComponentObject target, Configuration configuration) throws ConfigurationException {
        return this.delete(target, configuration, false);
    }

    public Configuration delete(ComponentObject target, Configuration configuration, boolean deleteDependencies) throws ConfigurationException {
        if (target instanceof Configuration) {
            throw new UnsupportedOperationException("Cannot call method delete(ComponentObject, Configuration) to delete a configuration, call delete(Configuration).");
        }
        Configuration config = ConfigurationObjectEditorHelper.delete((ComponentObjectID)target.getID(), configuration);
        this.createDestroyAction(target.getID(), target);
        return config;
    }

    public ProductServiceConfig renamePSC(ProductServiceConfig psc, String name) throws ConfigurationException {
        if (psc == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ProductServiceConfig == null ? (class$com$metamatrix$common$config$api$ProductServiceConfig = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ProductServiceConfig")) : class$com$metamatrix$common$config$api$ProductServiceConfig).getName()));
        }
        BasicProductServiceConfig target = (BasicProductServiceConfig)this.verifyTargetClass(psc, class$com$metamatrix$common$config$model$BasicProductServiceConfig == null ? (class$com$metamatrix$common$config$model$BasicProductServiceConfig = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicProductServiceConfig")) : class$com$metamatrix$common$config$model$BasicProductServiceConfig);
        ConfigurationID configID = target.getConfigurationID();
        target = (BasicProductServiceConfig)BasicUtil.createComponentDefn(6, configID, psc.getComponentTypeID(), name);
        this.createExchangeAction(target.getID(), ConfigurationModel.Attribute.NAME, target.getName(), name);
        return target;
    }

    public VMComponentDefn renameVM(VMComponentDefn vm, String name) throws ConfigurationException {
        if (vm == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$VMComponentDefn == null ? (class$com$metamatrix$common$config$api$VMComponentDefn = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.VMComponentDefn")) : class$com$metamatrix$common$config$api$VMComponentDefn).getName()));
        }
        BasicVMComponentDefn target = (BasicVMComponentDefn)this.verifyTargetClass(vm, class$com$metamatrix$common$config$model$BasicVMComponentDefn == null ? (class$com$metamatrix$common$config$model$BasicVMComponentDefn = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicVMComponentDefn")) : class$com$metamatrix$common$config$model$BasicVMComponentDefn);
        ConfigurationID configID = target.getConfigurationID();
        target = (BasicVMComponentDefn)BasicUtil.createComponentDefn(5, configID, target.getComponentTypeID(), name);
        this.createExchangeAction(target.getID(), ConfigurationModel.Attribute.NAME, target.getName(), name);
        return target;
    }

    public boolean isDeployed(ServiceComponentDefnID defnID, Configuration config) {
        Iterator iterator = config.getDeployedComponents().iterator();
        while (iterator.hasNext()) {
            DeployedComponent comp = (DeployedComponent)iterator.next();
            ServiceComponentDefnID depDefnID = comp.getServiceComponentDefnID();
            if (!defnID.equals(depDefnID)) continue;
            return true;
        }
        return false;
    }

    public void setBootStrapConfiguration(ConfigurationID configurationID) throws ConfigurationException {
        this.createExchangeAction(configurationID, ConfigurationModel.Attribute.NEXT_STARTUP_CONFIGURATION, configurationID, configurationID);
    }

    public void setStartupConfiguration(ConfigurationID configurationID) throws ConfigurationException {
        this.createExchangeAction(configurationID, ConfigurationModel.Attribute.STARTUP_CONFIGURATION, configurationID, configurationID);
    }

    public void setNextStartupConfiguration(ConfigurationID configurationID) throws ConfigurationException {
        this.createExchangeAction(configurationID, ConfigurationModel.Attribute.NEXT_STARTUP_CONFIGURATION, configurationID, configurationID);
    }

    public ComponentType setComponentTypeDefinitions(ComponentType t2, Collection defns) {
        if (t2 == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ComponentType == null ? (class$com$metamatrix$common$config$api$ComponentType = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentType")) : class$com$metamatrix$common$config$api$ComponentType).getName()));
        }
        BasicComponentType target = (BasicComponentType)this.verifyTargetClass(t2, class$com$metamatrix$common$config$model$BasicComponentType == null ? (class$com$metamatrix$common$config$model$BasicComponentType = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicComponentType")) : class$com$metamatrix$common$config$model$BasicComponentType);
        target.setComponentTypeDefinitions(defns);
        return target;
    }

    public ComponentTypeDefn setPropertyDefinition(ComponentTypeDefn t2, PropertyDefinition defn) {
        if (t2 == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ComponentTypeDefn == null ? (class$com$metamatrix$common$config$api$ComponentTypeDefn = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentTypeDefn")) : class$com$metamatrix$common$config$api$ComponentTypeDefn).getName()));
        }
        BasicComponentTypeDefn target = (BasicComponentTypeDefn)this.verifyTargetClass(t2, class$com$metamatrix$common$config$model$BasicComponentTypeDefn == null ? (class$com$metamatrix$common$config$model$BasicComponentTypeDefn = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicComponentTypeDefn")) : class$com$metamatrix$common$config$model$BasicComponentTypeDefn);
        target.setPropertyDefinition(defn);
        return target;
    }

    public Configuration setConfigurationComponentDefns(Configuration t2, Collection componentDefns) {
        BasicConfiguration target = (BasicConfiguration)this.verifyTargetClass(t2, class$com$metamatrix$common$config$model$BasicConfiguration == null ? (class$com$metamatrix$common$config$model$BasicConfiguration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicConfiguration")) : class$com$metamatrix$common$config$model$BasicConfiguration);
        HashMap<BaseID, ComponentDefn> defns = new HashMap<BaseID, ComponentDefn>(componentDefns.size());
        Iterator it = componentDefns.iterator();
        while (it.hasNext()) {
            ComponentDefn cd = (ComponentDefn)it.next();
            defns.put(cd.getID(), cd);
        }
        target.setComponentDefns(defns);
        return target;
    }

    public Configuration setConfigurationDeployedComponents(Configuration t2, Collection deployedComponents) {
        BasicConfiguration target = (BasicConfiguration)this.verifyTargetClass(t2, class$com$metamatrix$common$config$model$BasicConfiguration == null ? (class$com$metamatrix$common$config$model$BasicConfiguration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicConfiguration")) : class$com$metamatrix$common$config$model$BasicConfiguration);
        HashMap<BaseID, DeployedComponent> dcs = new HashMap<BaseID, DeployedComponent>(deployedComponents.size());
        Iterator it = deployedComponents.iterator();
        while (it.hasNext()) {
            DeployedComponent dc = (DeployedComponent)it.next();
            dcs.put(dc.getID(), dc);
        }
        target.setDeployedComponents(dcs);
        return target;
    }

    public Configuration setConfigurationHostComponents(Configuration t2, Collection hostComponents) {
        BasicConfiguration target = (BasicConfiguration)this.verifyTargetClass(t2, class$com$metamatrix$common$config$model$BasicConfiguration == null ? (class$com$metamatrix$common$config$model$BasicConfiguration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicConfiguration")) : class$com$metamatrix$common$config$model$BasicConfiguration);
        HashMap<BaseID, Host> hosts = new HashMap<BaseID, Host>(hostComponents.size());
        Iterator it = hostComponents.iterator();
        while (it.hasNext()) {
            Host host = (Host)it.next();
            hosts.put(host.getID(), host);
        }
        target.setHosts(hosts);
        return target;
    }

    public Properties getEditableProperties(ComponentObject t2) {
        BasicComponentObject bco = (BasicComponentObject)this.verifyTargetClass(t2, class$com$metamatrix$common$config$model$BasicComponentObject == null ? (class$com$metamatrix$common$config$model$BasicComponentObject = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicComponentObject")) : class$com$metamatrix$common$config$model$BasicComponentObject);
        return bco.getEditableProperties();
    }

    public Object assignConfigurationID(Object t2, ConfigurationID configurationID) {
        if (t2 instanceof ComponentDefn) {
            BasicComponentDefn bcd = (BasicComponentDefn)this.verifyTargetClass(t2, class$com$metamatrix$common$config$model$BasicComponentDefn == null ? (class$com$metamatrix$common$config$model$BasicComponentDefn = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicComponentDefn")) : class$com$metamatrix$common$config$model$BasicComponentDefn);
            bcd.setConfigurationID(configurationID);
        } else if (t2 instanceof DeployedComponent) {
            BasicDeployedComponent bdc = (BasicDeployedComponent)this.verifyTargetClass(t2, class$com$metamatrix$common$config$model$BasicDeployedComponent == null ? (class$com$metamatrix$common$config$model$BasicDeployedComponent = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicDeployedComponent")) : class$com$metamatrix$common$config$model$BasicDeployedComponent);
            bdc.setConfigurationID(configurationID);
        }
        return t2;
    }

    public ConnectorBinding createConnectorComponent(ConfigurationID configurationID, ComponentTypeID typeID, String descriptorName, String routingUUID) {
        if (typeID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ComponentTypeID == null ? (class$com$metamatrix$common$config$api$ComponentTypeID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ComponentTypeID")) : class$com$metamatrix$common$config$api$ComponentTypeID).getName()));
        }
        if (descriptorName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", (class$com$metamatrix$common$config$api$ConnectorBinding == null ? (class$com$metamatrix$common$config$api$ConnectorBinding = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ConnectorBinding")) : class$com$metamatrix$common$config$api$ConnectorBinding).getName()));
        }
        BasicConnectorBinding defn = (BasicConnectorBinding)BasicUtil.createComponentDefn(2, configurationID, typeID, descriptorName);
        this.createCreationAction(defn.getID(), defn);
        if (routingUUID == null) {
            routingUUID = ((Object)this.getObjectIDFactory().create()).toString();
        }
        defn.setRoutingUUID(routingUUID);
        try {
            ConnectorBinding newDefn = (ConnectorBinding)defn.clone();
            return newDefn;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0078", new Object[]{(class$com$metamatrix$common$config$api$ConnectorBinding == null ? (class$com$metamatrix$common$config$api$ConnectorBinding = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ConnectorBinding")) : class$com$metamatrix$common$config$api$ConnectorBinding).getName(), e2.getMessage()}));
        }
    }

    public ConnectorBinding createConnectorComponent(Configuration configuration, ComponentTypeID typeID, String componentName, ProductServiceConfigID pscID) {
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$Configuration == null ? (class$com$metamatrix$common$config$api$Configuration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.Configuration")) : class$com$metamatrix$common$config$api$Configuration).getName()));
        }
        if (pscID == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ProductServiceConfigID == null ? (class$com$metamatrix$common$config$api$ProductServiceConfigID = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ProductServiceConfigID")) : class$com$metamatrix$common$config$api$ProductServiceConfigID).getName()));
        }
        ProductServiceConfig psc = (ProductServiceConfig)configuration.getComponentDefn(pscID);
        if (psc == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ProductServiceConfig == null ? (class$com$metamatrix$common$config$api$ProductServiceConfig = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ProductServiceConfig")) : class$com$metamatrix$common$config$api$ProductServiceConfig).getName()));
        }
        BasicConnectorBinding newServiceDefn = (BasicConnectorBinding)this.createConnectorComponent((ConfigurationID)configuration.getID(), typeID, componentName, null);
        this.addServiceComponentDefn(psc, (ServiceComponentDefnID)newServiceDefn.getID());
        BasicConfiguration bc = (BasicConfiguration)this.verifyTargetClass(configuration, class$com$metamatrix$common$config$model$BasicConfiguration == null ? (class$com$metamatrix$common$config$model$BasicConfiguration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicConfiguration")) : class$com$metamatrix$common$config$model$BasicConfiguration);
        bc.addComponentDefn(newServiceDefn);
        this.deployServiceDefn(bc, newServiceDefn, pscID);
        return newServiceDefn;
    }

    public ConnectorBinding createConnectorComponent(ConfigurationID configurationID, ConnectorBinding original, String newName, String routingUUID) {
        if (original == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ConnectorBinding == null ? (class$com$metamatrix$common$config$api$ConnectorBinding = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ConnectorBinding")) : class$com$metamatrix$common$config$api$ConnectorBinding).getName()));
        }
        if (newName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", (class$com$metamatrix$common$config$api$ConnectorBinding == null ? (class$com$metamatrix$common$config$api$ConnectorBinding = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ConnectorBinding")) : class$com$metamatrix$common$config$api$ConnectorBinding).getName()));
        }
        BasicConnectorBinding defn = (BasicConnectorBinding)BasicUtil.createComponentDefn(2, configurationID, original.getComponentTypeID(), newName);
        if (routingUUID == null) {
            routingUUID = ((Object)this.getObjectIDFactory().create()).toString();
        }
        defn.setRoutingUUID(routingUUID);
        this.createCreationAction(defn.getID(), defn);
        this.modifyProperties(defn, original.getProperties(), 1);
        try {
            ConnectorBinding newDefn = (ConnectorBinding)defn.clone();
            return newDefn;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0078", new Object[]{(class$com$metamatrix$common$config$api$ConnectorBinding == null ? (class$com$metamatrix$common$config$api$ConnectorBinding = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ConnectorBinding")) : class$com$metamatrix$common$config$api$ConnectorBinding).getName(), e2.getMessage()}));
        }
    }

    public ConnectorBinding createConnectorComponent(Configuration configuration, ConnectorBinding originalConnector, String newName) {
        if (configuration == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$Configuration == null ? (class$com$metamatrix$common$config$api$Configuration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.Configuration")) : class$com$metamatrix$common$config$api$Configuration).getName()));
        }
        if (originalConnector == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0089", (class$com$metamatrix$common$config$api$ConnectorBinding == null ? (class$com$metamatrix$common$config$api$ConnectorBinding = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ConnectorBinding")) : class$com$metamatrix$common$config$api$ConnectorBinding).getName()));
        }
        if (newName == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.001.0087", (class$com$metamatrix$common$config$api$ConnectorBinding == null ? (class$com$metamatrix$common$config$api$ConnectorBinding = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ConnectorBinding")) : class$com$metamatrix$common$config$api$ConnectorBinding).getName()));
        }
        BasicConnectorBinding defn = (BasicConnectorBinding)BasicUtil.createComponentDefn(2, (ConfigurationID)configuration.getID(), originalConnector.getComponentTypeID(), newName);
        defn.setRoutingUUID(originalConnector.getRoutingUUID());
        defn.setIsQueuedService(originalConnector.isQueuedService());
        this.createCreationAction(defn.getID(), defn);
        this.modifyProperties(defn, originalConnector.getProperties(), 1);
        try {
            ConnectorBinding newDefn = (ConnectorBinding)defn.clone();
            BasicConfiguration bc = (BasicConfiguration)this.verifyTargetClass(configuration, class$com$metamatrix$common$config$model$BasicConfiguration == null ? (class$com$metamatrix$common$config$model$BasicConfiguration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicConfiguration")) : class$com$metamatrix$common$config$model$BasicConfiguration);
            bc.addComponentDefn(newDefn);
            return newDefn;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(CommonPlugin.Util.getString("ERR.003.001.0078", new Object[]{(class$com$metamatrix$common$config$api$ConnectorBinding == null ? (class$com$metamatrix$common$config$api$ConnectorBinding = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.api.ConnectorBinding")) : class$com$metamatrix$common$config$api$ConnectorBinding).getName(), e2.getMessage()}));
        }
    }

    public Collection deployServiceDefn(Configuration configuration, ServiceComponentDefn serviceComponentDefn, ProductServiceConfigID pscID) {
        ArrayList<DeployedComponent> result = null;
        BasicServiceComponentDefn basicService = (BasicServiceComponentDefn)this.verifyTargetClass(serviceComponentDefn, class$com$metamatrix$common$config$model$BasicServiceComponentDefn == null ? (class$com$metamatrix$common$config$model$BasicServiceComponentDefn = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicServiceComponentDefn")) : class$com$metamatrix$common$config$model$BasicServiceComponentDefn);
        BasicConfiguration targetConfig = (BasicConfiguration)this.verifyTargetClass(configuration, class$com$metamatrix$common$config$model$BasicConfiguration == null ? (class$com$metamatrix$common$config$model$BasicConfiguration = BasicConfigurationObjectEditor.class$("com.metamatrix.common.config.model.BasicConfiguration")) : class$com$metamatrix$common$config$model$BasicConfiguration);
        DeployedComponent aDeployedComponent = null;
        ProductServiceConfigID aPscID = null;
        HostID hostID = null;
        VMComponentDefnID vmID = null;
        ConfigurationID configID = (ConfigurationID)targetConfig.getID();
        ServiceComponentDefnID serviceDefnID = (ServiceComponentDefnID)basicService.getID();
        ProductServiceConfig psc = targetConfig.getPSC(pscID);
        HashSet<DeployedComponentID> deployedIDs = new HashSet<DeployedComponentID>();
        Iterator iter = targetConfig.getDeployedComponents().iterator();
        while (iter.hasNext()) {
            aDeployedComponent = (DeployedComponent)iter.next();
            aPscID = aDeployedComponent.getProductServiceConfigID();
            if (aPscID == null || !aPscID.equals(pscID)) continue;
            hostID = aDeployedComponent.getHostID();
            vmID = aDeployedComponent.getVMComponentDefnID();
            DeployedComponentID id = new DeployedComponentID(serviceDefnID.getName(), configID, hostID, vmID, pscID, serviceDefnID);
            if (deployedIDs.contains(id)) continue;
            deployedIDs.add(id);
            DeployedComponent deployComponent = this.createDeployedServiceComponent(serviceDefnID.getName(), configuration, hostID, vmID, basicService, aPscID);
            if (result == null) {
                result = new ArrayList<DeployedComponent>();
            }
            result.add(deployComponent);
            if (psc.getServiceComponentDefnIDs() == null) {
                this.addServiceComponentDefn(psc, serviceDefnID);
                continue;
            }
            if (psc.getServiceComponentDefnIDs().contains(serviceDefnID)) continue;
            this.addServiceComponentDefn(psc, serviceDefnID);
        }
        targetConfig.addComponentDefn(basicService);
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

