/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.xml;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.api.ComponentDefn;
import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeDefn;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConfigurationInfo;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ConnectorBindingID;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.config.api.ProductServiceConfigID;
import com.metamatrix.common.config.api.ProductType;
import com.metamatrix.common.config.api.ProductTypeID;
import com.metamatrix.common.config.api.ResourceDescriptor;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.ServiceComponentDefnID;
import com.metamatrix.common.config.api.SharedResource;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.api.VMComponentDefnID;
import com.metamatrix.common.config.model.BasicComponentObject;
import com.metamatrix.common.config.model.BasicComponentType;
import com.metamatrix.common.config.util.ConfigurationPropertyNames;
import com.metamatrix.common.config.util.InvalidConfigurationElementException;
import com.metamatrix.common.config.xml.XMLHelper;
import com.metamatrix.common.log.LogConfiguration;
import com.metamatrix.common.object.Multiplicity;
import com.metamatrix.common.object.MultiplicityExpressionException;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.object.PropertyDefinitionImpl;
import com.metamatrix.common.object.PropertyType;
import com.metamatrix.common.util.DateUtil;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.EquivalenceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jdom.Element;

public class XMLConfig_42_HelperImpl
implements XMLHelper,
ConfigurationPropertyNames {
    public DeployedComponent createDeployedComponent(Element element, ConfigurationID configID, HostID hostID, VMComponentDefnID vmID, ProductServiceConfigID pscID, Map componentTypeMap, ConfigurationObjectEditor editor) throws InvalidConfigurationElementException {
        return null;
    }

    public Element createConfigurationElement(Configuration configuration) {
        Assertion.isNotNull(configuration);
        Element configElement = this.createComponentObjectElement("Configuration", configuration);
        return configElement;
    }

    public Element createLogConfigurationElement(LogConfiguration logConfiguration) {
        throw new UnsupportedOperationException("Method createLogConfigurationElement is unsupported in 4.2");
    }

    public Element createConfigurationInfoElement(ConfigurationInfo info) {
        throw new UnsupportedOperationException("Method createConfigurationInfoElement is unsupported in 4.2");
    }

    public Element createDeployedComponentElement(DeployedComponent deployedComponent) {
        Assertion.isNotNull(deployedComponent);
        Element deployedComponentElement = this.createComponentObjectElement("Service", deployedComponent);
        return deployedComponentElement;
    }

    public Element createVMComponentDefnElement(VMComponentDefn defn) {
        Assertion.isNotNull(defn);
        Element vmComponentDefnElement = this.createComponentObjectElement("Process", defn);
        return vmComponentDefnElement;
    }

    public Element createDeployedServiceComponentDefnElement(ServiceComponentDefn defn) {
        Assertion.isNotNull(defn);
        Element serviceComponentDefnElement = this.createComponentObjectElement("Service", defn);
        serviceComponentDefnElement.setAttribute("QueuedService", Boolean.valueOf(defn.isQueuedService()).toString());
        serviceComponentDefnElement.setAttribute("routingUUID", defn.getRoutingUUID());
        return serviceComponentDefnElement;
    }

    public Element createServiceComponentDefnElement(ServiceComponentDefn defn) {
        Assertion.isNotNull(defn);
        Element serviceComponentDefnElement = this.createComponentObjectElement("Service", defn);
        serviceComponentDefnElement.setAttribute("QueuedService", Boolean.valueOf(defn.isQueuedService()).toString());
        serviceComponentDefnElement.setAttribute("routingUUID", defn.getRoutingUUID());
        return serviceComponentDefnElement;
    }

    public Element createDeployedProductServiceConfigElement(ProductServiceConfig config) {
        Assertion.isNotNull(config);
        Element productServiceConfigElement = this.createComponentObjectElement("PSC", config);
        return productServiceConfigElement;
    }

    public Element createProductServiceConfigsElement() {
        return new Element("ProductServiceConfigs");
    }

    public Element createProductServiceConfigElement(ProductServiceConfig config) {
        Assertion.isNotNull(config);
        Element productServiceConfigElement = this.createComponentObjectElement("PSC", config);
        Iterator iterator = config.getServiceComponentDefnIDs().iterator();
        while (iterator.hasNext()) {
            ServiceComponentDefnID id = (ServiceComponentDefnID)iterator.next();
            boolean isEnabled = config.isServiceEnabled(id);
            Element idElement = this.createIDElement("Service", id.getName());
            idElement.setAttribute("IsEnabled", Boolean.valueOf(isEnabled).toString());
            productServiceConfigElement.addContent(idElement);
        }
        return productServiceConfigElement;
    }

    public Element createComponentTypeElement(ComponentType type) {
        ComponentTypeID parentID;
        Assertion.isNotNull(type);
        Element componentTypeElement = new Element("ComponentType");
        Iterator iterator = type.getComponentTypeDefinitions().iterator();
        while (iterator.hasNext()) {
            ComponentTypeDefn defn = (ComponentTypeDefn)iterator.next();
            Element propertyDefinitionElement = this.createPropertyDefinitionElement(defn.getPropertyDefinition());
            componentTypeElement.addContent(propertyDefinitionElement);
        }
        componentTypeElement.setAttribute("Name", type.getName());
        if (type.getDescription() != null) {
            componentTypeElement.setAttribute("Description", type.getDescription());
        }
        componentTypeElement.setAttribute("ComponentTypeCode", new Integer(type.getComponentTypeCode()).toString());
        componentTypeElement.setAttribute("Deployable", Boolean.valueOf(type.isDeployable()).toString());
        componentTypeElement.setAttribute("Deprecated", Boolean.valueOf(type.isDeprecated()).toString());
        componentTypeElement.setAttribute("Monitorable", Boolean.valueOf(type.isMonitored()).toString());
        ComponentTypeID superID = type.getSuperComponentTypeID();
        if (superID != null) {
            String superIDString = superID.getName();
            componentTypeElement.setAttribute("SuperComponentType", superIDString);
        }
        if ((parentID = type.getParentComponentTypeID()) != null) {
            String parentIDString = parentID.getName();
            componentTypeElement.setAttribute("ParentComponentType", parentIDString);
        }
        this.addChangeHistoryElement(type, componentTypeElement);
        return componentTypeElement;
    }

    public Element createPropertyDefinitionElement(PropertyDefinition defn) {
        PropertyType type;
        Multiplicity mult;
        Assertion.isNotNull(defn);
        Element element = new Element("PropertyDefinition");
        String name = defn.getName();
        element.setAttribute("Name", name);
        String displayName = defn.getDisplayName();
        element.setAttribute("DisplayName", displayName);
        XMLConfig_42_HelperImpl.setAttributeString(element, "ShortDescription", defn.getShortDescription(), PropertyDefinitionImpl.DEFAULT_SHORT_DESCRIPTION);
        Object value = defn.getDefaultValue();
        if (value != null) {
            XMLConfig_42_HelperImpl.setAttributeString(element, "DefaultValue", value.toString(), PropertyDefinitionImpl.DEFAULT_DEFAULT_VALUE);
        }
        if ((mult = defn.getMultiplicity()) != null) {
            XMLConfig_42_HelperImpl.setAttributeString(element, "Multiplicity", mult.toString(), "0..1");
        }
        if ((type = defn.getPropertyType()) != null) {
            XMLConfig_42_HelperImpl.setAttributeString(element, "PropertyType", type.getDisplayName(), PropertyDefinitionImpl.DEFAULT_TYPE.getDisplayName());
        }
        XMLConfig_42_HelperImpl.setAttributeString(element, "ValueDelimiter", defn.getValueDelimiter(), ",");
        XMLConfig_42_HelperImpl.setAttributeBoolean(element, "IsConstrainedToAllowedValues", defn.isConstrainedToAllowedValues(), true);
        XMLConfig_42_HelperImpl.setAttributeBoolean(element, "IsExpert", defn.isExpert(), false);
        XMLConfig_42_HelperImpl.setAttributeBoolean(element, "IsHidden", defn.isHidden(), false);
        XMLConfig_42_HelperImpl.setAttributeBoolean(element, "IsMasked", defn.isMasked(), false);
        XMLConfig_42_HelperImpl.setAttributeBoolean(element, "IsModifiable", defn.isModifiable(), true);
        XMLConfig_42_HelperImpl.setAttributeBoolean(element, "IsPreferred", defn.isPreferred(), false);
        XMLConfig_42_HelperImpl.setAttributeBoolean(element, "RequiresRestart", defn.getRequiresRestart(), false);
        List allowedValues = defn.getAllowedValues();
        Iterator iterator = allowedValues.iterator();
        while (iterator.hasNext()) {
            Element allowedValueElement = new Element("AllowedValue");
            allowedValueElement.addContent(iterator.next().toString());
            element.addContent(allowedValueElement);
        }
        return element;
    }

    private static void setAttributeString(Element element, String attributeName, String value, String defaultValue) {
        if (value != null && !EquivalenceUtil.areEqual(value, defaultValue)) {
            element.setAttribute(attributeName, value);
        }
    }

    private static void setAttributeBoolean(Element element, String attributeName, boolean value, boolean defaultValue) {
        if (!value == defaultValue) {
            String valueString = String.valueOf(value);
            element.setAttribute(attributeName, valueString);
        }
    }

    public Element createComponentTypeDefnElement(ComponentTypeDefn defn) {
        Assertion.isNotNull(defn);
        Element componentTypeDefnElement = new Element("ComponentTypeDefn");
        componentTypeDefnElement.setAttribute("Deprecated", Boolean.valueOf(defn.isDeprecated()).toString());
        return componentTypeDefnElement;
    }

    public Element createProductTypeElement(ProductType type) {
        Assertion.isNotNull(type);
        Element productTypeElement = new Element("ProductType");
        Iterator iterator = type.getComponentTypeIDs().iterator();
        while (iterator.hasNext()) {
            ComponentTypeID id = (ComponentTypeID)iterator.next();
            Element componentTypeIDElement = this.createIDElement("ComponentTypeID", id.getName());
            productTypeElement.addContent(componentTypeIDElement);
        }
        productTypeElement.setAttribute("Name", type.getName());
        productTypeElement.setAttribute("ComponentTypeCode", new Integer(type.getComponentTypeCode()).toString());
        productTypeElement.setAttribute("Deployable", Boolean.valueOf(type.isDeployable()).toString());
        productTypeElement.setAttribute("Deprecated", Boolean.valueOf(type.isDeprecated()).toString());
        productTypeElement.setAttribute("Monitorable", Boolean.valueOf(type.isMonitored()).toString());
        ComponentTypeID superID = type.getSuperComponentTypeID();
        if (superID != null) {
            String superIDString = superID.getName();
            productTypeElement.setAttribute("SuperComponentType", superIDString);
        }
        this.addChangeHistoryElement(type, productTypeElement);
        return productTypeElement;
    }

    public Element createDeployedHostElement(Host host) {
        Assertion.isNotNull(host);
        Element hostElement = this.createComponentObjectElement("Host", host);
        return hostElement;
    }

    public Element createDeployedVMElementx(DeployedComponent vm) {
        Assertion.isNotNull(vm);
        Element hostElement = this.createComponentObjectElement("Host", vm);
        return hostElement;
    }

    public final boolean is42ConfigurationCompatible(Element root) throws InvalidConfigurationElementException {
        Element headerElement = root.getChild("Header");
        if (headerElement == null) {
            throw new InvalidConfigurationElementException("The header element is not found in the configuration under element.", (Object)root.getName());
        }
        Properties props = this.getHeaderProperties(headerElement);
        String sVersion = props.getProperty("ConfigurationVersion");
        if (sVersion == null) {
            return false;
        }
        try {
            double sv = Double.parseDouble(sVersion);
            if (sv == 4.2) {
                return true;
            }
        }
        catch (Throwable t2) {
            return false;
        }
        return true;
    }

    public Properties getHeaderProperties(Element element) throws InvalidConfigurationElementException {
        Properties props = new Properties();
        if (!element.getName().equals("Header")) {
            throw new InvalidConfigurationElementException("This is not the header element: " + element.getName() + ".", (Object)element);
        }
        List elements = element.getChildren();
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            Element e2 = (Element)it.next();
            props.setProperty(e2.getName(), e2.getText());
        }
        return props;
    }

    public Element createHeaderElement(Properties props) {
        Assertion.isNotNull(props);
        Element headerElement = new Element("Header");
        String applicationCreatedByContent = props.getProperty("ApplicationCreatedBy");
        String applicationVersionCreatedByContent = props.getProperty("ApplicationVersion");
        String userNameContent = props.getProperty("UserCreatedBy");
        String configVersionContent = props.getProperty("ConfigurationVersion");
        String serverVersionContent = props.getProperty("MetaMatrixSystemVersion");
        String timeContent = props.getProperty("Time");
        if (configVersionContent != null) {
            Element configurationVersion = new Element("ConfigurationVersion");
            configurationVersion.addContent(configVersionContent);
            headerElement.addContent(configurationVersion);
        }
        if (applicationCreatedByContent != null) {
            Element applicationCreatedBy = new Element("ApplicationCreatedBy");
            applicationCreatedBy.addContent(applicationCreatedByContent);
            headerElement.addContent(applicationCreatedBy);
        }
        if (applicationVersionCreatedByContent != null) {
            Element applicationVersionCreatedBy = new Element("ApplicationVersion");
            applicationVersionCreatedBy.addContent(applicationVersionCreatedByContent);
            headerElement.addContent(applicationVersionCreatedBy);
        }
        if (userNameContent != null) {
            Element userName = new Element("UserCreatedBy");
            userName.addContent(userNameContent);
            headerElement.addContent(userName);
        }
        if (serverVersionContent != null) {
            Element serverVersion = new Element("MetaMatrixSystemVersion");
            serverVersion.addContent(serverVersionContent);
            headerElement.addContent(serverVersion);
        }
        if (timeContent != null) {
            Element time = new Element("Time");
            time.addContent(timeContent);
            headerElement.addContent(time);
        }
        return headerElement;
    }

    private ComponentObject setDateHistory(ComponentObject defn, Element element, ConfigurationObjectEditor editor) {
        String lastChangedBy = null;
        String lastChangedDate = null;
        String createdDate = null;
        String createdBy = null;
        Properties props = this.getChangeHistoryFromElement(element);
        if (props != null && props.size() > 0) {
            lastChangedBy = props.getProperty("LastChangedBy");
            lastChangedDate = props.getProperty("LastChangedDate");
            createdBy = props.getProperty("CreatedBy");
            createdDate = props.getProperty("CreationDate");
        } else {
            lastChangedBy = element.getAttributeValue("LastChangedBy");
            lastChangedDate = element.getAttributeValue("LastChangedDate");
            createdBy = element.getAttributeValue("CreatedBy");
            createdDate = element.getAttributeValue("CreationDate");
        }
        lastChangedBy = lastChangedBy != null ? lastChangedBy : "";
        lastChangedDate = lastChangedDate != null ? lastChangedDate : DateUtil.getCurrentDateAsString();
        createdBy = createdBy != null ? createdBy : "";
        createdDate = createdDate != null ? createdDate : DateUtil.getCurrentDateAsString();
        defn = editor.setCreationChangedHistory(defn, createdBy, createdDate);
        defn = editor.setLastChangedHistory(defn, lastChangedBy, lastChangedDate);
        return defn;
    }

    private ComponentType setDateHistory(ComponentType type, Element element, ConfigurationObjectEditor editor) {
        String lastChangedBy = null;
        String lastChangedDate = null;
        String createdDate = null;
        String createdBy = null;
        Properties props = this.getChangeHistoryFromElement(element);
        if (props != null && props.size() > 0) {
            lastChangedBy = props.getProperty("LastChangedBy");
            lastChangedDate = props.getProperty("LastChangedDate");
            createdBy = props.getProperty("CreatedBy");
            createdDate = props.getProperty("CreationDate");
        } else {
            lastChangedBy = element.getAttributeValue("LastChangedBy");
            lastChangedDate = element.getAttributeValue("LastChangedDate");
            createdBy = element.getAttributeValue("CreatedBy");
            createdDate = element.getAttributeValue("CreationDate");
        }
        lastChangedBy = lastChangedBy != null ? lastChangedBy : "";
        lastChangedDate = lastChangedDate != null ? lastChangedDate : DateUtil.getCurrentDateAsString();
        createdBy = createdBy != null ? createdBy : "";
        createdDate = createdDate != null ? createdDate : DateUtil.getCurrentDateAsString();
        type = editor.setCreationChangedHistory(type, createdBy, createdDate);
        type = editor.setLastChangedHistory(type, lastChangedBy, lastChangedDate);
        return type;
    }

    private Properties getChangeHistoryFromElement(Element parentElement) {
        Element propertiesElement = parentElement.getChild("ChangeHistory");
        if (propertiesElement == null) {
            return new Properties();
        }
        Properties props = new Properties();
        List properties = propertiesElement.getChildren("Property");
        if (properties == null) {
            return new Properties();
        }
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            Element propertyElement = (Element)iterator.next();
            String propertyName = propertyElement.getAttributeValue("Name");
            String propertyValue = propertyElement.getText();
            props.setProperty(propertyName, propertyValue != null ? propertyValue : "");
        }
        return props;
    }

    private void addChangeHistoryElement(ComponentObject obj, Element element) {
        String lastChangedBy = null;
        String lastChangedDate = null;
        String createdDate = null;
        String createdBy = null;
        lastChangedBy = obj.getLastChangedBy();
        lastChangedDate = ((BasicComponentObject)obj).getLastChangedDateString();
        createdBy = obj.getCreatedBy();
        createdDate = ((BasicComponentObject)obj).getCreatedDateString();
        if (lastChangedBy != null && lastChangedBy.trim().length() != 0) {
            element.setAttribute("LastChangedBy", lastChangedBy);
        }
        if (lastChangedDate != null) {
            element.setAttribute("LastChangedDate", lastChangedDate);
        }
        if (createdBy != null && createdBy.trim().length() != 0) {
            element.setAttribute("CreatedBy", createdBy);
        }
        if (createdDate != null) {
            element.setAttribute("CreationDate", createdDate);
        }
    }

    private void addChangeHistoryElement(ComponentType obj, Element element) {
        String lastChangedBy = null;
        String lastChangedDate = null;
        String createdDate = null;
        String createdBy = null;
        lastChangedBy = obj.getLastChangedBy();
        lastChangedDate = ((BasicComponentType)obj).getLastChangedDateString();
        createdBy = obj.getCreatedBy();
        createdDate = ((BasicComponentType)obj).getCreatedDateString();
        if (lastChangedBy != null && lastChangedBy.trim().length() != 0) {
            element.setAttribute("LastChangedBy", lastChangedBy);
        }
        if (lastChangedDate == null) {
            lastChangedDate = DateUtil.getCurrentDateAsString();
        }
        element.setAttribute("LastChangedDate", lastChangedDate);
        if (createdBy != null && createdBy.trim().length() != 0) {
            element.setAttribute("CreatedBy", createdBy);
        }
        if (createdDate == null) {
            createdDate = DateUtil.getCurrentDateAsString();
        }
        element.setAttribute("CreationDate", createdDate);
    }

    public Element createPropertiesElement(Properties props) {
        Assertion.isNotNull(props);
        Properties sortprops = PropertiesUtils.sort(props);
        Element propertiesElement = new Element("Properties");
        Enumeration<?> enumeration = sortprops.propertyNames();
        while (enumeration.hasMoreElements()) {
            String propName = (String)enumeration.nextElement();
            propertiesElement = this.addPropertyElement(propertiesElement, propName, props.getProperty(propName));
        }
        return propertiesElement;
    }

    private Element addPropertyElement(Element propertiesElement, String propName, String propValue) {
        Element property = new Element("Property");
        property.setAttribute("Name", propName);
        property.addContent(propValue);
        propertiesElement.addContent(property);
        return propertiesElement;
    }

    public Element createIDElement(String type, String name) {
        Element idElement = new Element(type);
        idElement.setAttribute("Name", name);
        return idElement;
    }

    public Element createConfigurationsElement() {
        throw new UnsupportedOperationException("Method createConfigurationsElement is unsupported in 4.2");
    }

    public Element createHostsElement() {
        throw new UnsupportedOperationException("Method createHostsElement is unsupported in 4.2");
    }

    public Element createHostElement(Host host) {
        Assertion.isNotNull(host);
        Element hostElement = this.createComponentObjectElement("Host", host);
        return hostElement;
    }

    public Element createServiceComponentDefnsElement() {
        return new Element("Services");
    }

    public Element createComponentTypesElement() {
        return new Element("ComponentTypes");
    }

    public Element createProductTypesElement() {
        return new Element("ProductTypes");
    }

    public Element createConnectorBindingsElement() {
        return new Element("ConnectorBindings");
    }

    public Element createRootConfigurationDocumentElement() {
        return new Element("ConfigurationDocument");
    }

    private Element createComponentObjectElement(String type, ComponentObject componentObject) {
        Element componentObjectElement = new Element(type);
        componentObjectElement.setAttribute("Name", componentObject.getName());
        ComponentTypeID id = componentObject.getComponentTypeID();
        if (id != null) {
            componentObjectElement.setAttribute("ComponentType", id.getName());
        }
        if (!(componentObject instanceof DeployedComponent)) {
            Element properties = this.createPropertiesElement(componentObject.getProperties());
            componentObjectElement.addContent(properties);
        }
        this.addChangeHistoryElement(componentObject, componentObjectElement);
        return componentObjectElement;
    }

    public Host createHost(Element element, ConfigurationID configID, ConfigurationObjectEditor editor, String name) throws InvalidConfigurationElementException {
        Assertion.isNotNull(element);
        Assertion.isNotNull(editor);
        if (!element.getName().equals("Host")) {
            throw new InvalidConfigurationElementException("ERR.003.001.0032", CommonPlugin.Util.getString("ERR.003.001.0032", element.getName()), (Object)element);
        }
        if (name == null) {
            name = element.getAttributeValue("Name");
        }
        Host host = editor.createHost(configID, name);
        host = (Host)this.setDateHistory(host, element, editor);
        host = (Host)this.addProperties(element, host, editor);
        return host;
    }

    public Element createResourcePoolElement(ResourceDescriptor resource) {
        Assertion.isNotNull(resource);
        Element resourceElement = this.createComponentObjectElement("ConnectionPool", resource);
        return resourceElement;
    }

    public Element createResourcePoolsElement() {
        return new Element("ConnectionPools");
    }

    public ResourceDescriptor createResourcePool(Element element, ConfigurationID configID, ConfigurationObjectEditor editor) throws InvalidConfigurationElementException {
        Assertion.isNotNull(element);
        Assertion.isNotNull(editor);
        if (!element.getName().equals("ConnectionPool")) {
            throw new InvalidConfigurationElementException("ERR.003.001.0033", CommonPlugin.Util.getString("ERR.003.001.0033", element.getName()), (Object)element);
        }
        String name = element.getAttributeValue("Name");
        this.checkElementValue(name, null, "ERR.003.001.0053");
        String type = element.getAttributeValue("ComponentType");
        this.checkElementValue(type, name, "ERR.003.001.0054");
        ComponentTypeID id = new ComponentTypeID(type);
        ResourceDescriptor descriptor = editor.createResourceDescriptor(configID, id, name);
        Element propertiesElement = element.getChild("Properties");
        descriptor = (ResourceDescriptor)this.setDateHistory(descriptor, element, editor);
        if (propertiesElement != null) {
            descriptor = (ResourceDescriptor)this.addProperties(propertiesElement, descriptor, editor);
        }
        return descriptor;
    }

    public Element createSharedResourceElement(SharedResource resource) {
        Assertion.isNotNull(resource);
        Element resourceElement = this.createComponentObjectElement("Resource", resource);
        return resourceElement;
    }

    public SharedResource createSharedResource(Element element, ConfigurationObjectEditor editor) throws InvalidConfigurationElementException {
        Assertion.isNotNull(element);
        Assertion.isNotNull(editor);
        if (!element.getName().equals("Resource")) {
            throw new InvalidConfigurationElementException("ERR.003.001.0034", CommonPlugin.Util.getString("ERR.003.001.0034", element.getName()), (Object)element);
        }
        String name = element.getAttributeValue("Name");
        this.checkElementValue(name, null, "ERR.003.001.0055");
        String type = element.getAttributeValue("ComponentType");
        this.checkElementValue(type, name, "ERR.003.001.0056");
        ComponentTypeID id = new ComponentTypeID(type);
        SharedResource descriptor = editor.createSharedResource(id, name);
        Element propertiesElement = element.getChild("Properties");
        descriptor = (SharedResource)this.setDateHistory(descriptor, element, editor);
        if (propertiesElement != null) {
            descriptor = (SharedResource)this.addProperties(propertiesElement, descriptor, editor);
        }
        return descriptor;
    }

    public Element createSharedResourcesElement() {
        return new Element("SharedResources");
    }

    public ComponentType createComponentType(Element element, ConfigurationObjectEditor editor, String name, boolean maintainParentID) throws InvalidConfigurationElementException {
        Assertion.isNotNull(element);
        Assertion.isNotNull(editor);
        if (!element.getName().equals("ComponentType")) {
            throw new InvalidConfigurationElementException("ERR.003.001.0035", CommonPlugin.Util.getString("ERR.003.001.0035", element.getName()), (Object)element);
        }
        String parentType = element.getAttributeValue("ParentComponentType");
        String superType = element.getAttributeValue("SuperComponentType");
        String componentTypeCode = element.getAttributeValue("ComponentTypeCode");
        String deployable = element.getAttributeValue("Deployable");
        String monitorable = element.getAttributeValue("Monitorable");
        String description = element.getAttributeValue("Description");
        if (name == null) {
            name = element.getAttributeValue("Name");
        }
        int typeCode = Integer.parseInt(componentTypeCode);
        ProductTypeID parentTypeID = null;
        ComponentTypeID superTypeID = null;
        if (parentType != null && parentType.length() > 0) {
            parentTypeID = new ProductTypeID(parentType);
        }
        if (superType != null && superType.length() > 0) {
            superTypeID = new ComponentTypeID(superType);
        }
        boolean isDeployable = Boolean.valueOf(deployable);
        boolean isMonitorable = Boolean.valueOf(monitorable);
        BasicComponentType type = (BasicComponentType)editor.createComponentType(typeCode, name, parentTypeID, superTypeID, isDeployable, isMonitorable);
        if (description != null && description.length() > 0) {
            type.setDescription(description);
        }
        ComponentType t2 = this.setDateHistory(type, element, editor);
        List componentTypeDefnElements = element.getChildren("ComponentTypeDefn");
        if (componentTypeDefnElements == null || componentTypeDefnElements.size() == 0) {
            componentTypeDefnElements = element.getChildren("PropertyDefinition");
            return this.addPropertyDefns(componentTypeDefnElements, t2, editor);
        }
        return this.addComponentTypeDefns(componentTypeDefnElements, t2, editor);
    }

    public ProductType createProductType(Element element, ConfigurationObjectEditor editor, Map componentTypeMap, String name) throws InvalidConfigurationElementException {
        Assertion.isNotNull(element);
        Assertion.isNotNull(editor);
        if (!element.getName().equals("ProductType")) {
            throw new InvalidConfigurationElementException("ERR.003.001.0036", CommonPlugin.Util.getString("ERR.003.001.0036", element.getName()), (Object)element);
        }
        String deployable = element.getAttributeValue("Deployable");
        if (name == null) {
            name = element.getAttributeValue("Name");
        }
        boolean isDeployable = Boolean.valueOf(deployable);
        List componentTypeIDs = element.getChildren("ComponentTypeID");
        ArrayList<ComponentType> componentTypes = new ArrayList<ComponentType>();
        Iterator iter = componentTypeIDs.iterator();
        while (iter.hasNext()) {
            Element componentTypeIDElement = (Element)iter.next();
            String componentTypeIDName = componentTypeIDElement.getAttributeValue("Name");
            ComponentTypeID componentTypeID = new ComponentTypeID(componentTypeIDName);
            ComponentType componentType = (ComponentType)componentTypeMap.get(componentTypeID);
            if (componentType == null) {
                throw new InvalidConfigurationElementException("ERR.003.001.0037", CommonPlugin.Util.getString("ERR.003.001.0037", new Object[]{componentTypeID, name}), (Object)element);
            }
            componentTypes.add(componentType);
        }
        ProductType type = editor.createProductType(name, componentTypes, isDeployable, false);
        return type;
    }

    public Configuration createConfiguration(Element element, ConfigurationObjectEditor editor, String name) throws InvalidConfigurationElementException {
        Assertion.isNotNull(element);
        Assertion.isNotNull(editor);
        if (!element.getName().equals("Configuration")) {
            throw new InvalidConfigurationElementException("ERR.003.001.0038", CommonPlugin.Util.getString("ERR.003.001.0038", element.getName()), (Object)element);
        }
        if (name == null) {
            name = element.getAttributeValue("Name");
        }
        Configuration config = editor.createConfiguration(name);
        config = (Configuration)this.setDateHistory(config, element, editor);
        config = (Configuration)this.addProperties(element, config, editor);
        return config;
    }

    public Element createConnectorBindingElement(ConnectorBinding connector, boolean isExportConfig) {
        Assertion.isNotNull(connector);
        Element connectorElement = this.createComponentObjectElement("Connector", connector);
        connectorElement.setAttribute("QueuedService", Boolean.valueOf(connector.isQueuedService()).toString());
        connectorElement.setAttribute("routingUUID", connector.getRoutingUUID());
        return connectorElement;
    }

    public ConnectorBinding createConnectorBinding(ConfigurationID configurationID, Element element, ConfigurationObjectEditor editor, String name, boolean isImportConfig) throws InvalidConfigurationElementException {
        Assertion.isNotNull(element);
        Assertion.isNotNull(editor);
        if (!element.getName().equals("Connector")) {
            throw new InvalidConfigurationElementException("ERR.003.001.0041", CommonPlugin.Util.getString("ERR.003.001.0041", element.getName()), (Object)element);
        }
        if (name == null) {
            name = element.getAttributeValue("Name");
        }
        String componentType = element.getAttributeValue("ComponentType");
        this.checkElementValue(componentType, name, "ERR.003.001.0057");
        ComponentTypeID id = new ComponentTypeID(componentType);
        String routingUUID = null;
        if (isImportConfig) {
            routingUUID = element.getAttributeValue("routingUUID");
        }
        ConnectorBinding defn = null;
        defn = editor.createConnectorComponent(configurationID, id, name, routingUUID);
        defn = (ConnectorBinding)this.setDateHistory(defn, element, editor);
        Element propertiesElement = element.getChild("Properties");
        if (propertiesElement != null) {
            return (ConnectorBinding)this.addProperties(propertiesElement, defn, editor);
        }
        return defn;
    }

    public ComponentDefn createServiceComponentDefn(Element element, Configuration config, ConfigurationObjectEditor editor, String name) throws InvalidConfigurationElementException {
        ConfigurationID configID = null;
        if (config != null) {
            configID = (ConfigurationID)config.getID();
        }
        return this.createServiceComponentDefn(element, configID, editor, name);
    }

    public ComponentDefn createServiceComponentDefn(Element element, ConfigurationID configID, ConfigurationObjectEditor editor, String name) throws InvalidConfigurationElementException {
        Assertion.isNotNull(element);
        Assertion.isNotNull(editor);
        Assertion.isNotNull(configID);
        if (!element.getName().equals("Service")) {
            throw new InvalidConfigurationElementException("ERR.003.001.0042", CommonPlugin.Util.getString("ERR.003.001.0042", element.getName()), (Object)element);
        }
        if (name == null) {
            name = element.getAttributeValue("Name");
        }
        String componentType = element.getAttributeValue("ComponentType");
        this.checkElementValue(componentType, name, "ERR.003.001.0058");
        ComponentTypeID id = new ComponentTypeID(componentType);
        String routingUUID = element.getAttributeValue("routingUUID");
        ComponentDefn defn = null;
        boolean isResourcePool = this.isResourcePool(componentType);
        if (configID != null) {
            defn = !isResourcePool ? (routingUUID == null ? editor.createServiceComponentDefn(configID, id, name) : editor.createServiceComponentDefn(configID, id, name, routingUUID)) : editor.createResourceDescriptor(configID, id, name);
        }
        defn = (ComponentDefn)this.setDateHistory(defn, element, editor);
        Element propertiesElement = element.getChild("Properties");
        if (propertiesElement != null) {
            return (ComponentDefn)this.addProperties(propertiesElement, defn, editor);
        }
        return defn;
    }

    private boolean isResourcePool(String componentTypeName) {
        boolean result = false;
        if (componentTypeName.equals("JDBC Resource Type") || componentTypeName.equals("JMS Resource Type") || componentTypeName.equals("Miscellaneous Resource Type") || componentTypeName.equals("Searchbase Resource Type")) {
            return true;
        }
        return result;
    }

    public ProductServiceConfig createProductServiceConfig(Element element, ConfigurationID configID, ConfigurationObjectEditor editor, String name) throws InvalidConfigurationElementException {
        Iterator iterator;
        Assertion.isNotNull(element);
        Assertion.isNotNull(editor);
        Assertion.isNotNull(configID);
        if (!element.getName().equals("PSC")) {
            throw new InvalidConfigurationElementException("ERR.003.001.0043", CommonPlugin.Util.getString("ERR.003.001.0043", element.getName()), (Object)element);
        }
        if (name == null) {
            name = element.getAttributeValue("Name");
        }
        String componentType = element.getAttributeValue("ComponentType");
        this.checkElementValue(componentType, name, "ERR.003.001.0059");
        ProductTypeID id = new ProductTypeID(componentType);
        ProductServiceConfig productServiceConfig = editor.createProductServiceConfig(configID, id, name);
        List serviceComponentDefnIDs = element.getChildren("Service");
        if (id.getFullName().equals("Connectors")) {
            iterator = serviceComponentDefnIDs.iterator();
            while (iterator.hasNext()) {
                Element serviceComponentDefnIDElement = (Element)iterator.next();
                String serviceComponentDefnName = serviceComponentDefnIDElement.getAttributeValue("Name");
                String enabled = serviceComponentDefnIDElement.getAttributeValue("IsEnabled");
                if (enabled == null) {
                    enabled = Boolean.TRUE.toString();
                }
                ConnectorBindingID serviceComponentDefnID = new ConnectorBindingID(configID, serviceComponentDefnName);
                productServiceConfig = editor.addServiceComponentDefn(productServiceConfig, serviceComponentDefnID);
                editor.setEnabled(serviceComponentDefnID, productServiceConfig, Boolean.valueOf(enabled));
            }
        } else {
            iterator = serviceComponentDefnIDs.iterator();
            while (iterator.hasNext()) {
                Element serviceComponentDefnIDElement = (Element)iterator.next();
                String serviceComponentDefnName = serviceComponentDefnIDElement.getAttributeValue("Name");
                String enabled = serviceComponentDefnIDElement.getAttributeValue("IsEnabled");
                if (enabled == null) {
                    enabled = Boolean.TRUE.toString();
                }
                ServiceComponentDefnID serviceComponentDefnID = new ServiceComponentDefnID(configID, serviceComponentDefnName);
                productServiceConfig = editor.addServiceComponentDefn(productServiceConfig, serviceComponentDefnID);
                editor.setEnabled(serviceComponentDefnID, productServiceConfig, Boolean.valueOf(enabled));
            }
        }
        productServiceConfig = (ProductServiceConfig)this.setDateHistory(productServiceConfig, element, editor);
        Element propertiesElement = element.getChild("Properties");
        if (propertiesElement != null) {
            productServiceConfig = (ProductServiceConfig)this.addProperties(propertiesElement, productServiceConfig, editor);
            return productServiceConfig;
        }
        return productServiceConfig;
    }

    public DeployedComponent createDeployedServiceComponent(Element element, ConfigurationID configID, HostID hostID, VMComponentDefnID vmID, ProductServiceConfigID pscID, Map componentTypeMap, ConfigurationObjectEditor editor) throws InvalidConfigurationElementException {
        Assertion.isNotNull(element);
        Assertion.isNotNull(editor);
        Assertion.isNotNull(configID);
        Assertion.isNotNull(hostID);
        Assertion.isNotNull(vmID);
        if (!element.getName().equals("Service")) {
            throw new InvalidConfigurationElementException("ERR.003.001.0044", CommonPlugin.Util.getString("ERR.003.001.0044", element.getName()), (Object)element);
        }
        String name = element.getAttributeValue("Name");
        this.checkElementValue(name, "NAME", "ERR.003.001.0048");
        String componentTypeIDString = element.getAttributeValue("ComponentType");
        this.checkElementValue(componentTypeIDString, name, "ERR.003.001.0049");
        ComponentType type = null;
        Iterator it = componentTypeMap.keySet().iterator();
        while (it.hasNext()) {
            ComponentTypeID id = (ComponentTypeID)it.next();
            if (!id.getFullName().equals(componentTypeIDString)) continue;
            type = (ComponentType)componentTypeMap.get(id);
            break;
        }
        if (type == null) {
            throw new InvalidConfigurationElementException("ERR.003.001.0050", CommonPlugin.Util.getString("ERR.003.001.0050", new Object[]{componentTypeIDString, name}), (Object)element);
        }
        ServiceComponentDefnID svcid = null;
        svcid = type.getComponentTypeCode() == 2 ? new ConnectorBindingID(configID, name) : new ServiceComponentDefnID(configID, name);
        DeployedComponent component = editor.createDeployedServiceComponent(name, configID, hostID, vmID, svcid, pscID, (ComponentTypeID)type.getID());
        component = (DeployedComponent)this.setDateHistory(component, element, editor);
        return component;
    }

    public DeployedComponent createDeployedVMComponentDefnx(Element element, ConfigurationID configID, HostID hostID, ComponentTypeID typeID, ConfigurationObjectEditor editor) throws InvalidConfigurationElementException {
        Assertion.isNotNull(element);
        Assertion.isNotNull(editor);
        Assertion.isNotNull(configID);
        Assertion.isNotNull(hostID);
        DeployedComponent component = null;
        if (!element.getName().equals("Process")) {
            throw new InvalidConfigurationElementException("ERR.003.001.0044", CommonPlugin.Util.getString("ERR.003.001.0044", element.getName()), (Object)element);
        }
        String name = element.getAttributeValue("Name");
        String componentTypeIDString = element.getAttributeValue("ComponentType");
        this.checkElementValue(componentTypeIDString, name, "ERR.003.001.0049");
        return component;
    }

    public DeployedComponent createDeployedComponent(Element element, Configuration config, ConfigurationObjectEditor editor, Map serviceComponentDefnMap, Map vmComponentDefnMap, Map componentTypeMap, String name) throws InvalidConfigurationElementException {
        throw new UnsupportedOperationException("Method createDeployedComponent is unsupported in 4.2");
    }

    public VMComponentDefn createVMComponentDefn(Element element, ConfigurationID configID, HostID hostID, ConfigurationObjectEditor editor, String name) throws InvalidConfigurationElementException {
        Assertion.isNotNull(element);
        Assertion.isNotNull(editor);
        Assertion.isNotNull(configID);
        if (!element.getName().equals("Process")) {
            throw new InvalidConfigurationElementException("A Configuration object cannot be created from a JDOM Element type: " + element.getName() + ".", (Object)element);
        }
        if (name == null) {
            name = element.getAttributeValue("Name");
        }
        String componentType = element.getAttributeValue("ComponentType");
        this.checkElementValue(componentType, name, "ERR.003.001.0060");
        ComponentTypeID id = new ComponentTypeID(componentType);
        VMComponentDefn defn = editor.createVMComponentDefn(configID, hostID, id, name);
        defn = (VMComponentDefn)this.setDateHistory(defn, element, editor);
        defn = (VMComponentDefn)this.addProperties(element, defn, editor);
        return defn;
    }

    public PropertyDefinition createPropertyDefinition(Element element) throws InvalidConfigurationElementException {
        if (!element.getName().equals("PropertyDefinition")) {
            throw new InvalidConfigurationElementException("A Configuration object cannot be created from a JDOM Element type: " + element.getName() + ".", (Object)element);
        }
        String nameString = element.getAttributeValue("Name");
        String displayNameString = element.getAttributeValue("DisplayName");
        String shortDescriptionString = XMLConfig_42_HelperImpl.getAttributeString(element, "ShortDescription", PropertyDefinitionImpl.DEFAULT_SHORT_DESCRIPTION);
        String defaultValueString = XMLConfig_42_HelperImpl.getAttributeString(element, "DefaultValue", PropertyDefinitionImpl.DEFAULT_DEFAULT_VALUE);
        String valueDelimiterString = XMLConfig_42_HelperImpl.getAttributeString(element, "ValueDelimiter", ",");
        String multiplicityString = XMLConfig_42_HelperImpl.getAttributeString(element, "Multiplicity", "0..1");
        Multiplicity mult = null;
        try {
            mult = Multiplicity.getInstance(multiplicityString);
        }
        catch (MultiplicityExpressionException e2) {
            throw new InvalidConfigurationElementException((Throwable)e2, "The PropertyDefinition object: " + nameString + " could not be created because the multiplicity definition: '" + multiplicityString + " is not a valid multiplicity definition.", (Object)element);
        }
        String propertyTypeString = XMLConfig_42_HelperImpl.getAttributeString(element, "PropertyType", PropertyDefinitionImpl.DEFAULT_TYPE.getDisplayName());
        PropertyType type = PropertyType.getInstance(propertyTypeString);
        boolean isConstrainedToAllowedValues = XMLConfig_42_HelperImpl.getAttributeBoolean(element, "IsConstrainedToAllowedValues", true);
        boolean isExpert = XMLConfig_42_HelperImpl.getAttributeBoolean(element, "IsExpert", false);
        boolean isHidden = XMLConfig_42_HelperImpl.getAttributeBoolean(element, "IsHidden", false);
        boolean isMasked = XMLConfig_42_HelperImpl.getAttributeBoolean(element, "IsMasked", false);
        boolean isModifiable = XMLConfig_42_HelperImpl.getAttributeBoolean(element, "IsModifiable", true);
        boolean isPreferred = XMLConfig_42_HelperImpl.getAttributeBoolean(element, "IsPreferred", false);
        boolean requiresRestart = XMLConfig_42_HelperImpl.getAttributeBoolean(element, "RequiresRestart", false);
        List allowedValuesElements = element.getChildren("AllowedValue");
        ArrayList<String> allowedValues = new ArrayList<String>(allowedValuesElements.size());
        Iterator iterator = allowedValuesElements.iterator();
        while (iterator.hasNext()) {
            Element allowedValueElement = (Element)iterator.next();
            allowedValues.add(allowedValueElement.getText());
        }
        PropertyDefinitionImpl defn = new PropertyDefinitionImpl(nameString, displayNameString, type, mult, shortDescriptionString, defaultValueString, allowedValues, valueDelimiterString, isHidden, isPreferred, isExpert, isModifiable);
        defn.setMasked(isMasked);
        defn.setConstrainedToAllowedValues(isConstrainedToAllowedValues);
        defn.setRequiresRestart(requiresRestart);
        return defn;
    }

    private static String getAttributeString(Element element, String attributeName, String defaultValue) {
        String stringValue = element.getAttributeValue(attributeName);
        if (stringValue == null) {
            return defaultValue;
        }
        return stringValue;
    }

    private static boolean getAttributeBoolean(Element element, String attributeName, boolean defaultValue) {
        String stringValue = element.getAttributeValue(attributeName);
        if (stringValue == null) {
            return defaultValue;
        }
        return Boolean.valueOf(stringValue);
    }

    public ComponentObject addProperties(Element propertiesElement, ComponentObject object, ConfigurationObjectEditor editor) throws InvalidConfigurationElementException {
        if (!propertiesElement.getName().equals("Properties") && (propertiesElement = propertiesElement.getChild("Properties")) == null) {
            throw new InvalidConfigurationElementException("A Properties object cannot be created from a null properties element", (Object)null);
        }
        Properties props = this.getProperties(propertiesElement);
        object = editor.modifyProperties(object, props, 1);
        return object;
    }

    private Properties getProperties(Element propertiesElement) {
        Properties props = new Properties();
        List properties = propertiesElement.getChildren("Property");
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            Element propertyElement = (Element)iterator.next();
            String propertyName = propertyElement.getAttributeValue("Name");
            String propertyValue = propertyElement.getText();
            props.setProperty(propertyName, propertyValue);
        }
        return props;
    }

    private ComponentType addComponentTypeDefns(Collection componentTypeDefnElements, ComponentType type, ConfigurationObjectEditor editor) throws InvalidConfigurationElementException {
        ArrayList<ComponentTypeDefn> componentTypeDefns = new ArrayList<ComponentTypeDefn>(componentTypeDefnElements.size());
        Iterator iterator = componentTypeDefnElements.iterator();
        while (iterator.hasNext()) {
            Element componentTypeDefnElement = (Element)iterator.next();
            Element propertyDefinitionElement = componentTypeDefnElement.getChild("PropertyDefinition");
            PropertyDefinition propDefn = this.createPropertyDefinition(propertyDefinitionElement);
            componentTypeDefns.add(editor.createComponentTypeDefn(type, propDefn, false));
        }
        return editor.setComponentTypeDefinitions(type, componentTypeDefns);
    }

    private ComponentType addPropertyDefns(Collection propertyDefnElements, ComponentType type, ConfigurationObjectEditor editor) throws InvalidConfigurationElementException {
        ArrayList<ComponentTypeDefn> componentTypeDefns = new ArrayList<ComponentTypeDefn>(propertyDefnElements.size());
        Iterator iterator = propertyDefnElements.iterator();
        while (iterator.hasNext()) {
            Element propertyDefinitionElement = (Element)iterator.next();
            PropertyDefinition propDefn = this.createPropertyDefinition(propertyDefinitionElement);
            componentTypeDefns.add(editor.createComponentTypeDefn(type, propDefn, false));
        }
        return editor.setComponentTypeDefinitions(type, componentTypeDefns);
    }

    public void orderComponentTypeElementList(List componentTypeElements) {
        ComponentTypeElementComparator comparator = new ComponentTypeElementComparator();
        Collections.sort(componentTypeElements, comparator);
    }

    private void checkElementValue(String value, String name, String errorKey) throws InvalidConfigurationElementException {
        if (value == null || value.trim().length() > 0) {
            if (name != null) {
                if (value == null) {
                    Assertion.isNotNull(value, CommonPlugin.Util.getString(errorKey, name));
                }
            } else if (value == null) {
                Assertion.isNotNull(value, CommonPlugin.Util.getString(errorKey));
            }
        }
    }

    class ComponentTypeElementComparator
    implements Comparator {
        ComponentTypeElementComparator() {
        }

        public int compare(Object thisObject, Object thatObject) {
            if (thisObject instanceof Element) {
                Element thisElement = (Element)thisObject;
                if (thatObject instanceof Element) {
                    Element thatElement = (Element)thatObject;
                    String thatSuperID = this.getElementSuperID(thatElement);
                    String thisSuperID = this.getElementSuperID(thisElement);
                    String thatID = this.getElementID(thatElement);
                    String thisID = this.getElementID(thisElement);
                    if (thisSuperID != null && thisSuperID.equals(thatID)) {
                        return 1;
                    }
                    if (thatSuperID != null && thatSuperID.equals(thisID)) {
                        return -1;
                    }
                    return 0;
                }
            }
            return 0;
        }

        private String getElementSuperID(Element componentTypeElement) {
            return componentTypeElement.getAttributeValue("SuperComponentType");
        }

        private String getElementID(Element componentTypeElement) {
            return componentTypeElement.getAttributeValue("Name");
        }
    }
}

