/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.connection;

import com.metamatrix.common.connection.ManagedConnection;
import com.metamatrix.common.connection.ManagedConnectionException;
import com.metamatrix.common.connection.TransactionFactory;
import com.metamatrix.common.connection.TransactionInterface;
import com.metamatrix.common.properties.UnmodifiableProperties;
import com.metamatrix.core.util.ReflectionHelper;
import java.util.Properties;

public class TransactionMgr {
    public static final String FACTORY = "metamatrix.common.connection.transaction.factory";
    private TransactionFactory connectionFactory;
    private Properties properties;
    private String userName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionMgr(Properties properties, String userName) throws ManagedConnectionException {
        this.userName = userName;
        if (properties == null) {
            this.properties = new Properties();
        } else {
            Properties properties2 = properties;
            synchronized (properties2) {
                this.properties = (Properties)properties.clone();
            }
        }
        if (!(this.properties instanceof UnmodifiableProperties)) {
            this.properties = new UnmodifiableProperties(this.properties);
        }
        String connectionFactoryClassName = this.properties.getProperty(FACTORY);
        try {
            this.connectionFactory = (TransactionFactory)ReflectionHelper.create(connectionFactoryClassName, null, this.getClass().getClassLoader());
        }
        catch (Exception e2) {
            throw new ManagedConnectionException(e2);
        }
    }

    public TransactionInterface getReadTransaction() throws ManagedConnectionException {
        ManagedConnection connection = this.connectionFactory.createConnection(this.properties, this.userName);
        connection.open();
        connection.setForRead();
        return this.connectionFactory.createTransaction(connection, true);
    }

    public TransactionInterface getWriteTransaction() throws ManagedConnectionException {
        ManagedConnection connection = this.connectionFactory.createConnection(this.properties, this.userName);
        connection.open();
        return this.connectionFactory.createTransaction(connection, false);
    }
}

