/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.extensionmodule.protocol;

import com.metamatrix.common.extensionmodule.protocol.extensionjar.Handler;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class URLFactory {
    public static final String MM_JAR_PROTOCOL = "extensionjar";
    private static final String SEPARATOR = ":";
    private static final String QUESTION_MARK = "?";

    private URLFactory() {
    }

    public static String getFileName(String url) {
        String filename = url;
        if (filename.indexOf("extensionjar:") >= 0) {
            filename = filename.substring(url.lastIndexOf(SEPARATOR) + SEPARATOR.length());
        }
        if (filename.indexOf(QUESTION_MARK) >= 0) {
            filename = filename.substring(0, filename.indexOf(QUESTION_MARK));
        }
        return filename;
    }

    public static URL parseURL(URL context, String url) throws MalformedURLException {
        URL result = null;
        if (url.indexOf("extensionjar:") >= 0) {
            String filename = url.substring(url.lastIndexOf(SEPARATOR) + SEPARATOR.length());
            result = new URL(MM_JAR_PROTOCOL, "", -1, filename, new Handler());
        } else {
            result = new URL(context, url);
        }
        return result;
    }

    public static URL parseURL(String url) throws MalformedURLException {
        return URLFactory.parseURL(null, url);
    }

    public static URL[] parseURLs(List urls) throws MalformedURLException {
        URL[] result = new URL[urls.size()];
        Iterator urlIter = urls.iterator();
        int i2 = 0;
        while (urlIter.hasNext()) {
            result[i2] = URLFactory.parseURL((String)urlIter.next());
            ++i2;
        }
        return result;
    }

    public static URL[] parseURLs(String delimitedURLs, String delimiter) throws MalformedURLException {
        if (delimiter == null) {
            delimiter = " ";
        }
        StringTokenizer toke = new StringTokenizer(delimitedURLs, delimiter);
        ArrayList<String> urlStrings = new ArrayList<String>(toke.countTokens());
        while (toke.hasMoreElements()) {
            String urlString = toke.nextToken();
            urlStrings.add(urlString);
        }
        return URLFactory.parseURLs(urlStrings);
    }

    static {
        String propKey = "java.protocol.handler.pkgs";
        String directory = "com.metamatrix.common.extensionmodule.protocol";
        String value = System.getProperty(propKey);
        if (value == null) {
            System.setProperty(propKey, directory);
        } else if (value.trim().length() == 0) {
            System.setProperty(propKey, directory);
        } else if (value.indexOf(directory) < 0) {
            value = value + "|" + directory;
            System.setProperty(propKey, value);
        }
    }
}

