/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.id;

import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.core.id.UUID;
import com.metamatrix.internal.core.id.EmbeddedUUIDFactory;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;

public class UUIDGeneratorFactory {
    public static void main(String[] args) {
        int nGen = args.length > 0 ? Integer.parseInt(args[0]) : 10;
        String outfile = args.length > 1 ? args[1] : null;
        EmbeddedUUIDFactory generator = new EmbeddedUUIDFactory();
        long startTime = System.currentTimeMillis();
        System.out.println("\r\nStarting " + new Date() + " ...\n");
        System.out.println("Generating " + nGen + " UUIDs ...");
        UUID uuid = null;
        HashSet<UUID> uuids = new HashSet<UUID>();
        HashSet<UUID> duplicates = new HashSet<UUID>();
        Properties props = new Properties();
        for (int k2 = 0; k2 < nGen; ++k2) {
            uuid = (UUID)generator.create();
            if (uuids.contains(uuid)) {
                duplicates.add(uuid);
            } else {
                uuids.add(uuid);
            }
            if (!generator.validate(uuid)) {
                System.out.println("UUID is invalid!");
                continue;
            }
            props.put("(UUID" + k2 + ")", uuid.exportableForm());
        }
        if (outfile != null && outfile.length() > 0) {
            try {
                PropertiesUtils.print(outfile, props);
            }
            catch (IOException err) {
                err.printStackTrace();
                System.exit(-1);
            }
        } else {
            System.out.println("No output file generated containing the UUIDs");
        }
        long endTime = System.currentTimeMillis();
        System.out.println("\nGenerated " + generator.getCount() + " UUIDs in " + (float)(endTime - startTime) / 1000.0f + " seconds (" + 1000.0f * (float)nGen / (float)(endTime - startTime) + "/second).");
    }
}

