/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.jdbc.metadata;

import com.metamatrix.common.CommonPlugin;
import java.util.HashMap;
import java.util.Map;

public class ColumnType {
    public static final ColumnType COLUMN_PSEUDO_UNKNOWN = new ColumnType(0, "Unknown Pseudo Column");
    public static final ColumnType COLUMN_PSEUDO = new ColumnType(2, "Pseudo Column");
    public static final ColumnType COLUMN_NOT_PSEUDO = new ColumnType(1, "Non-Pseudo Column");
    private int value;
    private String displayName;
    private static final Map BY_NAME = new HashMap();
    private static final Map BY_VALUE = new HashMap();

    private ColumnType(int value, String displayName) {
        this.value = value;
        this.displayName = displayName;
    }

    public static ColumnType getInstance(String displayName) {
        return (ColumnType)BY_NAME.get(displayName);
    }

    public static ColumnType getInstance(int value) {
        return (ColumnType)BY_VALUE.get(new Integer(value));
    }

    public String getDisplayName() {
        return this.displayName;
    }

    private static void add(ColumnType instance) {
        BY_NAME.put(instance.getDisplayName(), instance);
        BY_VALUE.put(new Integer(instance.value), instance);
    }

    public int compareTo(Object obj) {
        ColumnType that = (ColumnType)obj;
        if (obj == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.015.0022"));
        }
        return this.value - that.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ColumnType) {
            ColumnType that = (ColumnType)obj;
            return this.value == that.value;
        }
        return false;
    }

    public final int hashCode() {
        return this.value;
    }

    public final String toString() {
        return this.getDisplayName();
    }

    static {
        ColumnType.add(COLUMN_PSEUDO_UNKNOWN);
        ColumnType.add(COLUMN_PSEUDO);
        ColumnType.add(COLUMN_NOT_PSEUDO);
    }
}

