/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.jgroups;

import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.util.NetUtils;
import com.metamatrix.common.util.VMNaming;
import com.metamatrix.core.util.StringUtil;
import java.util.Properties;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;

public class JGroupsManager {
    private static String properties;
    private static final String DEFAULT_UDP_MCAST_SUPPORTED = "true";
    private static final String DEFAULT_UDP_MCAST_ADDR_PREFIX = "224.224.223.";
    private static final String DEFAULT_UDP_MCAST_PORT = "5555";
    private static final String ALL_INTERFACES_ADDR = "0.0.0.0";
    private static final String DEFAULT_PING_GOSSIP_HOST = "localhost";
    private static final String DEFAULT_PING_GOSSIP_PORT = "5555";
    private static final String DEFAULT_PING_GOSSIP_REFRESH = "15000";
    private static final String DEFAULT_PING_TIMEOUT = "2000";
    private static final String DEFAULT_PING_NUM_INITIAL_MEMBERS = "3";
    private static final String DEFAULT_JGROUPS_OTHER_SETTINGS = "MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;retransmit_timeout=300,600,1200,2400,4800):UNICAST(timeout=5000):pbcast.STABLE(desired_avg_gossip=20000):FRAG(frag_size=4096;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true):pbcast.STATE_TRANSFER";
    public static final String UDP_MCAST_SUPPORTED_PROPERTY = "udp.multicast_supported";
    public static final String UDP_MCAST_MESSAGEBUS_PORT_PROPERTY = "udp.mcast_messagebus_port";
    public static final String UDP_MCAST_JNDI_PORT_PROPERTY = "udp.mcast_jndi_port";
    public static final String UDP_MCAST_ADDR_PROPERTY = "udp.mcast_addr";
    public static final String PING_GOSSIP_HOST_PROPERTY = "ping.gossip_host";
    public static final String PING_GOSSIP_PORT_PROPERTY = "ping.gossip_port";
    public static final String PING_GOSSIP_REFRESH_PROPERTY = "ping.gossip_refresh";
    public static final String PING_GOSSIP_TIMEOUT_PROPERTY = "ping.gossip_timout";
    public static final String PING_GOSSIP_NUM_INITIAL_MEMBERS_PROPERTY = "ping.gossip_initialmembers";
    public static final String JGROUPS_OTHER_SETTINGS_PROPERTY = "jgroups.other.channel.settings";
    public static final String MESSAGE_BUS_CHANNEL = "MessageBus";
    public static final String JNDI_REGISTRY_CHANNEL = "JNDIRegistry";
    public static final String BIND_ADDRESS_PROPERTY = "jgroups.bind.address";
    private static String UDP_MCAST_SUPPORTED;
    private static String UDP_MCAST_ADDR;
    private static String UDP_MCAST_PORT;
    private static Boolean UDP_RECV_ON_ALL_INTERFACES;
    private static String PING_GOSSIP_HOST;
    private static String PING_GOSSIP_PORT;
    private static String PING_GOSSIP_REFRESH;
    private static String PING_TIMEOUT;
    private static String PING_NUM_INITIAL_MEMBERS;
    private static String JGROUPS_OTHER_SETTINGS;
    private static String BIND_ADDRESS;

    public static JChannel createJChannel(String name) throws ChannelException {
        JChannel channel = new JChannel(JGroupsManager.getChannelProperties(name));
        String systemName = null;
        try {
            systemName = CurrentConfiguration.getSystemName();
        }
        catch (ConfigurationException err) {
            systemName = "Default";
        }
        channel.connect(systemName + "_" + name);
        return channel;
    }

    public static synchronized String getChannelProperties(String name) {
        String port = null;
        port = MESSAGE_BUS_CHANNEL.equals(name) ? UDP_MCAST_MESSAGEBUS_PORT_PROPERTY : UDP_MCAST_JNDI_PORT_PROPERTY;
        try {
            Properties configProps = CurrentConfiguration.getResourceProperties("JGroups");
            UDP_MCAST_SUPPORTED = configProps.getProperty(UDP_MCAST_SUPPORTED_PROPERTY, DEFAULT_UDP_MCAST_SUPPORTED);
            UDP_MCAST_PORT = configProps.getProperty(port, "5555");
            PING_GOSSIP_HOST = configProps.getProperty(PING_GOSSIP_HOST_PROPERTY, DEFAULT_PING_GOSSIP_HOST);
            PING_GOSSIP_PORT = configProps.getProperty(PING_GOSSIP_PORT_PROPERTY, "5555");
            PING_GOSSIP_REFRESH = configProps.getProperty(PING_GOSSIP_REFRESH_PROPERTY, DEFAULT_PING_GOSSIP_REFRESH);
            PING_TIMEOUT = configProps.getProperty(PING_GOSSIP_TIMEOUT_PROPERTY, DEFAULT_PING_TIMEOUT);
            PING_NUM_INITIAL_MEMBERS = configProps.getProperty(PING_GOSSIP_NUM_INITIAL_MEMBERS_PROPERTY, DEFAULT_PING_NUM_INITIAL_MEMBERS);
            JGROUPS_OTHER_SETTINGS = configProps.getProperty(JGROUPS_OTHER_SETTINGS_PROPERTY, DEFAULT_JGROUPS_OTHER_SETTINGS);
            BIND_ADDRESS = JGroupsManager.getBindAddress();
            if (UDP_MCAST_ADDR == null && ((UDP_MCAST_ADDR = configProps.getProperty(UDP_MCAST_ADDR_PROPERTY)) == null || UDP_MCAST_ADDR.length() == 0)) {
                String lastNode = StringUtil.getLastToken(NetUtils.getHostAddress(), ".");
                UDP_MCAST_ADDR = DEFAULT_UDP_MCAST_ADDR_PREFIX + lastNode;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        properties = UDP_MCAST_SUPPORTED.equalsIgnoreCase(DEFAULT_UDP_MCAST_SUPPORTED) ? (UDP_RECV_ON_ALL_INTERFACES.booleanValue() ? "UDP(mcast_addr=" + UDP_MCAST_ADDR + ";mcast_port=" + UDP_MCAST_PORT + ";ip_ttl=32;receive_on_all_interfaces=" + UDP_MCAST_SUPPORTED.toString() + ";" + "mcast_send_buf_size=150000;mcast_recv_buf_size=80000):" + "PING(timeout=" + PING_TIMEOUT + ";num_initial_members=" + PING_NUM_INITIAL_MEMBERS + "):" : "UDP(mcast_addr=" + UDP_MCAST_ADDR + ";mcast_port=" + UDP_MCAST_PORT + ";ip_ttl=32;bind_addr=" + BIND_ADDRESS + ";" + "mcast_send_buf_size=150000;mcast_recv_buf_size=80000):" + "PING(timeout=" + PING_TIMEOUT + ";num_initial_members=" + PING_NUM_INITIAL_MEMBERS + "):") : "UDP(ip_mcast=false;mcast_addr=" + UDP_MCAST_ADDR + ";mcast_port=" + UDP_MCAST_PORT + ";bind_addr=" + BIND_ADDRESS + "):" + "PING(gossip_host=" + PING_GOSSIP_HOST + ";gossip_port=" + PING_GOSSIP_PORT + ";gossip_refresh=" + PING_GOSSIP_REFRESH + ";" + "timeout=" + PING_TIMEOUT + ";num_initial_members=" + PING_NUM_INITIAL_MEMBERS + "):";
        properties = properties + JGROUPS_OTHER_SETTINGS;
        return properties;
    }

    private static final String getBindAddress() {
        String bindAddress = System.getProperty(BIND_ADDRESS_PROPERTY);
        if (bindAddress == null) {
            bindAddress = VMNaming.getBindAddress();
        }
        if (bindAddress == null) {
            System.out.println("WARNING: Unable to set jgroups.bind.address, will set to 127.0.0.1");
            bindAddress = "127.0.0.1";
        }
        if (bindAddress.equalsIgnoreCase(ALL_INTERFACES_ADDR)) {
            UDP_RECV_ON_ALL_INTERFACES = Boolean.TRUE;
        }
        return bindAddress;
    }

    static {
        UDP_MCAST_SUPPORTED = DEFAULT_UDP_MCAST_SUPPORTED;
        UDP_MCAST_ADDR = null;
        UDP_MCAST_PORT = "5555";
        UDP_RECV_ON_ALL_INTERFACES = Boolean.FALSE;
        PING_GOSSIP_HOST = DEFAULT_PING_GOSSIP_HOST;
        PING_GOSSIP_PORT = "5555";
        PING_GOSSIP_REFRESH = DEFAULT_PING_GOSSIP_REFRESH;
        PING_TIMEOUT = DEFAULT_PING_TIMEOUT;
        PING_NUM_INITIAL_MEMBERS = DEFAULT_PING_NUM_INITIAL_MEMBERS;
        JGROUPS_OTHER_SETTINGS = DEFAULT_JGROUPS_OTHER_SETTINGS;
        BIND_ADDRESS = null;
    }
}

