/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.pooling.appserver;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.api.ResourceDescriptor;
import com.metamatrix.common.jdbc.JDBCPlatform;
import com.metamatrix.common.jdbc.JDBCPlatformFactory;
import com.metamatrix.common.pooling.api.Resource;
import com.metamatrix.common.pooling.api.ResourceAdapter;
import com.metamatrix.common.pooling.api.exception.ResourcePoolException;
import com.metamatrix.common.pooling.appserver.AppServerJDBCResource;
import java.sql.Connection;

public abstract class AppServerJDBCResourceAdapter
implements ResourceAdapter {
    private boolean decryptRequired = false;
    private static final boolean DEFAULT_DECRYPTION_REQUIRED = false;

    public Resource createResource(Object physicalResource) throws ResourcePoolException {
        try {
            Connection conn = this.convertToConnection(physicalResource);
            JDBCPlatform jdbcPlatform = JDBCPlatformFactory.getPlatform(conn);
            AppServerJDBCResource resource = new AppServerJDBCResource(conn, jdbcPlatform);
            return resource;
        }
        catch (Exception e2) {
            throw new ResourcePoolException((Throwable)e2, "ERR.003.002.0009", CommonPlugin.Util.getString("ERR.003.002.0009", physicalResource.getClass().getName()));
        }
    }

    public abstract Object createPhysicalResourceObject(ResourceDescriptor var1) throws ResourcePoolException;

    public void closePhyicalResourceObject(Resource resource) throws ResourcePoolException {
    }

    private Connection convertToConnection(Object obj) throws ResourcePoolException {
        if (obj instanceof Connection) {
            return (Connection)obj;
        }
        throw new ResourcePoolException(CommonPlugin.Util.getString("ERR.003.002.0009", obj.getClass().getName()));
    }

    public boolean isDecryptRequired() {
        return this.decryptRequired;
    }

    protected void setDecryptRequired(boolean decryptRequired) {
        this.decryptRequired = decryptRequired;
    }
}

