/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.pooling.jdbc;

import com.metamatrix.common.pooling.jdbc.JDBCApplicationConnectionResource;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;

public class ApplicationPreparedStatement
implements PreparedStatement {
    private PreparedStatement preparedStatement;
    private JDBCApplicationConnectionResource connection;
    private String sql = null;
    private Hashtable params = new Hashtable();
    private static boolean sqlTracing = false;
    public static final String SQL_TRACING_PROPERTY = "sqlTracing";

    static void enableSQLTracing() {
        System.out.println("ApplicationPreparedStatement.enableSQLTracing: SQL tracking on");
        sqlTracing = true;
    }

    static void disableSQLTracing() {
        System.out.println("ApplicationPreparedStatement.disableSQLTracing: tracking off");
        sqlTracing = false;
    }

    public ApplicationPreparedStatement(PreparedStatement preparedStatement, String sql, JDBCApplicationConnectionResource connection) {
        this.preparedStatement = preparedStatement;
        this.sql = sql;
        this.connection = connection;
    }

    private void setParam(int index, Object param) {
        if (param != null) {
            this.params.put(new Integer(index), param);
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer("ApplicationPreparedStatement:");
        result.append("sql='" + this.sql + "'");
        Enumeration keys = this.params.keys();
        TreeSet set = new TreeSet();
        while (keys.hasMoreElements()) {
            set.add(keys.nextElement());
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Integer key = (Integer)iterator.next();
            Object value = this.params.get(key);
            result.append("\tparameter[" + key + "]=>" + value + "<");
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery() throws SQLException {
        ResultSet result = null;
        boolean finished = false;
        this.printDebugInfo();
        try {
            result = this.preparedStatement.executeQuery();
            finished = true;
        }
        finally {
            if (!finished) {
                System.out.println(this);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() throws SQLException {
        int result = 0;
        boolean finished = false;
        this.printDebugInfo();
        try {
            result = this.preparedStatement.executeUpdate();
            finished = true;
        }
        finally {
            if (!finished) {
                System.out.println(this);
            }
        }
        return result;
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.preparedStatement.setNull(parameterIndex, sqlType);
    }

    public void setBoolean(int parameterIndex, boolean x2) throws SQLException {
        this.preparedStatement.setBoolean(parameterIndex, x2);
        this.setParam(parameterIndex, x2);
    }

    public void setByte(int parameterIndex, byte x2) throws SQLException {
        this.preparedStatement.setByte(parameterIndex, x2);
        this.setParam(parameterIndex, new Byte(x2));
    }

    public void setShort(int parameterIndex, short x2) throws SQLException {
        this.preparedStatement.setShort(parameterIndex, x2);
        this.setParam(parameterIndex, new Short(x2));
    }

    public void setInt(int parameterIndex, int x2) throws SQLException {
        this.preparedStatement.setInt(parameterIndex, x2);
        this.setParam(parameterIndex, new Integer(x2));
    }

    public void setLong(int parameterIndex, long x2) throws SQLException {
        this.preparedStatement.setLong(parameterIndex, x2);
        this.setParam(parameterIndex, new Long(x2));
    }

    public void setFloat(int parameterIndex, float x2) throws SQLException {
        this.preparedStatement.setFloat(parameterIndex, x2);
        this.setParam(parameterIndex, new Float(x2));
    }

    public void setDouble(int parameterIndex, double x2) throws SQLException {
        this.preparedStatement.setDouble(parameterIndex, x2);
        this.setParam(parameterIndex, new Double(x2));
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x2) throws SQLException {
        this.preparedStatement.setBigDecimal(parameterIndex, x2);
        this.setParam(parameterIndex, x2);
    }

    public void setString(int parameterIndex, String x2) throws SQLException {
        if (x2 != null && x2.length() == 0) {
            this.preparedStatement.setNull(parameterIndex, 12);
        } else {
            this.preparedStatement.setString(parameterIndex, x2);
        }
        this.setParam(parameterIndex, x2);
    }

    public void setBytes(int parameterIndex, byte[] x2) throws SQLException {
        this.preparedStatement.setBytes(parameterIndex, x2);
        this.setParam(parameterIndex, x2);
    }

    public void setDate(int parameterIndex, Date x2) throws SQLException {
        this.preparedStatement.setDate(parameterIndex, x2);
        this.setParam(parameterIndex, x2);
    }

    public void setTime(int parameterIndex, Time x2) throws SQLException {
        this.preparedStatement.setTime(parameterIndex, x2);
        this.setParam(parameterIndex, x2);
    }

    public void setTimestamp(int parameterIndex, Timestamp x2) throws SQLException {
        this.preparedStatement.setTimestamp(parameterIndex, x2);
        this.setParam(parameterIndex, x2);
    }

    public void setAsciiStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        this.preparedStatement.setAsciiStream(parameterIndex, x2, length);
        this.setParam(parameterIndex, x2);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        this.preparedStatement.setUnicodeStream(parameterIndex, x2, length);
        this.setParam(parameterIndex, x2);
    }

    public void setBinaryStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        this.preparedStatement.setBinaryStream(parameterIndex, x2, length);
        this.setParam(parameterIndex, x2);
    }

    public void clearParameters() throws SQLException {
        this.preparedStatement.clearParameters();
    }

    public void setObject(int parameterIndex, Object x2, int targetSqlType, int scale) throws SQLException {
        this.preparedStatement.setObject(parameterIndex, x2, targetSqlType, scale);
        this.setParam(parameterIndex, x2);
    }

    public void setObject(int parameterIndex, Object x2, int targetSqlType) throws SQLException {
        this.preparedStatement.setObject(parameterIndex, x2, targetSqlType);
        this.setParam(parameterIndex, x2);
    }

    public void setObject(int parameterIndex, Object x2) throws SQLException {
        this.preparedStatement.setObject(parameterIndex, x2);
        this.setParam(parameterIndex, x2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        boolean result = false;
        boolean finished = false;
        this.printDebugInfo();
        try {
            result = this.preparedStatement.execute();
            finished = true;
        }
        finally {
            if (!finished) {
                System.out.println(this);
            }
        }
        return result;
    }

    public void addBatch() throws SQLException {
        this.preparedStatement.addBatch();
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.preparedStatement.setCharacterStream(parameterIndex, reader, length);
        this.setParam(parameterIndex, reader);
    }

    public void setRef(int i2, Ref x2) throws SQLException {
        this.preparedStatement.setRef(i2, x2);
    }

    public void setBlob(int i2, Blob x2) throws SQLException {
        this.preparedStatement.setBlob(i2, x2);
        this.setParam(i2, x2);
    }

    public void setClob(int i2, Clob x2) throws SQLException {
        this.preparedStatement.setClob(i2, x2);
        this.setParam(i2, x2);
    }

    public void setArray(int i2, Array x2) throws SQLException {
        this.preparedStatement.setArray(i2, x2);
        this.setParam(i2, x2);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.preparedStatement.getMetaData();
    }

    public void setDate(int parameterIndex, Date x2, Calendar cal) throws SQLException {
        this.preparedStatement.setDate(parameterIndex, x2, cal);
        this.setParam(parameterIndex, x2);
    }

    public void setTime(int parameterIndex, Time x2, Calendar cal) throws SQLException {
        this.preparedStatement.setTime(parameterIndex, x2, cal);
        this.setParam(parameterIndex, x2);
    }

    public void setTimestamp(int parameterIndex, Timestamp x2, Calendar cal) throws SQLException {
        this.preparedStatement.setTimestamp(parameterIndex, x2, cal);
        this.setParam(parameterIndex, x2);
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.preparedStatement.setNull(paramIndex, sqlType, typeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery(String sql) throws SQLException {
        ResultSet result = null;
        boolean finished = false;
        this.printDebugInfo();
        try {
            result = this.preparedStatement.executeQuery(sql);
            finished = true;
        }
        finally {
            if (!finished) {
                System.out.println(this);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql) throws SQLException {
        int result = 0;
        boolean finished = false;
        this.printDebugInfo();
        try {
            result = this.preparedStatement.executeUpdate(sql);
            finished = true;
        }
        finally {
            if (!finished) {
                System.out.println(this);
            }
        }
        return result;
    }

    public void close() throws SQLException {
        this.preparedStatement.close();
        this.params = null;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.preparedStatement.getMaxFieldSize();
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.preparedStatement.setMaxFieldSize(max);
    }

    public int getMaxRows() throws SQLException {
        return this.preparedStatement.getMaxRows();
    }

    public void setMaxRows(int max) throws SQLException {
        this.preparedStatement.setMaxRows(max);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.preparedStatement.setEscapeProcessing(enable);
    }

    public int getQueryTimeout() throws SQLException {
        return this.preparedStatement.getQueryTimeout();
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.preparedStatement.setQueryTimeout(seconds);
    }

    public void cancel() throws SQLException {
        this.preparedStatement.cancel();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.preparedStatement.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.preparedStatement.clearWarnings();
    }

    public void setCursorName(String name) throws SQLException {
        this.preparedStatement.setCursorName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql) throws SQLException {
        boolean result = false;
        boolean finished = false;
        this.printDebugInfo();
        try {
            result = this.preparedStatement.execute(sql);
            finished = true;
        }
        finally {
            if (!finished) {
                System.out.println(this);
            }
        }
        return result;
    }

    public ResultSet getResultSet() throws SQLException {
        return this.preparedStatement.getResultSet();
    }

    public int getUpdateCount() throws SQLException {
        return this.preparedStatement.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        return this.preparedStatement.getMoreResults();
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.preparedStatement.setFetchDirection(direction);
    }

    public int getFetchDirection() throws SQLException {
        return this.preparedStatement.getFetchDirection();
    }

    public void setFetchSize(int rows) throws SQLException {
        this.preparedStatement.setFetchSize(rows);
    }

    public int getFetchSize() throws SQLException {
        return this.preparedStatement.getFetchSize();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.preparedStatement.getResultSetConcurrency();
    }

    public int getResultSetType() throws SQLException {
        return this.preparedStatement.getResultSetType();
    }

    public void addBatch(String sql) throws SQLException {
        this.preparedStatement.addBatch(sql);
    }

    public void clearBatch() throws SQLException {
        this.preparedStatement.clearBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public int[] executeBatch() throws SQLException {
        void var1_2;
        boolean finished = false;
        this.printDebugInfo();
        try {
            int[] result = this.preparedStatement.executeBatch();
            finished = true;
        }
        finally {
            if (!finished) {
                System.out.println(this);
            }
        }
        return var1_2;
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    private void printDebugInfo() {
        if (sqlTracing) {
            System.out.println(this);
        }
    }

    public void setURL(int parameterIndex, URL x2) throws SQLException {
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return 0;
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return false;
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return 0;
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return false;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return 0;
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return false;
    }

    static {
        String tracingFlag = System.getProperties().getProperty(SQL_TRACING_PROPERTY);
        if (tracingFlag != null) {
            ApplicationPreparedStatement.enableSQLTracing();
        }
    }
}

