/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.tree.directory;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.tree.directory.FileSystemViewHelper;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

class WindowsAltFileSystemView
extends FileSystemViewHelper {
    WindowsAltFileSystemView() {
    }

    public boolean isRoot(File f2) {
        if (!f2.isAbsolute()) {
            return false;
        }
        String parentPath = f2.getParent();
        if (parentPath == null) {
            return true;
        }
        File parent = new File(parentPath);
        return parent.equals(f2);
    }

    public File createNewFolder(File containingDir) throws IOException {
        if (containingDir == null) {
            throw new IOException(CommonPlugin.Util.getString("ERR.003.028.0054"));
        }
        File newFolder = null;
        newFolder = this.createFileObject(containingDir, "New Folder");
        for (int i2 = 2; newFolder.exists() && i2 < 100; ++i2) {
            newFolder = this.createFileObject(containingDir, "New Folder (" + i2 + ")");
        }
        if (newFolder.exists()) {
            throw new IOException(CommonPlugin.Util.getString("ERR.003.028.0055", newFolder.getAbsolutePath()));
        }
        newFolder.mkdirs();
        return newFolder;
    }

    public boolean isHiddenFile(File f2) {
        return false;
    }

    public File[] getRoots() {
        Vector<FileSystemRoot> rootsVector = new Vector<FileSystemRoot>();
        for (char c2 = 'C'; c2 <= 'Z'; c2 = (char)((char)(c2 + 1))) {
            char[] device = new char[]{c2, ':', '\\'};
            String deviceName = new String(device);
            FileSystemRoot deviceFile = new FileSystemRoot(deviceName);
            if (deviceFile == null || !deviceFile.exists()) continue;
            rootsVector.addElement(deviceFile);
        }
        Object[] roots = new File[rootsVector.size()];
        rootsVector.copyInto(roots);
        return roots;
    }

    class FileSystemRoot
    extends File {
        public FileSystemRoot(File f2) {
            super(f2, "");
        }

        public FileSystemRoot(String s2) {
            super(s2);
        }

        public boolean isDirectory() {
            return true;
        }
    }
}

