/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.util.DiagnosticReporterConstants;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.internal.core.xml.JdomHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.jdom.Document;
import org.jdom.Element;

public class DiagnosticReporter
implements DiagnosticReporterConstants {
    private static final int BUFFER_SIZE = 2000;
    private final String propertyFilePath;
    private final String rootInstallPath;
    private final int productType;
    private final List entries = new ArrayList();
    private final HashSet exclusions = new HashSet();
    private final List roots = new ArrayList();
    private final MultiStatus status;
    private String emailHost;
    private String emailPort;
    private String overrideEmailAddress;

    public DiagnosticReporter(MultiStatus result, String rootInstallPath, String propertyFilePath, int productType) {
        ArgCheck.isNotZeroLength(propertyFilePath);
        ArgCheck.isNotZeroLength(rootInstallPath);
        ArgCheck.isNotNull(result);
        this.status = result;
        this.rootInstallPath = rootInstallPath.replace('/', '\\');
        this.propertyFilePath = propertyFilePath.replace('/', '\\');
        this.productType = productType;
        this.init();
    }

    public DiagnosticReportResult execute() {
        DiagnosticReportResult result = new DiagnosticReportResult();
        if (this.status.getSeverity() == 4) {
            String msg = CommonPlugin.Util.getString("DiagnosticReporter.invalidPre");
            this.createStatus(4, msg);
            return result;
        }
        String prodName = this.getNameForProductType();
        long time = new Date().getTime();
        String zipName = CommonPlugin.Util.getString("DiagnosticReporter.zipName", prodName, Long.toString(time));
        try {
            File next;
            File zipFile = new File(this.rootInstallPath + File.separator + "Diagnostics" + File.separator + zipName);
            File diagnosticDir = new File(this.rootInstallPath + File.separator + "Diagnostics");
            if (!diagnosticDir.exists()) {
                diagnosticDir.mkdir();
            }
            if (!zipFile.exists()) {
                zipFile.createNewFile();
            }
            result.result = zipFile;
            Iterator entriesIt = this.entries.iterator();
            while (entriesIt.hasNext()) {
                String nextEntryName = this.convertPlatformReferences((String)entriesIt.next());
                next = new File(this.rootInstallPath + File.separator + nextEntryName);
                if (!next.exists()) continue;
                this.buildFileList(result, next, true);
            }
            Iterator rootsIt = this.roots.iterator();
            while (rootsIt.hasNext()) {
                next = new File((String)rootsIt.next());
                if (!next.exists()) continue;
                this.buildFileList(result, next, true);
            }
            return result;
        }
        catch (Exception err) {
            String msg = CommonPlugin.Util.getString("DiagnosticReporter.executeException");
            this.createStatus(4, msg, err);
            return result;
        }
    }

    public String getEmailHost() {
        return this.emailHost;
    }

    public String getEmailPort() {
        return this.emailPort;
    }

    public String getOverrideEmailAddress() {
        return this.overrideEmailAddress;
    }

    public String getRootInstallPath() {
        return this.rootInstallPath;
    }

    private String convertPlatformReferences(String in) {
        if (in != null && in.startsWith("[PLATFORM]") && Platform.getInstanceLocation() != null) {
            StringBuffer buff = new StringBuffer();
            String platform = Platform.getInstanceLocation().getURL().toString();
            int index = (platform = platform.replace('/', '\\')).indexOf(this.rootInstallPath);
            if (index != -1) {
                buff.append(platform.substring(index + this.rootInstallPath.length() + 1));
            }
            if (in.equals("[PLATFORM]")) {
                return buff.toString();
            }
            buff.append(in.substring("[PLATFORM]".length() + 1));
            return buff.toString();
        }
        return in;
    }

    private void buildFileList(DiagnosticReportResult result, File file, boolean checkRoots) {
        if (file == null) {
            return;
        }
        if (checkRoots) {
            result.entryFiles.add(file);
            boolean found = false;
            File tmp = file;
            while (!found && tmp != null) {
                if (this.exclusions.contains(tmp.getPath())) {
                    result.excludedFiles.add(tmp);
                    return;
                }
                if (result.roots.contains(tmp)) {
                    found = true;
                    continue;
                }
                tmp = tmp.getParentFile();
            }
            if (!found) {
                result.roots.add(file);
            }
        }
        if (this.exclusions.contains(file.getPath())) {
            result.getExcludedFiles().add(file);
            return;
        }
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            for (int i2 = 0; i2 < children.length; ++i2) {
                this.buildFileList(result, children[i2], false);
            }
            return;
        }
    }

    public String getRelativePath(File file) {
        String fullPath = file.getPath();
        int indx = fullPath.indexOf(this.rootInstallPath);
        if (indx != -1) {
            return fullPath.substring(indx + this.rootInstallPath.length() + 1);
        }
        return file.getName();
    }

    private void init() {
        this.validate();
        if (this.status.getSeverity() == 4) {
            return;
        }
        File file = new File(this.propertyFilePath);
        try {
            Document doc = JdomHelper.buildDocument(file);
            Element root = doc.getRootElement();
            String targetName = this.getNameForProductType();
            if (root != null && !targetName.equals(root.getName())) {
                boolean done = false;
                Iterator children = root.getDescendants();
                while (children.hasNext() && !done) {
                    Object next = children.next();
                    if (!(next instanceof Element) || !targetName.equals(((Element)next).getName())) continue;
                    root = (Element)next;
                    done = true;
                }
            }
            if (root != null) {
                Iterator children = root.getDescendants();
                while (children.hasNext()) {
                    Object next = children.next();
                    if (!(next instanceof Element)) continue;
                    Element elem = (Element)next;
                    if ("entry".equals(elem.getName())) {
                        this.entries.add(elem.getText());
                        continue;
                    }
                    if ("exclude".equals(elem.getName())) {
                        String tmp = elem.getText();
                        String nextFileName = this.convertPlatformReferences(tmp);
                        File excl = new File(this.rootInstallPath + File.separator + nextFileName);
                        if (!excl.exists()) continue;
                        this.exclusions.add(excl.getPath());
                        continue;
                    }
                    if ("root".equals(elem.getName())) {
                        this.roots.add(elem.getText());
                        continue;
                    }
                    if (!"email".equals(elem.getName())) continue;
                    Iterator emailProps = elem.getDescendants();
                    while (emailProps.hasNext()) {
                        Object nextProp = emailProps.next();
                        if (!(nextProp instanceof Element)) continue;
                        Element emailProp = (Element)nextProp;
                        if ("host".equals(emailProp.getName())) {
                            if (emailProp.getText().trim().length() <= 0) continue;
                            this.emailHost = emailProp.getText();
                            continue;
                        }
                        if ("port".equals(emailProp.getName())) {
                            if (emailProp.getText().trim().length() <= 0) continue;
                            this.emailPort = emailProp.getText();
                            continue;
                        }
                        if (!"testEmail".equals(emailProp.getName()) || emailProp.getText().trim().length() <= 0) continue;
                        this.overrideEmailAddress = emailProp.getText();
                    }
                }
            } else {
                String msg = CommonPlugin.Util.getString("DiagnosticReporter.noRoot");
                this.createStatus(4, msg);
                return;
            }
            if (this.entries.isEmpty()) {
                String msg = CommonPlugin.Util.getString("DiagnosticReporter.noEntries");
                this.createStatus(4, msg);
            }
        }
        catch (Exception err) {
            String msg = CommonPlugin.Util.getString("DiagnosticReporter.initError");
            this.createStatus(4, msg, err);
        }
    }

    private void validate() {
        File propFilePath;
        File rootPath;
        if (this.productType < 0 || this.productType > 1) {
            String msg = CommonPlugin.Util.getString("DiagnosticReporter.invalidProductType");
            this.createStatus(4, msg);
        }
        if (!(rootPath = new File(this.rootInstallPath)).exists()) {
            String msg = CommonPlugin.Util.getString("DiagnosticReporter.invalidRootPath");
            this.createStatus(4, msg);
        }
        if (!(propFilePath = new File(this.propertyFilePath)).exists()) {
            String msg = CommonPlugin.Util.getString("DiagnosticReporter.noPropFile", this.propertyFilePath);
            this.createStatus(4, msg);
        }
    }

    private String getNameForProductType() {
        switch (this.productType) {
            case 1: {
                return "server";
            }
            case 0: {
                return "designer";
            }
        }
        return "";
    }

    private void createStatus(int severity, String msg) {
        this.createStatus(severity, msg, null);
    }

    private void createStatus(int severity, String msg, Throwable throwable) {
        Status sts = new Status(severity, "com.metamatrix.common", 0, msg, throwable);
        this.status.add(sts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeToZip(MultiStatus result, File zip, Object[] filesToWrite, DiagnosticReporter dr) {
        ZipOutputStream out = null;
        FileOutputStream os = new FileOutputStream(zip);
        out = new ZipOutputStream(new BufferedOutputStream(os));
        for (int i2 = 0; i2 < filesToWrite.length; ++i2) {
            String msg;
            File file;
            Object nxt = filesToWrite[i2];
            if (!(nxt instanceof File) || (file = (File)nxt) == null || !file.exists() || !file.isFile()) continue;
            InputStream in = null;
            in = new FileInputStream(file);
            in = new BufferedInputStream(in);
            String rootRelativeName = dr.getRelativePath(file);
            ZipEntry entry = new ZipEntry(rootRelativeName);
            out.putNextEntry(entry);
            byte[] buffer = new byte[2000];
            int n2 = 0;
            while ((n2 = in.read(buffer)) > -1) {
                out.write(buffer, 0, n2);
            }
            out.flush();
            out.closeEntry();
            Object var15_17 = null;
            if (in == null) continue;
            try {
                in.close();
            }
            catch (IOException err) {
                msg = CommonPlugin.Util.getString("DiagnosticReporter.errClose", file.getName());
                CommonPlugin.Util.log(4, err, msg);
            }
            continue;
            {
                catch (Exception e2) {
                    String msg2 = CommonPlugin.Util.getString("DiagnosticReporter.errEntry", file.getPath());
                    DiagnosticReporter.addStatus(result, msg2, 4, e2);
                    var15_17 = null;
                    if (in == null) continue;
                    try {
                        in.close();
                    }
                    catch (IOException err) {
                        msg = CommonPlugin.Util.getString("DiagnosticReporter.errClose", file.getName());
                        CommonPlugin.Util.log(4, err, msg);
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                var15_17 = null;
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException err) {
                    msg = CommonPlugin.Util.getString("DiagnosticReporter.errClose", file.getName());
                    CommonPlugin.Util.log(4, err, msg);
                }
                throw throwable;
            }
        }
        Object var19_21 = null;
        if (out == null) return;
        try {
            out.close();
            return;
        }
        catch (Exception err) {
            String msg3 = CommonPlugin.Util.getString("DiagnosticReporter.errClose", zip.getName());
            CommonPlugin.Util.log(4, msg3);
        }
        return;
        {
            catch (Exception e3) {
                String msg = CommonPlugin.Util.getString("DiagnosticReporter.errWrite");
                DiagnosticReporter.addStatus(result, msg, 4, e3);
                Object var19_22 = null;
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (Exception err) {
                    String msg3 = CommonPlugin.Util.getString("DiagnosticReporter.errClose", zip.getName());
                    CommonPlugin.Util.log(4, msg3);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var19_23 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (Exception err) {
                String msg3 = CommonPlugin.Util.getString("DiagnosticReporter.errClose", zip.getName());
                CommonPlugin.Util.log(4, msg3);
            }
            throw throwable;
        }
    }

    private static void addStatus(MultiStatus parent, String msg, int severity, Throwable err) {
        Status sts = new Status(severity, "com.metamatrix.common", 0, msg, err);
        parent.add(sts);
    }

    public class DiagnosticReportResult {
        final List roots = new ArrayList();
        final List excludedFiles = new ArrayList();
        final List entryFiles = new ArrayList();
        File result;

        public File getResult() {
            return this.result;
        }

        public Object[] getRootArray() {
            return this.roots.toArray();
        }

        public List getEntryFiles() {
            return this.entryFiles;
        }

        public List getExcludedFiles() {
            return this.excludedFiles;
        }
    }
}

