/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.metadata.index;

import com.metamatrix.connector.metadata.index.MetadataSearchCriteria;
import com.metamatrix.core.util.ArgCheck;

public class MetadataLiteralCriteria
implements MetadataSearchCriteria {
    private final String fieldName;
    private final Object fieldValue;
    private String fieldFunction;
    private String valueFunction;

    public MetadataLiteralCriteria(String fieldName, Object fieldValue) {
        ArgCheck.isNotNull(fieldName);
        this.fieldName = fieldName;
        this.fieldValue = fieldValue;
    }

    public String getFieldFunction() {
        return this.fieldFunction;
    }

    public void setFieldFunction(String fieldFunction) {
        this.fieldFunction = fieldFunction;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object getFieldValue() {
        return this.fieldValue;
    }

    public boolean isFalseCriteria() {
        Object evaluatedValue = this.getEvaluatedValue();
        if (evaluatedValue instanceof String && this.fieldFunction != null) {
            String stringValue = evaluatedValue.toString();
            if (this.fieldFunction.equalsIgnoreCase("UPPER") || this.fieldFunction.equalsIgnoreCase("UCASE")) {
                return !stringValue.equals(stringValue.toUpperCase());
            }
            if (this.fieldFunction.equalsIgnoreCase("LOWER") || this.fieldFunction.equalsIgnoreCase("LCASE")) {
                return !stringValue.equals(stringValue.toLowerCase());
            }
        }
        return false;
    }

    public Object getEvaluatedValue() {
        if (this.valueFunction != null && this.fieldValue instanceof String) {
            if (this.valueFunction.equalsIgnoreCase("UPPER") || this.valueFunction.equalsIgnoreCase("UCASE")) {
                return this.fieldValue.toString().toUpperCase();
            }
            if (this.valueFunction.equalsIgnoreCase("LOWER") || this.valueFunction.equalsIgnoreCase("LCASE")) {
                return this.fieldValue.toString().toLowerCase();
            }
        }
        return this.getFieldValue();
    }

    public String getValueFunction() {
        return this.valueFunction;
    }

    public void setValueFunction(String valueFunction) {
        this.valueFunction = valueFunction;
    }

    public boolean hasFieldWithCaseFunctions() {
        return this.fieldFunction != null && (this.fieldFunction.equalsIgnoreCase("UPPER") || this.fieldFunction.equalsIgnoreCase("UCASE") || this.fieldFunction.equalsIgnoreCase("LOWER") || this.fieldFunction.equalsIgnoreCase("LCASE"));
    }
}

