/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.metadata.internal;

import com.metamatrix.connector.metadata.MetadataConnectorPlugin;
import com.metamatrix.connector.metadata.index.MetadataLiteralCriteria;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.ICommand;
import com.metamatrix.data.language.IMetadataReference;
import com.metamatrix.data.language.IParameter;
import com.metamatrix.data.language.IProcedure;
import com.metamatrix.data.metadata.runtime.Element;
import com.metamatrix.data.metadata.runtime.MetadataID;
import com.metamatrix.data.metadata.runtime.MetadataObject;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ObjectProcedure {
    private final RuntimeMetadata metadata;
    private final IProcedure procedure;
    private IParameter resultSetParameter;
    private Collection inParams;
    private Map criteriaMap;
    private Map propValueMap;
    private String[] columnNames = null;
    private String[] columnNamesInSource = null;
    private Class[] columnTypes = null;

    public ObjectProcedure(RuntimeMetadata metadata, ICommand command) throws ConnectorException {
        ArgCheck.isNotNull(metadata);
        ArgCheck.isNotNull(command);
        this.metadata = metadata;
        this.procedure = (IProcedure)command;
        this.initParameters();
        this.initSetProperties();
        this.initCriteria();
    }

    public RuntimeMetadata getMetadata() {
        return this.metadata;
    }

    public Collection getInParameters() {
        return this.inParams;
    }

    private void initParameters() throws ConnectorException {
        List parameters = this.procedure.getParameters();
        if (parameters != null) {
            this.inParams = new HashSet(parameters.size());
            Iterator iter = parameters.iterator();
            while (iter.hasNext()) {
                IParameter parameter = (IParameter)iter.next();
                if (parameter.getDirection() == 4) {
                    this.resultSetParameter = parameter;
                    this.initResultSet();
                }
                if (parameter.getDirection() != 0 && parameter.getDirection() != 2) continue;
                this.inParams.add(parameter);
            }
        }
    }

    private void initResultSet() throws ConnectorException {
        List columnMetadata = this.resultSetParameter.getMetadataID().getChildIDs();
        int size = columnMetadata.size();
        this.columnNames = new String[size];
        this.columnNamesInSource = new String[size];
        this.columnTypes = new Class[size];
        for (int i2 = 0; i2 < size; ++i2) {
            MetadataID mID = (MetadataID)columnMetadata.get(i2);
            Element element = (Element)this.metadata.getObject(mID);
            this.columnNames[i2] = element.getMetadataID().getFullName();
            this.columnNamesInSource[i2] = element.getNameInSource();
            this.columnTypes[i2] = element.getJavaType();
        }
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String[] getColumnNamesInSource() {
        return this.columnNamesInSource;
    }

    public Class[] getColumnTypes() {
        return this.columnTypes;
    }

    public String getResultSetNameInSource() throws ConnectorException {
        return this.getParameterNameInSource(this.resultSetParameter);
    }

    public String getParameterNameInSource(IParameter parameter) throws ConnectorException {
        return this.getMetadataObjectName(parameter);
    }

    public String getProcedureNameInSource() throws ConnectorException {
        return this.getMetadataObjectName(this.procedure);
    }

    private void initCriteria() throws ConnectorException {
        this.criteriaMap = new HashMap();
        if (this.inParams != null) {
            Iterator iter = this.inParams.iterator();
            while (iter.hasNext()) {
                Object value;
                IParameter parameter = (IParameter)iter.next();
                String nameInSource = this.getParameterNameInSource(parameter);
                if (nameInSource == null || !StringUtil.startsWithIgnoreCase(nameInSource, "get") || (value = parameter.getValue()) == null) continue;
                MetadataLiteralCriteria literalCriteria = new MetadataLiteralCriteria(nameInSource, value);
                this.criteriaMap.put(nameInSource.toUpperCase(), literalCriteria);
            }
        }
    }

    private void initSetProperties() throws ConnectorException {
        this.propValueMap = new HashMap();
        if (this.inParams != null) {
            Iterator iter = this.inParams.iterator();
            while (iter.hasNext()) {
                Object value;
                IParameter parameter = (IParameter)iter.next();
                String nameInSource = this.getParameterNameInSource(parameter);
                if (nameInSource == null || !StringUtil.startsWithIgnoreCase(nameInSource, "set") || (value = parameter.getValue()) == null) continue;
                this.propValueMap.put(nameInSource, value);
            }
        }
    }

    public Map getPropValues() {
        return this.propValueMap;
    }

    public Map getCriteria() {
        return this.criteriaMap;
    }

    public void checkType(int columnIndex, Object value) {
        if (value != null && this.columnTypes != null && !this.columnTypes[columnIndex].isAssignableFrom(value.getClass())) {
            throw new MetaMatrixRuntimeException(MetadataConnectorPlugin.Util.getString("ObjectQuery.Type_mismatch", new Object[]{this.columnNames[columnIndex], this.columnTypes[columnIndex].getName(), value.getClass().getName()}));
        }
    }

    public Class getResultSetColumnType(int columnIndex) {
        if (this.columnTypes == null) {
            return this.columnTypes[columnIndex];
        }
        return this.columnTypes[columnIndex];
    }

    private String getMetadataObjectName(IMetadataReference reference) throws ConnectorException {
        if (reference == null) {
            return null;
        }
        MetadataID id = reference.getMetadataID();
        MetadataObject obj = this.metadata.getObject(id);
        if (obj != null && obj.getNameInSource() != null) {
            return obj.getNameInSource();
        }
        throw new MetaMatrixRuntimeException(MetadataConnectorPlugin.Util.getString("ObjectQuery.Could_not_resolve_name_for_query___1", new Object[]{this.procedure.toString()}));
    }
}

