/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core;

import com.metamatrix.core.util.ExternalizeUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class MetaMatrixCoreException
extends CoreException
implements Externalizable {
    private static final String NO_MESSAGE = "No Error Message";
    CoreException nestedCoreException;

    public MetaMatrixCoreException() {
        super(new StatusHolder(new Status(4, "com.metamatrix.core", 0, MetaMatrixCoreException.getNonNullMessage(NO_MESSAGE), null)));
    }

    public MetaMatrixCoreException(IStatus status) {
        super(status == null ? new Status(4, "com.metamatrix.core", 0, "", null) : status);
    }

    public MetaMatrixCoreException(CoreException exception) {
        super(exception == null ? new Status(4, "com.metamatrix.core", 0, "", null) : exception.getStatus());
        if (exception != null) {
            this.nestedCoreException = exception;
        }
    }

    public MetaMatrixCoreException(String message) {
        super(new Status(4, "com.metamatrix.core", 0, MetaMatrixCoreException.getNonNullMessage(message), null));
    }

    public MetaMatrixCoreException(int code, String message) {
        super(new Status(4, "com.metamatrix.core", code, MetaMatrixCoreException.getNonNullMessage(message), null));
    }

    public MetaMatrixCoreException(Throwable e2) {
        super(new Status(4, "com.metamatrix.core", 0, MetaMatrixCoreException.getNonNullMessageFromThrowable(e2), e2));
    }

    public MetaMatrixCoreException(Throwable e2, String message) {
        super(new Status(4, "com.metamatrix.core", 0, MetaMatrixCoreException.getNonNullMessage(message), e2));
    }

    public MetaMatrixCoreException(Throwable e2, int code) {
        super(new Status(4, "com.metamatrix.core", code, "", e2));
    }

    public MetaMatrixCoreException(Throwable e2, int code, String message) {
        super(new Status(4, "com.metamatrix.core", code, MetaMatrixCoreException.getNonNullMessage(message), e2));
    }

    public Throwable getException() {
        if (this.nestedCoreException == null) {
            return this.getStatus().getException();
        }
        return this.nestedCoreException;
    }

    public CoreException getNestedCoreException() {
        return this.nestedCoreException;
    }

    public void setNestedCoreException(CoreException coreException) {
        this.nestedCoreException = coreException;
    }

    static String getNonNullMessage(String message) {
        if (message == null) {
            return "";
        }
        return message;
    }

    static String getNonNullMessageFromThrowable(Throwable t2) {
        if (t2 == null) {
            return "";
        }
        return MetaMatrixCoreException.getNonNullMessage(t2.getMessage());
    }

    public String getMessage() {
        return this.getStatus().getMessage();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getToStringType());
        buffer.append(":");
        if (this.getException() != null) {
            if (this.getException() instanceof CoreException) {
                CoreException c2 = (CoreException)this.getException();
                buffer.append(" Core Exception [code ");
                buffer.append(c2.getStatus().getCode());
                buffer.append("] ");
                buffer.append(c2.getStatus().getMessage());
            } else {
                buffer.append(" ");
                buffer.append(this.getException().toString());
            }
        } else {
            buffer.append(" ");
            buffer.append(this.getStatus().toString());
        }
        return buffer.toString();
    }

    protected String getToStringType() {
        return "MetaMatrix Core Exception";
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        IStatus status = ExternalizeUtil.readIStatus(in);
        IStatus currentStatus = this.getStatus();
        if (currentStatus instanceof StatusHolder && status != null) {
            ((StatusHolder)currentStatus).setStatus(status);
        }
        StackTraceElement[] stackTrace = (StackTraceElement[])in.readObject();
        this.setStackTrace(stackTrace);
        this.nestedCoreException = (CoreException)ExternalizeUtil.readThrowable(in);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizeUtil.writeIStatus(out, this.getStatus());
        out.writeObject(this.getStackTrace());
        ExternalizeUtil.writeThrowable(out, this.nestedCoreException);
    }

    private static class StatusHolder
    implements IStatus,
    Serializable {
        private IStatus status = null;

        public StatusHolder() {
        }

        private StatusHolder(IStatus status) {
            this.setStatus(status);
        }

        private void setStatus(IStatus status) {
            this.status = status;
        }

        public IStatus[] getChildren() {
            return this.status.getChildren();
        }

        public int getCode() {
            return this.status.getCode();
        }

        public Throwable getException() {
            return this.status.getException();
        }

        public String getMessage() {
            return this.status.getMessage();
        }

        public String getPlugin() {
            return this.status.getPlugin();
        }

        public int getSeverity() {
            return this.status.getSeverity();
        }

        public boolean isMultiStatus() {
            return this.status.isMultiStatus();
        }

        public boolean isOK() {
            return this.status.isOK();
        }

        public boolean matches(int severityMask) {
            return this.status.matches(severityMask);
        }
    }
}

