/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.util;

import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.util.StringUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;

public class FileUtil {
    private String fileName;

    public FileUtil(String fileName) {
        this.fileName = fileName;
    }

    private FileWriter getWriter(boolean append) {
        try {
            return new FileWriter(this.fileName, append);
        }
        catch (IOException e2) {
            throw new MetaMatrixRuntimeException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(String text) {
        FileWriter writer = null;
        try {
            try {
                writer = this.getWriter(true);
                writer.write(text);
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (IOException e2) {
            throw new MetaMatrixRuntimeException(e2);
        }
    }

    public void write(String text) {
        this.delete();
        this.append(text);
    }

    public void delete() {
        File file = new File(this.fileName);
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBytes(byte[] bytes) {
        this.delete();
        FileOutputStream stream = null;
        try {
            try {
                stream = new FileOutputStream(this.fileName);
                stream.write(bytes);
                stream.flush();
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (FileNotFoundException e2) {
            throw new MetaMatrixRuntimeException(e2);
        }
        catch (IOException e3) {
            throw new MetaMatrixRuntimeException(e3);
        }
    }

    public String read() {
        try {
            return this.readSafe();
        }
        catch (FileNotFoundException e2) {
            throw new MetaMatrixRuntimeException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public String readSafe() throws FileNotFoundException {
        void var1_2;
        InputStreamReader reader = null;
        try {
            reader = new FileReader(this.fileName);
            String result = FileUtil.read(reader);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
        return var1_2;
    }

    public static String read(Reader reader) {
        StringWriter writer = new StringWriter();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(reader);
            while (bufferedReader.ready()) {
                String line = bufferedReader.readLine();
                writer.write(line);
                writer.write(StringUtil.LINE_SEPARATOR);
            }
        }
        catch (IOException e2) {
            throw new MetaMatrixRuntimeException(e2);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception e3) {}
        }
        return writer.toString();
    }

    public byte[] readBytes() {
        try {
            return this.readBytesSafe();
        }
        catch (FileNotFoundException e2) {
            throw new MetaMatrixRuntimeException(e2);
        }
        catch (IOException e3) {
            throw new MetaMatrixRuntimeException(e3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytesSafe() throws FileNotFoundException, IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        FileInputStream input = null;
        try {
            input = new FileInputStream(this.fileName);
            byte[] buffer = new byte[1024];
            int readCount = input.read(buffer);
            while (readCount > 0) {
                result.write(buffer, 0, readCount);
                readCount = input.read(buffer);
            }
            byte[] byArray = result.toByteArray();
            return byArray;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }
}

