/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class HashCodeUtil {
    private static final int PRIME = 1000003;

    public static final int hashCode(int previous, boolean x2) {
        return 1000003 * previous + (x2 ? 1 : 0);
    }

    public static final int hashCode(int previous, int x2) {
        return 1000003 * previous + x2;
    }

    public static final int hashCode(int previous, long x2) {
        return 1000003 * previous + (int)(1000003L * (x2 >>> 32) + (x2 & 0xFFFFFFFFFFFFFFFFL));
    }

    public static final int hashCode(int previous, float x2) {
        return HashCodeUtil.hashCode(previous, x2 == 0.0f ? 0 : Float.floatToIntBits(x2));
    }

    public static final int hashCode(int previous, double x2) {
        return HashCodeUtil.hashCode(previous, x2 == 0.0 ? 0L : Double.doubleToLongBits(x2));
    }

    public static final int hashCode(int previous, Object x2) {
        return x2 == null ? 1000003 * previous : 1000003 * previous + x2.hashCode();
    }

    public static final int hashCode(int previous, Object[] x2) {
        if (x2 == null) {
            return 1000003 * previous;
        }
        int hc = 0;
        for (int i2 = 0; i2 < x2.length; ++i2) {
            hc = HashCodeUtil.hashCode(hc, x2[i2]);
        }
        return hc;
    }

    public static final int expHashCode(int previous, Object[] x2) {
        if (x2 == null) {
            return 1000003 * previous;
        }
        int hc = 1000003 * previous + x2.length;
        int xlen = x2.length + 1;
        for (int index = 1; index < xlen; index <<= 1) {
            hc = HashCodeUtil.hashCode(hc, x2[index - 1]);
        }
        return hc;
    }

    public static final int expHashCode(int previous, List x2) {
        if (x2 == null) {
            return 1000003 * previous;
        }
        int hc = 1000003 * previous + x2.size();
        int xlen = x2.size() + 1;
        for (int index = 1; index < xlen; index <<= 1) {
            hc = HashCodeUtil.hashCode(hc, x2.get(index - 1));
        }
        return hc;
    }

    public static final int expHashCode(int previous, Collection x2) {
        if (x2 == null || x2.size() == 0) {
            return 1000003 * previous;
        }
        int size = x2.size();
        int hc = 1000003 * previous + size;
        int skip = 0;
        Iterator iter = x2.iterator();
        Object obj = iter.next();
        for (int total = 0; total < size; total += skip) {
            for (int i2 = 0; i2 < skip; ++i2) {
                obj = iter.next();
            }
            hc = HashCodeUtil.hashCode(hc, obj);
            skip = skip == 0 ? 1 : skip << 1;
        }
        return hc;
    }
}

