/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.util;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public final class ZipFileUtil {
    static final int BUFFER = 16384;
    static final String TMP_PFX = "ZipFileUtil";
    static final String TMP_SFX = ".zip";

    public static boolean add(String zipFileName, String fileName) throws Exception {
        ArgCheck.isNotEmpty(zipFileName);
        ArgCheck.isNotEmpty(fileName);
        ArrayList<String> fileNames = new ArrayList<String>();
        fileNames.add(fileName);
        return ZipFileUtil.addAll(new File(zipFileName), fileNames, fileNames);
    }

    public static boolean add(String zipFileName, String entryName, String fileName) throws Exception {
        ArgCheck.isNotEmpty(zipFileName);
        ArgCheck.isNotEmpty(entryName);
        ArgCheck.isNotEmpty(fileName);
        ArrayList<String> fileNames = new ArrayList<String>();
        fileNames.add(fileName);
        ArrayList<String> entryNames = new ArrayList<String>();
        entryNames.add(entryName);
        return ZipFileUtil.addAll(new File(zipFileName), entryNames, fileNames);
    }

    public static boolean add(File zipFile, String fileName) throws Exception {
        ArgCheck.isNotNull(zipFile);
        ArgCheck.isNotEmpty(fileName);
        ArrayList<String> fileNames = new ArrayList<String>();
        fileNames.add(fileName);
        return ZipFileUtil.addAll(zipFile, fileNames, fileNames);
    }

    public static boolean addAll(File zipFile, String dirName) throws Exception {
        return ZipFileUtil.addAll(zipFile, dirName, "");
    }

    public static boolean addAll(File zipFile, String dirName, String pathInZip) throws Exception {
        ArgCheck.isNotNull(zipFile);
        ArgCheck.isNotEmpty(dirName);
        File dir = new File(dirName);
        if (pathInZip.length() > 0) {
            pathInZip = pathInZip + File.separator;
        }
        List entryNames = ZipFileUtil.listRecursively(dir, pathInZip);
        List fileNames = ZipFileUtil.listRecursively(dir, dir.getAbsolutePath() + File.separator);
        return ZipFileUtil.addAll(zipFile, entryNames, fileNames);
    }

    private static List listRecursively(File sourceDirectory, String pathSoFar) throws FileNotFoundException {
        if (!sourceDirectory.exists()) {
            throw new FileNotFoundException(CorePlugin.Util.getString("FileUtils.File_does_not_exist._1", sourceDirectory));
        }
        if (!sourceDirectory.isDirectory()) {
            throw new FileNotFoundException(CorePlugin.Util.getString("FileUtils.Not_a_directory", sourceDirectory));
        }
        return ZipFileUtil.listRecursivelySub(sourceDirectory, pathSoFar);
    }

    private static List listRecursivelySub(File sourceDirectory, String pathSoFar) {
        ArrayList<String> results = new ArrayList<String>();
        File[] sourceFiles = sourceDirectory.listFiles();
        for (int i2 = 0; i2 < sourceFiles.length; ++i2) {
            File srcFile = sourceFiles[i2];
            String newPathSoFar = pathSoFar + srcFile.getName();
            if (srcFile.isDirectory()) {
                results.addAll(ZipFileUtil.listRecursivelySub(srcFile, newPathSoFar + File.separator));
                continue;
            }
            results.add(newPathSoFar);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean addAll(File zipFile, List entryNames, List fileNames) throws Exception {
        boolean bl;
        FileOutputStream fos = null;
        ZipOutputStream out = null;
        File tmpFile = File.createTempFile(TMP_PFX, TMP_SFX);
        try {
            byte[] buf;
            block13: {
                fos = new FileOutputStream(tmpFile);
                out = new ZipOutputStream(fos);
                buf = new byte[16384];
                if (zipFile.exists()) {
                    ZipInputStream in;
                    FileInputStream fis;
                    block11: {
                        ZipFile zipFileZip = null;
                        fis = null;
                        in = null;
                        try {
                            Object var12_13;
                            try {
                                zipFileZip = new ZipFile(zipFile);
                                fis = new FileInputStream(zipFile);
                                in = new ZipInputStream(fis);
                                ZipEntry entry = in.getNextEntry();
                                while (entry != null) {
                                    ZipFileUtil.writeEntry(entry, zipFileZip.getInputStream(entry), out, buf);
                                    entry = in.getNextEntry();
                                }
                                var12_13 = null;
                                if (zipFileZip == null) break block11;
                            }
                            catch (ZipException ignored) {
                                var12_13 = null;
                                if (zipFileZip != null) {
                                    zipFileZip.close();
                                }
                                ZipFileUtil.cleanup(in);
                                ZipFileUtil.cleanup(fis);
                                break block13;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var12_14 = null;
                            if (zipFileZip != null) {
                                zipFileZip.close();
                            }
                            ZipFileUtil.cleanup(in);
                            ZipFileUtil.cleanup(fis);
                            throw throwable;
                        }
                        zipFileZip.close();
                    }
                    ZipFileUtil.cleanup(in);
                    ZipFileUtil.cleanup(fis);
                }
            }
            Iterator entryNamesIter = entryNames.iterator();
            Iterator fileNamesIter = fileNames.iterator();
            while (entryNamesIter.hasNext() && fileNamesIter.hasNext()) {
                String entryName = (String)entryNamesIter.next();
                String fileName = (String)fileNamesIter.next();
                long modified = new File(fileName).lastModified();
                FileInputStream fis = new FileInputStream(fileName);
                ZipEntry entry = new ZipEntry(entryName);
                entry.setTime(modified);
                ZipFileUtil.writeEntry(entry, fis, out, buf);
                ZipFileUtil.cleanup(fis);
            }
            out.close();
            out = null;
            fos.close();
            fos = null;
            FileUtils.rename(tmpFile.getAbsolutePath(), zipFile.getAbsolutePath(), true);
            bl = true;
            Object var16_19 = null;
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            ZipFileUtil.cleanup(out);
            ZipFileUtil.cleanup(fos);
            if (tmpFile == null) throw throwable;
            if (!tmpFile.exists()) throw throwable;
            System.out.println(tmpFile.delete());
            throw throwable;
        }
        ZipFileUtil.cleanup(out);
        ZipFileUtil.cleanup(fos);
        if (tmpFile == null) return bl;
        if (!tmpFile.exists()) return bl;
        System.out.println(tmpFile.delete());
        return bl;
    }

    public static void extract(String zipFileName, String destinationDirectory) throws IOException {
        File sourceZipFile = new File(zipFileName);
        File unzipDestinationDirectory = new File(destinationDirectory);
        ZipFile zipFile = new ZipFile(sourceZipFile, 1);
        Enumeration<? extends ZipEntry> zipFileEntries = zipFile.entries();
        while (zipFileEntries.hasMoreElements()) {
            int currentByte;
            ZipEntry entry = zipFileEntries.nextElement();
            String currentEntry = entry.getName();
            File destFile = new File(unzipDestinationDirectory, currentEntry);
            File destinationParent = destFile.getParentFile();
            destinationParent.mkdirs();
            if (entry.isDirectory()) continue;
            BufferedInputStream is = new BufferedInputStream(zipFile.getInputStream(entry));
            byte[] data = new byte[16384];
            FileOutputStream fos = new FileOutputStream(destFile);
            BufferedOutputStream dest = new BufferedOutputStream(fos, 16384);
            while ((currentByte = is.read(data, 0, 16384)) != -1) {
                dest.write(data, 0, currentByte);
            }
            dest.flush();
            dest.close();
            fos.close();
            is.close();
        }
        zipFile.close();
    }

    public static boolean remove(String zipFileName, String fileName, boolean ignoreCase) throws Exception {
        ArgCheck.isNotEmpty(zipFileName);
        return ZipFileUtil.remove(new File(zipFileName), fileName, ignoreCase);
    }

    public static boolean remove(String zipFileName, String fileName) throws Exception {
        ArgCheck.isNotEmpty(zipFileName);
        return ZipFileUtil.remove(new File(zipFileName), fileName, false);
    }

    public static boolean remove(File zipFile, String fileName) throws Exception {
        ArgCheck.isNotNull(zipFile);
        ArgCheck.isNotEmpty(fileName);
        return ZipFileUtil.remove(zipFile, fileName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean remove(File zipFile, String fileName, boolean ignoreCase) throws Exception {
        boolean bl;
        ArgCheck.isNotNull(zipFile);
        ArgCheck.isNotEmpty(fileName);
        FileOutputStream fos = null;
        ZipOutputStream out = null;
        File tmpFile = File.createTempFile(TMP_PFX, TMP_SFX);
        try {
            fos = new FileOutputStream(tmpFile);
            out = new ZipOutputStream(fos);
            byte[] buf = new byte[16384];
            ZipFile zipFileZip = new ZipFile(zipFile);
            FileInputStream fis = null;
            ZipInputStream in = null;
            try {
                fis = new FileInputStream(zipFile);
                in = new ZipInputStream(fis);
                ZipEntry entry = in.getNextEntry();
                while (entry != null) {
                    if (ignoreCase) {
                        if (!entry.getName().equalsIgnoreCase(fileName)) {
                            ZipFileUtil.writeEntry(entry, zipFileZip.getInputStream(entry), out, buf);
                        }
                    } else if (!entry.getName().equals(fileName)) {
                        ZipFileUtil.writeEntry(entry, zipFileZip.getInputStream(entry), out, buf);
                    }
                    entry = in.getNextEntry();
                }
            }
            catch (Throwable throwable) {
                zipFileZip.close();
                ZipFileUtil.cleanup(in);
                ZipFileUtil.cleanup(fis);
                throw throwable;
            }
            zipFileZip.close();
            ZipFileUtil.cleanup(in);
            ZipFileUtil.cleanup(fis);
            out.close();
            out = null;
            fos.close();
            fos = null;
            FileUtils.rename(tmpFile.getAbsolutePath(), zipFile.getAbsolutePath(), true);
            bl = true;
        }
        catch (Throwable throwable) {
            ZipFileUtil.cleanup(out);
            ZipFileUtil.cleanup(fos);
            throw throwable;
        }
        ZipFileUtil.cleanup(out);
        ZipFileUtil.cleanup(fos);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream get(File zipFile, String fileName, boolean ignoreCase) throws Exception {
        ArgCheck.isNotNull(zipFile);
        ArgCheck.isNotEmpty(fileName);
        ByteArrayOutputStream out = null;
        try {
            ByteArrayInputStream byteArrayInputStream;
            ZipEntry entry;
            out = new ByteArrayOutputStream();
            byte[] buf = new byte[16384];
            ZipFile zipFileZip = new ZipFile(zipFile);
            FileInputStream fis = null;
            ZipInputStream in = null;
            try {
                fis = new FileInputStream(zipFile);
                in = new ZipInputStream(fis);
                boolean match = false;
                entry = in.getNextEntry();
                while (entry != null) {
                    if (ignoreCase) {
                        if (entry.getName().equalsIgnoreCase(fileName)) {
                            match = true;
                        }
                    } else if (entry.getName().equals(fileName)) {
                        match = true;
                    }
                    if (!match) break block12;
                    ZipFileUtil.copyEntry(zipFileZip.getInputStream(entry), out, buf);
                    byte[] data = out.toByteArray();
                    out.close();
                    byteArrayInputStream = new ByteArrayInputStream(data);
                }
            }
            catch (Throwable throwable) {
                zipFileZip.close();
                ZipFileUtil.cleanup(in);
                ZipFileUtil.cleanup(fis);
                throw throwable;
            }
            {
                block12: {
                    zipFileZip.close();
                    ZipFileUtil.cleanup(in);
                    ZipFileUtil.cleanup(fis);
                    return byteArrayInputStream;
                }
                entry = in.getNextEntry();
                continue;
            }
            zipFileZip.close();
            ZipFileUtil.cleanup(in);
            ZipFileUtil.cleanup(fis);
        }
        finally {
            ZipFileUtil.cleanup(out);
        }
        return null;
    }

    public static Manifest getManifest(File jarfile) {
        JarFile jfile = null;
        String path = jarfile.getAbsolutePath();
        if (!(jarfile.isDirectory() || path.indexOf(".jar") <= 0 && path.indexOf(TMP_SFX) <= 0)) {
            try {
                jfile = new JarFile(jarfile);
                Manifest manifest = jfile.getManifest();
                if (manifest != null) {
                    return manifest;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static void writeEntry(ZipEntry entry, InputStream in, ZipOutputStream out, byte[] buffer) throws IOException {
        out.putNextEntry(entry);
        BufferedInputStream zipEntryIn = new BufferedInputStream(in);
        int count = zipEntryIn.read(buffer);
        while (count >= 0) {
            out.write(buffer, 0, count);
            count = zipEntryIn.read(buffer);
        }
        zipEntryIn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyEntry(InputStream in, OutputStream out, byte[] buffer) throws IOException {
        BufferedInputStream zipEntryIn = null;
        try {
            zipEntryIn = new BufferedInputStream(in);
            int count = zipEntryIn.read(buffer);
            while (count >= 0) {
                out.write(buffer, 0, count);
                count = zipEntryIn.read(buffer);
            }
        }
        finally {
            zipEntryIn.close();
        }
    }

    private static void cleanup(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void cleanup(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private ZipFileUtil() {
    }
}

