/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.data.visitor.framework;

import com.metamatrix.data.DataPlugin;
import com.metamatrix.data.language.IAggregate;
import com.metamatrix.data.language.IBatchedUpdates;
import com.metamatrix.data.language.ICaseExpression;
import com.metamatrix.data.language.ICompareCriteria;
import com.metamatrix.data.language.ICompoundCriteria;
import com.metamatrix.data.language.IDelete;
import com.metamatrix.data.language.IElement;
import com.metamatrix.data.language.IExistsCriteria;
import com.metamatrix.data.language.IFrom;
import com.metamatrix.data.language.IFunction;
import com.metamatrix.data.language.IGroup;
import com.metamatrix.data.language.IGroupBy;
import com.metamatrix.data.language.IInCriteria;
import com.metamatrix.data.language.IInlineView;
import com.metamatrix.data.language.IInsert;
import com.metamatrix.data.language.IIsNullCriteria;
import com.metamatrix.data.language.IJoin;
import com.metamatrix.data.language.ILanguageObject;
import com.metamatrix.data.language.ILikeCriteria;
import com.metamatrix.data.language.ILimit;
import com.metamatrix.data.language.ILiteral;
import com.metamatrix.data.language.INotCriteria;
import com.metamatrix.data.language.IOrderBy;
import com.metamatrix.data.language.IOrderByItem;
import com.metamatrix.data.language.IParameter;
import com.metamatrix.data.language.IProcedure;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.language.IScalarSubquery;
import com.metamatrix.data.language.ISearchedCaseExpression;
import com.metamatrix.data.language.ISelect;
import com.metamatrix.data.language.ISelectSymbol;
import com.metamatrix.data.language.ISubqueryCompareCriteria;
import com.metamatrix.data.language.ISubqueryInCriteria;
import com.metamatrix.data.language.IUnion;
import com.metamatrix.data.language.IUpdate;
import com.metamatrix.data.visitor.framework.HierarchyVisitor;
import com.metamatrix.data.visitor.framework.LanguageObjectVisitor;

public class DelegatingHierarchyVisitor
extends HierarchyVisitor {
    private LanguageObjectVisitor postVisitor = null;
    private LanguageObjectVisitor preVisitor = null;

    public DelegatingHierarchyVisitor(LanguageObjectVisitor preProcessingDelegate, LanguageObjectVisitor postProcessingDelegate) {
        if (preProcessingDelegate == null && postProcessingDelegate == null) {
            throw new IllegalArgumentException(DataPlugin.Util.getString("DelegatingHierarchyVisitor.The_pre-_and_post-processing_visitors_cannot_both_be_null._1"));
        }
        this.preVisitor = preProcessingDelegate;
        this.postVisitor = postProcessingDelegate;
    }

    protected LanguageObjectVisitor getPostVisitor() {
        return this.postVisitor;
    }

    protected LanguageObjectVisitor getPreVisitor() {
        return this.preVisitor;
    }

    public void visit(IAggregate obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public void visit(IBatchedUpdates obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public void visit(ICaseExpression obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public void visit(ICompareCriteria obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public void visit(ICompoundCriteria obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public void visit(IDelete obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public void visit(IElement obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public void visit(IProcedure obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public void visit(IExistsCriteria obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public void visit(IFrom obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public void visit(IFunction obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public void visit(IGroup obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public void visit(IGroupBy obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public void visit(IInCriteria obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public void visit(IInlineView obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public void visit(IInsert obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public void visit(IIsNullCriteria obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public void visit(IJoin obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public void visit(ILikeCriteria obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public void visit(ILimit obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public void visit(ILiteral obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public void visit(INotCriteria obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public void visit(IOrderBy obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public void visit(IOrderByItem obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public void visit(IParameter obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public void visit(IQuery obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public void visit(IScalarSubquery obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public void visit(ISearchedCaseExpression obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public void visit(ISelect obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public void visit(ISelectSymbol obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public void visit(ISubqueryCompareCriteria obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public void visit(ISubqueryInCriteria obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public void visit(IUnion obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public void visit(IUpdate obj) {
        if (this.preVisitor != null) {
            this.preVisitor.visit(obj);
        }
        super.visit(obj);
        if (this.postVisitor != null) {
            this.postVisitor.visit(obj);
        }
    }

    public static void preOrderVisit(LanguageObjectVisitor behaviorVisitor, ILanguageObject object) {
        DelegatingHierarchyVisitor hierarchyVisitor = new DelegatingHierarchyVisitor(behaviorVisitor, null);
        object.acceptVisitor(hierarchyVisitor);
    }

    public static void postOrderVisit(LanguageObjectVisitor behaviorVisitor, ILanguageObject object) {
        DelegatingHierarchyVisitor hierarchyVisitor = new DelegatingHierarchyVisitor(null, behaviorVisitor);
        object.acceptVisitor(hierarchyVisitor);
    }
}

