/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.log.LogConfiguration;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.log.config.BasicLogConfiguration;
import com.metamatrix.core.log.FileLimitSizeLogWriter;
import com.metamatrix.core.log.LogListener;
import com.metamatrix.core.log.NullLogWriter;
import com.metamatrix.core.log.SystemLogWriter;
import com.metamatrix.dqp.embedded.DQPEmbeddedPlugin;
import com.metamatrix.internal.core.log.PlatformLog;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EmbeddedConfigUtil {
    static final String STDOUT = "STDOUT";
    private static Object lock = new Object();
    private static int count = 0;

    private EmbeddedConfigUtil() {
    }

    public static void setLogLevel(String logLevel) throws MetaMatrixComponentException {
        int level = 0;
        if (logLevel != null && logLevel.trim().length() > 0) {
            try {
                level = Integer.parseInt(logLevel);
            }
            catch (NumberFormatException e2) {
                throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("DQPComponent.Unable_to_parse_level") + logLevel);
            }
        }
        LogConfiguration config = LogManager.getLogConfiguration(true);
        config.setMessageLevel(level);
        LogManager.setLogConfiguration(config);
        LogManager.logCritical("DQP", "LogManager configured with level = " + level);
    }

    public static void setDiscardedContexts(Collection contexts) {
        LogManager.setLogConfiguration(new BasicLogConfiguration(contexts, LogManager.getLogConfiguration(false).getMessageLevel()));
        LogManager.logCritical("DQP", "LogManager discarded contexts " + contexts);
    }

    public static void installLogListener(LogListener newListener) throws MetaMatrixComponentException {
        if (newListener == null) {
            return;
        }
        PlatformLog log = PlatformLog.getInstance();
        ArrayList listeners = new ArrayList(log.getLogListeners());
        if (listeners.size() == 1 && listeners.get(0).getClass().equals(newListener.getClass())) {
            return;
        }
        EmbeddedConfigUtil.removeListeners(listeners);
        log.addListener(newListener);
    }

    private static void removeListeners(List listeners) {
        for (int i2 = 0; i2 < listeners.size(); ++i2) {
            PlatformLog.getInstance().removeListener((LogListener)listeners.get(i2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configureLogger(String logFile, String logLevel, boolean captureSystemStreams, boolean useSingleLogger) throws MetaMatrixComponentException {
        PlatformLog log = PlatformLog.getInstance();
        ArrayList previousListeners = new ArrayList(log.getLogListeners());
        if (previousListeners.size() == 0 || !useSingleLogger) {
            if (logFile != null && logFile.trim().length() > 0) {
                if (logFile.equalsIgnoreCase(STDOUT)) {
                    SystemLogWriter logWriter = new SystemLogWriter();
                    EmbeddedConfigUtil.installLogListener(logWriter);
                } else {
                    File file = new File(logFile);
                    FileLimitSizeLogWriter logWriter = new FileLimitSizeLogWriter(file, captureSystemStreams);
                    EmbeddedConfigUtil.installLogListener(logWriter);
                }
            } else {
                EmbeddedConfigUtil.removeListeners(previousListeners);
                NullLogWriter logNull = new NullLogWriter();
                EmbeddedConfigUtil.installLogListener(logNull);
            }
            if (logLevel != null) {
                EmbeddedConfigUtil.setLogLevel(logLevel);
            } else {
                EmbeddedConfigUtil.setLogLevel("3");
            }
        }
        Object object = lock;
        synchronized (object) {
            ++count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownLogger() {
        Object object = lock;
        synchronized (object) {
        }
        if (--count == 0) {
            PlatformLog.getInstance().shutdown(false);
            PlatformLog.getInstance().setShutdownRequested(false);
        }
    }

    static {
        System.setProperty("shutdownHookInstalled", String.valueOf(Boolean.TRUE));
    }
}

